/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.beust.jcommander.Parameter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.facebook.nailgun.NGServer;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NailgunServer$;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.ParameterValidators;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011Ec\u0001B0a\u0001-D\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\n\u007f\u0002\u0011\t\u0011)A\u0005\u0003\u0003A!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\ty\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005M\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\n\u0003W\u0001!\u0019!C\u0005\u0003[A\u0001\"a\u0010\u0001A\u0003%\u0011q\u0006\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"!\u0016\u0001A\u0003%\u0011Q\t\u0005\n\u0003/\u0002!\u0019!C\u0005\u00033B\u0001\"a\u0017\u0001A\u0003%\u00111\u0003\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?B\u0001\"!\u001c\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003cB\u0001\"a-\u0001A\u0003%\u00111\u000f\u0005\n\u0003k\u0003!\u0019!C\u0005\u0003oC\u0001\"!3\u0001A\u0003%\u0011\u0011\u0018\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\u0011)\u0001\u0001C\u0001\u00033BqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u0005F\u0001!\tE!\u0015\u0007\r\u0011\u001d\u0003\u0001\u0001C%\u0011\u001d\tIb\u0006C\u0001\t\u0017Bqaa\"\u0018\t\u0003\u0012\tfB\u0004\u0003$\u0001D\tA!\n\u0007\r}\u0003\u0007\u0012\u0001B\u0014\u0011\u001d\tIb\u0007C\u0001\u0005_AqA!\r\u001c\t\u0003\u0011\u0019DB\u0005\u0003@m\u0001\n1!\u0001\u0003B!9!q\n\u0010\u0005\u0002\tE\u0003\u0002C8\u001f\u0001\u0004%\tAa\u0015\t\u0013\tmc\u00041A\u0005\u0002\tucA\u0002B27\u0001\u0013)\u0007\u0003\u0006\u0003t\t\u0012)\u001a!C\u0001\u0005kB!Ba\u001e#\u0005#\u0005\u000b\u0011BAF\u0011)\u0011IH\tBK\u0002\u0013\u0005!1\u0010\u0005\u000b\u0005{\u0012#\u0011#Q\u0001\n\u0005\u0005\u0001B\u0003B@E\tU\r\u0011\"\u0001\u0002Z!Q!\u0011\u0011\u0012\u0003\u0012\u0003\u0006I!a\u0005\t\u0015\t\r%E!f\u0001\n\u0003\u0011)\t\u0003\u0006\u0003\u000e\n\u0012\t\u0012)A\u0005\u0005\u000fC!Ba$#\u0005+\u0007I\u0011\u0001BC\u0011)\u0011\tJ\tB\tB\u0003%!q\u0011\u0005\u000b\u0005'\u0013#Q3A\u0005\u0002\t\u0015\u0005B\u0003BKE\tE\t\u0015!\u0003\u0003\b\"Q!q\u0013\u0012\u0003\u0016\u0004%\tA!\"\t\u0015\te%E!E!\u0002\u0013\u00119\tC\u0004\u0002\u001a\t\"\tAa'\t\u0013\t=&%!A\u0005\u0002\tE\u0006\"\u0003BaEE\u0005I\u0011\u0001Bb\u0011%\u0011INII\u0001\n\u0003\u0011Y\u000eC\u0005\u0003`\n\n\n\u0011\"\u0001\u0003b\"I!Q\u001d\u0012\u0012\u0002\u0013\u0005!q\u001d\u0005\n\u0005W\u0014\u0013\u0013!C\u0001\u0005OD\u0011B!<##\u0003%\tAa:\t\u0013\t=(%%A\u0005\u0002\t\u001d\b\"\u0003ByE\u0005\u0005I\u0011\tBz\u0011%\u0011IPIA\u0001\n\u0003\u0011Y\bC\u0005\u0003|\n\n\t\u0011\"\u0001\u0003~\"I1\u0011\u0001\u0012\u0002\u0002\u0013\u000531\u0001\u0005\n\u0007#\u0011\u0013\u0011!C\u0001\u0007'A\u0011b!\b#\u0003\u0003%\tea\b\t\u0013\r\r\"%!A\u0005B\r\u0015\u0002\"CB\u0014E\u0005\u0005I\u0011IB\u0015\u0011%\u0019YCIA\u0001\n\u0003\u001aicB\u0005\u00042m\t\t\u0011#\u0001\u00044\u0019I!1M\u000e\u0002\u0002#\u00051Q\u0007\u0005\b\u00033!E\u0011AB'\u0011%\u00199\u0003RA\u0001\n\u000b\u001aI\u0003C\u0005\u0004P\u0011\u000b\t\u0011\"!\u0004R!I1\u0011\r#\u0002\u0002\u0013\u000551\r\u0005\n\u0007c\"\u0015\u0011!C\u0005\u0007g2aa!\u001e\u001c\u0001\r]\u0004\"CB@\u0015\n\u0005\t\u0015!\u0003m\u0011\u001d\tIB\u0013C\u0001\u0007\u0003Cqaa\"K\t\u0003\u0012\tF\u0002\u0004\u0004\nn\u000111\u0012\u0005\b\u00033qE\u0011ABG\u0011-\u0019\tJ\u0014a\u0001\u0002\u0004%\tA!\u001e\t\u0017\rMe\n1AA\u0002\u0013\u00051Q\u0013\u0005\f\u00073s\u0005\u0019!A!B\u0013\tY\t\u0003\u0005\u0000\u001d\u0002\u0007I\u0011\u0001B>\u0011%\u0019YL\u0014a\u0001\n\u0003\u0019i\f\u0003\u0005\u0004B:\u0003\u000b\u0015BA\u0001\u0011%\u0019\u0019O\u0014a\u0001\n\u0003\u0011Y\bC\u0005\u0004f:\u0003\r\u0011\"\u0001\u0004h\"A11\u001e(!B\u0013\t\t\u0001C\u0005\u0004|:\u0003\r\u0011\"\u0001\u0004~\"IAQ\u0002(A\u0002\u0013\u0005Aq\u0002\u0005\t\t'q\u0005\u0015)\u0003\u0004\u0000\"I\u0011Q\u0017(A\u0002\u0013\u00051Q \u0005\n\tgq\u0005\u0019!C\u0001\tkA\u0001\"!3OA\u0003&1q \u0002\u000e\u001d\u0006LGnZ;o'\u0016\u0014h/\u001a:\u000b\u0005\u0005\u0014\u0017!B;uS2\u001c(BA2e\u0003\u0015!xn\u001c7t\u0015\t)g-A\u0004hK>lWm]1\u000b\u0005\u001dD\u0017\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A5\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0007CA7u\u001b\u0005q'BA8q\u0003\u001dq\u0017-\u001b7hk:T!!\u001d:\u0002\u0011\u0019\f7-\u001a2p_.T\u0011a]\u0001\u0004G>l\u0017BA;o\u0005!quiU3sm\u0016\u0014\u0018\u0001B1eIJ\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u00079,GOC\u0001}\u0003\u0011Q\u0017M^1\n\u0005yL(aC%oKR\fE\r\u001a:fgN\fA\u0001]8siB!\u00111AA\u0005\u001b\t\t)A\u0003\u0002\u0002\b\u0005)1oY1mC&!\u00111BA\u0003\u0005\rIe\u000e^\u0001\u0010g\u0016\u001c8/[8o!>|GnU5{K\u0006iA/[7f_V$X*\u001b7mSN\f\u0011#\u001b3mKRKW.Z8vi6KG\u000e\\5t!\u0011\t\u0019!!\u0006\n\t\u0005]\u0011Q\u0001\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\r\u0003;\t\t#a\t\u0002&\u0005\u001d\u0012\u0011\u0006\t\u0004\u0003?\u0001Q\"\u00011\t\u000bY4\u0001\u0019A<\t\r}4\u0001\u0019AA\u0001\u0011\u001d\tiA\u0002a\u0001\u0003\u0003Aq!a\u0004\u0007\u0001\u0004\t\t\u0001C\u0004\u0002\u0012\u0019\u0001\r!a\u0005\u0002\u0011I,w-[:uef,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u00059Q.\u001a;sS\u000e\u001c(bAA\u001de\u0006A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002>\u0005M\"AD'fiJL7MU3hSN$(/_\u0001\ne\u0016<\u0017n\u001d;ss\u0002\n\u0001B]3rk\u0016\u001cHo]\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u0014|\u0003\u0011)H/\u001b7\n\t\u0005M\u0013\u0011\n\u0002\u0007!\"\f7/\u001a:\u0002\u0013I,\u0017/^3tiN\u0004\u0013!B:uCJ$XCAA\n\u0003\u0019\u0019H/\u0019:uA\u0005YA.Y:u%\u0016\fX/Z:u+\t\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\u0011\t9'!\u0013\u0002\r\u0005$x.\\5d\u0013\u0011\tY'!\u001a\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u0007mCN$(+Z9vKN$\b%\u0001\u0004uS6,'o]\u000b\u0003\u0003g\u0002\u0002\"!\u001e\u0002\b\u0006-\u0015\u0011U\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005)1-Y2iK*!\u0011QPA@\u0003!\u0019\u0017M\u001a4fS:,'\u0002BAA\u0003\u0007\u000b\u0001BY3o[\u0006tWm\u001d\u0006\u0004\u0003\u000b\u0013\u0018AB4ji\",(-\u0003\u0003\u0002\n\u0006]$\u0001\u0004'pC\u0012LgnZ\"bG\",\u0007\u0003BAG\u00037sA!a$\u0002\u0018B!\u0011\u0011SA\u0003\u001b\t\t\u0019JC\u0002\u0002\u0016*\fa\u0001\u0010:p_Rt\u0014\u0002BAM\u0003\u000b\ta\u0001\u0015:fI\u00164\u0017\u0002BAO\u0003?\u0013aa\u0015;sS:<'\u0002BAM\u0003\u000b\u0001\u0002\"a\u0001\u0002$\u0006\u001d\u0016QV\u0005\u0005\u0003K\u000b)A\u0001\u0004UkBdWM\r\t\u0005\u0003G\nI+\u0003\u0003\u0002,\u0006\u0015$!D!u_6L7-\u00138uK\u001e,'\u000f\u0005\u0003\u00022\u0005=\u0016\u0002BAY\u0003g\u0011Q\u0001V5nKJ\fq\u0001^5nKJ\u001c\b%\u0001\u0003jI2,WCAA]a\u0011\tY,!2\u0011\r\u0005\u001d\u0013QXAa\u0013\u0011\ty,!\u0013\u0003\r\u0019+H/\u001e:f!\u0011\t\u0019-!2\r\u0001\u0011Y\u0011q\u0019\n\u0002\u0002\u0003\u0005)\u0011AAf\u0005\ryF%M\u0001\u0006S\u0012dW\rI\t\u0005\u0003\u001b\f\u0019\u000e\u0005\u0003\u0002\u0004\u0005=\u0017\u0002BAi\u0003\u000b\u0011qAT8uQ&tw\r\u0005\u0003\u0002\u0004\u0005U\u0017\u0002BAl\u0003\u000b\u00111!\u00118z\u0003\u001d)\u00070Z2vi\u0016$B!!8\u0002dB!\u00111AAp\u0013\u0011\t\t/!\u0002\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003K\u001c\u0002\u0019AAt\u0003\u001d\u0019w.\\7b]\u0012\u0004B!!;\u0002\u0000:!\u00111^A~\u001d\u0011\ti/!?\u000f\t\u0005=\u0018q\u001f\b\u0005\u0003c\f)P\u0004\u0003\u0002\u0012\u0006M\u0018\"A5\n\u0005\u001dD\u0017BA3g\u0013\t\u0019G-C\u0002\u0002~\n\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0002\t\r!aB\"p[6\fg\u000e\u001a\u0006\u0004\u0003{\u0014\u0017aB:uCJ$X\rZ\u0001\u0006gR\fGo]\u000b\u0003\u0005\u0017\u0001bA!\u0004\u0003\u0016\tma\u0002\u0002B\b\u0005'qA!!%\u0003\u0012%\u0011\u0011qA\u0005\u0005\u0003{\f)!\u0003\u0003\u0003\u0018\te!aA*fc*!\u0011Q`A\u0003!\r\u0011iB\t\b\u0004\u0005?Qb\u0002BAv\u0005CI!!\u00192\u0002\u001b9\u000b\u0017\u000e\\4v]N+'O^3s!\r\tybG\n\u00047\t%\u0002\u0003BA\u0002\u0005WIAA!\f\u0002\u0006\t1\u0011I\\=SK\u001a$\"A!\n\u0002\t5\f\u0017N\u001c\u000b\u0005\u0003;\u0014)\u0004C\u0004\u00038u\u0001\rA!\u000f\u0002\t\u0005\u0014xm\u001d\t\u0007\u0003\u0007\u0011Y$a#\n\t\tu\u0012Q\u0001\u0002\u0006\u0003J\u0014\u0018-\u001f\u0002\r\u001d\u0006LGnZ;o\u0003^\f'/Z\n\u0006=\t\r\u0013q\u001d\t\u0005\u0005\u000b\u0012Y%\u0004\u0002\u0003H)\u0019!\u0011J>\u0002\t1\fgnZ\u0005\u0005\u0005\u001b\u00129E\u0001\u0004PE*,7\r^\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0005\u0005uWC\u0001B+!\u0019\t\u0019Aa\u0016\u0002\u001e%!!\u0011LA\u0003\u0005\u0019y\u0005\u000f^5p]\u0006Ya.Y5mOVtw\fJ3r)\u0011\tiNa\u0018\t\u0013\t\u0005\u0014%!AA\u0002\tU\u0013a\u0001=%c\tY1i\\7nC:$7\u000b^1u'\u001d\u0011#\u0011\u0006B4\u0005[\u0002B!a\u0001\u0003j%!!1NA\u0003\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u0004\u0003p%!!\u0011\u000fB\r\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011q\u0017-\\3\u0016\u0005\u0005-\u0015!\u00028b[\u0016\u0004\u0013AB1di&4X-\u0006\u0002\u0002\u0002\u00059\u0011m\u0019;jm\u0016\u0004\u0013\u0001C2p[BdW\r^3\u0002\u0013\r|W\u000e\u001d7fi\u0016\u0004\u0013\u0001B7fC:,\"Aa\"\u0011\t\u0005\r!\u0011R\u0005\u0005\u0005\u0017\u000b)A\u0001\u0004E_V\u0014G.Z\u0001\u0006[\u0016\fg\u000eI\u0001\u0007[\u0016$\u0017.\u00198\u0002\u000f5,G-[1oA\u0005\u0019a.O\u001b\u0002\t9LT\u0007I\u0001\u0005e\u0006$X-A\u0003sCR,\u0007\u0005\u0006\t\u0003\u001e\n\u0005&1\u0015BS\u0005O\u0013IKa+\u0003.B\u0019!q\u0014\u0012\u000e\u0003mAqAa\u001d2\u0001\u0004\tY\tC\u0004\u0003zE\u0002\r!!\u0001\t\u000f\t}\u0014\u00071\u0001\u0002\u0014!9!1Q\u0019A\u0002\t\u001d\u0005b\u0002BHc\u0001\u0007!q\u0011\u0005\b\u0005'\u000b\u0004\u0019\u0001BD\u0011\u001d\u00119*\ra\u0001\u0005\u000f\u000bAaY8qsR\u0001\"Q\u0014BZ\u0005k\u00139L!/\u0003<\nu&q\u0018\u0005\n\u0005g\u0012\u0004\u0013!a\u0001\u0003\u0017C\u0011B!\u001f3!\u0003\u0005\r!!\u0001\t\u0013\t}$\u0007%AA\u0002\u0005M\u0001\"\u0003BBeA\u0005\t\u0019\u0001BD\u0011%\u0011yI\rI\u0001\u0002\u0004\u00119\tC\u0005\u0003\u0014J\u0002\n\u00111\u0001\u0003\b\"I!q\u0013\u001a\u0011\u0002\u0003\u0007!qQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)M\u000b\u0003\u0002\f\n\u001d7F\u0001Be!\u0011\u0011YM!6\u000e\u0005\t5'\u0002\u0002Bh\u0005#\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tM\u0017QA\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bl\u0005\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!8+\t\u0005\u0005!qY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019O\u000b\u0003\u0002\u0014\t\u001d\u0017AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005STCAa\"\u0003H\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u001f\t\u0005\u0005\u000b\u001290\u0003\u0003\u0002\u001e\n\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003'\u0014y\u0010C\u0005\u0003bq\n\t\u00111\u0001\u0002\u0002\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004\u0006A11qAB\u0007\u0003'l!a!\u0003\u000b\t\r-\u0011QA\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\b\u0007\u0013\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!1QCB\u000e!\u0011\t\u0019aa\u0006\n\t\re\u0011Q\u0001\u0002\b\u0005>|G.Z1o\u0011%\u0011\tGPA\u0001\u0002\u0004\t\u0019.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B{\u0007CA\u0011B!\u0019@\u0003\u0003\u0005\r!!\u0001\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0001\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!>\u0002\r\u0015\fX/\u00197t)\u0011\u0019)ba\f\t\u0013\t\u0005$)!AA\u0002\u0005M\u0017aC\"p[6\fg\u000eZ*uCR\u00042Aa(E'\u0015!5qGB\"!Q\u0019Ida\u0010\u0002\f\u0006\u0005\u00111\u0003BD\u0005\u000f\u00139Ia\"\u0003\u001e6\u001111\b\u0006\u0005\u0007{\t)!A\u0004sk:$\u0018.\\3\n\t\r\u000531\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:<\u0004\u0003BB#\u0007\u0017j!aa\u0012\u000b\u0007\r%30\u0001\u0002j_&!!\u0011OB$)\t\u0019\u0019$A\u0003baBd\u0017\u0010\u0006\t\u0003\u001e\u000eM3QKB,\u00073\u001aYf!\u0018\u0004`!9!1O$A\u0002\u0005-\u0005b\u0002B=\u000f\u0002\u0007\u0011\u0011\u0001\u0005\b\u0005\u007f:\u0005\u0019AA\n\u0011\u001d\u0011\u0019i\u0012a\u0001\u0005\u000fCqAa$H\u0001\u0004\u00119\tC\u0004\u0003\u0014\u001e\u0003\rAa\"\t\u000f\t]u\t1\u0001\u0003\b\u00069QO\\1qa2LH\u0003BB3\u0007[\u0002b!a\u0001\u0003X\r\u001d\u0004CEA\u0002\u0007S\nY)!\u0001\u0002\u0014\t\u001d%q\u0011BD\u0005\u000fKAaa\u001b\u0002\u0006\t1A+\u001e9mK^B\u0011ba\u001cI\u0003\u0003\u0005\rA!(\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003D\tA1\u000b[;uI><hnE\u0003K\u0005\u0007\u001aI\b\u0005\u0003\u0003F\rm\u0014\u0002BB?\u0005\u000f\u0012\u0001BU;o]\u0006\u0014G.Z\u0001\u0003]\u001e$Baa!\u0004\u0006B\u0019!q\u0014&\t\r\r}D\n1\u0001m\u0003\r\u0011XO\u001c\u0002\u000e\u001d\u0006LGnZ;o!\u0006\u0014\u0018-\\:\u0014\u00079\u0013I\u0003\u0006\u0002\u0004\u0010B\u0019!q\u0014(\u0002\t!|7\u000f^\u0001\tQ>\u001cHo\u0018\u0013fcR!\u0011Q\\BL\u0011%\u0011\t'UA\u0001\u0002\u0004\tY)A\u0003i_N$\b\u0005K\u0006S\u0007;\u001bika,\u00046\u000e]\u0006\u0003BBP\u0007Sk!a!)\u000b\t\r\r6QU\u0001\u000bU\u000e|W.\\1oI\u0016\u0014(bABTe\u0006)!-Z;ti&!11VBQ\u0005%\u0001\u0016M]1nKR,'/A\u0003oC6,7\u000f\f\u0002\u00042\u0006\u001211W\u0001\u0007[5Bwn\u001d;\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0007s\u000bq#\u00113ee\u0016\u001c8\u000f\t;pA\tLg\u000e\u001a\u0011bO\u0006Lgn\u001d;\u0002\u0011A|'\u000f^0%KF$B!!8\u0004@\"I!\u0011\r+\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0006a>\u0014H\u000f\t\u0015\u0010+\u000eu5QVBc\u0007k\u001bYma4\u0004R2\u00121qY\u0011\u0003\u0007\u0013\fa!L\u0017q_J$\u0018EABg\u0003Q\u0001vN\u001d;!i>\u0004#-\u001b8eA\u0005<\u0017-\u001b8ti\u0006aa/\u00197jI\u0006$XmV5uQ2\u001211[\u0012\u0003\u0007+\u0004Baa6\u0004^:!!qDBm\u0013\r\u0019Y\u000eY\u0001\u0014!\u0006\u0014\u0018-\\3uKJ4\u0016\r\\5eCR|'o]\u0005\u0005\u0007?\u001c\tOA\bQ_NLG/\u001b<f\u0013:$XmZ3s\u0015\r\u0019Y\u000eY\u0001\ta>|GnU5{K\u0006a\u0001o\\8m'&TXm\u0018\u0013fcR!\u0011Q\\Bu\u0011%\u0011\tgVA\u0001\u0002\u0004\t\t!A\u0005q_>d7+\u001b>fA!z\u0001l!(\u0004.\u000e=8QWB{\u0007\u001f\u001cI\u0010\f\u0002\u0004r\u0006\u001211_\u0001\f[5\u0002xn\u001c7.g&TX-\t\u0002\u0004x\u0006\u00114+\u001b>fA=4\u0007\u0005\u001e5fAQD'/Z1eAA|w\u000e\u001c\u0011vg\u0016$\u0007EZ8sA!\fg\u000e\u001a7j]\u001e\u0004#/Z9vKN$8\u000f\f\u0002\u0004T\u00069A/[7f_V$XCAB\u0000!\u0011!\t\u0001\"\u0003\u000e\u0005\u0011\r!\u0002\u0002C\u0003\t\u000f\t\u0001\u0002Z;sCRLwN\u001c\u0006\u0005\u0003\u0017\n)!\u0003\u0003\u0005\f\u0011\r!\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u0017QLW.Z8vi~#S-\u001d\u000b\u0005\u0003;$\t\u0002C\u0005\u0003bi\u000b\t\u00111\u0001\u0004\u0000\u0006AA/[7f_V$\b\u0005K\b\\\u0007;\u001bi\u000bb\u0006\u00046\u0012uA\u0011\u0005C\u0012Y\t!I\"\t\u0002\u0005\u001c\u0005IQ&\f;j[\u0016|W\u000f^\u0011\u0003\t?\t!,T1yS6,X\u000eI5oi\u0016\u0014h/\u00197!i>\u0004s/Y5uA\t,Go^3f]\u0002BW-\u0019:uE\u0016\fGo\u001d\u0011cK\u001a|'/\u001a\u0011d_:\u001c\u0018\u000eZ3sS:<\u0007e\u00197jK:$\b\u0005^8!Q\u00064X\r\t3jg\u000e|gN\\3di\u0016$\u0017!C2p]Z,'\u000f^3sG\t!)\u0003\u0005\u0003\u0005(\u00115b\u0002\u0002B\u0010\tSI1\u0001b\u000ba\u0003M\u0001\u0016M]1nKR,'oQ8om\u0016\u0014H/\u001a:t\u0013\u0011!y\u0003\"\r\u0003#\u0011+(/\u0019;j_:\u001cuN\u001c<feR,'OC\u0002\u0005,\u0001\f\u0001\"\u001b3mK~#S-\u001d\u000b\u0005\u0003;$9\u0004C\u0005\u0003bu\u000b\t\u00111\u0001\u0004\u0000\"zal!(\u0004.\u0012m2Q\u0017C!\tC!\u0019\u0003\f\u0002\u0005>\u0005\u0012AqH\u0001\u0007[5JG\r\\3\"\u0005\u0011\r\u0013!\u000e+j[\u0016\u0004#-\u001a4pe\u0016\u0004C\u000f[3!g\u0016\u0014h/\u001a:!SN\u00043\u000f[;uA\u0011|wO\u001c\u0011ek\u0016\u0004Co\u001c\u0011j]\u0006\u001cG/\u001b<jif\f\u0001b\u001d5vi\u0012|wO\u001c\u0002\n\u0013\u0012dWm\u00115fG.\u001cRa\u0006B\"\u0007s\"\"\u0001\"\u0014\u0011\u0007\u0011=s#D\u0001\u0001\u0001")
public class NailgunServer
extends NGServer {
    public final long org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis;
    private final MetricRegistry org$locationtech$geomesa$tools$utils$NailgunServer$$registry;
    private final Phaser org$locationtech$geomesa$tools$utils$NailgunServer$$requests;
    private final long start;
    private final AtomicLong org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest;
    private final LoadingCache<String, Tuple2<AtomicInteger, Timer>> timers;
    private final Future<?> idle;

    public static void main(String[] args) {
        NailgunServer$.MODULE$.main(args);
    }

    public MetricRegistry org$locationtech$geomesa$tools$utils$NailgunServer$$registry() {
        return this.org$locationtech$geomesa$tools$utils$NailgunServer$$registry;
    }

    public Phaser org$locationtech$geomesa$tools$utils$NailgunServer$$requests() {
        return this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests;
    }

    private long start() {
        return this.start;
    }

    public AtomicLong org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest() {
        return this.org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest;
    }

    private LoadingCache<String, Tuple2<AtomicInteger, Timer>> timers() {
        return this.timers;
    }

    private Future<?> idle() {
        return this.idle;
    }

    public void execute(package.Command command) {
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests().register();
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest().set(System.currentTimeMillis());
        try {
            package.Command command2 = command;
            if (command2 instanceof NailgunAware) {
                NailgunAware nailgunAware = (NailgunAware)command2;
                nailgunAware.nailgun_$eq((Option<NailgunServer>)new Some((Object)this));
            }
            Tuple2 tuple2 = (Tuple2)this.timers().get((Object)command.name());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AtomicInteger active = (AtomicInteger)tuple2._1();
            Timer timer = (Timer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)active, (Object)timer);
            AtomicInteger active2 = (AtomicInteger)tuple22._1();
            Timer timer2 = (Timer)tuple22._2();
            active2.incrementAndGet();
            try {
                timer2.time((Runnable)command);
            }
            finally {
                active2.decrementAndGet();
            }
        }
        finally {
            this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests().arriveAndDeregister();
        }
    }

    public long started() {
        return this.start();
    }

    public Seq<CommandStat> stats() {
        return (Seq)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.timers().asMap()).asScala()).toSeq().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    AtomicInteger active = (AtomicInteger)tuple22._1();
                    Timer timer = (Timer)tuple22._2();
                    Snapshot snap = timer.getSnapshot();
                    return new CommandStat(name, active.get(), timer.getCount(), snap.getMean(), snap.getMedian(), snap.get95thPercentile(), timer.getMeanRate());
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void shutdown() {
        super.shutdown();
        this.idle().cancel(true);
    }

    public NailgunServer(InetAddress addr, int port, int sessionPoolSize, int timeoutMillis, long idleTimeoutMillis) {
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis = idleTimeoutMillis;
        super(addr, port, sessionPoolSize, timeoutMillis);
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$registry = new MetricRegistry();
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests = new Phaser(1);
        this.start = System.currentTimeMillis();
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest = new AtomicLong(System.currentTimeMillis());
        this.timers = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, Tuple2<AtomicInteger, Timer>>(this){
            private final /* synthetic */ NailgunServer $outer;

            public Map<? extends String, ? extends Tuple2<AtomicInteger, Timer>> loadAll(Set<? extends String> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) throws Exception {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<? extends Map<? extends String, ? extends Tuple2<AtomicInteger, Timer>>> asyncLoadAll(Set<? extends String> x$1, Executor x$2) throws Exception {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) throws Exception {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Tuple2<AtomicInteger, Timer> load(String k) {
                return new Tuple2((Object)new AtomicInteger(0), (Object)this.$outer.org$locationtech$geomesa$tools$utils$NailgunServer$$registry().timer(k));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.idle = CachedThreadPool$.MODULE$.submit((Runnable)new IdleCheck());
    }

    public static class CommandStat
    implements Product,
    Serializable {
        private final String name;
        private final int active;
        private final long complete;
        private final double mean;
        private final double median;
        private final double n95;
        private final double rate;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public int active() {
            return this.active;
        }

        public long complete() {
            return this.complete;
        }

        public double mean() {
            return this.mean;
        }

        public double median() {
            return this.median;
        }

        public double n95() {
            return this.n95;
        }

        public double rate() {
            return this.rate;
        }

        public CommandStat copy(String name, int active, long complete, double mean, double median, double n95, double rate) {
            return new CommandStat(name, active, complete, mean, median, n95, rate);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.active();
        }

        public long copy$default$3() {
            return this.complete();
        }

        public double copy$default$4() {
            return this.mean();
        }

        public double copy$default$5() {
            return this.median();
        }

        public double copy$default$6() {
            return this.n95();
        }

        public double copy$default$7() {
            return this.rate();
        }

        public String productPrefix() {
            return "CommandStat";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.active());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.complete());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this.mean());
                }
                case 4: {
                    return BoxesRunTime.boxToDouble((double)this.median());
                }
                case 5: {
                    return BoxesRunTime.boxToDouble((double)this.n95());
                }
                case 6: {
                    return BoxesRunTime.boxToDouble((double)this.rate());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CommandStat;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "active";
                }
                case 2: {
                    return "complete";
                }
                case 3: {
                    return "mean";
                }
                case 4: {
                    return "median";
                }
                case 5: {
                    return "n95";
                }
                case 6: {
                    return "rate";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.active());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.complete()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mean()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.median()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.n95()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.rate()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CommandStat)) return false;
            boolean bl = true;
            if (!bl) return false;
            CommandStat commandStat = (CommandStat)x$1;
            if (this.active() != commandStat.active()) return false;
            if (this.complete() != commandStat.complete()) return false;
            if (this.mean() != commandStat.mean()) return false;
            if (this.median() != commandStat.median()) return false;
            if (this.n95() != commandStat.n95()) return false;
            if (this.rate() != commandStat.rate()) return false;
            String string = this.name();
            String string2 = commandStat.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!commandStat.canEqual(this)) return false;
            return true;
        }

        public CommandStat(String name, int active, long complete, double mean, double median, double n95, double rate) {
            this.name = name;
            this.active = active;
            this.complete = complete;
            this.mean = mean;
            this.median = median;
            this.n95 = n95;
            this.rate = rate;
            Product.$init$((Product)this);
        }
    }

    public class IdleCheck
    implements Runnable {
        @Override
        public void run() {
            boolean loop = true;
            try {
                Thread.sleep(this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                loop = false;
            }
            while (loop) {
                try {
                    long remaining;
                    int phase = this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$requests().arrive();
                    if (this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$requests().getPhase() == phase) {
                        this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$requests().awaitAdvanceInterruptibly(phase);
                        Thread.sleep(30000L);
                    }
                    if ((remaining = this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis - (System.currentTimeMillis() - this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest().get())) <= 0L) {
                        loop = false;
                        this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().shutdown();
                        continue;
                    }
                    Thread.sleep(remaining);
                }
                catch (InterruptedException interruptedException) {
                    loop = false;
                }
            }
        }

        public /* synthetic */ NailgunServer org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer() {
            return NailgunServer.this;
        }

        public IdleCheck() {
            if (NailgunServer.this == null) {
                throw null;
            }
        }
    }

    public static interface NailgunAware
    extends package.Command {
        public Option<NailgunServer> nailgun();

        public void nailgun_$eq(Option<NailgunServer> var1);

        public static void $init$(NailgunAware $this) {
            $this.nailgun_$eq((Option<NailgunServer>)None$.MODULE$);
        }
    }

    public static class NailgunParams {
        @Parameter(names={"--host"}, description="Address to bind against")
        private String host;
        @Parameter(names={"--port"}, description="Port to bind against", validateWith={ParameterValidators.PositiveInteger.class})
        private int port = 2113;
        @Parameter(names={"--pool-size"}, description="Size of the thread pool used for handling requests", validateWith={ParameterValidators.PositiveInteger.class})
        private int poolSize = 2;
        @Parameter(names={"--timeout"}, description="Maximum interval to wait between heartbeats before considering client to have disconnected", converter=ParameterConverters.DurationConverter.class)
        private Duration timeout = Duration$.MODULE$.apply(10000L, TimeUnit.MILLISECONDS);
        @Parameter(names={"--idle"}, description="Time before the server is shut down due to inactivity", converter=ParameterConverters.DurationConverter.class)
        private Duration idle = Duration$.MODULE$.apply(1L, TimeUnit.HOURS);

        public String host() {
            return this.host;
        }

        public void host_$eq(String x$1) {
            this.host = x$1;
        }

        public int port() {
            return this.port;
        }

        public void port_$eq(int x$1) {
            this.port = x$1;
        }

        public int poolSize() {
            return this.poolSize;
        }

        public void poolSize_$eq(int x$1) {
            this.poolSize = x$1;
        }

        public Duration timeout() {
            return this.timeout;
        }

        public void timeout_$eq(Duration x$1) {
            this.timeout = x$1;
        }

        public Duration idle() {
            return this.idle;
        }

        public void idle_$eq(Duration x$1) {
            this.idle = x$1;
        }
    }

    public static class Shutdown
    implements Runnable {
        private final NGServer ng;

        @Override
        public void run() {
            this.ng.shutdown();
            for (int count2 = 0; this.ng.isRunning() && count2 < 50; ++count2) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.ng.isRunning()) {
                System.err.println("Unable to cleanly shutdown server.  Exiting JVM Anyway.");
                return;
            }
            System.out.println("NGServer shut down.");
        }

        public Shutdown(NGServer ng) {
            this.ng = ng;
        }
    }
}

