/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import java.io.File;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.JobWithLibJars;
import org.locationtech.geomesa.tools.export.ExportFormat;
import org.locationtech.geomesa.tools.export.ExportJob;
import org.locationtech.geomesa.tools.export.ExportJob$Config$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ExportJob$
implements JobWithLibJars {
    public static final ExportJob$ MODULE$ = new ExportJob$();
    private static final NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat;
    private static final NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat;

    static {
        JobWithLibJars.$init$((JobWithLibJars)MODULE$);
        org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat = MODULE$.createFormat(4);
        org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat = MODULE$.createFormat(5);
    }

    public void setLibJars(Job job, Seq<String> fileNames, Iterator<Function0<Seq<File>>> searchPath) {
        JobWithLibJars.setLibJars$((JobWithLibJars)this, (Job)job, fileNames, searchPath);
    }

    public NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat() {
        return org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat;
    }

    public NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat() {
        return org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat;
    }

    public Job configure(Job job, Map<String, String> dsParams, SimpleFeatureType sft, Hints hints, String filename, Path output, ExportFormat format, boolean headers, Option<Object> chunks, Option<Object> gzip, int reducers, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths) {
        Configuration conf = job.getConfiguration();
        this.setLibJars(job, libjarsFiles, libjarsPaths);
        conf.set("mapreduce.job.user.classpath.first", "true");
        job.setJarByClass(this.getClass());
        job.setMapperClass(ExportJob.PassThroughMapper.class);
        job.setOutputFormatClass(ExportJob.ExportOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(ScalaSimpleFeature.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        ExportJob$Config$.MODULE$.setOutputFile(conf, filename);
        ExportJob$Config$.MODULE$.setFormat(conf, format);
        ExportJob$Config$.MODULE$.setHeaders(conf, headers);
        chunks.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$1 -> ExportJob$Config$.MODULE$.setChunks(conf, x$1));
        gzip.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> ExportJob$Config$.MODULE$.setGzip(conf, x$2));
        ExportJob$Config$.MODULE$.setQueryHints(conf, hints);
        if (conf.get(GeoMesaConfigurator.Keys$.MODULE$.FeatureReducer()) != null) {
            throw new IllegalArgumentException("Query requires a feature reduce step, which is not supported in this job");
        }
        Option option = GeoMesaConfigurator$.MODULE$.getSorting(conf);
        if (None$.MODULE$.equals(option)) {
            job.setNumReduceTasks(0);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Seq sort = (Seq)some.value();
            Predef$.MODULE$.require(reducers > 0, (Function0 & Serializable)() -> "Reducers must be a positive number");
            job.setNumReduceTasks(reducers);
            job.setReducerClass(Reducer.class);
            job.setMapperClass(ExportJob.SortKeyMapper.class);
            Seq sortBy = (Seq)sort.map((Function1 & Serializable)x$3 -> (String)x$3._1());
            boolean reverse = ((Tuple2)sort.head())._2$mcZ$sp();
            if (sortBy.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ExportJob$.$anonfun$configure$5(sft, x$4)))) {
                throw new IllegalArgumentException(new StringBuilder(41).append("Trying to sort by non-existing property: ").append(sortBy.mkString(", ")).toString());
            }
            if (sort.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ExportJob$.$anonfun$configure$6(reverse, x$5)))) {
                throw new IllegalArgumentException(new StringBuilder(66).append("Sort order is required to be the same across all sort properties: ").append(QueryHints$.MODULE$.sortReadableString(sort)).toString());
            }
            if (reverse) {
                job.setSortComparatorClass(ExportJob.ReverseComparator.class);
            }
            if (reducers > 1) {
                TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)new Path(FileOutputFormat.getOutputPath((JobContext)job), new StringBuilder(11).append(UUID.randomUUID()).append(".partitions").toString()));
                InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new ExportJob.FallbackSampler(0.01, 1000, 100));
                job.setPartitionerClass(TotalOrderPartitioner.class);
            }
        } else {
            throw new MatchError((Object)option);
        }
        job.setMapSpeculativeExecution(false);
        job.setReduceSpeculativeExecution(false);
        conf.set("mapreduce.job.reduce.slowstart.completedmaps", ".90");
        return job;
    }

    private NumberFormat createFormat(int digits) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(digits);
        nf.setGroupingUsed(false);
        return nf;
    }

    public static final /* synthetic */ boolean $anonfun$configure$5(SimpleFeatureType sft$1, String x$4) {
        return sft$1.indexOf(x$4) == -1;
    }

    public static final /* synthetic */ boolean $anonfun$configure$6(boolean reverse$1, Tuple2 x$5) {
        return x$5._2$mcZ$sp() != reverse$1;
    }

    private ExportJob$() {
    }
}

