/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.bin;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.locationtech.geomesa.utils.bin.AxisOrder$;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$RichTraversableOnce$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecParser$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class BinaryOutputEncoder$
implements LazyLogging {
    public static BinaryOutputEncoder$ MODULE$;
    private final SimpleFeatureType BinEncodedSft;
    private final int BIN_ATTRIBUTE_INDEX;
    private final Ordering<byte[]> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BinaryOutputEncoder$();
    }

    private Logger logger$lzycompute() {
        BinaryOutputEncoder$ binaryOutputEncoder$ = this;
        synchronized (binaryOutputEncoder$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public SimpleFeatureType BinEncodedSft() {
        return this.BinEncodedSft;
    }

    public int BIN_ATTRIBUTE_INDEX() {
        return this.BIN_ATTRIBUTE_INDEX;
    }

    public Ordering<byte[]> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering() {
        return this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering;
    }

    public BinaryOutputEncoder apply(SimpleFeatureType sft, BinaryOutputEncoder.EncodingOptions options) {
        return new BinaryOutputEncoder(this.toValues(sft, options));
    }

    public int convertToTrack(SimpleFeature f, int i) {
        return this.convertToTrack(f.getAttribute(i));
    }

    public int convertToTrack(Object track) {
        return track == null ? 0 : track.hashCode();
    }

    public long convertToDate(SimpleFeature f, int i) {
        return this.convertToDate((Date)f.getAttribute(i));
    }

    public long convertToDate(Date date) {
        return date == null ? 0L : date.getTime();
    }

    public long convertToLabel(SimpleFeature f, int i) {
        return this.convertToLabel(f.getAttribute(i));
    }

    public long convertToLabel(Object label) {
        long l;
        Object object = label;
        if (object == null) {
            l = 0L;
        } else if (object instanceof Number) {
            Number number = (Number)object;
            l = number.longValue();
        } else {
            LongRef sum = LongRef.create((long)0L);
            ScalaImplicits$RichTraversableOnce$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichTraversableOnce(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(label.toString().getBytes(StandardCharsets.UTF_8))).iterator().take(8)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                BinaryOutputEncoder$.$anonfun$convertToLabel$1(sum, BoxesRunTime.unboxToByte((Object)x0$1), BoxesRunTime.unboxToInt((Object)x1$1));
                return BoxedUnit.UNIT;
            });
            l = sum.elem;
        }
        return l;
    }

    public void decode(byte[] encoded, BinaryOutputCallback callback) {
        ByteBuffer buf = ByteBuffer.wrap(encoded).order(ByteOrder.LITTLE_ENDIAN);
        int trackId = buf.getInt();
        long time = (long)buf.getInt() * 1000L;
        float lat = buf.getFloat();
        float lon = buf.getFloat();
        if (encoded.length > 16) {
            long label = buf.getLong();
            callback.apply(trackId, lat, lon, time, label);
        } else {
            callback.apply(trackId, lat, lon, time);
        }
    }

    public BinaryOutputEncoder.EncodedValues decode(byte[] encoded) {
        ObjectRef values = ObjectRef.create(null);
        this.decode(encoded, new BinaryOutputCallback(values){
            private final ObjectRef values$1;

            public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg) {
                BinaryOutputCallback.put$(this, buffer, trackId, lat, lon, dtg);
            }

            public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg, long label) {
                BinaryOutputCallback.put$(this, buffer, trackId, lat, lon, dtg, label);
            }

            public void apply(int trackId, float lat, float lon, long dtg) {
                this.values$1.elem = new BinaryOutputEncoder.EncodedValues(trackId, lat, lon, dtg, -1L);
            }

            public void apply(int trackId, float lat, float lon, long dtg, long label) {
                this.values$1.elem = new BinaryOutputEncoder.EncodedValues(trackId, lat, lon, dtg, label);
            }
            {
                this.values$1 = values$1;
                BinaryOutputCallback.$init$(this);
            }
        });
        return (BinaryOutputEncoder.EncodedValues)values.elem;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private BinaryOutputEncoder.ToValues toValues(SimpleFeatureType sft, BinaryOutputEncoder.EncodingOptions options) {
        block33: {
            block35: {
                block37: {
                    block36: {
                        block34: {
                            block32: {
                                geomIndex = BoxesRunTime.unboxToInt((Object)options.geomField().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$toValues$1(org.opengis.feature.simple.SimpleFeatureType ), ()I)((SimpleFeatureType)sft)));
                                if (geomIndex == -1) {
                                    throw new IllegalArgumentException(new StringBuilder(50).append("Invalid geometry field requested for feature type ").append(sft.getTypeName()).toString());
                                }
                                dtgIndex = BoxesRunTime.unboxToInt((Object)options.dtgField().orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$toValues$2(org.opengis.feature.simple.SimpleFeatureType ), ()Lscala/Option;)((SimpleFeatureType)sft)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$toValues$3(), ()I)()));
                                if (dtgIndex == -1) {
                                    throw new RuntimeException(new StringBuilder(46).append("Invalid date field requested for feature type ").append(sft.getTypeName()).toString());
                                }
                                isSingleDate = Date.class.isAssignableFrom(sft.getDescriptor(dtgIndex).getType().getBinding());
                                axisOrder = (Enumeration.Value)options.axisOrder().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$toValues$4(), ()Lscala/Enumeration$Value;)());
                                v0 = binding = sft.getDescriptor(geomIndex).getType().getBinding();
                                var17_8 = Point.class;
                                v1 = binding;
                                var18_9 = LineString.class;
                                var15_10 = new Tuple2.mcZZ.sp(!(v0 != null ? v0.equals(var17_8) == false : var17_8 != null), !(v1 != null ? v1.equals(var18_9) == false : var18_9 != null));
                                if (var15_10 == null) {
                                    throw new MatchError((Object)var15_10);
                                }
                                isPoint = var15_10._1$mcZ$sp();
                                isLineString = var15_10._2$mcZ$sp();
                                var9_13 = new Tuple2.mcZZ.sp(isPoint, isLineString);
                                var14_14 = var9_13;
                                isPoint = var14_14._1$mcZ$sp();
                                isLineString = var14_14._2$mcZ$sp();
                                if (options.trackIdField().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, $anonfun$toValues$5(int ), (I)Z)())) {
                                    throw new IllegalArgumentException(new StringBuilder(47).append("Invalid track field requested for feature type ").append(sft.getTypeName()).toString());
                                }
                                if (options.labelField().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, $anonfun$toValues$6(int ), (I)Z)())) {
                                    throw new IllegalArgumentException(new StringBuilder(47).append("Invalid label field requested for feature type ").append(sft.getTypeName()).toString());
                                }
                                if (!isSingleDate) {
                                    if (isLineString) {
                                        dtgField = sft.getDescriptor(dtgIndex).getLocalName();
                                        sftAttributes = SimpleFeatureSpecParser$.MODULE$.parse(SimpleFeatureTypes$.MODULE$.encodeType(sft), SimpleFeatureSpecParser$.MODULE$.parse$default$2()).attributes();
                                        sftAttributes.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$7$adapted(java.lang.String org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec$AttributeSpec ), (Lorg/locationtech/geomesa/utils/geotools/sft/SimpleFeatureSpec$AttributeSpec;)Ljava/lang/Object;)((String)dtgField)).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$8$adapted(org.opengis.feature.simple.SimpleFeatureType org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec$AttributeSpec ), (Lorg/locationtech/geomesa/utils/geotools/sft/SimpleFeatureSpec$AttributeSpec;)Ljava/lang/Object;)((SimpleFeatureType)sft));
                                    } else {
                                        throw new RuntimeException(new StringBuilder(46).append("Invalid date field requested for feature type ").append(sft.getTypeName()).toString());
                                    }
                                }
                                if (None$.MODULE$.equals(var26_19 = options.trackIdField())) {
                                    var8_20 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$9$adapted(org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)Ljava/lang/Object;)();
                                } else if (var26_19 instanceof Some) {
                                    var27_21 = (Some)var26_19;
                                    trackId = BoxesRunTime.unboxToInt((Object)var27_21.value());
                                    var8_20 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$10$adapted(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)Ljava/lang/Object;)((int)trackId);
                                } else {
                                    throw new MatchError(var26_19);
                                }
                                getTrackId = var8_20;
                                getLabelOption = options.labelField().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$11$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Function1;)());
                                if (!isLineString) break block32;
                                var31_25 = axisOrder;
                                v2 = AxisOrder$.MODULE$.LatLon();
                                var32_26 = var31_25;
                                if (!(v2 != null ? v2.equals(var32_26) == false : var32_26 != null)) {
                                    var7_27 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$13(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)[Lscala/Tuple2;)((int)geomIndex);
                                } else {
                                    v3 = AxisOrder$.MODULE$.LonLat();
                                    var33_28 = var31_25;
                                    if (!(v3 != null ? v3.equals(var33_28) == false : var33_28 != null)) {
                                        var7_27 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$14(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)[Lscala/Tuple2;)((int)geomIndex);
                                    } else {
                                        throw new MatchError((Object)var31_25);
                                    }
                                }
                                getLineLatLon = var7_27;
                                if (isSingleDate) {
                                    var34_30 = getLabelOption;
                                    if (None$.MODULE$.equals(var34_30)) {
                                        var6_31 /* !! */  = new BinaryOutputEncoder.ToValuesLines((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, dtgIndex);
                                    } else if (var34_30 instanceof Some) {
                                        var35_32 = (Some)var34_30;
                                        getLabel = (Function1)var35_32.value();
                                        var6_31 /* !! */  = new BinaryOutputEncoder.ToValuesLinesLabels((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, (Function1<SimpleFeature, Object>)getLabel, dtgIndex);
                                    } else {
                                        throw new MatchError((Object)var34_30);
                                    }
                                    v4 /* !! */  = var6_31 /* !! */ ;
                                } else {
                                    getLineDtg = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$15(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)[J)((int)dtgIndex);
                                    var38_35 = getLabelOption;
                                    if (None$.MODULE$.equals(var38_35)) {
                                        var5_36 /* !! */  = new BinaryOutputEncoder.ToValuesLinesDates((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, (Function1<SimpleFeature, long[]>)getLineDtg);
                                    } else if (var38_35 instanceof Some) {
                                        var39_37 = (Some)var38_35;
                                        getLabel = (Function1)var39_37.value();
                                        var5_36 /* !! */  = new BinaryOutputEncoder.ToValuesLinesDatesLabels((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, (Function1<SimpleFeature, long[]>)getLineDtg, (Function1<SimpleFeature, Object>)getLabel);
                                    } else {
                                        throw new MatchError((Object)var38_35);
                                    }
                                    v4 /* !! */  = var5_36 /* !! */ ;
                                }
                                break block33;
                            }
                            var42_39 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isPoint), (Object)axisOrder);
                            if (var42_39 == null) break block34;
                            var43_40 = var42_39._1$mcZ$sp();
                            var44_41 = (Enumeration.Value)var42_39._2();
                            if (!var43_40) break block34;
                            v5 = AxisOrder$.MODULE$.LatLon();
                            var45_42 = var44_41;
                            if (v5 != null ? v5.equals(var45_42) == false : var45_42 != null) break block34;
                            var4_43 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$16(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)Lscala/Tuple2;)((int)geomIndex);
                            break block35;
                        }
                        if (var42_39 == null) break block36;
                        var46_44 = var42_39._1$mcZ$sp();
                        var47_45 = (Enumeration.Value)var42_39._2();
                        if (!var46_44) break block36;
                        v6 = AxisOrder$.MODULE$.LonLat();
                        var48_46 = var47_45;
                        if (v6 != null ? v6.equals(var48_46) == false : var48_46 != null) break block36;
                        var4_43 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$17(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)Lscala/Tuple2;)((int)geomIndex);
                        break block35;
                    }
                    if (var42_39 == null) break block37;
                    var49_47 = var42_39._1$mcZ$sp();
                    var50_48 = (Enumeration.Value)var42_39._2();
                    if (var49_47) break block37;
                    v7 = AxisOrder$.MODULE$.LatLon();
                    var51_49 = var50_48;
                    if (v7 != null ? v7.equals(var51_49) == false : var51_49 != null) break block37;
                    var4_43 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$18(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)Lscala/Tuple2;)((int)geomIndex);
                    break block35;
                }
                if (var42_39 == null) ** GOTO lbl-1000
                var52_50 = var42_39._1$mcZ$sp();
                var53_51 = (Enumeration.Value)var42_39._2();
                if (var52_50) ** GOTO lbl-1000
                v8 = AxisOrder$.MODULE$.LonLat();
                var54_52 = var53_51;
                if (!(v8 != null ? v8.equals(var54_52) == false : var54_52 != null)) {
                    var4_43 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toValues$19(int org.opengis.feature.simple.SimpleFeature ), (Lorg/opengis/feature/simple/SimpleFeature;)Lscala/Tuple2;)((int)geomIndex);
                } else lbl-1000:
                // 3 sources

                {
                    throw new MatchError((Object)var42_39);
                }
            }
            getLatLon = var4_43;
            var55_54 = getLabelOption;
            if (None$.MODULE$.equals(var55_54)) {
                var3_55 /* !! */  = new BinaryOutputEncoder.ToValuesPoints((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>>)getLatLon, dtgIndex);
            } else if (var55_54 instanceof Some) {
                var56_56 = (Some)var55_54;
                getLabel = (Function1)var56_56.value();
                var3_55 /* !! */  = new BinaryOutputEncoder.ToValuesPointsLabels((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>>)getLatLon, (Function1<SimpleFeature, Object>)getLabel, dtgIndex);
            } else {
                throw new MatchError((Object)var55_54);
            }
            v4 /* !! */  = var3_55 /* !! */ ;
        }
        return v4 /* !! */ ;
    }

    private Tuple2<Object, Object> pointToXY(Point p) {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((float)p.getX())), (Object)BoxesRunTime.boxToFloat((float)((float)p.getY())));
    }

    private Tuple2<Object, Object> pointToYX(Point p) {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((float)p.getY())), (Object)BoxesRunTime.boxToFloat((float)((float)p.getX())));
    }

    private Tuple2<Object, Object> pointToXY(SimpleFeature f, int i) {
        return this.pointToXY((Point)f.getAttribute(i));
    }

    private Tuple2<Object, Object> pointToYX(SimpleFeature f, int i) {
        return this.pointToYX((Point)f.getAttribute(i));
    }

    private Tuple2<Object, Object> geomToXY(SimpleFeature f, int i) {
        return this.pointToXY(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)f.getAttribute(i))));
    }

    private Tuple2<Object, Object> geomToYX(SimpleFeature f, int i) {
        return this.pointToYX(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)f.getAttribute(i))));
    }

    private Tuple2<Object, Object>[] lineToXY(SimpleFeature f, int i2) {
        LineString line = (LineString)f.getAttribute(i2);
        return (Tuple2[])Array$.MODULE$.tabulate(line.getNumPoints(), (Function1 & Serializable & scala.Serializable)i -> BinaryOutputEncoder$.MODULE$.pointToXY(line.getPointN(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Tuple2<Object, Object>[] lineToYX(SimpleFeature f, int i2) {
        LineString line = (LineString)f.getAttribute(i2);
        return (Tuple2[])Array$.MODULE$.tabulate(line.getNumPoints(), (Function1 & Serializable & scala.Serializable)i -> BinaryOutputEncoder$.MODULE$.pointToYX(line.getPointN(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private long[] dateArray(SimpleFeature f, int i) {
        List dates = (List)f.getAttribute(i);
        return dates == null ? (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.Long()) : (long[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.getTime()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
    }

    public static final /* synthetic */ void $anonfun$convertToLabel$1(LongRef sum$1, byte x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)x0$1), (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 != null) {
            byte b = BoxesRunTime.unboxToByte((Object)tuple2._1());
            int i = tuple2._2$mcI$sp();
            sum$1.elem += ((long)b & 0xFFL) << 8 * i;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$toValues$1(SimpleFeatureType sft$1) {
        return RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1));
    }

    public static final /* synthetic */ Option $anonfun$toValues$2(SimpleFeatureType sft$1) {
        return RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1));
    }

    public static final /* synthetic */ int $anonfun$toValues$3() {
        return -1;
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$toValues$4() {
        return AxisOrder$.MODULE$.LonLat();
    }

    public static final /* synthetic */ boolean $anonfun$toValues$5(int x$4) {
        return x$4 == -1;
    }

    public static final /* synthetic */ boolean $anonfun$toValues$6(int x$5) {
        return x$5 == -1;
    }

    public static final /* synthetic */ boolean $anonfun$toValues$7(String dtgField$1, SimpleFeatureSpec.AttributeSpec x$6) {
        String string = x$6.name();
        String string2 = dtgField$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$toValues$8(SimpleFeatureType sft$1, SimpleFeatureSpec.AttributeSpec spec) {
        if (!(spec instanceof SimpleFeatureSpec.ListAttributeSpec) || !Date.class.isAssignableFrom(((SimpleFeatureSpec.ListAttributeSpec)spec).subClass())) {
            throw new RuntimeException(new StringBuilder(46).append("Invalid date field requested for feature type ").append(sft$1.getTypeName()).toString());
        }
    }

    public static final /* synthetic */ int $anonfun$toValues$9(SimpleFeature f) {
        return f.getID().hashCode();
    }

    public static final /* synthetic */ Function1 $anonfun$toValues$11(int labelIndex) {
        return (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)BinaryOutputEncoder$.MODULE$.convertToLabel(x$8, labelIndex));
    }

    public static final /* synthetic */ Tuple2[] $anonfun$toValues$13(int geomIndex$1, SimpleFeature x$9) {
        return MODULE$.lineToXY(x$9, geomIndex$1);
    }

    public static final /* synthetic */ Tuple2[] $anonfun$toValues$14(int geomIndex$1, SimpleFeature x$10) {
        return MODULE$.lineToYX(x$10, geomIndex$1);
    }

    public static final /* synthetic */ long[] $anonfun$toValues$15(int dtgIndex$1, SimpleFeature x$11) {
        return MODULE$.dateArray(x$11, dtgIndex$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$toValues$16(int geomIndex$1, SimpleFeature x$12) {
        return MODULE$.pointToXY(x$12, geomIndex$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$toValues$17(int geomIndex$1, SimpleFeature x$13) {
        return MODULE$.pointToYX(x$13, geomIndex$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$toValues$18(int geomIndex$1, SimpleFeature x$14) {
        return MODULE$.geomToXY(x$14, geomIndex$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$toValues$19(int geomIndex$1, SimpleFeature x$15) {
        return MODULE$.geomToYX(x$15, geomIndex$1);
    }

    private BinaryOutputEncoder$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.BinEncodedSft = SimpleFeatureTypes$.MODULE$.createType("bin", "bin:Bytes,*geom:Point:srid=4326");
        this.BIN_ATTRIBUTE_INDEX = 0;
        this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering = new Ordering<byte[]>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<byte[]> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, byte[]> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(byte[] x, byte[] y) {
                int compare1 = Ordering.Byte$.MODULE$.compare(x[4], y[4]);
                if (compare1 != 0) {
                    return compare1;
                }
                int compare2 = Ordering.Byte$.MODULE$.compare(x[5], y[5]);
                if (compare2 != 0) {
                    return compare2;
                }
                int compare3 = Ordering.Byte$.MODULE$.compare(x[6], y[6]);
                if (compare3 != 0) {
                    return compare3;
                }
                return Ordering.Byte$.MODULE$.compare(x[7], y[7]);
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    public static final /* synthetic */ Object $anonfun$toValues$7$adapted(String dtgField$1, SimpleFeatureSpec.AttributeSpec x$6) {
        return BoxesRunTime.boxToBoolean((boolean)BinaryOutputEncoder$.$anonfun$toValues$7(dtgField$1, x$6));
    }

    public static final /* synthetic */ Object $anonfun$toValues$8$adapted(SimpleFeatureType sft$1, SimpleFeatureSpec.AttributeSpec spec) {
        BinaryOutputEncoder$.$anonfun$toValues$8(sft$1, spec);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$toValues$9$adapted(SimpleFeature f) {
        return BoxesRunTime.boxToInteger((int)BinaryOutputEncoder$.$anonfun$toValues$9(f));
    }

    public static final /* synthetic */ Object $anonfun$toValues$10$adapted(int trackId$1, SimpleFeature x$7) {
        return BoxesRunTime.boxToInteger((int)BinaryOutputEncoder$.MODULE$.convertToTrack(x$7, trackId$1));
    }

    public static final /* synthetic */ Function1 $anonfun$toValues$11$adapted(Object labelIndex) {
        return BinaryOutputEncoder$.$anonfun$toValues$11(BoxesRunTime.unboxToInt((Object)labelIndex));
    }
}

