/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.classpath;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ClassPathUtils$
implements LazyLogging {
    public static ClassPathUtils$ MODULE$;
    private final FilenameFilter jarFileFilter;
    private final FileFilter folderFileFilter;
    private final FileFilter fileFilter;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ClassPathUtils$();
    }

    private Logger logger$lzycompute() {
        ClassPathUtils$ classPathUtils$ = this;
        synchronized (classPathUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private FilenameFilter jarFileFilter() {
        return this.jarFileFilter;
    }

    private FileFilter folderFileFilter() {
        return this.folderFileFilter;
    }

    private FileFilter fileFilter() {
        return this.fileFilter;
    }

    public Seq<File> findJars(Seq<String> jars, Iterator<Function0<Seq<File>>> searchPath) {
        BoxedUnit boxedUnit;
        ArrayBuffer foundJars = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Seq remaining = jars;
        while (remaining.nonEmpty() && searchPath.hasNext()) {
            Seq files = (Seq)((Function0)searchPath.next()).apply();
            remaining = (Seq)remaining.filter((Function1 & Serializable & scala.Serializable)jarPrefix -> BoxesRunTime.boxToBoolean((boolean)ClassPathUtils$.$anonfun$findJars$1(files, foundJars, jarPrefix)));
        }
        if (remaining.nonEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Could not find requested jars: {}", new Object[]{remaining});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((SeqLike)foundJars.distinct()).toSeq();
    }

    public Seq<File> getJarsFromEnvironment(String home) {
        return (Seq)Option$.MODULE$.option2Iterable(package$.MODULE$.env().get((Object)home).map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory()))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)dir -> MODULE$.loadJarsFromFolder((File)dir), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<File> getJarsFromEnvironment(String home, String path) {
        return (Seq)Option$.MODULE$.option2Iterable(package$.MODULE$.env().get((Object)home).map((Function1 & Serializable & scala.Serializable)h -> new File(new File((String)h), path)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory()))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)dir -> MODULE$.loadJarsFromFolder((File)dir), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<File> getJarsFromClasspath(Class<?> clas) {
        Seq seq;
        ClassLoader classLoader = clas.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs())).map((Function1 & Serializable & scala.Serializable)u -> new File(MODULE$.cleanClassPathURL(u.getFile())), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Can't load jars from classloader of type {}", new Object[]{classLoader.getClass().getCanonicalName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    public Seq<File> getJarsFromSystemClasspath() {
        URL[] urls = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])urls)).map((Function1 & Serializable & scala.Serializable)u -> new File(MODULE$.cleanClassPathURL(u.getFile())), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<File> loadJarsFromFolder(File dir2) {
        Seq files = (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)dir2.listFiles(this.jarFileFilter()))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
        Seq children = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)dir2.listFiles(this.folderFileFilter()))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).flatMap((Function1 & Serializable & scala.Serializable)dir -> MODULE$.loadJarsFromFolder((File)dir), Seq$.MODULE$.canBuildFrom());
        return (Seq)files.$plus$plus((GenTraversableOnce)children, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<File> getFilesFromSystemProperty(String prop) {
        Seq seq;
        Option option = Option$.MODULE$.apply((Object)System.getProperty(prop));
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.toString().split(":"))).map((Function1 & Serializable & scala.Serializable)x$5 -> new File((String)x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)file -> MODULE$.loadFiles((File)file), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("No files loaded onto classpath from system property: {}", new Object[]{prop});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = (Seq)Nil$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    public Seq<File> loadFiles(File file2) {
        Seq seq;
        if (file2.isDirectory()) {
            Seq files = (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file2.listFiles(this.fileFilter()))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
            Seq childDirs = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file2.listFiles(this.folderFileFilter()))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).flatMap((Function1 & Serializable & scala.Serializable)file -> MODULE$.loadFiles((File)file), Seq$.MODULE$.canBuildFrom());
            seq = (Seq)files.$plus$plus((GenTraversableOnce)childDirs, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)file2)).toSeq();
        }
        return seq;
    }

    public String cleanClassPathURL(String url) {
        return URLDecoder.decode(url, "UTF-8").replace("file:", "").replace("!", "");
    }

    /*
     * WARNING - void declaration
     */
    public Seq<File> loadClassPathFromEnv(String prop) {
        void var2_2;
        BoxedUnit boxedUnit;
        Seq files = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(package$.MODULE$.env().get((Object)prop)).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$6)).split(':'))).toSeq(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)entry -> {
            File f;
            return entry.endsWith("/*") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File((String)new StringOps(Predef$.MODULE$.augmentString(entry)).dropRight(2)).listFiles(MODULE$.jarFileFilter()))) : ((f = new File((String)entry)).isDirectory() ? (SeqLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)f.listFiles())).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))) : (SeqLike)new .colon.colon((Object)f, (List)Nil$.MODULE$));
        }, Seq$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Loaded env classpath '{}': {}", (Object[])new String[]{prop, ((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(":")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$findJars$2(String jarPrefix$1, File x$1) {
        return x$1.getName().startsWith(jarPrefix$1);
    }

    public static final /* synthetic */ boolean $anonfun$findJars$1(Seq files$1, ArrayBuffer foundJars$1, String jarPrefix) {
        Seq matched = (Seq)files$1.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClassPathUtils$.$anonfun$findJars$2(jarPrefix, x$1)));
        foundJars$1.$plus$plus$eq((TraversableOnce)matched);
        return matched.isEmpty();
    }

    private ClassPathUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.jarFileFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && !name.endsWith("-sources.jar") && !name.endsWith("-javadoc.jar");
            }
        };
        this.folderFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        this.fileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
    }
}

