/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.conf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class ConfigLoader$
implements LazyLogging {
    public static ConfigLoader$ MODULE$;
    private Map<String, Tuple2<String, Object>> Config;
    private final String GEOMESA_CONFIG_FILE_PROP;
    private final String GEOMESA_CONFIG_FILE_NAME;
    private String EmbeddedConfigFile;
    private Logger logger;
    private volatile byte bitmap$0;

    static {
        new ConfigLoader$();
    }

    private Logger logger$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String GEOMESA_CONFIG_FILE_PROP() {
        return this.GEOMESA_CONFIG_FILE_PROP;
    }

    public String GEOMESA_CONFIG_FILE_NAME() {
        return this.GEOMESA_CONFIG_FILE_NAME;
    }

    private String EmbeddedConfigFile() {
        return this.EmbeddedConfigFile;
    }

    private Map<String, Tuple2<String, Object>> Config$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String file = (String)Option$.MODULE$.apply((Object)System.getProperty(this.GEOMESA_CONFIG_FILE_PROP())).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.GEOMESA_CONFIG_FILE_NAME());
                this.Config = this.loadConfig(this.EmbeddedConfigFile()).$plus$plus(this.loadConfig(file));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.EmbeddedConfigFile = null;
        return this.Config;
    }

    public Map<String, Tuple2<String, Object>> Config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.Config$lzycompute() : this.Config;
    }

    public Map<String, Tuple2<String, Object>> loadConfig(String path) {
        BoxedUnit boxedUnit;
        Map config;
        Map map;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
        if (input == null) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            try {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Loading config: {}", new Object[]{path});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                map = this.loadConfig(input, path);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit3;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(30).append("Error reading config file at: ").append(path).toString(), e);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                Map map2 = Predef$.MODULE$.Map().empty();
                map = config = map2;
            }
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Loaded {}", new Object[]{config.mkString(",")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return config;
    }

    public Map<String, Tuple2<String, Object>> loadConfig(InputStream input, String path) {
        Elem xml = (Elem)XML$.MODULE$.load(input);
        NodeSeq properties = xml.$bslash$bslash("configuration").$bslash$bslash("property");
        return ((TraversableOnce)properties.flatMap((Function1 & Serializable & scala.Serializable)prop -> {
            Try pair = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String key = prop.$bslash("name").text();
                String value = prop.$bslash("value").text();
                boolean isFinal = Boolean.parseBoolean(prop.$bslash("final").text());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToBoolean((boolean)isFinal)));
            });
            Try try_ = pair;
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn(new StringBuilder(31).append("Unable to load property from: ").append(path).append("\n").append(prop).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.option2Iterable(pair.toOption().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigLoader$.$anonfun$loadConfig$3(x0$1))));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$loadConfig$3(Tuple2 x0$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        String v = (String)tuple2._1();
        boolean bl = v != null && new StringOps(Predef$.MODULE$.augmentString(v)).nonEmpty();
        return bl;
    }

    private ConfigLoader$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.GEOMESA_CONFIG_FILE_PROP = "geomesa.config.file";
        this.GEOMESA_CONFIG_FILE_NAME = "geomesa-site.xml";
        this.EmbeddedConfigFile = "org/locationtech/geomesa/geomesa-site.xml.template";
    }
}

