/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.conf;

import java.io.Serializable;
import org.locationtech.geomesa.utils.conf.SemanticVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class SemanticVersion$
implements scala.Serializable {
    public static SemanticVersion$ MODULE$;
    private final Regex Regex;
    private final Regex LenientRegex;

    static {
        new SemanticVersion$();
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    private Regex Regex() {
        return this.Regex;
    }

    private Regex LenientRegex() {
        return this.LenientRegex;
    }

    public SemanticVersion apply(String version) {
        String string = version;
        Option option = this.Regex().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(7) != 0) {
            throw new MatchError((Object)string);
        }
        String major = (String)((LinearSeqOptimized)option.get()).apply(0);
        String minor = (String)((LinearSeqOptimized)option.get()).apply(1);
        String patch = (String)((LinearSeqOptimized)option.get()).apply(2);
        String preRelease = (String)((LinearSeqOptimized)option.get()).apply(4);
        String build = (String)((LinearSeqOptimized)option.get()).apply(6);
        Tuple5 tuple5 = new Tuple5((Object)major, (Object)minor, (Object)patch, (Object)preRelease, (Object)build);
        Tuple5 tuple52 = tuple5;
        String major2 = (String)tuple52._1();
        String minor2 = (String)tuple52._2();
        String patch2 = (String)tuple52._3();
        String preRelease2 = (String)tuple52._4();
        String build2 = (String)tuple52._5();
        return new SemanticVersion(new StringOps(Predef$.MODULE$.augmentString(major2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(minor2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(patch2)).toInt(), (Option<String>)Option$.MODULE$.apply((Object)preRelease2), (Option<String>)Option$.MODULE$.apply((Object)build2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SemanticVersion apply(String version, boolean lenient) {
        SemanticVersion semanticVersion;
        try {
            semanticVersion = this.apply(version);
            return semanticVersion;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) throw throwable;
            Throwable e = (Throwable)option.get();
            if (!lenient) throw throwable;
            Iterator versions = this.LenientRegex().findAllMatchIn((CharSequence)version).flatMap((Function1 & Serializable & scala.Serializable)m -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt()).toOption().iterator());
            if (!versions.hasNext()) throw e;
            Seq seq = versions.$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0}))).take(3).toSeq();
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)seq);
            }
            int major = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(0));
            int minor = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(1));
            int patch = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(2));
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)major), (Object)BoxesRunTime.boxToInteger((int)minor), (Object)BoxesRunTime.boxToInteger((int)patch));
            Tuple3 tuple32 = tuple3;
            int major2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int minor2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int patch2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            SemanticVersion semanticVersion2 = new SemanticVersion(major2, minor2, patch2, this.apply$default$4(), this.apply$default$5());
            semanticVersion = semanticVersion2;
        }
        return semanticVersion;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public int org$locationtech$geomesa$utils$conf$SemanticVersion$$comparePreReleases(Option<String> first, Option<String> second) {
        int n;
        if (first.isEmpty() && second.isEmpty()) {
            n = 0;
        } else if (first.isEmpty() && second.isDefined()) {
            n = 1;
        } else if (first.isDefined() && second.isEmpty()) {
            n = -1;
        } else {
            Either[] firstParsed = (Either[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)first.get())).split('.'))).map((Function1 & Serializable & scala.Serializable)version -> MODULE$.parsePreRelease((String)version), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Either.class)));
            Either[] secondParsed = (Either[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)second.get())).split('.'))).map((Function1 & Serializable & scala.Serializable)version -> MODULE$.parsePreRelease((String)version), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Either.class)));
            int[] compare = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstParsed)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])secondParsed), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)SemanticVersion$.$anonfun$comparePreReleases$3(x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            n = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(compare)).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstParsed)).lengthCompare(secondParsed.length)));
        }
        return n;
    }

    private Either<String, Object> parsePreRelease(String version) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(version)).toInt()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Left left = package$.MODULE$.Left().apply((Object)version);
            right = left;
        }
        return right;
    }

    public SemanticVersion apply(int major, int minor, int patch, Option<String> preRelease, Option<String> build) {
        return new SemanticVersion(major, minor, patch, preRelease, build);
    }

    public Option<Tuple5<Object, Object, Object, Option<String>, Option<String>>> unapply(SemanticVersion x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.major()), (Object)BoxesRunTime.boxToInteger((int)x$0.minor()), (Object)BoxesRunTime.boxToInteger((int)x$0.patch()), x$0.preRelease(), x$0.build()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ int $anonfun$comparePreReleases$3(Tuple2 x0$1) {
        int n;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Either firstInt = (Either)tuple2._1();
        Either secondInt = (Either)tuple2._2();
        Either either = firstInt;
        if (either instanceof Left) {
            Left left = (Left)either;
            String f = (String)left.value();
            Either either2 = secondInt;
            if (!(either2 instanceof Left)) {
                if (!(either2 instanceof Right)) throw new MatchError((Object)either2);
                return 1;
            }
            Left left2 = (Left)either2;
            String s = (String)left2.value();
            n = f.compareTo(s);
        } else {
            if (!(either instanceof Right)) throw new MatchError((Object)either);
            Right right = (Right)either;
            int f = BoxesRunTime.unboxToInt((Object)right.value());
            Either either3 = secondInt;
            if (either3 instanceof Left) {
                return -1;
            }
            if (!(either3 instanceof Right)) throw new MatchError((Object)either3);
            Right right2 = (Right)either3;
            int s = BoxesRunTime.unboxToInt((Object)right2.value());
            if (f > s) {
                return 1;
            }
            if (f >= s) return 0;
            return -1;
        }
        int n2 = n;
        return n2;
    }

    private SemanticVersion$() {
        MODULE$ = this;
        this.Regex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.(\\d+)\\.(\\d+)(-([0-9A-Za-z-.]+))?(\\+([0-9A-Za-z-.]+))?")).r();
        this.LenientRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.?")).r();
    }
}

