/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.TwoGeoHashBoundingBox;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.TreeSet;
import scala.collection.mutable.TreeSet$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4Aa\u0006\r\u0001G!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003;\u0001\u0011\u00051\b\u0003\u0006?\u0001A\u0005\t1!Q\u0001\n}Bq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004K\u0001\u0001\u0006I!\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001J\u0011\u0019a\u0005\u0001)A\u0005\u000b\"QQ\n\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002(\t\u000fI\u0003!\u0019!C\u0001'\"1A\u000b\u0001Q\u0001\n=Cq!\u0016\u0001C\u0002\u0013\u00051\u000b\u0003\u0004W\u0001\u0001\u0006Ia\u0014\u0005\b/\u0002\u0011\r\u0011\"\u0001J\u0011\u0019A\u0006\u0001)A\u0005\u000b\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\u0001\u0007I\u0011A3\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"1A\u000e\u0001Q!\nIBQ!\u001c\u0001\u0005\u00029DQA\u001d\u0001\u0005\u0002MDQ\u0001\u001e\u0001\u0005BU\u0014!DQ8v]\u0012Lgn\u001a\"pq\u001e+w\u000eS1tQ&#XM]1u_JT!!\u0007\u000e\u0002\u000f\u001d,w\u000e[1tQ*\u00111\u0004H\u0001\u0006kRLGn\u001d\u0006\u0003;y\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002 A\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I1\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004PE*,7\r\u001e\t\u0004[A\u0012T\"\u0001\u0018\u000b\u0005=B\u0013\u0001B;uS2L!!\r\u0018\u0003\u0011%#XM]1u_J\u0004\"a\r\u001b\u000e\u0003aI!!\u000e\r\u0003\u000f\u001d+w\u000eS1tQ\u0006)Ao^8HQB\u00111\u0007O\u0005\u0003sa\u0011Q\u0003V<p\u000f\u0016|\u0007*Y:i\u0005>,h\u000eZ5oO\n{\u00070\u0001\u0004=S:LGO\u0010\u000b\u0003yu\u0002\"a\r\u0001\t\u000bY\u0012\u0001\u0019A\u001c\u0002\u0007a$\u0013\u0007\u0005\u0003A\u0007\u0016+U\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\rQ+\b\u000f\\33!\t\u0001e)\u0003\u0002H\u0003\n\u0019\u0011J\u001c;\u0002\u00111\fGo\u0015;faN,\u0012!R\u0001\nY\u0006$8\u000b^3qg\u0002\n\u0001\u0002\\8o'R,\u0007o]\u0001\nY>t7\u000b^3qg\u0002\n1\u0001\u001f\u00133!\u0011\u00015iT(\u0011\u0005\u0001\u0003\u0016BA)B\u0005\u0011auN\\4\u0002\u0017\u0015tG\rT1u\u0013:$W\r_\u000b\u0002\u001f\u0006aQM\u001c3MCRLe\u000eZ3yA\u0005YQM\u001c3M_:Le\u000eZ3y\u00031)g\u000e\u001a'p]&sG-\u001a=!\u0003\tq7/A\u0002og\u0002\nQ!];fk\u0016,\u0012a\u0017\t\u00049\u0006\u0014T\"A/\u000b\u0005y{\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003A\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u0011WLA\u0004Ue\u0016,7+\u001a;\u0002\rE,X-^3!\u0003\u0019qW\r\u001f;HQV\t!'\u0001\u0006oKb$x\t[0%KF$\"\u0001[6\u0011\u0005\u0001K\u0017B\u00016B\u0005\u0011)f.\u001b;\t\u000fy\u0012\u0012\u0011!a\u0001e\u00059a.\u001a=u\u000f\"\u0004\u0013a\u00025bg:+\u0007\u0010\u001e\u000b\u0002_B\u0011\u0001\t]\u0005\u0003c\u0006\u0013qAQ8pY\u0016\fg.\u0001\u0003oKb$H#\u0001\u001a\u0002\rI,Wn\u001c<f)\u0005A\u0007")
public class BoundingBoxGeoHashIterator
implements Iterator<GeoHash> {
    private final TwoGeoHashBoundingBox twoGh;
    private final /* synthetic */ Tuple2 x$1;
    private final int latSteps;
    private final int lonSteps;
    private final /* synthetic */ Tuple2 x$2;
    private final long endLatIndex;
    private final long endLonIndex;
    private final int ns;
    private final TreeSet<GeoHash> queue;
    private GeoHash nextGh;

    @Override
    public void forEachRemaining(Consumer<? super GeoHash> x$1) {
        Iterator.super.forEachRemaining(x$1);
    }

    public int latSteps() {
        return this.latSteps;
    }

    public int lonSteps() {
        return this.lonSteps;
    }

    public long endLatIndex() {
        return this.endLatIndex;
    }

    public long endLonIndex() {
        return this.endLonIndex;
    }

    public int ns() {
        return this.ns;
    }

    public TreeSet<GeoHash> queue() {
        return this.queue;
    }

    public GeoHash nextGh() {
        return this.nextGh;
    }

    public void nextGh_$eq(GeoHash x$1) {
        this.nextGh = x$1;
    }

    @Override
    public boolean hasNext() {
        return this.queue().nonEmpty();
    }

    @Override
    public GeoHash next() {
        if (this.hasNext()) {
            Object object;
            Object object2;
            this.nextGh_$eq((GeoHash)this.queue().head());
            long latIndex = GeoHash$.MODULE$.gridIndexForLatitude(this.nextGh());
            long lonIndex = GeoHash$.MODULE$.gridIndexForLongitude(this.nextGh());
            if (lonIndex + 1L <= this.endLonIndex()) {
                GeoHash nextLonGh = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(latIndex, lonIndex + 1L, this.nextGh().prec());
                object2 = this.twoGh.bbox().covers(nextLonGh.getPoint()) ? BoxesRunTime.boxToBoolean((boolean)this.queue().add((Object)nextLonGh)) : BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            if (latIndex + 1L <= this.endLatIndex()) {
                GeoHash nextLatGh = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(latIndex + 1L, lonIndex, this.nextGh().prec());
                object = this.twoGh.bbox().covers(nextLatGh.getPoint()) ? BoxesRunTime.boxToBoolean((boolean)this.queue().add((Object)nextLatGh)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            throw new NoSuchElementException("No more geohashes available in iterator");
        }
        this.queue().remove((Object)this.nextGh());
        return this.nextGh();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation not supported");
    }

    public BoundingBoxGeoHashIterator(TwoGeoHashBoundingBox twoGh) {
        this.twoGh = twoGh;
        Tuple2<Object, Object> tuple2 = GeoHash$.MODULE$.getLatitudeLongitudeSpanCount(twoGh.ll(), twoGh.ur(), twoGh.prec());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int latSteps = tuple2._1$mcI$sp();
        int lonSteps = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(latSteps, lonSteps);
        this.x$1 = sp2;
        this.latSteps = this.x$1._1$mcI$sp();
        this.lonSteps = this.x$1._2$mcI$sp();
        long[] lArray = GeoHash$.MODULE$.gridIndicesForLatLong(twoGh.ur());
        Option option = Array$.MODULE$.unapplySeq((Object)lArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)lArray);
        }
        long endLatIndex = BoxesRunTime.unboxToLong((Object)((SeqLike)option.get()).apply(0));
        long endLonIndex = BoxesRunTime.unboxToLong((Object)((SeqLike)option.get()).apply(1));
        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(endLatIndex, endLonIndex);
        this.x$2 = sp3;
        this.endLatIndex = this.x$2._1$mcJ$sp();
        this.endLonIndex = this.x$2._2$mcJ$sp();
        this.ns = this.latSteps() * this.lonSteps();
        this.queue = (TreeSet)TreeSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeoHash[]{twoGh.ll()}), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.nextGh = twoGh.ll();
    }
}

