/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.TwoGeoHashBoundingBox;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001M4A\u0001E\t\u00019!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0004<\u0001\t\u0007I\u0011\u0001\u001f\t\r\r\u0003\u0001\u0015!\u0003>\u0011)!\u0005\u0001%A\u0001\u0004\u0003\u0006I!\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019i\u0005\u0001)A\u0005\u0011\"9a\n\u0001b\u0001\n\u0003a\u0005BB(\u0001A\u0003%\u0001\nC\u0004Q\u0001\t\u0007I\u0011\u0001'\t\rE\u0003\u0001\u0015!\u0003I\u0011\u001d\u0011\u0006A1A\u0005\nMCa\u0001\u001a\u0001!\u0002\u0013!\u0006\"B3\u0001\t\u00032\u0007\"\u00026\u0001\t\u000bZ'A\u0005\"pk:$\u0017N\\4C_b\u001c\u0016-\u001c9mKJT!AE\n\u0002\u000f\u001d,w\u000e[1tQ*\u0011A#F\u0001\u0006kRLGn\u001d\u0006\u0003-]\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u00193\u0005aAn\\2bi&|g\u000e^3dQ*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007c\u0001\u0013-_9\u0011QE\u000b\b\u0003M%j\u0011a\n\u0006\u0003Qm\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005-z\u0012a\u00029bG.\fw-Z\u0005\u0003[9\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003W}\u0001\"\u0001M\u0019\u000e\u0003EI!AM\t\u0003\u000f\u001d+w\u000eS1tQ\u0006)Ao^8HQB\u0011\u0001'N\u0005\u0003mE\u0011Q\u0003V<p\u000f\u0016|\u0007*Y:i\u0005>,h\u000eZ5oO\n{\u00070\u0001\u0004=S:LGO\u0010\u000b\u0003si\u0002\"\u0001\r\u0001\t\u000bM\u0012\u0001\u0019\u0001\u001b\u0002\tI\fg\u000eZ\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iH\u0001\u0005kRLG.\u0003\u0002C\u007f\t1!+\u00198e_6\fQA]1oI\u0002\n1\u0001\u001f\u00132!\u0011qb\t\u0013%\n\u0005\u001d{\"A\u0002+va2,'\u0007\u0005\u0002\u001f\u0013&\u0011!j\b\u0002\u0004\u0013:$\u0018\u0001\u00037biN#X\r]:\u0016\u0003!\u000b\u0011\u0002\\1u'R,\u0007o\u001d\u0011\u0002\u00111|gn\u0015;faN\f\u0011\u0002\\8o'R,\u0007o\u001d\u0011\u0002\u00139,X\u000eU8j]R\u001c\u0018A\u00038v[B{\u0017N\u001c;tA\u0005!Qo]3e+\u0005!\u0006cA+[96\taK\u0003\u0002X1\u00069Q.\u001e;bE2,'BA- \u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00037Z\u0013q\u0001S1tQN+G\u000f\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\u000f%sG/Z4fe\u0006)Qo]3eA\u00059\u0001.Y:OKb$X#A4\u0011\u0005yA\u0017BA5 \u0005\u001d\u0011un\u001c7fC:\fAA\\3yiR\tq\u0006\u000b\u0002\u0010[B\u0011a.]\u0007\u0002_*\u0011\u0001oH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:p\u0005\u001d!\u0018-\u001b7sK\u000e\u0004")
public class BoundingBoxSampler
implements Iterator<GeoHash> {
    private final TwoGeoHashBoundingBox twoGh;
    private final Random rand;
    private final /* synthetic */ Tuple2 x$1;
    private final int latSteps;
    private final int lonSteps;
    private final int numPoints;
    private final HashSet<Integer> used;

    public Iterator<GeoHash> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<GeoHash> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<GeoHash> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<GeoHash> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<GeoHash> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<GeoHash, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<GeoHash, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<GeoHash> filter(Function1<GeoHash, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<GeoHash, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<GeoHash> withFilter(Function1<GeoHash, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<GeoHash> filterNot(Function1<GeoHash, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<GeoHash, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, GeoHash, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<GeoHash, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<GeoHash> takeWhile(Function1<GeoHash, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<GeoHash>, Iterator<GeoHash>> partition(Function1<GeoHash, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<GeoHash>, Iterator<GeoHash>> span(Function1<GeoHash, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<GeoHash> dropWhile(Function1<GeoHash, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<GeoHash, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<GeoHash, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<GeoHash, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<GeoHash, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<GeoHash, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<GeoHash> find(Function1<GeoHash, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<GeoHash, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<GeoHash, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<GeoHash> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<GeoHash>, Iterator<GeoHash>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<GeoHash> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<GeoHash> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<GeoHash> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<GeoHash> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<GeoHash, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<GeoHash, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, GeoHash, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<GeoHash, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, GeoHash, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<GeoHash, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, GeoHash, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<GeoHash, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, GeoHash, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<GeoHash, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, GeoHash, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<GeoHash> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<GeoHash> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<GeoHash> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<GeoHash> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<GeoHash> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, GeoHash, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<GeoHash, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    public Random rand() {
        return this.rand;
    }

    public int latSteps() {
        return this.latSteps;
    }

    public int lonSteps() {
        return this.lonSteps;
    }

    public int numPoints() {
        return this.numPoints;
    }

    private HashSet<Integer> used() {
        return this.used;
    }

    public boolean hasNext() {
        return this.used().size() < this.numPoints();
    }

    public final GeoHash next() {
        GeoHash gh;
        do {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more points available.");
            }
            int idx = this.rand().nextInt(this.numPoints());
            while (this.used().contains((Object)Predef$.MODULE$.int2Integer(idx))) {
                idx = this.rand().nextInt(this.numPoints());
            }
            this.used().add((Object)Predef$.MODULE$.int2Integer(idx));
            gh = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(GeoHash$.MODULE$.gridIndexForLatitude(this.twoGh.ll()) + (long)(idx / this.lonSteps()), GeoHash$.MODULE$.gridIndexForLongitude(this.twoGh.ll()) + (long)(idx % this.lonSteps()), this.twoGh.ll().prec());
        } while (!this.twoGh.bbox().covers(gh.bbox()));
        return gh;
    }

    public BoundingBoxSampler(TwoGeoHashBoundingBox twoGh) {
        this.twoGh = twoGh;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        this.rand = new Random();
        Tuple2<Object, Object> tuple2 = GeoHash$.MODULE$.getLatitudeLongitudeSpanCount(twoGh.ll(), twoGh.ur(), twoGh.prec());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int latSteps = tuple2._1$mcI$sp();
        int lonSteps = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(latSteps, lonSteps);
        this.x$1 = sp2;
        this.latSteps = this.x$1._1$mcI$sp();
        this.lonSteps = this.x$1._2$mcI$sp();
        this.numPoints = this.latSteps() * this.lonSteps();
        Predef$.MODULE$.require(this.numPoints() <= Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> "Bounding box too big, cannot sample.");
        Predef$.MODULE$.require(this.numPoints() > 1, (Function0 & Serializable & scala.Serializable)() -> "Only one point in bounding box, cannot sample.");
        this.used = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

