/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.locationtech.geomesa.utils.geohash.BoundingBox;
import org.locationtech.geomesa.utils.geohash.BoundingBox$;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.GeohashUtils;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$2$;
import org.locationtech.geomesa.utils.geohash.GeomDistance;
import org.locationtech.geomesa.utils.geohash.GeomDistance$Distance$;
import org.locationtech.geomesa.utils.geohash.VincentyModel$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.iterators.CartesianProductIterable;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.BitSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class GeohashUtils$
implements GeomDistance,
LazyLogging {
    public static GeohashUtils$ MODULE$;
    private Polygon wholeEarthBBox;
    private Geometry emptyGeometry;
    private final Seq<Object> base32seq;
    private final IndexedSeq<List<Seq<Object>>> Base32Padding;
    private final IndexedSeq<List<Seq<Object>>> BinaryPadding;
    private final int maxRealisticGeoHashPrecision;
    private final long numDistinctGridPoints;
    private final PrecisionModel defaultPrecisionModel;
    private final GeometryFactory defaultGeometryFactory;
    private Logger logger;
    private volatile GeomDistance$Distance$ Distance$module;
    private volatile byte bitmap$0;

    static {
        new GeohashUtils$();
    }

    private Logger logger$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public GeomDistance$Distance$ Distance() {
        if (this.Distance$module == null) {
            this.Distance$lzycompute$1();
        }
        return this.Distance$module;
    }

    public Seq<Object> base32seq() {
        return this.base32seq;
    }

    private Polygon wholeEarthBBox$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.wholeEarthBBox = this.defaultGeometryFactory().createPolygon((Coordinate[])((Object[])new Coordinate[]{new Coordinate(-180.0, 90.0), new Coordinate(-180.0, -90.0), new Coordinate(180.0, -90.0), new Coordinate(180.0, 90.0), new Coordinate(-180.0, 90.0)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.wholeEarthBBox;
    }

    public Polygon wholeEarthBBox() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.wholeEarthBBox$lzycompute() : this.wholeEarthBBox;
    }

    public IndexedSeq<List<Seq<Object>>> Base32Padding() {
        return this.Base32Padding;
    }

    public IndexedSeq<List<Seq<Object>>> BinaryPadding() {
        return this.BinaryPadding;
    }

    public Geometry wkt2geom(String wkt) {
        return WKTUtils$.MODULE$.read(wkt);
    }

    public String getGeohashWKT(GeoHash gh) {
        return WKTUtils$.MODULE$.write(GeoHash$.MODULE$.toGeometry(gh));
    }

    public int maxRealisticGeoHashPrecision() {
        return this.maxRealisticGeoHashPrecision;
    }

    public long numDistinctGridPoints() {
        return this.numDistinctGridPoints;
    }

    public PrecisionModel defaultPrecisionModel() {
        return this.defaultPrecisionModel;
    }

    public GeometryFactory defaultGeometryFactory() {
        return this.defaultGeometryFactory;
    }

    public Tuple6<Point, Point, Point, Point, Point, Point> getGeohashPoints(GeoHash gh) {
        BoundingBox bbox = gh.bbox();
        Point lr = bbox.lr();
        Point ul = bbox.ul();
        Point ll = bbox.ll();
        Point ur = bbox.ur();
        double midLatitude = 0.5 * (lr.getY() + ul.getY());
        Point cl = lr.getFactory().createPoint(new Coordinate(ul.getX(), midLatitude));
        Point cr = lr.getFactory().createPoint(new Coordinate(lr.getX(), midLatitude));
        return new Tuple6((Object)ll, (Object)cl, (Object)ul, (Object)ur, (Object)cr, (Object)lr);
    }

    public double getGeohashAreaSquareMeters(GeoHash gh) {
        Tuple6<Point, Point, Point, Point, Point, Point> tuple6 = this.getGeohashPoints(gh);
        if (tuple6 == null) {
            throw new MatchError(tuple6);
        }
        Point ll = (Point)tuple6._1();
        Point cl = (Point)tuple6._2();
        Point ul = (Point)tuple6._3();
        Point cr = (Point)tuple6._5();
        Tuple4 tuple4 = new Tuple4((Object)ll, (Object)cl, (Object)ul, (Object)cr);
        Tuple4 tuple42 = tuple4;
        Point ll2 = (Point)tuple42._1();
        Point cl2 = (Point)tuple42._2();
        Point ul2 = (Point)tuple42._3();
        Point cr2 = (Point)tuple42._4();
        double dx = VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(cl2, cr2));
        double dy = VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ll2, ul2));
        return dx * dy;
    }

    public double getGeohashExtremeDimensionMeters(GeoHash gh, Function2<Object, Object, Object> fExtreme) {
        Tuple6<Point, Point, Point, Point, Point, Point> tuple6 = this.getGeohashPoints(gh);
        if (tuple6 == null) {
            throw new MatchError(tuple6);
        }
        Point ll = (Point)tuple6._1();
        Point cl = (Point)tuple6._2();
        Point ul = (Point)tuple6._3();
        Point ur = (Point)tuple6._4();
        Point cr = (Point)tuple6._5();
        Point lr = (Point)tuple6._6();
        Tuple6 tuple62 = new Tuple6((Object)ll, (Object)cl, (Object)ul, (Object)ur, (Object)cr, (Object)lr);
        Tuple6 tuple63 = tuple62;
        Point ll2 = (Point)tuple63._1();
        Point cl2 = (Point)tuple63._2();
        Point ul2 = (Point)tuple63._3();
        Point ur2 = (Point)tuple63._4();
        Point cr2 = (Point)tuple63._5();
        Point lr2 = (Point)tuple63._6();
        return fExtreme.apply$mcDDD$sp(fExtreme.apply$mcDDD$sp(VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ll2, lr2)), VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ul2, ur2))), fExtreme.apply$mcDDD$sp(VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ll2, ul2)), VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(lr2, ur2))));
    }

    public double getGeohashMaxDimensionMeters(GeoHash gh) {
        return this.getGeohashExtremeDimensionMeters(gh, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y));
    }

    public double getGeohashMinDimensionMeters(GeoHash gh) {
        return this.getGeohashExtremeDimensionMeters(gh, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.min(x, y));
    }

    public GeoHash getMinimumBoundingGeohash(Geometry geom, GeohashUtils.ResolutionRange resolutions) {
        Option ghOpt;
        Point centroid = this.getCentroid(geom);
        Geometry env = this.defaultGeometryFactory().toGeometry(geom.getEnvelopeInternal());
        Tuple2 tuple2 = (Tuple2)resolutions.range().foldRight((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)resolutions.minBitsResolution()), (Object)Option$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> GeohashUtils$.$anonfun$getMinimumBoundingGeohash$1(centroid, env, BoxesRunTime.unboxToInt((Object)x0$1), x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = ghOpt = (Option)tuple2._2();
        Option ghOpt2 = option;
        GeoHash gh = (GeoHash)ghOpt2.getOrElse((Function0 & Serializable & scala.Serializable)() -> GeoHash$.MODULE$.apply(centroid.getX(), centroid.getY(), resolutions.minBitsResolution()));
        if (!GeoHash$.MODULE$.toGeometry(gh).contains(env) && !gh.geom().equals(env)) {
            throw new Exception(new StringBuilder(69).append("ERROR:  Could not find a suitable ").append(resolutions.minBitsResolution()).append("-bit MBR for the target geometry:  ").append(geom).toString());
        }
        return gh;
    }

    public GeomDistance.Distance getMinimumGeodeticDistance(BoundingBox bbox, Point point, boolean exhaustive) {
        GeohashUtils.GHClosePoint closestPoint = this.getClosestPoint(bbox, point, exhaustive);
        return closestPoint.chordLength() == 0.0 ? new GeomDistance.Distance(VincentyModel$.MODULE$, 0.0) : VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(point, this.defaultGeometryFactory().createPoint(new Coordinate(Math.toDegrees(closestPoint.point().getX()), Math.toDegrees(closestPoint.point().getY()))));
    }

    public boolean getMinimumGeodeticDistance$default$3() {
        return false;
    }

    public double getMinimumChordLength(BoundingBox bbox, Point point, boolean exhaustive) {
        return this.getClosestPoint(bbox, point, exhaustive).chordLength();
    }

    public boolean getMinimumChordLength$default$3() {
        return false;
    }

    public GeohashUtils.GHClosePoint min(GeohashUtils.GHClosePoint p1, GeohashUtils.GHClosePoint p2) {
        return p1.chordLength() < p2.chordLength() ? p1 : p2;
    }

    private GeohashUtils.GHClosePoint getClosestPoint(BoundingBox bbox, Point point, boolean exhaustive) {
        GeohashUtils.GHClosePoint gHClosePoint;
        if (point.within(BoundingBox$.MODULE$.toGeometry(bbox))) {
            gHClosePoint = new GeohashUtils.GHClosePoint(point, 0.0);
        } else {
            Seq seq;
            LazyRef topEdgeSolutions$lzy = new LazyRef();
            LazyRef bottomEdgeSolutions$lzy = new LazyRef();
            LazyRef leftEdgeSolutions$lzy = new LazyRef();
            LazyRef rightEdgeSolutions$lzy = new LazyRef();
            double x = Math.toRadians(point.getX());
            double y = Math.toRadians(point.getY());
            double sinY = Math.sin(y);
            double sinX = Math.sin(x);
            double cosY = Math.cos(y);
            double cosX = Math.cos(x);
            double minLon = Math.toRadians(bbox.minLon());
            double maxLon = Math.toRadians(bbox.maxLon());
            double minLat = Math.toRadians(bbox.minLat());
            double maxLat = Math.toRadians(bbox.maxLat());
            if (exhaustive) {
                seq = (Seq)((TraversableLike)((TraversableLike)this.topEdgeSolutions$1(topEdgeSolutions$lzy, maxLat, minLon, maxLon, x).$plus$plus((GenTraversableOnce)this.bottomEdgeSolutions$1(bottomEdgeSolutions$lzy, minLat, minLon, maxLon, x), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.leftEdgeSolutions$1(leftEdgeSolutions$lzy, minLon, minLat, maxLat, y, cosX, sinX), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.rightEdgeSolutions$1(rightEdgeSolutions$lzy, maxLon, minLat, maxLat, y, cosX, sinX), Seq$.MODULE$.canBuildFrom());
            } else {
                double d;
                double d2 = y;
                double d3 = d2;
                Seq seq2 = d3 >= maxLat && x <= maxLon && x >= minLon ? this.topEdgeSolutions$1(topEdgeSolutions$lzy, maxLat, minLon, maxLon, x) : ((d = d2) <= minLat && x <= maxLon && x >= minLon ? this.bottomEdgeSolutions$1(bottomEdgeSolutions$lzy, minLat, minLon, maxLon, x) : (Seq)this.leftEdgeSolutions$1(leftEdgeSolutions$lzy, minLon, minLat, maxLat, y, cosX, sinX).$plus$plus((GenTraversableOnce)this.rightEdgeSolutions$1(rightEdgeSolutions$lzy, maxLon, minLat, maxLat, y, cosX, sinX), Seq$.MODULE$.canBuildFrom()));
                seq = seq2;
            }
            Seq pointsToTry = seq;
            gHClosePoint = (GeohashUtils.GHClosePoint)((TraversableOnce)pointsToTry.map((Function1 & Serializable & scala.Serializable)p -> new GeohashUtils.GHClosePoint((Point)p, GeohashUtils$.getChordLength$1(p.getY(), p.getX(), cosY, cosX, sinX, sinY)), Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2 & Serializable & scala.Serializable)(p1, p2) -> MODULE$.min((GeohashUtils.GHClosePoint)p1, (GeohashUtils.GHClosePoint)p2));
        }
        return gHClosePoint;
    }

    private boolean getClosestPoint$default$3() {
        return false;
    }

    public Point getCentroid(Geometry geom) {
        Point pt = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
        return geom.getFactory().createPoint(new Coordinate(pt.getX(), pt.getY()));
    }

    public Option<GeoHash> getMBGH(Point ll, Point ur) {
        double width = ur.getX() - ll.getX();
        double height = ur.getY() - ll.getY();
        Predef$.MODULE$.require(width >= 0.0 && height >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Wrong width ").append(width).append(" and height ").append(height).append(" of input bounding box, cannot process").toString());
        for (int prec = 60; prec >= 0; prec -= 5) {
            GeoHash geo;
            double lonDelta = GeoHash$.MODULE$.longitudeDeltaForPrecision(prec);
            double latDelta = GeoHash$.MODULE$.latitudeDeltaForPrecision(prec);
            if (!(lonDelta >= width) || !(latDelta >= height) || !(geo = GeoHash$.MODULE$.apply(ll.getX(), ll.getY(), prec)).bbox().covers(ur)) continue;
            return new Some((Object)geo);
        }
        return None$.MODULE$;
    }

    public Option<GeoHash> getMBGH(Envelope env) {
        return this.getMBGH(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    public Option<GeoHash> getMBGH(BoundingBox bbox) {
        return this.getMBGH(BoundingBox$.MODULE$.toEnvelope(bbox).getMinX(), BoundingBox$.MODULE$.toEnvelope(bbox).getMaxX(), BoundingBox$.MODULE$.toEnvelope(bbox).getMinY(), BoundingBox$.MODULE$.toEnvelope(bbox).getMaxY());
    }

    public Option<GeoHash> getMBGH(double minX, double maxX, double minY, double maxY) {
        return this.getMBGH(GeoHash$.MODULE$.factory().createPoint(new Coordinate(minX, minY)), GeoHash$.MODULE$.factory().createPoint(new Coordinate(maxX, maxY)));
    }

    public Option<GeoHash> getClosestAcceptableGeoHash(Envelope env) {
        return this.getClosestAcceptableGeoHash(BoundingBox$.MODULE$.apply(env));
    }

    public Option<GeoHash> getClosestAcceptableGeoHash(BoundingBox bbox) {
        None$ none$;
        int prec = this.calculatePrecision(bbox);
        if (prec >= 0) {
            GeoHash gh = this.getClosestAcceptableGeoHash(bbox, prec);
            int n = prec % 5;
            switch (n) {
                case 0: {
                    none$ = new Some((Object)gh);
                    break;
                }
                default: {
                    if (prec > 5) {
                        none$ = new Some((Object)GeoHash$.MODULE$.apply((String)new StringOps(Predef$.MODULE$.augmentString(gh.hash())).dropRight(1)));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public GeoHash getClosestAcceptableGeoHash(BoundingBox bbox, int r) {
        return GeoHash$.MODULE$.apply(BoundingBox$.MODULE$.toGeometry(bbox).getCentroid(), r);
    }

    public int calculatePrecision(BoundingBox bbox) {
        double dx = bbox.maxLon() - bbox.minLon();
        double dy = bbox.maxLat() - bbox.minLat();
        return (int)package$.MODULE$.round(package$.MODULE$.log((double)360 / dx) / package$.MODULE$.log(2.0) + package$.MODULE$.log((double)180 / dy) / package$.MODULE$.log(2.0));
    }

    private Geometry emptyGeometry$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.emptyGeometry = WKTUtils$.MODULE$.read("POLYGON((0 0,0 0,0 0,0 0,0 0))");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.emptyGeometry;
    }

    public Geometry emptyGeometry() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.emptyGeometry$lzycompute() : this.emptyGeometry;
    }

    public boolean decompositionCandidateSorter(GeohashUtils.DecompositionCandidate a, GeohashUtils.DecompositionCandidate b) {
        return a.isLT(b);
    }

    private List<GeoHash> decomposeGeometry_(Geometry targetGeom, int maxSize, GeohashUtils.ResolutionRange resolutions) {
        LazyRef geomCatcher$lzy = new LazyRef();
        double targetArea = BoxesRunTime.unboxToDouble((Object)GeohashUtils$.geomCatcher$2(geomCatcher$lzy).opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> targetGeom.getArea()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        double targetLength = BoxesRunTime.unboxToDouble((Object)GeohashUtils$.geomCatcher$2(geomCatcher$lzy).opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> targetGeom.getLength()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        GeoHash ghMBR = this.getMinimumBoundingGeohash(targetGeom, resolutions);
        GeohashUtils.DecompositionCandidate candidateMBR = GeohashUtils$.createDecompositionCandidate$1(ghMBR, targetGeom, targetArea, resolutions, targetLength);
        List keepers = this.decomposeStep$1((List)new .colon.colon((Object)candidateMBR, (List)Nil$.MODULE$), maxSize, resolutions, targetGeom, targetArea, targetLength);
        return ((List)keepers.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GeohashUtils$.$anonfun$decomposeGeometry_$8(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)keeper -> keeper.gh(), List$.MODULE$.canBuildFrom())).toList();
    }

    public Geometry getDecomposableGeometry(Geometry targetGeom) {
        Geometry geometry = targetGeom;
        Geometry geometry2 = geometry instanceof Point ? targetGeom : (geometry instanceof Polygon ? targetGeom : (geometry instanceof LineString && targetGeom.getNumPoints() < 100 ? targetGeom : (geometry instanceof MultiLineString && targetGeom.getNumPoints() < 100 ? targetGeom : targetGeom.convexHull())));
        return geometry2;
    }

    public Try<Geometry> getInternationalDateLineSafeGeometry(Geometry targetGeom) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Geometry copy = GeometryUtils$.MODULE$.geoFactory().createGeometry(targetGeom);
            Geometry withinBoundsGeom = targetGeom.getEnvelopeInternal().getMinX() < (double)-180 || targetGeom.getEnvelopeInternal().getMaxX() > (double)180 ? this.translateGeometry$1(copy) : copy;
            return JtsSpatialContext.GEO.makeShape(withinBoundsGeom, true, true).getGeom();
        });
    }

    public List<GeoHash> decomposeGeometry(Geometry targetGeom, int maxSize, GeohashUtils.ResolutionRange resolutions, boolean relaxFit) {
        List list;
        Geometry geometry = targetGeom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            list = new .colon.colon((Object)GeoHash$.MODULE$.apply(point.getX(), point.getY(), resolutions.maxBitsResolution()), (List)Nil$.MODULE$);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            list = (List)((SeqLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometryCollection.getNumGeometries()).toList().flatMap((Function1 & Serializable & scala.Serializable)i -> GeohashUtils$.MODULE$.decomposeGeometry(geometryCollection.getGeometryN(BoxesRunTime.unboxToInt((Object)i)), maxSize, resolutions, relaxFit), List$.MODULE$.canBuildFrom())).distinct();
        } else {
            Geometry safeGeom = (Geometry)this.getInternationalDateLineSafeGeometry(targetGeom).getOrElse((Function0 & Serializable & scala.Serializable)() -> targetGeom);
            list = this.decomposeGeometry_(relaxFit ? this.getDecomposableGeometry(safeGeom) : safeGeom, maxSize, resolutions);
        }
        return list;
    }

    private int decomposeGeometry_$default$2() {
        return 100;
    }

    private GeohashUtils.ResolutionRange decomposeGeometry_$default$3() {
        return new GeohashUtils.ResolutionRange(5, 40, 5);
    }

    public int decomposeGeometry$default$2() {
        return 100;
    }

    public GeohashUtils.ResolutionRange decomposeGeometry$default$3() {
        return new GeohashUtils.ResolutionRange(0, 40, 5);
    }

    public boolean decomposeGeometry$default$4() {
        return true;
    }

    public int estimateGeometryGeohashPrecision(Geometry geometry) {
        int n;
        if (geometry == null) {
            n = 0;
        } else {
            Envelope envelope = geometry.getEnvelopeInternal();
            double spanLongitude = envelope.getWidth();
            double spanLatitude = envelope.getHeight();
            double numLatitudeDivisions = package$.MODULE$.log(180.0 / spanLatitude) / package$.MODULE$.log(2.0);
            double numLongitudeDivisions = package$.MODULE$.log(360.0 / spanLongitude) / package$.MODULE$.log(2.0);
            n = (int)package$.MODULE$.round(numLatitudeDivisions + numLongitudeDivisions);
        }
        return n;
    }

    public GeoHash reconstructGeohashFromGeometry(Geometry geometry) {
        GeoHash geoHash;
        Geometry geometry2 = geometry;
        if (geometry2 == null) {
            throw new Exception("Invalid geometry:  null");
        }
        if ("Point".equals(geometry.getGeometryType())) {
            geoHash = GeoHash$.MODULE$.apply((Point)geometry, this.maxRealisticGeoHashPrecision());
        } else if (geometry.isRectangle()) {
            geoHash = GeoHash$.MODULE$.apply(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geometry)), this.estimateGeometryGeohashPrecision(geometry));
        } else if (geometry2 instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry2;
            if (multiPolygon.getNumGeometries() != 1) {
                throw new Exception("Expected simple geometry");
            }
            if (!multiPolygon.getGeometryN(0).isRectangle()) {
                throw new Exception("Expected rectangular geometry");
            }
            geoHash = GeoHash$.MODULE$.apply(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(multiPolygon.getGeometryN(0))), this.estimateGeometryGeohashPrecision(multiPolygon.getGeometryN(0)));
        } else {
            throw new Exception(new StringBuilder(19).append("Invalid geometry:  ").append(geometry).toString());
        }
        return geoHash;
    }

    public Iterator<String> getGeohashStringDottingIterator(Seq<String> set, int maxSize) {
        int len = BoxesRunTime.unboxToInt((Object)set.headOption().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.length())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), len).iterator().flatMap((Function1 & Serializable & scala.Serializable)i -> GeohashUtils$.$anonfun$getGeohashStringDottingIterator$3(set, len, BoxesRunTime.unboxToInt((Object)i))).take(maxSize + 1);
    }

    public Geometry promoteToRegion(Geometry geom) {
        Object object;
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            object = point.buffer(1.0E-6);
        } else {
            Geometry env;
            Polygon polygon;
            object = geometry instanceof Polygon ? ((polygon = (Polygon)geometry).getArea() > 0.0 ? polygon : Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)polygon)).buffer(1.0E-6)) : ((env = geometry.getEnvelope()).getArea() > 0.0 ? env : env.getCentroid().buffer(1.0E-6));
        }
        return object;
    }

    public Try<Seq<String>> getUniqueGeohashSubstringsInPolygon(Geometry geom, int offset, int length, int MAX_KEYS_IN_LIST, boolean includeDots) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            List keepers;
            LazyRef BitPrefixes$module = new LazyRef();
            Geometry cover = MODULE$.promoteToRegion(geom);
            int maxBits = (offset + length) * 5;
            int minBits = offset * 5;
            int usedBits = length * 5;
            GeohashUtils.ResolutionRange allResolutions = new GeohashUtils.ResolutionRange(0, Math.min(35, maxBits), 1);
            int maxKeys = Math.min(2 << Math.min(usedBits, 29), MAX_KEYS_IN_LIST);
            Point polyCentroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(cover));
            GeoHash ghMBR = MODULE$.getMinimumBoundingGeohash(geom, allResolutions);
            public class Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1
            implements Product,
            scala.Serializable {
                private final Seq<String> prefixes;
                private final boolean hasEverythingPrefix;
                private final int entailedSize;
                private final boolean usesAll;
                private final int minBits$1;
                private final int maxKeys$1;
                private final int usedBits$1;
                private final int maxBits$1;
                private final int length$1;

                public Seq<String> prefixes() {
                    return this.prefixes;
                }

                public boolean hasEverythingPrefix() {
                    return this.hasEverythingPrefix;
                }

                public int entailedSize() {
                    return this.entailedSize;
                }

                public boolean usesAll() {
                    return this.usesAll;
                }

                public boolean hasRoom() {
                    return this.entailedSize() <= this.maxKeys$1;
                }

                public boolean notDone() {
                    return !this.usesAll() && this.hasRoom();
                }

                public boolean overflowed() {
                    return this.usesAll() ? 1 << this.usedBits$1 > this.maxKeys$1 : this.entailedSize() > this.maxKeys$1;
                }

                public Seq<String> generateAll(String prefix) {
                    Seq seq;
                    String prefixHash = GeoHash$.MODULE$.fromBinaryString(prefix).hash();
                    if (prefixHash.length() < this.length$1) {
                        List charSeqs = (List)GeohashUtils$.MODULE$.Base32Padding().apply(this.length$1 - prefixHash.length());
                        seq = (Seq)new CartesianProductIterable((Seq<Seq<?>>)charSeqs).toList().map((Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(0).append(prefixHash).append(x$9.mkString()).toString(), List$.MODULE$.canBuildFrom());
                    } else {
                        seq = (Seq)new .colon.colon((Object)prefixHash, (List)Nil$.MODULE$);
                    }
                    return seq;
                }

                public Seq<String> generateSome() {
                    return ((SetLike)this.prefixes().foldLeft((Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(ghsSoFar, prefix) -> {
                        Seq seq;
                        int bitsToBoundary = (65 - prefix.length()) % 5;
                        if (bitsToBoundary == 0) {
                            seq = (Seq)new .colon.colon(prefix, (List)Nil$.MODULE$);
                        } else {
                            List fillers = (List)GeohashUtils$.MODULE$.BinaryPadding().apply(bitsToBoundary);
                            List result = (List)new CartesianProductIterable((Seq<Seq<?>>)fillers).toList().map((Function1 & Serializable & scala.Serializable)x$10 -> new StringBuilder(0).append((String)prefix).append(x$10.mkString()).toString(), List$.MODULE$.canBuildFrom());
                            seq = result;
                        }
                        Seq bases = seq;
                        return (HashSet)bases.foldLeft(ghsSoFar, (Function2 & Serializable & scala.Serializable)(ghs, base) -> {
                            String baseTrimmed = (String)new StringOps(Predef$.MODULE$.augmentString(base)).drop($this.minBits$1);
                            Seq<String> newSubs = this.generateAll(baseTrimmed);
                            return (HashSet)ghs.$plus$plus(newSubs);
                        });
                    })).toSeq();
                }

                public Seq<String> toSeq() {
                    return this.usesAll() ? this.generateAll("") : this.generateSome();
                }

                public Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 copy(Seq<String> prefixes) {
                    return new Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1(prefixes, this.minBits$1, this.maxKeys$1, this.usedBits$1, this.maxBits$1, this.length$1);
                }

                public Seq<String> copy$default$1() {
                    return this.prefixes();
                }

                public String productPrefix() {
                    return "BitPrefixes";
                }

                public int productArity() {
                    return 1;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            break;
                        }
                        default: {
                            throw new IndexOutOfBoundsException(Integer.toString(x$1));
                        }
                    }
                    return this.prefixes();
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1;
                }

                public int hashCode() {
                    return ScalaRunTime$.MODULE$._hashCode((Product)this);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 var4_4 = (Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1)x$1;
                    Seq<String> seq = this.prefixes();
                    Seq<String> seq2 = var4_4.prefixes();
                    if (seq == null) {
                        if (seq2 != null) {
                            return false;
                        }
                    } else if (!seq.equals(seq2)) return false;
                    if (!var4_4.canEqual(this)) return false;
                    return true;
                }

                public static final /* synthetic */ boolean $anonfun$hasEverythingPrefix$1(Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 $this, String prefix) {
                    return prefix.length() <= $this.minBits$1;
                }

                public static final /* synthetic */ int $anonfun$entailedSize$1(Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 $this, int sumSoFar, String prefix) {
                    return sumSoFar + (1 << Math.min($this.usedBits$1, $this.maxBits$1 - prefix.length()));
                }

                public static final /* synthetic */ boolean $anonfun$usesAll$1(Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 $this, String prefix) {
                    return prefix.length() <= $this.minBits$1;
                }

                public Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1(Seq<String> prefixes) {
                    this.prefixes = prefixes;
                    this.minBits$1 = minBits$1;
                    this.maxKeys$1 = maxKeys$1;
                    this.usedBits$1 = usedBits$1;
                    this.maxBits$1 = maxBits$1;
                    this.length$1 = length$1;
                    Product.$init$((Product)this);
                    this.hasEverythingPrefix = prefixes.exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1.$anonfun$hasEverythingPrefix$1(this, prefix)));
                    this.entailedSize = this.hasEverythingPrefix() ? maxKeys$1 : Math.min(1 << usedBits$1, BoxesRunTime.unboxToInt((Object)prefixes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(sumSoFar, prefix) -> BoxesRunTime.boxToInteger((int)Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1.$anonfun$entailedSize$1(this, BoxesRunTime.unboxToInt((Object)sumSoFar), prefix)))));
                    this.usesAll = prefixes.exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1.$anonfun$usesAll$1(this, prefix))) || this.entailedSize() == maxKeys$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$generateAll$1(java.lang.String scala.collection.Seq ), $anonfun$generateSome$1(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 scala.collection.immutable.HashSet java.lang.String ), $anonfun$generateSome$2(java.lang.String scala.collection.Seq ), $anonfun$generateSome$3(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 scala.collection.immutable.HashSet java.lang.String ), $anonfun$hasEverythingPrefix$1$adapted(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 java.lang.String ), $anonfun$entailedSize$1$adapted(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 java.lang.Object java.lang.String ), $anonfun$usesAll$1$adapted(org.locationtech.geomesa.utils.geohash.GeohashUtils$BitPrefixes$1 java.lang.String )}, serializedLambda);
                }
            }
            Org_locationtech_geomesa_utils_geohash_GeohashUtils$BitPrefixes$1 bitPrefixes = this.BitPrefixes$3(BitPrefixes$module, minBits, maxKeys, usedBits, maxBits, length).apply((Seq<String>)(ghMBR.prec() <= maxBits ? GeohashUtils$.considerCandidate$1(ghMBR, geom, cover, maxBits, polyCentroid, minBits) : (Seq)new .colon.colon((Object)((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(ghMBR.toBinaryString())).drop(minBits))).take(usedBits)), (List)Nil$.MODULE$)));
            if (bitPrefixes.overflowed()) {
                throw new IllegalStateException(new StringBuilder(162).append("Bit prefixes overflowed while calculating unique Geohash substrings in polygon using the following parameters: ").append("\nGeometry: ").append(geom).append(" \nOffset: ").append(offset).append(" \nLength: ").append(length).append(" \nMax Keys in List: ").append(MAX_KEYS_IN_LIST).toString());
            }
            Seq unDotted = bitPrefixes.toSeq();
            return includeDots ? (unDotted.size() < maxKeys ? ((keepers = MODULE$.getGeohashStringDottingIterator((Seq<String>)unDotted, MAX_KEYS_IN_LIST).take(MAX_KEYS_IN_LIST + 1).toList()).size() <= MAX_KEYS_IN_LIST ? keepers.toSeq() : (Seq)Nil$.MODULE$) : (Seq)Nil$.MODULE$) : unDotted;
        });
    }

    public int getUniqueGeohashSubstringsInPolygon$default$4() {
        return 0x7FFFFFFE;
    }

    public boolean getUniqueGeohashSubstringsInPolygon$default$5() {
        return true;
    }

    private final void Distance$lzycompute$1() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if (this.Distance$module == null) {
                this.Distance$module = new GeomDistance$Distance$(this);
            }
        }
    }

    public static final /* synthetic */ List $anonfun$Base32Padding$1(int i) {
        return (List)List$.MODULE$.fill(i, (Function0 & Serializable & scala.Serializable)() -> MODULE$.base32seq());
    }

    public static final /* synthetic */ List $anonfun$BinaryPadding$1(int i) {
        return (List)List$.MODULE$.fill(i, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'0', '1'})));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getMinimumBoundingGeohash$1(Point centroid$1, Geometry env$1, int x0$1, Tuple2 x1$1) {
        Tuple2 orig;
        int bits;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
                if (tuple2 == null) break block2;
                bits = tuple2._1$mcI$sp();
                orig = (Tuple2)tuple2._2();
                if (orig != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int res = orig._1$mcI$sp();
        GeoHash gh = GeoHash$.MODULE$.apply(centroid$1.getX(), centroid$1.getY(), bits);
        Tuple2 tuple2 = GeoHash$.MODULE$.toGeometry(gh).contains(env$1) && bits >= res ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)bits), (Object)new Some((Object)gh)) : orig;
        return tuple2;
    }

    private static final Seq getLocalMinimumAlongLongitude$1(double lon2, double y$1, double cosX$1, double sinX$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Math.atan(Math.tan(y$1) / (Math.cos(lon2) * cosX$1 + Math.sin(lon2) * sinX$1))}));
    }

    private static final Seq getLocalMinimaAlongLatitude$1(double x$12) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x$12, x$12 > 0.0 ? x$12 - Math.PI : x$12 + Math.PI}));
    }

    private static final double getChordLength$1(double lat2, double lon2, double cosY$1, double cosX$1, double sinX$1, double sinY$1) {
        double cosLat2 = Math.cos(lat2);
        double dX = cosLat2 * Math.cos(lon2) - cosY$1 * cosX$1;
        double dY = cosLat2 * Math.sin(lon2) - cosY$1 * sinX$1;
        double dZ = Math.sin(lat2) - sinY$1;
        return Math.sqrt(dX * dX + dY * dY + dZ * dZ);
    }

    public static final /* synthetic */ Point $anonfun$getClosestPoint$2(double lat$1, double m) {
        return MODULE$.defaultGeometryFactory().createPoint(new Coordinate(m, lat$1));
    }

    private final Seq getPointsToTryIfAboveOrBelowLat$1(double lat, double minLon$1, double maxLon$1, double x$12) {
        Seq minima = (Seq)GeohashUtils$.getLocalMinimaAlongLatitude$1(x$12).withFilter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)m -> m > minLon$1 && m < maxLon$1).map((Function1 & Serializable & scala.Serializable)m -> GeohashUtils$.$anonfun$getClosestPoint$2(lat, BoxesRunTime.unboxToDouble((Object)m)), Seq$.MODULE$.canBuildFrom());
        Seq startAndEndpoints = (Seq)new .colon.colon((Object)this.defaultGeometryFactory().createPoint(new Coordinate(minLon$1, lat)), (List)new .colon.colon((Object)this.defaultGeometryFactory().createPoint(new Coordinate(maxLon$1, lat)), (List)Nil$.MODULE$));
        return (Seq)minima.$plus$plus((GenTraversableOnce)startAndEndpoints, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Point $anonfun$getClosestPoint$5(double lon$1, double m) {
        return MODULE$.defaultGeometryFactory().createPoint(new Coordinate(lon$1, m));
    }

    private final Seq getPointsToTryAlongLongitude$1(double lon, double minLat$1, double maxLat$1, double y$1, double cosX$1, double sinX$1) {
        Seq minima = (Seq)GeohashUtils$.getLocalMinimumAlongLongitude$1(lon, y$1, cosX$1, sinX$1).withFilter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)m -> m > minLat$1 && m < maxLat$1).withFilter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> !Double.isNaN(x$3)).map((Function1 & Serializable & scala.Serializable)m -> GeohashUtils$.$anonfun$getClosestPoint$5(lon, BoxesRunTime.unboxToDouble((Object)m)), Seq$.MODULE$.canBuildFrom());
        Seq startAndEndpoints = (Seq)new .colon.colon((Object)this.defaultGeometryFactory().createPoint(new Coordinate(lon, minLat$1)), (List)new .colon.colon((Object)this.defaultGeometryFactory().createPoint(new Coordinate(lon, maxLat$1)), (List)Nil$.MODULE$));
        return (Seq)minima.$plus$plus((GenTraversableOnce)startAndEndpoints, Seq$.MODULE$.canBuildFrom());
    }

    private final /* synthetic */ Seq topEdgeSolutions$lzycompute$1(LazyRef topEdgeSolutions$lzy$1, double maxLat$1, double minLon$1, double maxLon$1, double x$12) {
        Seq seq;
        LazyRef lazyRef = topEdgeSolutions$lzy$1;
        synchronized (lazyRef) {
            seq = topEdgeSolutions$lzy$1.initialized() ? (Seq)topEdgeSolutions$lzy$1.value() : (Seq)topEdgeSolutions$lzy$1.initialize((Object)this.getPointsToTryIfAboveOrBelowLat$1(maxLat$1, minLon$1, maxLon$1, x$12));
        }
        return seq;
    }

    private final Seq topEdgeSolutions$1(LazyRef topEdgeSolutions$lzy$1, double maxLat$1, double minLon$1, double maxLon$1, double x$12) {
        return topEdgeSolutions$lzy$1.initialized() ? (Seq)topEdgeSolutions$lzy$1.value() : this.topEdgeSolutions$lzycompute$1(topEdgeSolutions$lzy$1, maxLat$1, minLon$1, maxLon$1, x$12);
    }

    private final /* synthetic */ Seq bottomEdgeSolutions$lzycompute$1(LazyRef bottomEdgeSolutions$lzy$1, double minLat$1, double minLon$1, double maxLon$1, double x$12) {
        Seq seq;
        LazyRef lazyRef = bottomEdgeSolutions$lzy$1;
        synchronized (lazyRef) {
            seq = bottomEdgeSolutions$lzy$1.initialized() ? (Seq)bottomEdgeSolutions$lzy$1.value() : (Seq)bottomEdgeSolutions$lzy$1.initialize((Object)this.getPointsToTryIfAboveOrBelowLat$1(minLat$1, minLon$1, maxLon$1, x$12));
        }
        return seq;
    }

    private final Seq bottomEdgeSolutions$1(LazyRef bottomEdgeSolutions$lzy$1, double minLat$1, double minLon$1, double maxLon$1, double x$12) {
        return bottomEdgeSolutions$lzy$1.initialized() ? (Seq)bottomEdgeSolutions$lzy$1.value() : this.bottomEdgeSolutions$lzycompute$1(bottomEdgeSolutions$lzy$1, minLat$1, minLon$1, maxLon$1, x$12);
    }

    private final /* synthetic */ Seq leftEdgeSolutions$lzycompute$1(LazyRef leftEdgeSolutions$lzy$1, double minLon$1, double minLat$1, double maxLat$1, double y$1, double cosX$1, double sinX$1) {
        Seq seq;
        LazyRef lazyRef = leftEdgeSolutions$lzy$1;
        synchronized (lazyRef) {
            seq = leftEdgeSolutions$lzy$1.initialized() ? (Seq)leftEdgeSolutions$lzy$1.value() : (Seq)leftEdgeSolutions$lzy$1.initialize((Object)this.getPointsToTryAlongLongitude$1(minLon$1, minLat$1, maxLat$1, y$1, cosX$1, sinX$1));
        }
        return seq;
    }

    private final Seq leftEdgeSolutions$1(LazyRef leftEdgeSolutions$lzy$1, double minLon$1, double minLat$1, double maxLat$1, double y$1, double cosX$1, double sinX$1) {
        return leftEdgeSolutions$lzy$1.initialized() ? (Seq)leftEdgeSolutions$lzy$1.value() : this.leftEdgeSolutions$lzycompute$1(leftEdgeSolutions$lzy$1, minLon$1, minLat$1, maxLat$1, y$1, cosX$1, sinX$1);
    }

    private final /* synthetic */ Seq rightEdgeSolutions$lzycompute$1(LazyRef rightEdgeSolutions$lzy$1, double maxLon$1, double minLat$1, double maxLat$1, double y$1, double cosX$1, double sinX$1) {
        Seq seq;
        LazyRef lazyRef = rightEdgeSolutions$lzy$1;
        synchronized (lazyRef) {
            seq = rightEdgeSolutions$lzy$1.initialized() ? (Seq)rightEdgeSolutions$lzy$1.value() : (Seq)rightEdgeSolutions$lzy$1.initialize((Object)this.getPointsToTryAlongLongitude$1(maxLon$1, minLat$1, maxLat$1, y$1, cosX$1, sinX$1));
        }
        return seq;
    }

    private final Seq rightEdgeSolutions$1(LazyRef rightEdgeSolutions$lzy$1, double maxLon$1, double minLat$1, double maxLat$1, double y$1, double cosX$1, double sinX$1) {
        return rightEdgeSolutions$lzy$1.initialized() ? (Seq)rightEdgeSolutions$lzy$1.value() : this.rightEdgeSolutions$lzycompute$1(rightEdgeSolutions$lzy$1, maxLon$1, minLat$1, maxLat$1, y$1, cosX$1, sinX$1);
    }

    private static final /* synthetic */ Exception.Catch geomCatcher$lzycompute$2(LazyRef geomCatcher$lzy$2) {
        Exception.Catch catch_;
        LazyRef lazyRef = geomCatcher$lzy$2;
        synchronized (lazyRef) {
            catch_ = geomCatcher$lzy$2.initialized() ? (Exception.Catch)geomCatcher$lzy$2.value() : (Exception.Catch)geomCatcher$lzy$2.initialize((Object)Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Exception.class})));
        }
        return catch_;
    }

    private static final Exception.Catch geomCatcher$2(LazyRef geomCatcher$lzy$2) {
        return geomCatcher$lzy$2.initialized() ? (Exception.Catch)geomCatcher$lzy$2.value() : GeohashUtils$.geomCatcher$lzycompute$2(geomCatcher$lzy$2);
    }

    private static final GeohashUtils.DecompositionCandidate createDecompositionCandidate$1(GeoHash gh, Geometry targetGeom$1, double targetArea$1, GeohashUtils.ResolutionRange resolutions$2, double targetLength$1) {
        GeohashUtils.DecompositionCandidate decompositionCandidate;
        Geometry geometry = targetGeom$1;
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            decompositionCandidate = new GeohashUtils.PolygonDecompositionCandidate(gh, multiPolygon, targetArea$1, resolutions$2);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            decompositionCandidate = new GeohashUtils.PolygonDecompositionCandidate(gh, new MultiPolygon((Polygon[])((Object[])new Polygon[]{polygon}), polygon.getFactory()), targetArea$1, resolutions$2);
        } else if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            decompositionCandidate = new GeohashUtils.LineDecompositionCandidate(gh, new MultiLineString((LineString[])((Object[])new LineString[]{lineString}), lineString.getFactory()), targetLength$1, resolutions$2);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            decompositionCandidate = new GeohashUtils.LineDecompositionCandidate(gh, multiLineString, targetLength$1, resolutions$2);
        } else if (geometry instanceof Point) {
            Point point = (Point)geometry;
            decompositionCandidate = new GeohashUtils.PointDecompositionCandidate(gh, point, targetArea$1, resolutions$2);
        } else {
            throw new Exception(new StringBuilder(46).append("Unsupported Geometry type for decomposition:  ").append(targetGeom$1.getClass().getName()).toString());
        }
        return decompositionCandidate;
    }

    private final List decomposeStep$1(List candidates, int maxSize$1, GeohashUtils.ResolutionRange resolutions$2, Geometry targetGeom$1, double targetArea$1, double targetLength$1) {
        while (true) {
            if (candidates.size() > maxSize$1) {
                throw new Exception("Too many candidates upon entry.");
            }
            GeohashUtils.DecompositionCandidate candidate = (GeohashUtils.DecompositionCandidate)candidates.apply(0);
            int childResolution = candidate.gh().prec() + resolutions$2.numBitsIncrement();
            BitSet candidateBitSet = candidate.gh().bitset();
            List children = (List)((TraversableLike)resolutions$2.getNextChildren(candidateBitSet, candidate.gh().prec()).map((Function1 & Serializable & scala.Serializable)childBitSet -> GeohashUtils$.createDecompositionCandidate$1(GeoHash$.MODULE$.apply((BitSet)childBitSet, childResolution), targetGeom$1, targetArea$1, resolutions$2, targetLength$1), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)child.intersectsTarget()));
            List newCandidates = (List)((SeqLike)((List)candidates.tail()).$plus$plus((GenTraversableOnce)children, List$.MODULE$.canBuildFrom())).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)GeohashUtils$.MODULE$.decompositionCandidateSorter(a, b)));
            if (newCandidates.size() > maxSize$1 || childResolution > resolutions$2.maxBitsResolution()) break;
            candidates = newCandidates;
        }
        return candidates;
    }

    public static final /* synthetic */ boolean $anonfun$decomposeGeometry_$8(GeohashUtils.DecompositionCandidate check$ifrefutable$1) {
        GeohashUtils.DecompositionCandidate decompositionCandidate = check$ifrefutable$1;
        boolean bl = decompositionCandidate != null;
        return bl;
    }

    private static final double degreesLonTranslation$1(double lon) {
        return (int)(RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((lon + (double)180) / 360.0)) * (double)-360);
    }

    private static final Coordinate translateCoord$1(Coordinate coord) {
        return new Coordinate(coord.x + GeohashUtils$.degreesLonTranslation$1(coord.x), coord.y);
    }

    private final Geometry translatePolygon$1(Geometry geometry) {
        return this.defaultGeometryFactory().createPolygon((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates())).map((Function1 & Serializable & scala.Serializable)c -> GeohashUtils$.translateCoord$1(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
    }

    private final Geometry translateLineString$1(Geometry geometry) {
        return this.defaultGeometryFactory().createLineString((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates())).map((Function1 & Serializable & scala.Serializable)c -> GeohashUtils$.translateCoord$1(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
    }

    private final Geometry translateMultiLineString$1(Geometry geometry) {
        IndexedSeq coords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometry.getNumGeometries()).map((Function1 & Serializable & scala.Serializable)i -> geometry.getGeometryN(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq translated = (IndexedSeq)coords.map((Function1 & Serializable & scala.Serializable)c -> (LineString)this.translateLineString$1((Geometry)c), IndexedSeq$.MODULE$.canBuildFrom());
        return this.defaultGeometryFactory().createMultiLineString((LineString[])translated.toArray(ClassTag$.MODULE$.apply(LineString.class)));
    }

    private final Geometry translateMultiPolygon$1(Geometry geometry) {
        IndexedSeq coords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometry.getNumGeometries()).map((Function1 & Serializable & scala.Serializable)i -> geometry.getGeometryN(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq translated = (IndexedSeq)coords.map((Function1 & Serializable & scala.Serializable)c -> (Polygon)this.translatePolygon$1((Geometry)c), IndexedSeq$.MODULE$.canBuildFrom());
        return this.defaultGeometryFactory().createMultiPolygon((Polygon[])translated.toArray(ClassTag$.MODULE$.apply(Polygon.class)));
    }

    private final Geometry translateMultiPoint$1(Geometry geometry) {
        return this.defaultGeometryFactory().createMultiPoint((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates())).map((Function1 & Serializable & scala.Serializable)c -> GeohashUtils$.translateCoord$1(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
    }

    private final Geometry translatePoint$1(Geometry geometry) {
        return this.defaultGeometryFactory().createPoint(GeohashUtils$.translateCoord$1(geometry.getCoordinate()));
    }

    private final Geometry translateGeometry$1(Geometry geometry) {
        Geometry geometry2;
        Geometry geometry3 = geometry;
        if (geometry3 instanceof Polygon) {
            geometry2 = this.translatePolygon$1(geometry);
        } else if (geometry3 instanceof LineString) {
            geometry2 = this.translateLineString$1(geometry);
        } else if (geometry3 instanceof MultiLineString) {
            geometry2 = this.translateMultiLineString$1(geometry);
        } else if (geometry3 instanceof MultiPolygon) {
            geometry2 = this.translateMultiPolygon$1(geometry);
        } else if (geometry3 instanceof MultiPoint) {
            geometry2 = this.translateMultiPoint$1(geometry);
        } else if (geometry3 instanceof Point) {
            geometry2 = this.translatePoint$1(geometry);
        } else {
            throw new MatchError((Object)geometry3);
        }
        return geometry2;
    }

    public static final /* synthetic */ Seq $anonfun$getGeohashStringDottingIterator$3(Seq set$1, int len$1, int i) {
        return (Seq)((TraversableLike)((TraversableLike)((SeqLike)set$1.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)new StringOps(Predef$.MODULE$.augmentString(x$7)).take(i), Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)hash -> {
            String newStr = new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(hash)).take(i)).append(((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString("")).padTo(len$1 - i, (Object)".", Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString()).toString();
            return new Tuple2(hash, (Object)newStr);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            String newStr;
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = newStr = (String)tuple2._2();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static final /* synthetic */ GeohashUtils$BitPrefixes$2$ BitPrefixes$lzycompute$1(LazyRef BitPrefixes$module$1, int minBits$1, int maxKeys$1, int usedBits$1, int maxBits$1, int length$1) {
        GeohashUtils$BitPrefixes$2$ geohashUtils$BitPrefixes$2$;
        LazyRef lazyRef = BitPrefixes$module$1;
        synchronized (lazyRef) {
            geohashUtils$BitPrefixes$2$ = BitPrefixes$module$1.initialized() ? (GeohashUtils$BitPrefixes$2$)((Object)BitPrefixes$module$1.value()) : (GeohashUtils$BitPrefixes$2$)((Object)BitPrefixes$module$1.initialize((Object)new GeohashUtils$BitPrefixes$2$(minBits$1, maxKeys$1, usedBits$1, maxBits$1, length$1)));
        }
        return geohashUtils$BitPrefixes$2$;
    }

    private final GeohashUtils$BitPrefixes$2$ BitPrefixes$3(LazyRef BitPrefixes$module$1, int minBits$1, int maxKeys$1, int usedBits$1, int maxBits$1, int length$1) {
        return BitPrefixes$module$1.initialized() ? (GeohashUtils$BitPrefixes$2$)((Object)BitPrefixes$module$1.value()) : GeohashUtils$.BitPrefixes$lzycompute$1(BitPrefixes$module$1, minBits$1, maxKeys$1, usedBits$1, maxBits$1, length$1);
    }

    private static final Seq considerCandidate$1(GeoHash candidate, Geometry geom$2, Geometry cover$1, int maxBits$1, Point polyCentroid$1, int minBits$1) {
        Seq seq;
        String bitString = candidate.toBinaryString();
        if (!geom$2.intersects(candidate.geom())) {
            return Nil$.MODULE$;
        }
        if (cover$1.covers(candidate.geom()) || new StringOps(Predef$.MODULE$.augmentString(bitString)).size() == maxBits$1) {
            seq = (Seq)new .colon.colon((Object)bitString, (List)Nil$.MODULE$);
        } else if (new StringOps(Predef$.MODULE$.augmentString(bitString)).size() < maxBits$1) {
            Some some;
            String bitStr;
            double d1;
            Tuple2 tuple2;
            GeoHash gh0 = GeoHash$.MODULE$.fromBinaryString(new StringBuilder(1).append(bitString).append("0").toString());
            GeoHash gh1 = GeoHash$.MODULE$.fromBinaryString(new StringBuilder(1).append(bitString).append("1").toString());
            double d0 = Math.hypot(gh0.getPoint().getX() - polyCentroid$1.getX(), gh0.getPoint().getY() - polyCentroid$1.getY());
            Tuple2 tuple22 = tuple2 = d0 <= (d1 = Math.hypot(gh1.getPoint().getX() - polyCentroid$1.getX(), gh1.getPoint().getY() - polyCentroid$1.getY())) ? new Tuple2((Object)gh0, (Object)gh1) : new Tuple2((Object)gh1, (Object)gh0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeoHash firstChild = (GeoHash)tuple2._1();
            GeoHash secondChild = (GeoHash)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)firstChild, (Object)secondChild);
            Tuple2 tuple24 = tuple23;
            GeoHash firstChild2 = (GeoHash)tuple24._1();
            GeoHash secondChild2 = (GeoHash)tuple24._2();
            Seq firstChildList = GeohashUtils$.considerCandidate$1(firstChild2, geom$2, cover$1, maxBits$1, polyCentroid$1, minBits$1);
            Option option = firstChildList.headOption();
            Object object = option instanceof Some && (bitStr = (String)(some = (Some)option).value()).length() <= minBits$1 ? Nil$.MODULE$ : GeohashUtils$.considerCandidate$1(secondChild2, geom$2, cover$1, maxBits$1, polyCentroid$1, minBits$1);
            seq = (Seq)firstChildList.$plus$plus((GenTraversableOnce)object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Nil$.MODULE$;
        }
        return seq;
    }

    private GeohashUtils$() {
        MODULE$ = this;
        GeomDistance.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.base32seq = new StringOps(Predef$.MODULE$.augmentString(GeoHash$.MODULE$.base32())).toSeq();
        this.Base32Padding = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).map((Function1 & Serializable & scala.Serializable)i -> GeohashUtils$.$anonfun$Base32Padding$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.BinaryPadding = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> GeohashUtils$.$anonfun$BinaryPadding$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.maxRealisticGeoHashPrecision = 45;
        this.numDistinctGridPoints = 1L << (int)((long)((this.maxRealisticGeoHashPrecision() + 1) / 2));
        this.defaultPrecisionModel = new PrecisionModel((double)this.numDistinctGridPoints());
        this.defaultGeometryFactory = new GeometryFactory(this.defaultPrecisionModel(), 4326);
    }
}

