/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geometry;

import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.jts.geom.Point;
import scala.MatchError;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B-[\u0001\u0015DQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004{\u0001\u0001\u0006IA\u001d\u0005\u0006w\u0002!\t\u0001 \u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\tI\u0002\u0001C\u0001\u00057CqAa)\u0001\t\u0003\u0011)\u000bC\u0004\u0003$\u0002!\tA!,\t\u000f\tU\u0006\u0001\"\u0001\u00038\"9!Q\u0017\u0001\u0005\u0002\t}vaBA\u001e5\"\u0005\u0011Q\b\u0004\u00073jC\t!a\u0010\t\r1dA\u0011AA!\r\u0019\t\u0019\u0005\u0004!\u0002F!I1P\u0004BK\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003+r!\u0011#Q\u0001\nuD!\"a\u0016\u000f\u0005+\u0007I\u0011AA*\u0011%\tIF\u0004B\tB\u0003%Q\u0010\u0003\u0006\u0002\\9\u0011)\u001a!C\u0001\u0003'B\u0011\"!\u0018\u000f\u0005#\u0005\u000b\u0011B?\t\r1tA\u0011AA0\u0011%\tYGDA\u0001\n\u0003\ti\u0007C\u0005\u0002v9\t\n\u0011\"\u0001\u0002x!I\u0011Q\u0012\b\u0012\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u001fs\u0011\u0013!C\u0001\u0003oB\u0011\"!%\u000f\u0003\u0003%\t%a%\t\u0013\u0005\u0015f\"!A\u0005\u0002\u0005\u001d\u0006\"CAX\u001d\u0005\u0005I\u0011AAY\u0011%\tiLDA\u0001\n\u0003\ny\fC\u0005\u0002N:\t\t\u0011\"\u0001\u0002P\"I\u0011\u0011\u001c\b\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003;t\u0011\u0011!C!\u0003?D\u0011\"!9\u000f\u0003\u0003%\t%a9\b\u0013\u0005\u001dH\"!A\t\u0002\u0005%h!CA\"\u0019\u0005\u0005\t\u0012AAv\u0011\u0019a7\u0005\"\u0001\u0002z\"I\u0011Q\\\u0012\u0002\u0002\u0013\u0015\u0013q\u001c\u0005\n\u0003w\u001c\u0013\u0011!CA\u0003{D\u0011B!\u0002$\u0003\u0003%\tIa\u0002\t\u0013\te1%!A\u0005\n\tmaA\u0002B\u0012\u0019\u0001\u0013)\u0003C\u0005|S\tU\r\u0011\"\u0001\u0002T!I\u0011QK\u0015\u0003\u0012\u0003\u0006I! \u0005\u000b\u0005OI#Q3A\u0005\u0002\u0005M\u0003\"\u0003B\u0015S\tE\t\u0015!\u0003~\u0011\u0019a\u0017\u0006\"\u0001\u0003,!I\u00111N\u0015\u0002\u0002\u0013\u0005!1\u0007\u0005\n\u0003kJ\u0013\u0013!C\u0001\u0003oB\u0011\"!$*#\u0003%\t!a\u001e\t\u0013\u0005E\u0015&!A\u0005B\u0005M\u0005\"CASS\u0005\u0005I\u0011AAT\u0011%\ty+KA\u0001\n\u0003\u0011I\u0004C\u0005\u0002>&\n\t\u0011\"\u0011\u0002@\"I\u0011QZ\u0015\u0002\u0002\u0013\u0005!Q\b\u0005\n\u00033L\u0013\u0011!C!\u00037D\u0011\"!8*\u0003\u0003%\t%a8\t\u0013\u0005\u0005\u0018&!A\u0005B\t\u0005s!\u0003B#\u0019\u0005\u0005\t\u0012\u0001B$\r%\u0011\u0019\u0003DA\u0001\u0012\u0003\u0011I\u0005\u0003\u0004mw\u0011\u0005!\u0011\u000b\u0005\n\u0003;\\\u0014\u0011!C#\u0003?D\u0011\"a?<\u0003\u0003%\tIa\u0015\t\u0013\t\u00151(!A\u0005\u0002\ne\u0003\"\u0003B\rw\u0005\u0005I\u0011\u0002B\u000e\r\u0019\u0011)\u0007\u0004!\u0003h!I10\u0011BK\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003+\n%\u0011#Q\u0001\nuD!Ba\nB\u0005+\u0007I\u0011AA*\u0011%\u0011I#\u0011B\tB\u0003%Q\u0010\u0003\u0004m\u0003\u0012\u0005!\u0011\u000e\u0005\n\u0003W\n\u0015\u0011!C\u0001\u0005cB\u0011\"!\u001eB#\u0003%\t!a\u001e\t\u0013\u00055\u0015)%A\u0005\u0002\u0005]\u0004\"CAI\u0003\u0006\u0005I\u0011IAJ\u0011%\t)+QA\u0001\n\u0003\t9\u000bC\u0005\u00020\u0006\u000b\t\u0011\"\u0001\u0003x!I\u0011QX!\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\n\u0003\u001b\f\u0015\u0011!C\u0001\u0005wB\u0011\"!7B\u0003\u0003%\t%a7\t\u0013\u0005u\u0017)!A\u0005B\u0005}\u0007\"CAq\u0003\u0006\u0005I\u0011\tB@\u000f%\u0011\u0019\tDA\u0001\u0012\u0003\u0011)IB\u0005\u0003f1\t\t\u0011#\u0001\u0003\b\"1An\u0015C\u0001\u0005\u0017C\u0011\"!8T\u0003\u0003%)%a8\t\u0013\u0005m8+!A\u0005\u0002\n5\u0005\"\u0003B\u0003'\u0006\u0005I\u0011\u0011BJ\u0011%\u0011IbUA\u0001\n\u0013\u0011YB\u0001\nESN$\u0018M\\2f\u0007\u0006d7-\u001e7bi>\u0014(BA.]\u0003!9Wm\\7fiJL(BA/_\u0003\u0015)H/\u001b7t\u0015\ty\u0006-A\u0004hK>lWm]1\u000b\u0005\u0005\u0014\u0017\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A2\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0007CA4k\u001b\u0005A'\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002]B\u0011q\u000eA\u0007\u00025\u0006!1-\u00197d+\u0005\u0011\bCA:y\u001b\u0005!(BA;w\u0003-\u0011XMZ3sK:\u001c\u0017N\\4\u000b\u0005]\u0014\u0017\u0001C4f_R|w\u000e\\:\n\u0005e$(AE$f_\u0012,G/[2DC2\u001cW\u000f\\1u_J\fQaY1mG\u0002\na!\\3uKJ\u001cH#B?\u0002\u0002\u0005U\u0001CA4\u007f\u0013\ty\bN\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003\u0007!\u0001\u0019AA\u0003\u0003\u0005\t\u0007\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0005O\u0016|WNC\u0002\u0002\u0010\u0001\f1A\u001b;t\u0013\u0011\t\u0019\"!\u0003\u0003\u000bA{\u0017N\u001c;\t\u000f\u0005]A\u00011\u0001\u0002\u0006\u0005\t!-\u0001\u0005eSN$\u0018M\\2f)\u0019\tiBa&\u0003\u001aB\u0019\u0011q\u0004\b\u000f\u0007\u0005\u00052B\u0004\u0003\u0002$\u0005eb\u0002BA\u0013\u0003oqA!a\n\u000269!\u0011\u0011FA\u001a\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018I\u00061AH]8pizJ\u0011aY\u0005\u0003C\nL!a\u00181\n\u0005us\u0016BA.]\u0003I!\u0015n\u001d;b]\u000e,7)\u00197dk2\fGo\u001c:\u0011\u0005=d1C\u0001\u0007g)\t\tiD\u0001\u0005ESN$\u0018M\\2f'\u0019qa-a\u0012\u0002NA\u0019q-!\u0013\n\u0007\u0005-\u0003NA\u0004Qe>$Wo\u0019;\u0011\u0007\u001d\fy%C\u0002\u0002R!\u0014AbU3sS\u0006d\u0017N_1cY\u0016,\u0012!`\u0001\b[\u0016$XM]:!\u0003)i\u0017N\u001c#fOJ,Wm]\u0001\f[&tG)Z4sK\u0016\u001c\b%\u0001\u0006nCb$Um\u001a:fKN\f1\"\\1y\t\u0016<'/Z3tAQA\u0011\u0011MA3\u0003O\nI\u0007E\u0002\u0002d9i\u0011\u0001\u0004\u0005\u0006wV\u0001\r! \u0005\u0007\u0003/*\u0002\u0019A?\t\r\u0005mS\u00031\u0001~\u0003\u0011\u0019w\u000e]=\u0015\u0011\u0005\u0005\u0014qNA9\u0003gBqa\u001f\f\u0011\u0002\u0003\u0007Q\u0010\u0003\u0005\u0002XY\u0001\n\u00111\u0001~\u0011!\tYF\u0006I\u0001\u0002\u0004i\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003sR3!`A>W\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0013Ut7\r[3dW\u0016$'bAADQ\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0015\u0011\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0013\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0015\u0001\u00026bm\u0006LA!a)\u0002\u001a\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!+\u0011\u0007\u001d\fY+C\u0002\u0002.\"\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a-\u0002:B\u0019q-!.\n\u0007\u0005]\u0006NA\u0002B]fD\u0011\"a/\u001d\u0003\u0003\u0005\r!!+\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\r\u0005\u0004\u0002D\u0006%\u00171W\u0007\u0003\u0003\u000bT1!a2i\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\f)M\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAi\u0003/\u00042aZAj\u0013\r\t)\u000e\u001b\u0002\b\u0005>|G.Z1o\u0011%\tYLHA\u0001\u0002\u0004\t\u0019,\u0001\u0005iCND7i\u001c3f)\t\tI+\u0001\u0005u_N#(/\u001b8h)\t\t)*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\f)\u000fC\u0005\u0002<\u0006\n\t\u00111\u0001\u00024\u0006AA)[:uC:\u001cW\rE\u0002\u0002d\r\u001aRaIAw\u0003\u001b\u0002\u0012\"a<\u0002vvlX0!\u0019\u000e\u0005\u0005E(bAAzQ\u00069!/\u001e8uS6,\u0017\u0002BA|\u0003c\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\tI/A\u0003baBd\u0017\u0010\u0006\u0005\u0002b\u0005}(\u0011\u0001B\u0002\u0011\u0015Yh\u00051\u0001~\u0011\u0019\t9F\na\u0001{\"1\u00111\f\u0014A\u0002u\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\n\tU\u0001#B4\u0003\f\t=\u0011b\u0001B\u0007Q\n1q\n\u001d;j_:\u0004ba\u001aB\t{vl\u0018b\u0001B\nQ\n1A+\u001e9mKNB\u0011Ba\u0006(\u0003\u0003\u0005\r!!\u0019\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u000f!\u0011\t9Ja\b\n\t\t\u0005\u0012\u0011\u0014\u0002\u0007\u001f\nTWm\u0019;\u0003\u00175Kg\u000eR5ti\u0006t7-Z\n\u0007S\u0019\f9%!\u0014\u0002\u000f\u0011,wM]3fg\u0006AA-Z4sK\u0016\u001c\b\u0005\u0006\u0004\u0003.\t=\"\u0011\u0007\t\u0004\u0003GJ\u0003\"B>/\u0001\u0004i\bB\u0002B\u0014]\u0001\u0007Q\u0010\u0006\u0004\u0003.\tU\"q\u0007\u0005\bw>\u0002\n\u00111\u0001~\u0011!\u00119c\fI\u0001\u0002\u0004iH\u0003BAZ\u0005wA\u0011\"a/5\u0003\u0003\u0005\r!!+\u0015\t\u0005E'q\b\u0005\n\u0003w3\u0014\u0011!a\u0001\u0003g#B!!5\u0003D!I\u00111X\u001d\u0002\u0002\u0003\u0007\u00111W\u0001\f\u001b&tG)[:uC:\u001cW\rE\u0002\u0002dm\u001aRa\u000fB&\u0003\u001b\u0002\u0002\"a<\u0003Nul(QF\u0005\u0005\u0005\u001f\n\tPA\tBEN$(/Y2u\rVt7\r^5p]J\"\"Aa\u0012\u0015\r\t5\"Q\u000bB,\u0011\u0015Yh\b1\u0001~\u0011\u0019\u00119C\u0010a\u0001{R!!1\fB2!\u00159'1\u0002B/!\u00159'qL?~\u0013\r\u0011\t\u0007\u001b\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\t]q(!AA\u0002\t5\"aC'bq\u0012K7\u000f^1oG\u0016\u001cb!\u00114\u0002H\u00055CC\u0002B6\u0005[\u0012y\u0007E\u0002\u0002d\u0005CQa\u001f$A\u0002uDaAa\nG\u0001\u0004iHC\u0002B6\u0005g\u0012)\bC\u0004|\u000fB\u0005\t\u0019A?\t\u0011\t\u001dr\t%AA\u0002u$B!a-\u0003z!I\u00111\u0018'\u0002\u0002\u0003\u0007\u0011\u0011\u0016\u000b\u0005\u0003#\u0014i\bC\u0005\u0002<:\u000b\t\u00111\u0001\u00024R!\u0011\u0011\u001bBA\u0011%\tY,UA\u0001\u0002\u0004\t\u0019,A\u0006NCb$\u0015n\u001d;b]\u000e,\u0007cAA2'N)1K!#\u0002NAA\u0011q\u001eB'{v\u0014Y\u0007\u0006\u0002\u0003\u0006R1!1\u000eBH\u0005#CQa\u001f,A\u0002uDaAa\nW\u0001\u0004iH\u0003\u0002B.\u0005+C\u0011Ba\u0006X\u0003\u0003\u0005\rAa\u001b\t\u000f\u0005\rQ\u00011\u0001\u0002\u0006!9\u0011qC\u0003A\u0002\u0005\u0015A\u0003CA\u000f\u0005;\u0013yJ!)\t\u000f\u0005\ra\u00011\u0001\u0002\u0006!9\u0011q\u0003\u0004A\u0002\u0005\u0015\u0001\"B>\u0007\u0001\u0004i\u0018aA7j]R1!q\u0015BU\u0005W\u00032!a\b*\u0011\u001d\t\u0019a\u0002a\u0001\u0003\u000bAq!a\u0006\b\u0001\u0004\t)\u0001F\u0004~\u0005_\u0013\tLa-\t\u000f\u0005\r\u0001\u00021\u0001\u0002\u0006!9\u0011q\u0003\u0005A\u0002\u0005\u0015\u0001\"B>\t\u0001\u0004i\u0018aA7bqR1!\u0011\u0018B^\u0005{\u00032!a\bB\u0011\u001d\t\u0019!\u0003a\u0001\u0003\u000bAq!a\u0006\n\u0001\u0004\t)\u0001F\u0004~\u0005\u0003\u0014\u0019M!2\t\u000f\u0005\r!\u00021\u0001\u0002\u0006!9\u0011q\u0003\u0006A\u0002\u0005\u0015\u0001\"B>\u000b\u0001\u0004i\b")
public class DistanceCalculator {
    private final GeodeticCalculator calc = new GeodeticCalculator();

    private GeodeticCalculator calc() {
        return this.calc;
    }

    public double meters(Point a, Point b) {
        this.calc().setStartingGeographicPoint(a.getX(), a.getY());
        this.calc().setDestinationGeographicPoint(b.getX(), b.getY());
        return this.calc().getOrthodromicDistance();
    }

    public Distance distance(Point a, Point b) {
        return this.distance(a, b, this.meters(a, b));
    }

    public Distance distance(Point a, Point b, double meters) {
        Tuple2<Object, Object> tuple2 = GeometryUtils$.MODULE$.distanceDegrees(a, meters, this.calc());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double a0 = tuple2._1$mcD$sp();
        double a1 = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(a0, a1);
        Tuple2.mcDD.sp sp3 = sp2;
        double a02 = sp3._1$mcD$sp();
        double a12 = sp3._2$mcD$sp();
        Tuple2<Object, Object> tuple22 = GeometryUtils$.MODULE$.distanceDegrees(b, meters, this.calc());
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        double b0 = tuple22._1$mcD$sp();
        double b1 = tuple22._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(b0, b1);
        Tuple2.mcDD.sp sp5 = sp4;
        double b02 = sp5._1$mcD$sp();
        double b12 = sp5._2$mcD$sp();
        return new Distance(meters, package$.MODULE$.min(a02, b02), package$.MODULE$.max(a12, b12));
    }

    public MinDistance min(Point a, Point b) {
        double m = this.meters(a, b);
        return new MinDistance(m, this.min(a, b, m));
    }

    public double min(Point a, Point b, double meters) {
        double amin = GeometryUtils$.MODULE$.distanceDegrees(a, meters, this.calc())._1$mcD$sp();
        double bmin = GeometryUtils$.MODULE$.distanceDegrees(b, meters, this.calc())._1$mcD$sp();
        return package$.MODULE$.min(amin, bmin);
    }

    public MaxDistance max(Point a, Point b) {
        double m = this.meters(a, b);
        return new MaxDistance(m, this.max(a, b, m));
    }

    public double max(Point a, Point b, double meters) {
        double amax = GeometryUtils$.MODULE$.distanceDegrees(a, meters, this.calc())._2$mcD$sp();
        double bmax = GeometryUtils$.MODULE$.distanceDegrees(b, meters, this.calc())._2$mcD$sp();
        return package$.MODULE$.max(amax, bmax);
    }

    public static class Distance
    implements Product,
    Serializable {
        private final double meters;
        private final double minDegrees;
        private final double maxDegrees;

        public double meters() {
            return this.meters;
        }

        public double minDegrees() {
            return this.minDegrees;
        }

        public double maxDegrees() {
            return this.maxDegrees;
        }

        public Distance copy(double meters, double minDegrees, double maxDegrees) {
            return new Distance(meters, minDegrees, maxDegrees);
        }

        public double copy$default$1() {
            return this.meters();
        }

        public double copy$default$2() {
            return this.minDegrees();
        }

        public double copy$default$3() {
            return this.maxDegrees();
        }

        public String productPrefix() {
            return "Distance";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Double d;
            int n = x$1;
            switch (n) {
                case 0: {
                    d = BoxesRunTime.boxToDouble((double)this.meters());
                    break;
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble((double)this.minDegrees());
                    break;
                }
                case 2: {
                    d = BoxesRunTime.boxToDouble((double)this.maxDegrees());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return d;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Distance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.meters()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minDegrees()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maxDegrees()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Distance)) return false;
            boolean bl = true;
            if (!bl) return false;
            Distance distance = (Distance)x$1;
            if (this.meters() != distance.meters()) return false;
            if (this.minDegrees() != distance.minDegrees()) return false;
            if (this.maxDegrees() != distance.maxDegrees()) return false;
            if (!distance.canEqual(this)) return false;
            return true;
        }

        public Distance(double meters, double minDegrees, double maxDegrees) {
            this.meters = meters;
            this.minDegrees = minDegrees;
            this.maxDegrees = maxDegrees;
            Product.$init$((Product)this);
        }
    }

    public static class MaxDistance
    implements Product,
    Serializable {
        private final double meters;
        private final double degrees;

        public double meters() {
            return this.meters;
        }

        public double degrees() {
            return this.degrees;
        }

        public MaxDistance copy(double meters, double degrees) {
            return new MaxDistance(meters, degrees);
        }

        public double copy$default$1() {
            return this.meters();
        }

        public double copy$default$2() {
            return this.degrees();
        }

        public String productPrefix() {
            return "MaxDistance";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Double d;
            int n = x$1;
            switch (n) {
                case 0: {
                    d = BoxesRunTime.boxToDouble((double)this.meters());
                    break;
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble((double)this.degrees());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return d;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MaxDistance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.meters()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.degrees()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MaxDistance)) return false;
            boolean bl = true;
            if (!bl) return false;
            MaxDistance maxDistance = (MaxDistance)x$1;
            if (this.meters() != maxDistance.meters()) return false;
            if (this.degrees() != maxDistance.degrees()) return false;
            if (!maxDistance.canEqual(this)) return false;
            return true;
        }

        public MaxDistance(double meters, double degrees) {
            this.meters = meters;
            this.degrees = degrees;
            Product.$init$((Product)this);
        }
    }

    public static class MinDistance
    implements Product,
    Serializable {
        private final double meters;
        private final double degrees;

        public double meters() {
            return this.meters;
        }

        public double degrees() {
            return this.degrees;
        }

        public MinDistance copy(double meters, double degrees) {
            return new MinDistance(meters, degrees);
        }

        public double copy$default$1() {
            return this.meters();
        }

        public double copy$default$2() {
            return this.degrees();
        }

        public String productPrefix() {
            return "MinDistance";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Double d;
            int n = x$1;
            switch (n) {
                case 0: {
                    d = BoxesRunTime.boxToDouble((double)this.meters());
                    break;
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble((double)this.degrees());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return d;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MinDistance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.meters()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.degrees()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MinDistance)) return false;
            boolean bl = true;
            if (!bl) return false;
            MinDistance minDistance = (MinDistance)x$1;
            if (this.meters() != minDistance.meters()) return false;
            if (this.degrees() != minDistance.degrees()) return false;
            if (!minDistance.canEqual(this)) return false;
            return true;
        }

        public MinDistance(double meters, double degrees) {
            this.meters = meters;
            this.degrees = degrees;
            Product.$init$((Product)this);
        }
    }
}

