/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.geotools.data.Base64;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureIterator;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.identity.FeatureId;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class FeatureHandler$ {
    public static FeatureHandler$ MODULE$;
    private final String OUTPUT_FIELD_SEPARATOR;
    private final char OUTPUT_FIELD_SEPARATOR_CHAR;

    static {
        new FeatureHandler$();
    }

    public String OUTPUT_FIELD_SEPARATOR() {
        return this.OUTPUT_FIELD_SEPARATOR;
    }

    public char OUTPUT_FIELD_SEPARATOR_CHAR() {
        return this.OUTPUT_FIELD_SEPARATOR_CHAR;
    }

    public List<FeatureId> features2csv(FeatureIterator<SimpleFeature> featureIterator, SimpleFeatureType newType, String outputFile) {
        BufferedWriter fout = new BufferedWriter(new FileWriter(new File(outputFile)));
        ListBuffer buffer = new ListBuffer();
        while (featureIterator.hasNext()) {
            BoxedUnit boxedUnit;
            SimpleFeature sf = (SimpleFeature)featureIterator.next();
            try {
                String wkb64;
                Geometry geom = (Geometry)sf.getDefaultGeometry();
                if (geom != null) {
                    if (!geom.isValid() && !(geom = geom.buffer(0.0)).isValid()) {
                        throw new Exception(new StringBuilder(18).append("Invalid geometry:\n").append(geom).toString());
                    }
                    if (geom.isEmpty()) {
                        throw new Exception("Empty geometry.");
                    }
                    wkb64 = Base64.encodeBytes((byte[])WKBUtils$.MODULE$.write(geom), (int)8);
                    if (wkb64.length() < 1) {
                        throw new Exception("Invalid base-64 encoding");
                    }
                } else {
                    throw new Exception("Read a null geometry");
                }
                String encodedFeature = DataUtilities.encodeFeature((SimpleFeature)sf);
                fout.write(new .colon.colon((Object)wkb64, (List)new .colon.colon((Object)encodedFeature, (List)Nil$.MODULE$)).mkString(this.OUTPUT_FIELD_SEPARATOR()));
                fout.newLine();
                boxedUnit = buffer.$plus$eq((Object)sf.getIdentifier());
            }
            catch (Exception e) {
                System.err.println(new StringBuilder(94).append("[WARNING] Problem reading geometry or attributes from Shapefile.\n  Geometry:  ").append(sf.getDefaultGeometry()).append("\n  Attributes:  ").append(sf.getAttributes()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        fout.flush();
        fout.close();
        return buffer.toList();
    }

    private FeatureHandler$() {
        MODULE$ = this;
        this.OUTPUT_FIELD_SEPARATOR = "|";
        this.OUTPUT_FIELD_SEPARATOR_CHAR = this.OUTPUT_FIELD_SEPARATOR().charAt(0);
    }
}

