/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.locationtech.geomesa.utils.geotools.AttributeDetails$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class GenerateFeatureWrappers$ {
    public static GenerateFeatureWrappers$ MODULE$;
    private final String className;

    static {
        new GenerateFeatureWrappers$();
    }

    public String className() {
        return this.className;
    }

    public String buildAllClasses(Seq<SimpleFeatureType> sfts, String pkg) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        sb.append(new StringBuilder(10).append("package ").append(pkg).append("\n\n").toString());
        sb.append(new StringBuilder(9).append("object ").append(this.className()).append(" {").toString());
        sfts.foreach((Function1 & Serializable & scala.Serializable)sft -> sb.append("\n\n").append(MODULE$.buildClass((SimpleFeatureType)sft, "  ")));
        sb.append("\n}");
        return sb.toString();
    }

    public String buildClass(SimpleFeatureType sft, String tab) {
        Buffer attrs = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> AttributeDetails$.MODULE$.apply((AttributeDescriptor)x$1, sft), Buffer$.MODULE$.canBuildFrom());
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        sb.append(new StringBuilder(15).append(tab).append("implicit class ").append(sft.getTypeName()).toString());
        sb.append("(val sf: org.opengis.feature.simple.SimpleFeature) extends AnyVal {\n");
        attrs.foreach((Function1 & Serializable & scala.Serializable)a -> {
            sb.append("\n");
            sb.append(new StringBuilder(3).append(tab).append("  ").append(a.getter()).append("\n").toString());
            sb.append(new StringBuilder(3).append(tab).append("  ").append(a.optionGetter()).append("\n").toString());
            return sb.append(new StringBuilder(3).append(tab).append("  ").append(a.setter()).append("\n").toString());
        });
        sb.append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n        |").append(tab).append("  def debug(): String = {\n        |").append(tab).append("    import scala.collection.JavaConverters._\n        |").append(tab).append("    val sb = new StringBuilder(s\"${sf.getType.getTypeName}:${sf.getID}\")\n        |").append(tab).append("    sf.getProperties.asScala.foreach(p => sb.append(s\"|${p.getName.getLocalPart}=${p.getValue}\"))\n        |").append(tab).append("    sb.toString()\n        |").append(tab).append("  }\n        |").toString())).stripMargin());
        sb.append(new StringBuilder(1).append(tab).append("}").toString());
        return sb.toString();
    }

    public Seq<File> findFormatFiles(File file2) {
        String name;
        return !file2.isDirectory() ? ((name = file2.getName()).startsWith("format-") && name.endsWith(".conf") ? (Seq)new .colon.colon((Object)file2, (List)Nil$.MODULE$) : (Seq)Nil$.MODULE$) : (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles())).flatMap((Function1 & Serializable & scala.Serializable)file -> MODULE$.findFormatFiles((File)file), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public void main(String[] args) {
        String basedir = args[0];
        String packageName = args[1];
        Predef$.MODULE$.assert(basedir != null);
        Predef$.MODULE$.assert(packageName != null);
        File folder = new File(new StringBuilder(19).append(basedir).append("/src/main/resources").toString());
        Seq resources = (Seq)((SeqLike)new Some((Object)folder).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory())).map((Function1 & Serializable & scala.Serializable)file -> MODULE$.findFormatFiles((File)file)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), (Ordering)Ordering.String$.MODULE$);
        Seq sfts = (Seq)resources.map((Function1 & Serializable & scala.Serializable)r -> SimpleFeatureTypes$.MODULE$.createType(ConfigFactory.parseFile((File)r), SimpleFeatureTypes$.MODULE$.createType$default$2(), SimpleFeatureTypes$.MODULE$.createType$default$3()), Seq$.MODULE$.canBuildFrom());
        if (sfts.isEmpty()) {
            Predef$.MODULE$.println((Object)"No formats found");
        } else {
            String classFilePath = new StringBuilder(23).append(basedir).append("/src/main/scala/").append(packageName.replaceAll("\\.", "/")).append("/").append(this.className()).append(".scala").toString();
            File classFile = new File(classFilePath);
            Predef$.MODULE$.println((Object)new StringBuilder(34).append("Writing class file ").append(packageName).append(".").append(this.className()).append(" with formats ").append(((TraversableOnce)sfts.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getTypeName(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            FileWriter fw = new FileWriter(classFile);
            fw.write(this.buildAllClasses((Seq<SimpleFeatureType>)sfts, packageName));
            fw.flush();
            fw.close();
        }
    }

    private GenerateFeatureWrappers$() {
        MODULE$ = this;
        this.className = "SimpleFeatureWrappers";
    }
}

