/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import org.locationtech.geomesa.utils.geotools.GenerateRichFeatureModels;
import org.locationtech.geomesa.utils.geotools.GenerateRichFeatureModels$AttributeMethods$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$RichAttributeDescriptor$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.RichChar$;

public final class GenerateRichFeatureModels$ {
    public static GenerateRichFeatureModels$ MODULE$;

    static {
        new GenerateRichFeatureModels$();
    }

    public void main(String[] args) {
        String basedir = args[0];
        String packageName = args[1];
        Predef$.MODULE$.assert(basedir != null);
        Predef$.MODULE$.assert(packageName != null);
        List<SimpleFeatureType> sfts = SimpleFeatureTypeLoader$.MODULE$.sfts();
        if (sfts.isEmpty()) {
            Predef$.MODULE$.println((Object)"No formats found");
        } else {
            sfts.foreach((Function1 & Serializable & scala.Serializable)sft -> {
                GenerateRichFeatureModels$.$anonfun$main$1(basedir, packageName, sft);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void buildSingleClass(SimpleFeatureType sft, String name, String pkg, Writer out) {
        out.append(new StringBuilder(10).append("package ").append(pkg).append("\n\n").toString());
        out.append("import org.opengis.feature.simple.SimpleFeature\n\n");
        out.append(new StringBuilder(50).append("// this class was generated by ").append(this.getClass().getName()).append(" for feature type ").append(sft.getTypeName()).append("\n").toString());
        out.append(new StringBuilder(11).append("object ").append(name).append(" {\n\n").toString());
        out.append("  implicit class RichFeature(val sf: SimpleFeature) extends AnyVal {\n");
        for (int i = 0; i < sft.getAttributeCount(); ++i) {
            GenerateRichFeatureModels.AttributeMethods attr = GenerateRichFeatureModels$AttributeMethods$.MODULE$.apply(sft, i);
            out.append("\n");
            out.append(new StringBuilder(5).append("    ").append(attr.getter()).append("\n").toString());
            out.append(new StringBuilder(5).append("    ").append(attr.optionGetter()).append("\n").toString());
            out.append(new StringBuilder(5).append("    ").append(attr.setter()).append("\n").toString());
        }
        out.append(new StringOps(Predef$.MODULE$.augmentString("\n         |    def debug(): String = {\n         |      import scala.collection.JavaConverters._\n         |      val sb = new StringBuilder(s\"${sf.getType.getTypeName}:${sf.getID}\")\n         |      sf.getProperties.asScala.foreach(p => sb.append(s\"|${p.getName.getLocalPart}=${p.getValue}\"))\n         |      sb.toString()\n         |    }\n         |")).stripMargin());
        out.append("  }\n}");
    }

    /*
     * WARNING - void declaration
     */
    public String getAttributeBinding(AttributeDescriptor descriptor) {
        String string;
        String binding = descriptor.getType().getBinding().getCanonicalName();
        if (RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
            string = new StringBuilder(2).append(binding).append("[").append(GenerateRichFeatureModels$.subtype$1(RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)))).append("]").toString();
        } else if (RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
            Tuple2<Class<?>, Class<?>> tuple2 = RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Class keyType = (Class)tuple2._1();
            Class valueType = (Class)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)keyType, (Object)valueType);
            Tuple2 tuple23 = tuple22;
            Class keyType2 = (Class)tuple23._1();
            Class valueType2 = (Class)tuple23._2();
            string = new StringBuilder(3).append(binding).append("[").append(GenerateRichFeatureModels$.subtype$1(keyType2)).append(",").append(GenerateRichFeatureModels$.subtype$1(valueType2)).append("]").toString();
        } else {
            void var3_2;
            string = var3_2;
        }
        return string;
    }

    public String org$locationtech$geomesa$utils$geotools$GenerateRichFeatureModels$$safeIdentifier(String name) {
        scala.collection.mutable.StringBuilder safe = new scala.collection.mutable.StringBuilder();
        boolean upper = true;
        for (int i = 0; i < name.length(); ++i) {
            BoxedUnit boxedUnit;
            char c = name.charAt(i);
            if (c == '_' || i == 0 && !Character.isJavaIdentifierStart(c) || i != 0 && !Character.isJavaIdentifierPart(c)) {
                upper = true;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (upper) {
                safe.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(c)));
                upper = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = safe.append(c);
        }
        if (safe.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Can't create valid Java identifier from ").append(name).toString());
        }
        return safe.toString();
    }

    public static final /* synthetic */ void $anonfun$main$1(String basedir$1, String packageName$1, SimpleFeatureType sft) {
        String name = new StringBuilder(5).append(MODULE$.org$locationtech$geomesa$utils$geotools$GenerateRichFeatureModels$$safeIdentifier(sft.getTypeName())).append("Model").toString();
        String classFilePath = new StringBuilder(23).append(basedir$1).append("/src/main/scala/").append(packageName$1.replaceAll("\\.", "/")).append("/").append(name).append(".scala").toString();
        File classFile = new File(classFilePath);
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Writing class file ").append(packageName$1).append(".").append(name).append(" with feature type ").append(sft.getTypeName()).toString());
        package$WithClose$.MODULE$.apply(new FileWriter(classFile), (Function1 & Serializable & scala.Serializable)fw -> {
            GenerateRichFeatureModels$.MODULE$.buildSingleClass(sft, name, packageName$1, fw);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    private static final String subtype$1(Class c) {
        Class clazz = c;
        String string = clazz == null ? "String" : clazz.getCanonicalName();
        return string;
    }

    private GenerateRichFeatureModels$() {
        MODULE$ = this;
    }
}

