/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.locationtech.geomesa.utils.conf.ArgResolver;
import org.locationtech.geomesa.utils.conf.ArgResolver$ArgTypes$;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class SftArgResolver$
implements ArgResolver<SimpleFeatureType, SftArgs> {
    public static SftArgResolver$ MODULE$;
    private final Seq<String> confStrings;
    private final String specStrReg;
    private final String fileNameReg;
    private final String specStrRegError;
    private final Seq<Function1<SftArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType>>> parseMethodList;
    private final ConfigParseOptions parseOpts;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SftArgResolver$();
    }

    @Override
    public Either getArg(Object args) {
        return ArgResolver.getArg$(this, args);
    }

    @Override
    public ConfigParseOptions parseOpts() {
        return this.parseOpts;
    }

    @Override
    public void org$locationtech$geomesa$utils$conf$ArgResolver$_setter_$parseOpts_$eq(ConfigParseOptions x$1) {
        this.parseOpts = x$1;
    }

    private Logger logger$lzycompute() {
        SftArgResolver$ sftArgResolver$ = this;
        synchronized (sftArgResolver$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private Seq<String> confStrings() {
        return this.confStrings;
    }

    private String specStrReg() {
        return this.specStrReg;
    }

    private String fileNameReg() {
        return this.fileNameReg;
    }

    private String specStrRegError() {
        return this.specStrRegError;
    }

    @Override
    public Enumeration.Value argType(SftArgs args) {
        return this.confStrings().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SftArgResolver$.$anonfun$argType$1(args, x$1))) ? ArgResolver$ArgTypes$.MODULE$.CONFSTR() : (args.spec().matches(this.specStrReg()) ? ArgResolver$ArgTypes$.MODULE$.SPECSTR() : (args.spec().matches(this.fileNameReg()) || args.spec().contains("/") ? ArgResolver$ArgTypes$.MODULE$.PATH() : (args.spec().matches(this.specStrRegError()) ? ArgResolver$ArgTypes$.MODULE$.SPECSTR() : ArgResolver$ArgTypes$.MODULE$.NAME())));
    }

    @Override
    public Seq<Function1<SftArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType>>> parseMethodList() {
        return this.parseMethodList;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> getLoadedSft(SftArgs args) {
        Right right;
        Option option = SimpleFeatureTypeLoader$.MODULE$.sfts().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SftArgResolver$.$anonfun$getLoadedSft$1(args, x$1))).map((Function1 & Serializable & scala.Serializable)sft -> {
            SimpleFeatureType simpleFeatureType;
            block3: {
                block2: {
                    if (args.featureName() == null) break block2;
                    String string = args.featureName();
                    String string2 = sft.getTypeName();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                }
                simpleFeatureType = sft;
                return simpleFeatureType;
            }
            simpleFeatureType = SimpleFeatureTypes$.MODULE$.renameSft((SimpleFeatureType)sft, args.featureName());
            return simpleFeatureType;
        });
        if (option instanceof Some) {
            Some some = (Some)option;
            SimpleFeatureType sft2 = (SimpleFeatureType)some.value();
            right = package$.MODULE$.Right().apply((Object)sft2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(32).append("Unable to get loaded SFT using ").append(args.spec()).append(".").toString(), (Object)new RuntimeException(new StringBuilder(34).append(args.spec()).append(" was not found in the loaded SFTs.").toString()), (Object)ArgResolver$ArgTypes$.MODULE$.NAME()));
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseSpecString(SftArgs args) {
        Right right;
        try {
            String name = (String)Option$.MODULE$.apply((Object)args.featureName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException("Feature name was not provided.");
            });
            right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.createType(name, args.spec()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(38).append("Unable to parse sft spec from string ").append(args.spec()).append(".").toString(), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.SPECSTR()));
            right = left;
        }
        return right;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseSpecStringFile(SftArgs args) {
        Right right;
        try {
            String name = (String)Option$.MODULE$.apply((Object)args.featureName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException("Feature name was not provided.");
            });
            String file = (String)Option$.MODULE$.apply((Object)args.spec()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException("No input file specified.");
            });
            String spec = FileUtils.readFileToString((File)new File(file), (Charset)StandardCharsets.UTF_8);
            right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.createType(name, spec));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(36).append("Unable to parse sft spec from file ").append(args.spec()).append(".").toString(), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
            right = left;
        }
        return right;
    }

    public Either<Throwable, SimpleFeatureType> parseConf(Reader input, String name) {
        Left left;
        block17: {
            try {
                Right right;
                Seq<SimpleFeatureType> sfts = ConfigSftParsing$.MODULE$.parseConf(ConfigFactory.parseReader((Reader)input, (ConfigParseOptions)this.parseOpts()).resolve());
                if (sfts.isEmpty()) {
                    throw new RuntimeException("No feature types parsed from config string");
                }
                if (name == null) {
                    BoxedUnit boxedUnit;
                    if (sfts.lengthCompare(1) > 0) {
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Found more than one SFT conf in input arg");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    left = package$.MODULE$.Right().apply(sfts.head());
                    break block17;
                }
                Option option = sfts.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SftArgResolver$.$anonfun$parseConf$1(name, x$2)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SimpleFeatureType sft = (SimpleFeatureType)some.value();
                    right = package$.MODULE$.Right().apply((Object)sft);
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (sfts.lengthCompare(1) > 0) {
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Found more than one SFT conf in input arg");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.renameSft((SimpleFeatureType)sfts.head(), name));
                } else {
                    throw new MatchError((Object)option);
                }
                left = right;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                Left left2 = package$.MODULE$.Left().apply((Object)e);
                left = left2;
            }
        }
        return left;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseConfStr(SftArgs args) {
        return this.parseConf(new StringReader(args.spec()), args.featureName()).left().map((Function1 & Serializable & scala.Serializable)e -> new Tuple3((Object)new StringBuilder(48).append("Unable to parse sft spec from string '").append(args.spec()).append("' as conf.").toString(), e, (Object)ArgResolver$ArgTypes$.MODULE$.CONFSTR()));
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseConfFile(SftArgs args) {
        Either either;
        try {
            FileSystemDelegate.FileHandle handle = (FileSystemDelegate.FileHandle)PathUtils$.MODULE$.interpretPath(args.spec()).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException(new StringBuilder(23).append("Could not read file at ").append(args.spec()).toString());
            });
            either = (Either)package$WithClose$.MODULE$.apply(handle.open(), (Function1 & Serializable & scala.Serializable)streams -> {
                if (!streams.hasNext()) {
                    throw new RuntimeException(new StringBuilder(23).append("Could not read file at ").append(args.spec()).toString());
                }
                InputStreamReader reader = new InputStreamReader((InputStream)((Tuple2)streams.next())._2(), StandardCharsets.UTF_8);
                return MODULE$.parseConf(reader, args.featureName()).left().map((Function1 & Serializable & scala.Serializable)e -> new Tuple3((Object)new StringBuilder(38).append("Unable to parse sft spec from file '").append(args.spec()).append("'.").toString(), e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringBuilder(26).append("Unable to load '").append(args.spec()).append("' as file.").toString(), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
            either = left;
        }
        return either;
    }

    public static final /* synthetic */ boolean $anonfun$argType$1(SftArgs args$1, CharSequence x$1) {
        return args$1.spec().contains(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getLoadedSft$1(SftArgs args$2, SimpleFeatureType x$1) {
        String string = x$1.getTypeName();
        String string2 = args$2.spec();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$parseConf$1(String name$1, SimpleFeatureType x$2) {
        String string = x$2.getTypeName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private SftArgResolver$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        ArgResolver.$init$(this);
        this.confStrings = (Seq)new .colon.colon((Object)"geomesa{", (List)new .colon.colon((Object)"geomesa {", (List)new .colon.colon((Object)"geomesa.sfts", (List)Nil$.MODULE$)));
        this.specStrReg = "^[a-zA-Z0-9]+[:][String|Integer|Double|Point|Date|Map|List].*";
        this.fileNameReg = "([^.]*)\\.([^.]*)";
        this.specStrRegError = "^[a-zA-Z0-9]+[:][a-zA-Z0-9]+.*";
        this.parseMethodList = (Seq)new .colon.colon((Function1 & Serializable & scala.Serializable)args -> MODULE$.getLoadedSft((SftArgs)args), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)args -> MODULE$.parseSpecString((SftArgs)args), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)args -> MODULE$.parseConfStr((SftArgs)args), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)args -> MODULE$.parseSpecStringFile((SftArgs)args), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)args -> MODULE$.parseConfFile((SftArgs)args), (List)Nil$.MODULE$)))));
    }
}

