/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.text.StringEscapeUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.utils.geotools.NameableFeatureTypeFactory;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$AttributeOptions$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecConfig$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecParser$;
import org.locationtech.geomesa.utils.geotools.sft.package;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.parboiled.errors.ParsingException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SimpleFeatureTypes$ {
    public static SimpleFeatureTypes$ MODULE$;
    private final ConcurrentHashMap<Tuple2<String, String>, package.ImmutableSimpleFeatureType> cache;

    static {
        new SimpleFeatureTypes$();
    }

    private ConcurrentHashMap<Tuple2<String, String>, package.ImmutableSimpleFeatureType> cache() {
        return this.cache;
    }

    public SimpleFeatureType createType(String typeName, String spec) {
        Tuple2<String, String> tuple2 = this.parseTypeName(typeName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String namespace = (String)tuple2._1();
        String name = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)namespace, (Object)name);
        Tuple2 tuple23 = tuple22;
        String namespace2 = (String)tuple23._1();
        String name2 = (String)tuple23._2();
        return this.createType(namespace2, name2, spec);
    }

    public SimpleFeatureType createType(String namespace, String name, String spec) {
        SimpleFeatureSpec simpleFeatureSpec;
        try {
            simpleFeatureSpec = SimpleFeatureSpecParser$.MODULE$.parse(spec, SimpleFeatureSpecParser$.MODULE$.parse$default$2());
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        SimpleFeatureSpec parsed = simpleFeatureSpec;
        return this.createFeatureType(namespace, name, parsed, this.createFeatureType$default$4());
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType createImmutableType(String typeName, String spec) {
        void var3_3;
        Object object;
        package.ImmutableSimpleFeatureType sft = this.cache().get(new Tuple2((Object)typeName, (Object)spec));
        if (sft == null) {
            sft = (package.ImmutableSimpleFeatureType)this.immutable(this.createType(typeName, spec), this.immutable$default$2());
            object = this.cache().put((Tuple2<String, String>)new Tuple2((Object)typeName, (Object)spec), sft);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public SimpleFeatureType createImmutableType(String namespace, String name, String spec) {
        return this.createImmutableType(namespace == null ? name : new java.lang.StringBuilder(1).append(namespace).append(":").append(name).toString(), spec);
    }

    public SimpleFeatureType createType(Config conf, Option<String> typeName, Option<String> path) {
        Tuple2<Option<String>, SimpleFeatureSpec> tuple2 = SimpleFeatureSpecConfig$.MODULE$.parse(conf, path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option nameFromConf = (Option)tuple2._1();
        SimpleFeatureSpec spec = (SimpleFeatureSpec)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nameFromConf, (Object)spec);
        Tuple2 tuple23 = tuple22;
        Option nameFromConf2 = (Option)tuple23._1();
        SimpleFeatureSpec spec2 = (SimpleFeatureSpec)tuple23._2();
        Tuple2<String, String> tuple24 = this.parseTypeName((String)nameFromConf2.orElse((Function0 & Serializable & scala.Serializable)() -> typeName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Unable to parse type name from provided argument or config");
        }));
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String namespace = (String)tuple24._1();
        String name = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)namespace, (Object)name);
        Tuple2 tuple26 = tuple25;
        String namespace2 = (String)tuple26._1();
        String name2 = (String)tuple26._2();
        return this.createFeatureType(namespace2, name2, spec2, this.createFeatureType$default$4());
    }

    public Option<String> createType$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createType$default$3() {
        return new Some((Object)"sft");
    }

    public NameableFeatureTypeFactory.NameableSimpleFeatureType createNameableType(String spec) {
        SimpleFeatureSpec simpleFeatureSpec;
        try {
            simpleFeatureSpec = SimpleFeatureSpecParser$.MODULE$.parse(spec, SimpleFeatureSpecParser$.MODULE$.parse$default$2());
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        SimpleFeatureSpec parsed = simpleFeatureSpec;
        return (NameableFeatureTypeFactory.NameableSimpleFeatureType)this.createFeatureType(null, "", parsed, (Option<FeatureTypeFactory>)new Some((Object)new NameableFeatureTypeFactory()));
    }

    public AttributeDescriptor createDescriptor(String spec) {
        AttributeDescriptor attributeDescriptor;
        try {
            attributeDescriptor = SimpleFeatureSpecParser$.MODULE$.parseAttribute(spec, SimpleFeatureSpecParser$.MODULE$.parseAttribute$default$2()).toDescriptor();
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return attributeDescriptor;
    }

    public String encodeType(SimpleFeatureType sft) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.encodeDescriptor(sft, (AttributeDescriptor)x$4), Buffer$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String encodeType(SimpleFeatureType sft, boolean includeUserData) {
        return includeUserData ? new java.lang.StringBuilder(0).append(this.encodeType(sft)).append(this.encodeUserData(sft)).toString() : this.encodeType(sft);
    }

    public String encodeDescriptor(SimpleFeatureType sft, AttributeDescriptor descriptor) {
        return SimpleFeatureSpec$.MODULE$.attribute(sft, descriptor).toSpec();
    }

    public String encodeUserData(SimpleFeatureType sft) {
        Seq<String> prefixes = RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getUserDataPrefixes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        StringBuilder result = new StringBuilder(";");
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sft.getUserData()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Object object;
            Object v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    Object k = tuple2._1();
                    v = tuple2._2();
                    if (k == null) break block2;
                    object = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Object object2 = v;
            BoxedUnit boxedUnit = object2 != null && prefixes.exists(arg_0 -> SimpleFeatureTypes$.$anonfun$encodeUserData$2$adapted(string = object.toString(), arg_0)) ? result.append(MODULE$.encodeUserData(object, object2)).append(",") : BoxedUnit.UNIT;
            return boxedUnit;
        });
        return result.lengthCompare(1) > 0 ? result.substring(0, result.length() - 1) : "";
    }

    public String encodeUserData(Map<?, ?> data) {
        String string;
        if (data.isEmpty()) {
            string = "";
        } else {
            StringBuilder result = new StringBuilder(";");
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(data).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                StringBuilder stringBuilder = result.append(MODULE$.encodeUserData(k, v)).append(",");
                return stringBuilder;
            });
            string = result.substring(0, result.length() - 1);
        }
        return string;
    }

    public String encodeUserData(Object key, Object value) {
        return new java.lang.StringBuilder(3).append(key).append("='").append(StringEscapeUtils.escapeJava((String)value.toString())).append("'").toString();
    }

    public Config toConfig(SimpleFeatureType sft, boolean includeUserData, boolean includePrefix) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfig(sft, includeUserData, includePrefix);
    }

    public boolean toConfig$default$2() {
        return true;
    }

    public boolean toConfig$default$3() {
        return true;
    }

    public String toConfigString(SimpleFeatureType sft, boolean includeUserData, boolean concise, boolean includePrefix, boolean json) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfigString(sft, includeUserData, concise, includePrefix, json);
    }

    public boolean toConfigString$default$2() {
        return true;
    }

    public boolean toConfigString$default$3() {
        return false;
    }

    public boolean toConfigString$default$4() {
        return true;
    }

    public boolean toConfigString$default$5() {
        return false;
    }

    public String serialize(SimpleFeatureType sft) {
        return StringSerialization$.MODULE$.encodeSeq((Seq<String>)((Seq)new .colon.colon((Object)sft.getTypeName(), (List)new .colon.colon((Object)this.encodeType(sft, true), (List)Nil$.MODULE$))));
    }

    public SimpleFeatureType deserialize(String sft) {
        Seq<String> seq = StringSerialization$.MODULE$.decodeSeq(sft);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String name = (String)((SeqLike)some.get()).apply(0);
        String spec = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)name, (Object)spec);
        Tuple2 tuple22 = tuple2;
        String name2 = (String)tuple22._1();
        String spec2 = (String)tuple22._2();
        return this.createType(name2, spec2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleFeatureType immutable(SimpleFeatureType sft, Map<?, ?> extraData) {
        SimpleFeatureType simpleFeatureType = sft;
        if (simpleFeatureType instanceof package.ImmutableSimpleFeatureType) {
            package.ImmutableSimpleFeatureType immutableSimpleFeatureType = (package.ImmutableSimpleFeatureType)simpleFeatureType;
            if (extraData == null) return immutableSimpleFeatureType;
            if (extraData.isEmpty()) {
                return immutableSimpleFeatureType;
            }
        }
        ArrayList<AttributeDescriptor> schema = new ArrayList<AttributeDescriptor>(sft.getAttributeCount());
        GeometryDescriptor geom = null;
        for (int i = 0; i < sft.getAttributeCount(); ++i) {
            AttributeDescriptor descriptor = sft.getDescriptor(i);
            AttributeDescriptor im = this.immutable(descriptor);
            AttributeDescriptor attributeDescriptor = descriptor;
            GeometryDescriptor geometryDescriptor = sft.getGeometryDescriptor();
            if (!(attributeDescriptor != null ? !attributeDescriptor.equals(geometryDescriptor) : geometryDescriptor != null)) {
                geom = (GeometryDescriptor)im;
            }
            schema.add(im);
        }
        Option userData2 = Option$.MODULE$.apply(extraData).filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isEmpty())).map((Function1 & Serializable & scala.Serializable)data -> {
            void var2_2;
            HashMap map = new HashMap(data.size() + sft.getUserData().size());
            map.putAll(sft.getUserData());
            map.putAll(data);
            return var2_2;
        });
        return new package.ImmutableSimpleFeatureType(sft.getName(), schema, geom, sft.isAbstract(), sft.getRestrictions(), sft.getSuper(), sft.getDescription(), (Map)userData2.getOrElse((Function0 & Serializable & scala.Serializable)() -> sft.getUserData()));
    }

    public AttributeDescriptor immutable(AttributeDescriptor descriptor) {
        Object object;
        AttributeDescriptor attributeDescriptor = descriptor;
        if (attributeDescriptor instanceof package.ImmutableAttributeDescriptor) {
            package.ImmutableAttributeDescriptor immutableAttributeDescriptor;
            object = immutableAttributeDescriptor = (package.ImmutableAttributeDescriptor)attributeDescriptor;
        } else if (attributeDescriptor instanceof package.ImmutableGeometryDescriptor) {
            package.ImmutableGeometryDescriptor immutableGeometryDescriptor = (package.ImmutableGeometryDescriptor)attributeDescriptor;
            object = immutableGeometryDescriptor;
        } else if (attributeDescriptor instanceof GeometryDescriptor) {
            GeometryDescriptor geometryDescriptor = (GeometryDescriptor)attributeDescriptor;
            object = new package.ImmutableGeometryDescriptor(geometryDescriptor.getType(), geometryDescriptor.getName(), geometryDescriptor.getMinOccurs(), geometryDescriptor.getMaxOccurs(), geometryDescriptor.isNillable(), geometryDescriptor.getDefaultValue(), geometryDescriptor.getUserData());
        } else {
            object = new package.ImmutableAttributeDescriptor(attributeDescriptor.getType(), attributeDescriptor.getName(), attributeDescriptor.getMinOccurs(), attributeDescriptor.getMaxOccurs(), attributeDescriptor.isNillable(), attributeDescriptor.getDefaultValue(), attributeDescriptor.getUserData());
        }
        return object;
    }

    public Map<?, ?> immutable$default$2() {
        return null;
    }

    public SimpleFeatureType mutable(SimpleFeatureType sft) {
        return sft instanceof package.ImmutableSimpleFeatureType || ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).exists((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.MODULE$.isImmutable(d))) ? this.copy(sft) : sft;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType copy(SimpleFeatureType sft) {
        void var2_2;
        SimpleFeatureType copy = SimpleFeatureTypeBuilder.copy((SimpleFeatureType)sft);
        copy.getUserData().putAll(sft.getUserData());
        return var2_2;
    }

    private boolean isImmutable(AttributeDescriptor d) {
        return d instanceof package.ImmutableAttributeDescriptor || d instanceof package.ImmutableGeometryDescriptor;
    }

    public SimpleFeatureType renameSft(SimpleFeatureType sft, String newName) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(sft);
        int n = newName.indexOf(58);
        switch (n) {
            case -1: {
                builder.setName(newName);
                break;
            }
            default: {
                builder.setNamespaceURI(newName.substring(0, n));
                builder.setName(newName.substring(n + 1));
                break;
            }
        }
        SimpleFeatureType renamed = builder.buildFeatureType();
        renamed.getUserData().putAll(sft.getUserData());
        return renamed;
    }

    public AttributeDescriptor renameDescriptor(AttributeDescriptor descriptor, String newName) {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.init(descriptor);
        return builder.buildDescriptor(newName);
    }

    public int compare(SimpleFeatureType a, SimpleFeatureType b) {
        if (a.getAttributeCount() > b.getAttributeCount()) {
            return -1;
        }
        boolean exact = a.getAttributeCount() == b.getAttributeCount();
        for (int i = 0; i < a.getAttributeCount(); ++i) {
            AttributeDescriptor ad = a.getDescriptor(i);
            AttributeDescriptor bd = b.getDescriptor(i);
            String string = ad.getLocalName();
            String string2 = bd.getLocalName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Class clazz = ad.getType().getBinding();
                Class clazz2 = bd.getType().getBinding();
                if (!(clazz == null ? clazz2 != null : !clazz.equals(clazz2))) continue;
                if (bd.getType().getBinding().isAssignableFrom(ad.getType().getBinding())) {
                    exact = false;
                    continue;
                }
                return -1;
            }
            AttributeDescriptor reorder = b.getDescriptor(ad.getLocalName());
            if (reorder == null || !reorder.getType().getBinding().isAssignableFrom(ad.getType().getBinding())) {
                return -1;
            }
            exact = false;
        }
        return exact ? 0 : 1;
    }

    private SimpleFeatureType createFeatureType(String namespace, String name, SimpleFeatureSpec spec, Option<FeatureTypeFactory> factory) {
        None$ none$;
        Seq geomAttributes = (Seq)spec.attributes().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SimpleFeatureSpec.AttributeSpec, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SimpleFeatureSpec.GeomAttributeSpec) {
                    SimpleFeatureSpec.GeomAttributeSpec geomAttributeSpec = (SimpleFeatureSpec.GeomAttributeSpec)A1;
                    object = geomAttributeSpec;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SimpleFeatureSpec.AttributeSpec x1) {
                SimpleFeatureSpec.AttributeSpec attributeSpec = x1;
                boolean bl = attributeSpec instanceof SimpleFeatureSpec.GeomAttributeSpec;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option defaultGeom = geomAttributes.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$1(x$7))).orElse((Function0 & Serializable & scala.Serializable)() -> geomAttributes.headOption()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name());
        if (spec.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg()).exists((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.MODULE$.toBoolean(value)))) {
            none$ = None$.MODULE$;
        } else {
            Seq dateAttributes = (Seq)spec.attributes().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$6(a)));
            none$ = spec.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.DefaultDtgField()).flatMap((Function1 & Serializable & scala.Serializable)dtg -> dateAttributes.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$8(dtg, x$10)))).orElse((Function0 & Serializable & scala.Serializable)() -> dateAttributes.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$10(x$11)))).orElse((Function0 & Serializable & scala.Serializable)() -> dateAttributes.headOption()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name());
        }
        None$ defaultDate = none$;
        SimpleFeatureTypeBuilder b = (SimpleFeatureTypeBuilder)factory.map((Function1 & Serializable & scala.Serializable)x$14 -> new SimpleFeatureTypeBuilder(x$14)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new SimpleFeatureTypeBuilder());
        b.setNamespaceURI(namespace);
        b.setName(name);
        b.addAll((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)spec.attributes().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toDescriptor(), Seq$.MODULE$.canBuildFrom())).asJava());
        defaultGeom.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            b.setDefaultGeometry(x$1);
            return BoxedUnit.UNIT;
        });
        SimpleFeatureType sft = b.buildFeatureType();
        sft.getUserData().putAll((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(spec.options()).asJava());
        SimpleFeatureType simpleFeatureType = RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft);
        defaultDate.foreach((Function1 & Serializable & scala.Serializable)dtg -> {
            RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.setDtgField$extension(simpleFeatureType, dtg);
            return BoxedUnit.UNIT;
        });
        return sft;
    }

    private Option<FeatureTypeFactory> createFeatureType$default$4() {
        return None$.MODULE$;
    }

    private Tuple2<String, String> parseTypeName(String name) {
        Tuple2 tuple2;
        int nsIndex = name.lastIndexOf(58);
        Tuple2 tuple22 = tuple2 = nsIndex == -1 || nsIndex == name.length() - 1 ? new Tuple2(null, (Object)name) : new Tuple2((Object)name.substring(0, nsIndex), (Object)name.substring(nsIndex + 1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String namespace = (String)tuple2._1();
        String local = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)namespace, (Object)local);
        Tuple2 tuple24 = tuple23;
        String namespace2 = (String)tuple24._1();
        String local2 = (String)tuple24._2();
        return new Tuple2((Object)namespace2, (Object)local2);
    }

    public boolean toBoolean(Object value) {
        boolean bl;
        Object object = value;
        if (object == null) {
            bl = false;
        } else if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            bl = bl2;
        } else if (object instanceof String) {
            String string = (String)object;
            bl = Boolean.valueOf(string);
        } else {
            bl = Boolean.valueOf(object.toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$1(SimpleFeatureSpec.GeomAttributeSpec x$7) {
        return x$7.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OptDefault()).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$2(x$8)));
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$6(SimpleFeatureSpec.AttributeSpec a) {
        return Date.class.isAssignableFrom(a.clazz());
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$8(Object dtg$1, SimpleFeatureSpec.AttributeSpec x$10) {
        String string = x$10.name();
        Object object = dtg$1;
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$11(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$createFeatureType$10(SimpleFeatureSpec.AttributeSpec x$11) {
        return x$11.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OptDefault()).exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureTypes$.$anonfun$createFeatureType$11(x$12)));
    }

    private SimpleFeatureTypes$() {
        MODULE$ = this;
        this.cache = new ConcurrentHashMap();
    }

    public static final /* synthetic */ Object $anonfun$encodeUserData$2$adapted(String eta$0$1$1, String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.startsWith(x$1));
    }
}

