/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools.converters;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.data.util.InterpolationConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$IdentityConverter$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$ToStringConverter$;
import org.opengis.filter.expression.Expression;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class FastConverter$
implements StrictLogging {
    public static FastConverter$ MODULE$;
    private final ConverterFactory[] factories;
    private final ConcurrentHashMap<Tuple2<Class<?>, Class<?>>, Converter[]> cache;
    private final Logger logger;

    static {
        new FastConverter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConverterFactory[] factories() {
        return this.factories;
    }

    private ConcurrentHashMap<Tuple2<Class<?>, Class<?>>, Converter[]> cache() {
        return this.cache;
    }

    public <T> T convert(Object value, Class<T> binding) {
        BoxedUnit boxedUnit;
        Class<?> clas;
        if (value == null) {
            return null;
        }
        Class<?> clazz = clas = value.getClass();
        Class<T> clazz2 = binding;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return (T)value;
        }
        Converter[] converters = this.getConverters(clas, binding);
        for (int i = 0; i < converters.length; ++i) {
            try {
                Object result = converters[i].convert(value, binding);
                if (result == null) continue;
                return (T)result;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit2;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(new StringBuilder(50).append("Error converting ").append(value).append(" (of type ").append(value.getClass().getName()).append(") ").append("to ").append(binding.getName()).append(" using converter ").append(converters[i].getClass().getName()).append(":").toString(), e);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    continue;
                }
                throw throwable;
            }
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Could not convert '{}' (of type {}) to {}", new Object[]{value, value.getClass().getName(), binding.getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return null;
    }

    public <T> T convertFirst(Object value, Iterator<Class<? extends T>> bindings) {
        BoxedUnit boxedUnit;
        if (value == null) {
            return null;
        }
        Class<?> clas = value.getClass();
        while (bindings.hasNext()) {
            Class binding = (Class)bindings.next();
            Class<?> clazz = clas;
            Class clazz2 = binding;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return (T)value;
            }
            Converter[] converters = this.getConverters(clas, binding);
            for (int i = 0; i < converters.length; ++i) {
                try {
                    Object result = converters[i].convert(value, binding);
                    if (result == null) continue;
                    return (T)result;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit2;
                        Throwable e = (Throwable)option.get();
                        if (this.logger().underlying().isTraceEnabled()) {
                            this.logger().underlying().trace(new StringBuilder(50).append("Error converting ").append(value).append(" (of type ").append(value.getClass().getName()).append(") ").append("to ").append(binding.getName()).append(" using converter ").append(converters[i].getClass().getName()).append(":").toString(), e);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit2;
                        continue;
                    }
                    throw throwable;
                }
            }
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(42).append("Could not convert '").append(value).append("' (of type ").append(value.getClass().getName()).append(") ").append("to any of ").append(bindings.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName()).mkString(", ")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return null;
    }

    public <T> T convertOrElse(Object value, Function0<T> function0, ClassTag<T> ct) {
        T attempt = this.convert(value, ct.runtimeClass());
        return (T)(attempt == null ? function0.apply() : attempt);
    }

    public <T> T evaluate(Expression expression, Class<T> binding) {
        return this.convert(expression.evaluate(null), binding);
    }

    /*
     * Unable to fully structure code
     */
    private Converter[] getConverters(Class<?> from, Class<?> to) {
        block4: {
            block3: {
                converters = this.cache().get(new Tuple2(from, to));
                if (converters != null) break block3;
                if (from == to) ** GOTO lbl-1000
                v0 = from;
                var4_4 = to;
                if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false) || to.isAssignableFrom(from)) lbl-1000:
                // 2 sources

                {
                    converters = (Converter[])((Object[])new Converter[]{FastConverter$IdentityConverter$.MODULE$});
                } else {
                    converters = (Converter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.factories())).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getConverters$1(java.lang.Class java.lang.Class org.geotools.util.ConverterFactory ), (Lorg/geotools/util/ConverterFactory;)Lscala/collection/Iterable;)(from, to), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Converter.class)));
                    v1 = to;
                    var5_5 = String.class;
                    if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) {
                        converters = (Converter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])converters)).$colon$plus((Object)FastConverter$ToStringConverter$.MODULE$, ClassTag$.MODULE$.apply(Converter.class));
                    }
                }
                v2 = this.cache().put(new Tuple2(from, to), converters);
                break block4;
            }
            v2 = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$factories$1(ConverterFactory x0$1) {
        ConverterFactory converterFactory = x0$1;
        boolean bl = !(converterFactory instanceof InterpolationConverterFactory);
        return bl;
    }

    public static final /* synthetic */ Iterable $anonfun$getConverters$1(Class from$1, Class to$1, ConverterFactory factory) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)factory.createConverter(from$1, to$1, null)));
    }

    private FastConverter$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.factories = (ConverterFactory[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Converters.getConverterFactories((Hints)GeoTools.getDefaultHints())).asScala()).toArray(ClassTag$.MODULE$.apply(ConverterFactory.class)))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FastConverter$.$anonfun$factories$1(x0$1)));
        this.cache = new ConcurrentHashMap();
    }
}

