/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public final class MixedGeometryCheck$
implements LazyLogging {
    public static MixedGeometryCheck$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MixedGeometryCheck$();
    }

    private Logger logger$lzycompute() {
        MixedGeometryCheck$ mixedGeometryCheck$ = this;
        synchronized (mixedGeometryCheck$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void validateGeometryType(SimpleFeatureType sft) {
        GeometryDescriptor gd = sft.getGeometryDescriptor();
        if (gd != null) {
            Class clazz = gd.getType().getBinding();
            Class<Geometry> clazz2 = Geometry.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) && !GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries())) {
                throw new IllegalArgumentException(new StringBuilder(410).append("Trying to create a schema with mixed geometry type ").append("'").append(gd.getLocalName()).append(":Geometry'. Queries may be slower when using mixed geometries. ").append("If this is intentional, you may override this check by putting Boolean.TRUE into the ").append("SimpleFeatureType user data under the key '").append(SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries()).append("' before calling createSchema, or by ").append("setting the system property '").append(SimpleFeatureTypes$Configs$.MODULE$.MixedGeometries()).append("' to 'true'. Otherwise, please specify a single ").append("geometry type (e.g. Point, LineString, Polygon, etc).").toString());
            }
        }
    }

    private MixedGeometryCheck$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

