/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class ReservedWordCheck$
implements LazyLogging {
    public static ReservedWordCheck$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ReservedWordCheck$();
    }

    private Logger logger$lzycompute() {
        ReservedWordCheck$ reservedWordCheck$ = this;
        synchronized (reservedWordCheck$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void validateAttributeNames(SimpleFeatureType sft) {
        Seq<String> reservedWords = FeatureUtils$.MODULE$.sftReservedWords(sft);
        if (reservedWords.nonEmpty()) {
            String msg = new StringBuilder(313).append("The simple feature type contains attribute name(s) that are reserved words: ").append(reservedWords.mkString(", ")).append(". You may override this check by putting Boolean.TRUE into the ").append("SimpleFeatureType user data under the key '").append(SimpleFeatureTypes$Configs$.MODULE$.OverrideReservedWords()).append("' before calling createSchema, or by ").append("setting the system property '").append(SimpleFeatureTypes$Configs$.MODULE$.OverrideReservedWords()).append("' to 'true', however it may cause errors with some functionality.").toString();
            if (GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.OverrideReservedWords())) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private ReservedWordCheck$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

