/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.index.SizeSeparatedBucketIndex$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001\u0002$H\u0001IC\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\b!Q\u0011\u0011\u0003\u0001\u0003\u0002\u0003\u0006I!a\u0005\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0005C\u0002\u0001\u0015!\u0003\u00026!9!1\r\u0001\u0005B\t\u0015\u0004b\u0002B<\u0001\u0011\u0005#\u0011\u0010\u0005\b\u0005\u007f\u0002A\u0011\tBA\u0011\u001d\u00119\t\u0001C!\u0005\u0013CqAa\"\u0001\t\u0003\u0012\u0019\nC\u0004\u0002v\u0002!\t%a>\t\u000f\u0005e\b\u0001\"\u0011\u0002|\"9!Q\u0013\u0001\u0005\n\t]eABA\"\u0001\u0011\t)\u0005\u0003\u0006\u0002HA\u0011)\u0019!C\u0001\u0003\u0013B!\"a\u0013\u0011\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\ti\u0005\u0005BC\u0002\u0013\u0005\u0011\u0011\n\u0005\u000b\u0003\u001f\u0002\"\u0011!Q\u0001\n\u0005\u001d\u0001BCA)!\t\u0005\t\u0015!\u0003\u0002T!Q\u0011q\u0010\t\u0003\u0002\u0003\u0006I!!!\t\u000f\u0005\r\u0002\u0003\"\u0001\u0002\u000e\"I\u0011q\u0013\tA\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003C\u0003\u0002\u0019!C\u0001\u0003GC\u0001\"a,\u0011A\u0003&\u00111\u0014\u0005\n\u0003s\u0003\"\u0019!C\u0005\u0003wC\u0001\"a1\u0011A\u0003%\u0011Q\u0018\u0005\n\u0003\u000b\u0004\"\u0019!C\u0005\u0003wC\u0001\"a2\u0011A\u0003%\u0011Q\u0018\u0005\b\u0003\u0013\u0004B\u0011AAf\u0011\u001d\tI\r\u0005C\u0001\u0003+Dq!a7\u0011\t\u0003\ti\u000eC\u0004\u0002vB!\t!a>\t\u000f\u0005e\b\u0003\"\u0001\u0002|\"9\u0011Q \t\u0005\n\u0005}\bb\u0002B\u0002!\u0011%!Q\u0001\u0004\u0007\u0005\u0013\u0001\u0002Aa\u0003\t\u0015\u0005\u001dhE!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002l\u001a\u0012\t\u0011)A\u0005\u0003\u000fA!\"a<'\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\t\u0019P\nB\u0001B\u0003%\u0011q\u0001\u0005\b\u0003G1C\u0011\u0001B\u0007\u0011%\u0011YB\nb\u0001\n\u0013\tY\f\u0003\u0005\u0003\u001e\u0019\u0002\u000b\u0011BA_\u0011%\u0011yB\nb\u0001\n\u0013\tY\f\u0003\u0005\u0003\"\u0019\u0002\u000b\u0011BA_\u0011%\u0011\u0019C\nb\u0001\n\u0013\tY\f\u0003\u0005\u0003&\u0019\u0002\u000b\u0011BA_\u0011%\u00119C\na\u0001\n\u0013\tY\fC\u0005\u0003*\u0019\u0002\r\u0011\"\u0003\u0003,!A!q\u0006\u0014!B\u0013\ti\fC\u0005\u00032\u0019\u0002\r\u0011\"\u0003\u0002<\"I!1\u0007\u0014A\u0002\u0013%!Q\u0007\u0005\t\u0005s1\u0003\u0015)\u0003\u0002>\"I!1\b\u0014A\u0002\u0013%!Q\b\u0005\n\u0005\u000b2\u0003\u0019!C\u0005\u0005\u000fB\u0001Ba\u0013'A\u0003&!q\b\u0005\b\u0005\u001b2CQIAM\u0011\u001d\u0011iF\nC!\u0005?:qAa'H\u0011\u0003\u0011iJ\u0002\u0004G\u000f\"\u0005!q\u0014\u0005\b\u0003GqD\u0011\u0001BQ\u0011%\u0011\u0019K\u0010b\u0001\n\u0003\u0011)\u000bC\u0004\u0003(z\u0002\u000b\u0011\u0002;\t\u0013\t%f(%A\u0005\u0002\t-\u0006\"\u0003Ba}E\u0005I\u0011\u0001Bb\u0011%\u0011YMPI\u0001\n\u0003\u0011i\rC\u0005\u0003Rz\n\n\u0011\"\u0001\u0003T\nA2+\u001b>f'\u0016\u0004\u0018M]1uK\u0012\u0014UoY6fi&sG-\u001a=\u000b\u0005!K\u0015!B5oI\u0016D(B\u0001&L\u0003\u0015)H/\u001b7t\u0015\taU*A\u0004hK>lWm]1\u000b\u00059{\u0015\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001)\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005M\u00037\u0003\u0002\u0001U5&\u0004\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a!\u00118z%\u00164\u0007cA.]=6\tq)\u0003\u0002^\u000f\na1\u000b]1uS\u0006d\u0017J\u001c3fqB\u0011q\f\u0019\u0007\u0001\t\u0015\t\u0007A1\u0001c\u0005\u0005!\u0016CA2g!\t)F-\u0003\u0002f-\n9aj\u001c;iS:<\u0007CA+h\u0013\tAgKA\u0002B]f\u0004\"A[9\u000e\u0003-T!\u0001\\7\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00059|\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003A\f1aY8n\u0013\t\u00118NA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0006g&TXm\u001d\t\u0005kv\f\tA\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u00110U\u0001\u0007yI|w\u000e\u001e \n\u0003]K!\u0001 ,\u0002\u000fA\f7m[1hK&\u0011ap \u0002\u0004'\u0016\f(B\u0001?W!\u001d)\u00161AA\u0004\u0003\u000fI1!!\u0002W\u0005\u0019!V\u000f\u001d7feA\u0019Q+!\u0003\n\u0007\u0005-aK\u0001\u0004E_V\u0014G.Z\u0001\u0012q\n+8m[3u\u001bVdG/\u001b9mS\u0016\u0014\u0018!E=Ck\u000e\\W\r^'vYRL\u0007\u000f\\5fe\u00069Q\r\u001f;f]R\u001c\b\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0005O\u0016|WNC\u0002\u0002\u001e5\u000b1A\u001b;t\u0013\u0011\t\t#a\u0006\u0003\u0011\u0015sg/\u001a7pa\u0016\fa\u0001P5oSRtDCCA\u0014\u0003S\tY#!\f\u00020A\u00191\f\u00010\t\u000fM,\u0001\u0013!a\u0001i\"I\u0011QB\u0003\u0011\u0002\u0003\u0007\u0011q\u0001\u0005\n\u0003\u001f)\u0001\u0013!a\u0001\u0003\u000fA\u0011\"!\u0005\u0006!\u0003\u0005\r!a\u0005\u0002\u000bQLWM]:\u0016\u0005\u0005U\u0002CBA\u001c\u0003{\ty$\u0004\u0002\u0002:)\u0019\u00111\b,\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u007f\u0003s\u00012!!\u0011\u0011\u001b\u0005\u0001!\u0001\u0002+jKJ\u001c\"\u0001\u0005+\u0002\u00115\f\u0007pU5{Kb+\"!a\u0002\u0002\u00135\f\u0007pU5{Kb\u0003\u0013\u0001C7bqNK'0Z-\u0002\u00135\f\u0007pU5{Kf\u0003\u0013a\u00022vG.,Go\u001d\t\u0006+\u0006U\u0013\u0011L\u0005\u0004\u0003/2&!B!se\u0006L\b#B+\u0002V\u0005m\u0003cBA/\u0003W\nyGX\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u0015\u0014qM\u0001\u0005kRLGN\u0003\u0002\u0002j\u0005!!.\u0019<b\u0013\u0011\ti'a\u0018\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002r\u0005ed\u0002BA:\u0003k\u0002\"a\u001e,\n\u0007\u0005]d+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003w\niH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003o2\u0016\u0001C4sS\u0012\u001cf.\u00199\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"J\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BAF\u0003\u000b\u0013\u0001b\u0012:jINs\u0017\r\u001d\u000b\u000b\u0003\u007f\ty)!%\u0002\u0014\u0006U\u0005bBA$/\u0001\u0007\u0011q\u0001\u0005\b\u0003\u001b:\u0002\u0019AA\u0004\u0011\u001d\t\tf\u0006a\u0001\u0003'Bq!a \u0018\u0001\u0004\t\t)A\u0003f[B$\u00180\u0006\u0002\u0002\u001cB\u0019Q+!(\n\u0007\u0005}eKA\u0004C_>dW-\u00198\u0002\u0013\u0015l\u0007\u000f^=`I\u0015\fH\u0003BAS\u0003W\u00032!VAT\u0013\r\tIK\u0016\u0002\u0005+:LG\u000fC\u0005\u0002.f\t\t\u00111\u0001\u0002\u001c\u0006\u0019\u0001\u0010J\u0019\u0002\r\u0015l\u0007\u000f^=!Q\rQ\u00121\u0017\t\u0004+\u0006U\u0016bAA\\-\nAao\u001c7bi&dW-\u0001\u0003nCbDVCAA_!\r)\u0016qX\u0005\u0004\u0003\u00034&aA%oi\u0006)Q.\u0019=YA\u0005!Q.\u0019=Z\u0003\u0015i\u0017\r_-!\u0003\u0019\u0011WoY6fiR1\u00111LAg\u0003#Dq!a4 \u0001\u0004\t9!A\u0001y\u0011\u001d\t\u0019n\ba\u0001\u0003\u000f\t\u0011!\u001f\u000b\u0005\u00037\n9\u000eC\u0004\u0002Z\u0002\u0002\r!a\u0005\u0002\u0011\u0015tg/\u001a7pa\u0016\f\u0001\"\u001b;fe\u0006$xN\u001d\u000b\u000b\u0003?\f)/!;\u0002n\u0006E\b\u0003B;\u0002bzK1!a9\u0000\u0005!IE/\u001a:bi>\u0014\bbBAtC\u0001\u0007\u0011qA\u0001\u0005q6Lg\u000eC\u0004\u0002l\u0006\u0002\r!a\u0002\u0002\tel\u0017N\u001c\u0005\b\u0003_\f\u0003\u0019AA\u0004\u0003\u0011AX.\u0019=\t\u000f\u0005M\u0018\u00051\u0001\u0002\b\u0005!\u00110\\1y\u0003\u0011\u0019\u0018N_3\u0015\u0005\u0005u\u0016!B2mK\u0006\u0014HCAAS\u0003\u0015\u0019h.\u00199Y)\u0011\tiL!\u0001\t\u000f\u0005=G\u00051\u0001\u0002\b\u0005)1O\\1q3R!\u0011Q\u0018B\u0004\u0011\u001d\t\u0019.\na\u0001\u0003\u000f\u0011A\u0002V5fe&#XM]1u_J\u001cBA\n+\u0002`RQ!q\u0002B\n\u0005+\u00119B!\u0007\u0011\u0007\tEa%D\u0001\u0011\u0011\u001d\t9o\u000ba\u0001\u0003\u000fAq!a;,\u0001\u0004\t9\u0001C\u0004\u0002p.\u0002\r!a\u0002\t\u000f\u0005M8\u00061\u0001\u0002\b\u0005!Q.\u0019=j\u0003\u0015i\u0017\r_5!\u0003\u0011i\u0017N\u001c6\u0002\u000b5LgN\u001b\u0011\u0002\t5\f\u0007P[\u0001\u0006[\u0006D(\u000eI\u0001\u0002S\u0006)\u0011n\u0018\u0013fcR!\u0011Q\u0015B\u0017\u0011%\tikMA\u0001\u0002\u0004\ti,\u0001\u0002jA\u0005\t!.A\u0003k?\u0012*\u0017\u000f\u0006\u0003\u0002&\n]\u0002\"CAWm\u0005\u0005\t\u0019AA_\u0003\tQ\u0007%\u0001\u0003ji\u0016\u0014XC\u0001B !\u0015\u0011\tEa\u0011_\u001b\t\t\u0019'\u0003\u0003\u0002d\u0006\r\u0014\u0001C5uKJ|F%Z9\u0015\t\u0005\u0015&\u0011\n\u0005\n\u0003[K\u0014\u0011!a\u0001\u0005\u007f\tQ!\u001b;fe\u0002\nq\u0001[1t\u001d\u0016DH\u000fK\u0002<\u0005#\u0002BAa\u0015\u0003Z5\u0011!Q\u000b\u0006\u0004\u0005/2\u0016AC1o]>$\u0018\r^5p]&!!1\fB+\u0005\u001d!\u0018-\u001b7sK\u000e\fAA\\3yiR\ta,\u0001\u0004uS\u0016\u00148\u000fI\u0001\u0007S:\u001cXM\u001d;\u0015\u0011\u0005\u0015&q\rB8\u0005gBq!!\u0007\t\u0001\u0004\u0011I\u0007\u0005\u0003\u0002\u0016\t-\u0014\u0002\u0002B7\u0003/\u0011\u0001bR3p[\u0016$(/\u001f\u0005\b\u0005cB\u0001\u0019AA8\u0003\rYW-\u001f\u0005\u0007\u0005kB\u0001\u0019\u00010\u0002\u000bY\fG.^3\u0002\rI,Wn\u001c<f)\u0015q&1\u0010B?\u0011\u001d\tI\"\u0003a\u0001\u0005SBqA!\u001d\n\u0001\u0004\ty'A\u0002hKR$RA\u0018BB\u0005\u000bCq!!\u0007\u000b\u0001\u0004\u0011I\u0007C\u0004\u0003r)\u0001\r!a\u001c\u0002\u000bE,XM]=\u0015\u0015\u0005}'1\u0012BG\u0005\u001f\u0013\t\nC\u0004\u0002h.\u0001\r!a\u0002\t\u000f\u0005-8\u00021\u0001\u0002\b!9\u0011q^\u0006A\u0002\u0005\u001d\u0001bBAz\u0017\u0001\u0007\u0011q\u0001\u000b\u0003\u0003?\f!b]3mK\u000e$H+[3s)\u0011\tyD!'\t\u000f\u0005ew\u00021\u0001\u0002\u0014\u0005A2+\u001b>f'\u0016\u0004\u0018M]1uK\u0012\u0014UoY6fi&sG-\u001a=\u0011\u0005ms4C\u0001 U)\t\u0011i*\u0001\u0007EK\u001a\fW\u000f\u001c;US\u0016\u00148/F\u0001u\u00035!UMZ1vYR$\u0016.\u001a:tA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*BA!,\u0003@V\u0011!q\u0016\u0016\u0004i\nE6F\u0001BZ!\u0011\u0011)La/\u000e\u0005\t]&\u0002\u0002B]\u0005+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\tu&q\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!B1C\u0005\u0004\u0011\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0003\u0003F\n%WC\u0001BdU\u0011\t9A!-\u0005\u000b\u0005\u001c%\u0019\u00012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011)Ma4\u0005\u000b\u0005$%\u0019\u00012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011)N!7\u0016\u0005\t]'\u0006BA\n\u0005c#Q!Y#C\u0002\t\u0004")
public class SizeSeparatedBucketIndex<T>
implements SpatialIndex<T>,
StrictLogging {
    private final Seq<Tuple2<Object, Object>> sizes;
    private final double xBucketMultiplier;
    private final double yBucketMultiplier;
    public final Envelope org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents;
    private final Seq<Tier> tiers;
    private final Logger logger;

    public static <T> Envelope $lessinit$greater$default$4() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> double $lessinit$greater$default$3() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> double $lessinit$greater$default$2() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> Seq<Tuple2<Object, Object>> $lessinit$greater$default$1() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$1();
    }

    public static Seq<Tuple2<Object, Object>> DefaultTiers() {
        return SizeSeparatedBucketIndex$.MODULE$.DefaultTiers();
    }

    @Override
    public Iterator<T> query(Envelope bbox) {
        return SpatialIndex.query$(this, bbox);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Seq<Tier> tiers() {
        return this.tiers;
    }

    @Override
    public void insert(Geometry geom, String key, T value) {
        Envelope envelope = geom.getEnvelopeInternal();
        Tier tier = this.selectTier(envelope);
        if (tier.empty()) {
            tier.empty_$eq(false);
        }
        tier.bucket(envelope).put(key, value);
    }

    @Override
    public T remove(Geometry geom, String key) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).remove(key);
    }

    @Override
    public T get(Geometry geom, String key) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).get(key);
    }

    @Override
    public Iterator<T> query(double xmin, double ymin, double xmax, double ymax) {
        return this.tiers().iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.iterator(xmin, ymin, xmax, ymax));
    }

    @Override
    public Iterator<T> query() {
        return this.query(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxY());
    }

    @Override
    public int size() {
        IntRef size = IntRef.create((int)0);
        this.tiers().foreach((Function1 & Serializable & scala.Serializable)tier -> {
            SizeSeparatedBucketIndex.$anonfun$size$1(size, tier);
            return BoxedUnit.UNIT;
        });
        return size.elem;
    }

    @Override
    public void clear() {
        this.tiers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.clear();
            return BoxedUnit.UNIT;
        });
    }

    private Tier selectTier(Envelope envelope) {
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        return (Tier)this.tiers().find((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SizeSeparatedBucketIndex.$anonfun$selectTier$1(width, height, t))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new java.lang.StringBuilder(36).append("Envelope ").append(envelope).append(" exceeds the max tier size ").append($this.sizes.last()).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$2(Seq x0$1) {
        double y1;
        double x1;
        Tuple2 tuple2;
        block3: {
            Seq seq;
            block2: {
                seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(0);
                tuple2 = (Tuple2)((SeqLike)some.get()).apply(1);
                if (tuple22 == null) break block2;
                x1 = tuple22._1$mcD$sp();
                y1 = tuple22._2$mcD$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)seq);
        }
        double x2 = tuple2._1$mcD$sp();
        double y2 = tuple2._2$mcD$sp();
        boolean bl = x1 <= x2 && y1 <= y2;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$size$1(IntRef size$1, Tier tier) {
        size$1.elem += tier.size();
    }

    public static final /* synthetic */ boolean $anonfun$selectTier$1(double width$1, double height$1, Tier t) {
        return t.maxSizeX() >= width$1 && t.maxSizeY() >= height$1;
    }

    public SizeSeparatedBucketIndex(Seq<Tuple2<Object, Object>> sizes, double xBucketMultiplier, double yBucketMultiplier, Envelope extents) {
        this.sizes = sizes;
        this.xBucketMultiplier = xBucketMultiplier;
        this.yBucketMultiplier = yBucketMultiplier;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents = extents;
        SpatialIndex.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        Predef$.MODULE$.require(sizes.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No valid tier sizes specified");
        Predef$.MODULE$.require(sizes.lengthCompare(1) == 0 || sizes.sliding(2).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SizeSeparatedBucketIndex.$anonfun$new$2(x0$1))), (Function0 & Serializable & scala.Serializable)() -> "Tiers must be ordered by increasing size");
        this.tiers = (Seq)sizes.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ConcurrentHashMap[][] buckets;
            int ySize;
            int xSize;
            double height;
            double width;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                width = tuple2._1$mcD$sp();
                height = tuple2._2$mcD$sp();
                xSize = (int)scala.math.package$.MODULE$.ceil($this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getWidth() * $this.xBucketMultiplier / width);
                ySize = (int)scala.math.package$.MODULE$.ceil($this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getHeight() * $this.yBucketMultiplier / height);
                buckets = (ConcurrentHashMap[][])Array$.MODULE$.fill(xSize, ySize, (Function0 & Serializable & scala.Serializable)() -> new ConcurrentHashMap(), ClassTag$.MODULE$.apply(ConcurrentHashMap.class));
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Creating tier for size ({} {}) with buckets [{}x{}]", new Object[]{BoxesRunTime.boxToDouble((double)width), BoxesRunTime.boxToDouble((double)height), BoxesRunTime.boxToInteger((int)xSize), BoxesRunTime.boxToInteger((int)ySize)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tier tier = new Tier(this, width, height, buckets, new GridSnap($this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents, xSize, ySize));
            return tier;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private class Tier {
        private final double maxSizeX;
        private final double maxSizeY;
        public final ConcurrentHashMap<String, T>[][] org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets;
        private final GridSnap gridSnap;
        private volatile boolean empty;
        private final int maxX;
        private final int maxY;
        public final /* synthetic */ SizeSeparatedBucketIndex $outer;

        public double maxSizeX() {
            return this.maxSizeX;
        }

        public double maxSizeY() {
            return this.maxSizeY;
        }

        public boolean empty() {
            return this.empty;
        }

        public void empty_$eq(boolean x$1) {
            this.empty = x$1;
        }

        private int maxX() {
            return this.maxX;
        }

        private int maxY() {
            return this.maxY;
        }

        public ConcurrentHashMap<String, T> bucket(double x, double y) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(x)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(y)];
        }

        public ConcurrentHashMap<String, T> bucket(Envelope envelope) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX((envelope.getMinX() + envelope.getMaxX()) / 2.0)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY((envelope.getMinY() + envelope.getMaxY()) / 2.0)];
        }

        public Iterator<T> iterator(double xmin, double ymin, double xmax, double ymax) {
            return this.empty() ? package$.MODULE$.Iterator().empty() : new TierIterator(xmin, ymin, xmax, ymax);
        }

        /*
         * WARNING - void declaration
         */
        public int size() {
            int n;
            if (this.empty()) {
                n = 0;
            } else {
                void var1_1;
                int size = 0;
                for (int i = 0; i <= this.maxX(); ++i) {
                    for (int j = 0; j <= this.maxY(); ++j) {
                        size += this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].size();
                    }
                }
                n = var1_1;
            }
            return n;
        }

        public void clear() {
            for (int i = 0; i <= this.maxX(); ++i) {
                for (int j = 0; j <= this.maxY(); ++j) {
                    this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].clear();
                }
            }
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(double x) {
            int i = this.gridSnap.i(x);
            return i != -1 ? i : (x < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX() ? 0 : this.maxX());
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(double y) {
            int j = this.gridSnap.j(y);
            return j != -1 ? j : (y < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY() ? 0 : this.maxY());
        }

        public /* synthetic */ SizeSeparatedBucketIndex org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer() {
            return this.$outer;
        }

        public Tier(SizeSeparatedBucketIndex $outer, double maxSizeX, double maxSizeY, ConcurrentHashMap<String, T>[][] buckets, GridSnap gridSnap) {
            this.maxSizeX = maxSizeX;
            this.maxSizeY = maxSizeY;
            this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets = buckets;
            this.gridSnap = gridSnap;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.empty = true;
            this.maxX = buckets.length - 1;
            this.maxY = buckets[0].length - 1;
        }

        public class TierIterator
        implements Iterator<T> {
            private final int maxi;
            private final int minj;
            private final int maxj;
            private int i;
            private int j;
            private java.util.Iterator<T> iter;

            public Iterator<T> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return TraversableOnce.min$((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return TraversableOnce.max$((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private int maxi() {
                return this.maxi;
            }

            private int minj() {
                return this.minj;
            }

            private int maxj() {
                return this.maxj;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            private int j() {
                return this.j;
            }

            private void j_$eq(int x$1) {
                this.j = x$1;
            }

            private java.util.Iterator<T> iter() {
                return this.iter;
            }

            private void iter_$eq(java.util.Iterator<T> x$1) {
                this.iter = x$1;
            }

            public final boolean hasNext() {
                boolean bl;
                block5: {
                    block4: {
                        while (!this.iter().hasNext()) {
                            if (this.i() != this.maxi() || this.j() != this.maxj()) {
                                if (this.j() < this.maxj()) {
                                    this.j_$eq(this.j() + 1);
                                } else {
                                    this.j_$eq(this.minj());
                                    this.i_$eq(this.i() + 1);
                                }
                                this.iter_$eq(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator());
                                continue;
                            }
                            if (!false) break block4;
                        }
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                return bl;
            }

            public T next() {
                return this.iter().next();
            }

            public /* synthetic */ Tier org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer() {
                return Tier.this;
            }

            public TierIterator(double xmin, double ymin, double xmax, double ymax) {
                if (Tier.this == null) {
                    throw null;
                }
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.maxi = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmax + Tier.this.maxSizeX());
                this.minj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymin - Tier.this.maxSizeY());
                this.maxj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymax + Tier.this.maxSizeY());
                this.i = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmin - Tier.this.maxSizeX());
                this.j = this.minj();
                this.iter = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator();
            }
        }
    }
}

