/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Date;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class TemporalIndexCheck$
implements LazyLogging {
    public static TemporalIndexCheck$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TemporalIndexCheck$();
    }

    private Logger logger$lzycompute() {
        TemporalIndexCheck$ temporalIndexCheck$ = this;
        synchronized (temporalIndexCheck$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void validateDtgField(SimpleFeatureType sft) {
        block1: {
            Seq<String> dtgCandidates = this.scanForTemporalAttributes(sft);
            if (RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).exists((Function1 & java.io.Serializable & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)dtgCandidates.contains(elem)))) break block1;
            RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).foreach((Function1 & java.io.Serializable & Serializable)dtg -> {
                TemporalIndexCheck$.$anonfun$validateDtgField$2(sft, dtg);
                return BoxedUnit.UNIT;
            });
            if (!GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg())) {
                dtgCandidates.headOption().foreach((Function1 & java.io.Serializable & Serializable)candidate -> {
                    TemporalIndexCheck$.$anonfun$validateDtgField$3(sft, dtgCandidates, candidate);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private Seq<String> scanForTemporalAttributes(SimpleFeatureType sft) {
        return (Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).toList().withFilter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TemporalIndexCheck$.$anonfun$scanForTemporalAttributes$1(x$1))).map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.getLocalName(), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$validateDtgField$2(SimpleFeatureType sft$1, String dtg) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isWarnEnabled()) {
            MODULE$.logger().underlying().warn("Invalid date field '{}' specified for schema {}", new Object[]{dtg, sft$1});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.clearDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1));
    }

    private static final /* synthetic */ String theWarning$lzycompute$1(LazyRef theWarning$lzy$1, SimpleFeatureType sft$1, Seq dtgCandidates$1, String candidate$1) {
        String string;
        LazyRef lazyRef = theWarning$lzy$1;
        synchronized (lazyRef) {
            string = theWarning$lzy$1.initialized() ? (String)theWarning$lzy$1.value() : (String)theWarning$lzy$1.initialize((Object)new StringBuilder(364).append(SimpleFeatureTypes$Configs$.MODULE$.DefaultDtgField()).append(" is not valid or defined for simple feature type ").append(sft$1).append(". ").append("However, the following attribute(s) can be used in GeoMesa's temporal index: ").append(dtgCandidates$1.mkString(", ")).append(". To disable temporal indexing, put Boolean.TRUE into the ").append("SimpleFeatureType user data under the key '").append(SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg()).append("' before calling createSchema, or ").append("set the system property '").append(SimpleFeatureTypes$Configs$.MODULE$.IndexIgnoreDtg()).append("' to 'true'. GeoMesa will now point ").append(SimpleFeatureTypes$Configs$.MODULE$.DefaultDtgField()).append(" ").append("to the first temporal attribute found: ").append(candidate$1).toString());
        }
        return string;
    }

    private static final String theWarning$1(LazyRef theWarning$lzy$1, SimpleFeatureType sft$1, Seq dtgCandidates$1, String candidate$1) {
        return theWarning$lzy$1.initialized() ? (String)theWarning$lzy$1.value() : TemporalIndexCheck$.theWarning$lzycompute$1(theWarning$lzy$1, sft$1, dtgCandidates$1, candidate$1);
    }

    public static final /* synthetic */ void $anonfun$validateDtgField$3(SimpleFeatureType sft$1, Seq dtgCandidates$1, String candidate) {
        BoxedUnit boxedUnit;
        LazyRef theWarning$lzy = new LazyRef();
        if (MODULE$.logger().underlying().isWarnEnabled()) {
            MODULE$.logger().underlying().warn(TemporalIndexCheck$.theWarning$1(theWarning$lzy, sft$1, dtgCandidates$1, candidate));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.setDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1), candidate);
    }

    public static final /* synthetic */ boolean $anonfun$scanForTemporalAttributes$1(AttributeDescriptor x$1) {
        return Date.class.isAssignableFrom(x$1.getType().getBinding());
    }

    private TemporalIndexCheck$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

