/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.io.HadoopUtils;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate;
import org.locationtech.geomesa.utils.io.package$CloseWithLogging$;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HadoopUtils$
implements LazyLogging {
    public static HadoopUtils$ MODULE$;
    private HadoopUtils.TicketLogin krbRenewer;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HadoopUtils$();
    }

    private Logger logger$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private HadoopUtils.TicketLogin krbRenewer() {
        return this.krbRenewer;
    }

    private void krbRenewer_$eq(HadoopUtils.TicketLogin x$1) {
        this.krbRenewer = x$1;
    }

    public void addResource(Configuration conf, String path) {
        FileSystemDelegate delegate = PathUtils$.MODULE$.isRemote(path) ? new HadoopDelegate(conf) : PathUtils$.MODULE$;
        FileSystemDelegate.FileHandle handle = delegate.getHandle(path);
        if (!handle.exists()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Could not load configuration file at: {}", new Object[]{path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            package$WithClose$.MODULE$.apply(handle.open(), (Function1 & Serializable & scala.Serializable)files -> BoxesRunTime.boxToInteger((int)HadoopUtils$.$anonfun$addResource$1(conf, files)), IsCloseable$.MODULE$.closeableIsCloseable());
        }
    }

    public synchronized Closeable kerberosTicketRenewer() {
        if (this.krbRenewer() == null) {
            this.krbRenewer_$eq(new HadoopUtils.TicketLogin());
        }
        HadoopUtils.TicketLogin ticketLogin = this.krbRenewer();
        ticketLogin.registrations_$eq(ticketLogin.registrations() + 1);
        return new HadoopUtils.KrbRegistration();
    }

    public synchronized void org$locationtech$geomesa$utils$io$HadoopUtils$$deregister() {
        block0: {
            HadoopUtils.TicketLogin ticketLogin = this.krbRenewer();
            ticketLogin.registrations_$eq(ticketLogin.registrations() - 1);
            if (this.krbRenewer().registrations() != 0) break block0;
            package$CloseWithLogging$.MODULE$.apply(this.krbRenewer(), IsCloseable$.MODULE$.closeableIsCloseable());
            this.krbRenewer_$eq(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$addResource$2(Configuration conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            InputStream is = (InputStream)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                conf$1.addResource(is);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        InputStream is = (InputStream)tuple2._2();
        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
        Some some = (Some)option;
        String name = (String)some.value();
        conf$1.addResource(is, name);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$addResource$1(Configuration conf$1, CloseableIterator files) {
        files.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HadoopUtils$.$anonfun$addResource$2(conf$1, x0$1);
            return BoxedUnit.UNIT;
        });
        return conf$1.size();
    }

    private HadoopUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

