/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io.fs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$CreateMode$;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate$;
import org.locationtech.geomesa.utils.io.fs.package;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0013'\u0001MB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019\t\u0006\u0001)A\u0005\u001d\")!\u000b\u0001C!'\")A\u000f\u0001C!k\u001e9\u0011\u0011\u0001\u0014\t\u0002\u0005\raAB\u0013'\u0011\u0003\t)\u0001\u0003\u0004I\u0011\u0011\u0005\u0011q\u0001\u0005\n\u0003\u0013A!\u0019!C\u0005\u0003\u0017A\u0001\"!\t\tA\u0003%\u0011Q\u0002\u0005\n\u0003GA!\u0019!C\u0001\u0003KA\u0001\"!\r\tA\u0003%\u0011q\u0005\u0004\u0007\u0003gA\u0001!!\u000e\t\u0015\u0005]bB!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002@9\u0011\t\u0011)A\u0005\u0003\u0003Ba\u0001\u0013\b\u0005\u0002\u0005\u001d\u0003BB6\u000f\t\u0003\n\t\u0006\u0003\u0004\u0002T9!\t%\u0014\u0005\b\u0003+rA\u0011IA,\u0011\u001d\tyF\u0004C!\u0003CBq!!#\u000f\t\u0003\nY\tC\u0004\u0002\":!\t%a)\u0007\r\u00055\u0006\u0002AAX\u0011)\t9\u0004\u0007B\u0001B\u0003%\u0011\u0011\b\u0005\u000b\u0003\u007fA\"\u0011!Q\u0001\n\u0005\u0005\u0003B\u0002%\u0019\t\u0003\t\t\fC\u0004\u0002`a!\t%!\u0019\t\u000f\u0005%\u0005\u0004\"\u0011\u0002:\u001a1\u0011q\u0018\u0005\u0001\u0003\u0003D!\"a\u000e\u001f\u0005\u0003\u0005\u000b\u0011BA\u001d\u0011)\tyD\bB\u0001B\u0003%\u0011\u0011\t\u0005\u0007\u0011z!\t!a1\t\u000f\u0005}c\u0004\"\u0011\u0002b!9\u0011\u0011\u0012\u0010\u0005B\u0005-\u0007\"CAi\u0011E\u0005I\u0011AAj\u00059A\u0015\rZ8pa\u0012+G.Z4bi\u0016T!a\n\u0015\u0002\u0005\u0019\u001c(BA\u0015+\u0003\tIwN\u0003\u0002,Y\u0005)Q\u000f^5mg*\u0011QFL\u0001\bO\u0016|W.Z:b\u0015\ty\u0003'\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u00012\u0003\ry'oZ\u0002\u0001'\r\u0001AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005mbT\"\u0001\u0014\n\u0005u2#A\u0005$jY\u0016\u001c\u0016p\u001d;f[\u0012+G.Z4bi\u0016\fAaY8oMB\u0011\u0001IR\u0007\u0002\u0003*\u0011aH\u0011\u0006\u0003\u0007\u0012\u000ba\u0001[1e_>\u0004(BA#1\u0003\u0019\t\u0007/Y2iK&\u0011q)\u0011\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\tQ5\n\u0005\u0002<\u0001!9aH\u0001I\u0001\u0002\u0004y\u0014!\u0003:fGV\u00148/\u001b<f+\u0005q\u0005CA\u001bP\u0013\t\u0001fGA\u0004C_>dW-\u00198\u0002\u0015I,7-\u001e:tSZ,\u0007%A\u0005hKRD\u0015M\u001c3mKR\u0011AK\u001b\t\u0003+\u001et!AV3\u000f\u0005]#gB\u0001-d\u001d\tI&M\u0004\u0002[C:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=J\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0005=\u0002\u0014BA\u0017/\u0013\tYC&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003M\u001a\n!CR5mKNK8\u000f^3n\t\u0016dWmZ1uK&\u0011\u0001.\u001b\u0002\u000b\r&dW\rS1oI2,'B\u00014'\u0011\u0015YW\u00011\u0001m\u0003\u0011\u0001\u0018\r\u001e5\u0011\u00055\fhB\u00018p!\taf'\u0003\u0002qm\u00051\u0001K]3eK\u001aL!A]:\u0003\rM#(/\u001b8h\u0015\t\u0001h'A\u0007j]R,'\u000f\u001d:fiB\u000bG\u000f\u001b\u000b\u0003m~\u00042a\u001e?U\u001d\tA(P\u0004\u0002]s&\tq'\u0003\u0002|m\u00059\u0001/Y2lC\u001e,\u0017BA?\u007f\u0005\r\u0019V-\u001d\u0006\u0003wZBQa\u001b\u0004A\u00021\fa\u0002S1e_>\u0004H)\u001a7fO\u0006$X\r\u0005\u0002<\u0011M\u0011\u0001\u0002\u000e\u000b\u0003\u0003\u0007\tqAZ1di>\u0014\u00180\u0006\u0002\u0002\u000eA!\u0011qBA\u000f\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011!C1sG\"Lg/\u001a:t\u0015\u0011\t9\"!\u0007\u0002\u0011\r|W\u000e\u001d:fgNT1!a\u0007E\u0003\u001d\u0019w.\\7p]NLA!a\b\u0002\u0012\t!\u0012I]2iSZ,7\u000b\u001e:fC64\u0015m\u0019;pef\f\u0001BZ1di>\u0014\u0018\u0010I\u0001\u0011\u0011&$G-\u001a8GS2,g)\u001b7uKJ,\"!a\n\u0011\t\u0005%\u0012QF\u0007\u0003\u0003WQ!a\n\"\n\t\u0005=\u00121\u0006\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\u0018!\u0005%jI\u0012,gNR5mK\u001aKG\u000e^3sA\t\u0001\u0002*\u00193p_B4\u0015\u000e\\3IC:$G.Z\n\u0004\u001dQ\"\u0016A\u00014d!\u0011\tI#a\u000f\n\t\u0005u\u00121\u0006\u0002\f\r&dWmQ8oi\u0016DH/\u0001\u0003gS2,\u0007\u0003BA\u0015\u0003\u0007JA!!\u0012\u0002,\t!\u0001+\u0019;i)\u0019\tI%!\u0014\u0002PA\u0019\u00111\n\b\u000e\u0003!Aq!a\u000e\u0012\u0001\u0004\tI\u0004C\u0004\u0002@E\u0001\r!!\u0011\u0016\u00031\fa!\u001a=jgR\u001c\u0018A\u00027f]\u001e$\b.\u0006\u0002\u0002ZA\u0019Q'a\u0017\n\u0007\u0005ucG\u0001\u0003M_:<\u0017\u0001B8qK:,\"!a\u0019\u0011\r\u0005\u0015\u00141NA8\u001b\t\t9GC\u0002\u0002j)\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti'a\u001a\u0003#\rcwn]3bE2,\u0017\n^3sCR|'\u000fE\u00046\u0003c\n)(a\u001f\n\u0007\u0005MdG\u0001\u0004UkBdWM\r\t\u0005k\u0005]D.C\u0002\u0002zY\u0012aa\u00149uS>t\u0007\u0003BA?\u0003\u000bk!!a \u000b\u0007%\n\tI\u0003\u0002\u0002\u0004\u0006!!.\u0019<b\u0013\u0011\t9)a \u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0006oJLG/\u001a\u000b\u0007\u0003\u001b\u000b\u0019*!(\u0011\t\u0005u\u0014qR\u0005\u0005\u0003#\u000byH\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002\u0016Z\u0001\r!a&\u0002\t5|G-\u001a\t\u0004+\u0006e\u0015bAANS\nQ1I]3bi\u0016lu\u000eZ3\t\u0011\u0005}e\u0003%AA\u00029\u000bQb\u0019:fCR,\u0007+\u0019:f]R\u001c\u0018A\u00023fY\u0016$X\r\u0006\u0003\u0002&\u0006-\u0006cA\u001b\u0002(&\u0019\u0011\u0011\u0016\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u0019^\u0001\n\u00111\u0001O\u0005=A\u0015\rZ8pajK\u0007\u000fS1oI2,7c\u0001\r\u0002JQ1\u00111WA[\u0003o\u00032!a\u0013\u0019\u0011\u001d\t9d\u0007a\u0001\u0003sAq!a\u0010\u001c\u0001\u0004\t\t\u0005\u0006\u0004\u0002\u000e\u0006m\u0016Q\u0018\u0005\b\u0003+k\u0002\u0019AAL\u0011!\ty*\bI\u0001\u0002\u0004q%a\u0004%bI>|\u0007\u000fV1s\u0011\u0006tG\r\\3\u0014\u0007y\tI\u0005\u0006\u0004\u0002F\u0006\u001d\u0017\u0011\u001a\t\u0004\u0003\u0017r\u0002bBA\u001cC\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u007f\t\u0003\u0019AA!)\u0019\ti)!4\u0002P\"9\u0011QS\u0012A\u0002\u0005]\u0005\u0002CAPGA\u0005\t\u0019\u0001(\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t)NK\u0002@\u0003/\\#!!7\u0011\t\u0005m\u0017Q]\u0007\u0003\u0003;TA!a8\u0002b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G4\u0014AC1o]>$\u0018\r^5p]&!\u0011q]Ao\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class HadoopDelegate
implements FileSystemDelegate {
    private final Configuration conf;
    private final boolean recursive;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static Configuration $lessinit$greater$default$1() {
        return HadoopDelegate$.MODULE$.$lessinit$greater$default$1();
    }

    public static PathFilter HiddenFileFilter() {
        return HadoopDelegate$.MODULE$.HiddenFileFilter();
    }

    private Logger logger$lzycompute() {
        HadoopDelegate hadoopDelegate = this;
        synchronized (hadoopDelegate) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private boolean recursive() {
        return this.recursive;
    }

    @Override
    public FileSystemDelegate.FileHandle getHandle(String path) {
        boolean bl;
        Path p = new Path(path);
        FileContext fc = FileContext.getFileContext((URI)p.toUri(), (Configuration)this.conf);
        String string = PathUtils$.MODULE$.getUncompressedExtension(p.getName()).toLowerCase(Locale.US);
        HadoopFileHandle hadoopFileHandle = "tar".equals(string) ? new HadoopTarHandle(fc, p) : ((bl = "zip".equals(string) ? true : "jar".equals(string)) ? new HadoopZipHandle(fc, p) : new HadoopFileHandle(fc, p));
        return hadoopFileHandle;
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Path p = new Path(path);
        FileContext fc = FileContext.getFileContext((URI)p.toUri(), (Configuration)this.conf);
        FileStatus[] files = fc.util().globStatus(p, HadoopDelegate$.MODULE$.HiddenFileFilter());
        if (files == null) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(27).append("Input path does not exist: ").append(path).toString());
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).isEmpty()) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(37).append("Input path does not match any files: ").append(path).toString());
        }
        Queue remaining = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])files));
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (remaining.nonEmpty()) {
            ListBuffer listBuffer;
            BoxedUnit boxedUnit;
            FileStatus file = (FileStatus)remaining.dequeue();
            if (file.isDirectory()) {
                if (this.recursive()) {
                    RemoteIterator children = fc.listLocatedStatus(file.getPath());
                    Iterator<LocatedFileStatus> iter = new Iterator<LocatedFileStatus>(null, children){
                        private final RemoteIterator children$1;

                        public Iterator<LocatedFileStatus> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<LocatedFileStatus> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<LocatedFileStatus, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<LocatedFileStatus, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<LocatedFileStatus> filter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<LocatedFileStatus, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<LocatedFileStatus> withFilter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> filterNot(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<LocatedFileStatus, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<LocatedFileStatus> takeWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> partition(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> span(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> dropWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<LocatedFileStatus, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<LocatedFileStatus, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<LocatedFileStatus, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<LocatedFileStatus> find(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<LocatedFileStatus> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<LocatedFileStatus> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<LocatedFileStatus> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<LocatedFileStatus> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<LocatedFileStatus, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<LocatedFileStatus, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, LocatedFileStatus, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<LocatedFileStatus, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, LocatedFileStatus, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<LocatedFileStatus> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<LocatedFileStatus> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<LocatedFileStatus> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<LocatedFileStatus> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<LocatedFileStatus> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, LocatedFileStatus, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<LocatedFileStatus, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public boolean hasNext() {
                            return this.children$1.hasNext();
                        }

                        public LocatedFileStatus next() {
                            return (LocatedFileStatus)this.children$1.next();
                        }
                        {
                            this.children$1 = children$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    };
                    boxedUnit = remaining.$plus$plus$eq((TraversableOnce)iter.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegate.$anonfun$interpretPath$1(f))));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            String string = PathUtils$.MODULE$.getUncompressedExtension(file.getPath().getName()).toLowerCase(Locale.US);
            if ("tar".equals(string)) {
                listBuffer = result.$plus$eq((Object)new HadoopTarHandle(fc, file.getPath()));
            } else {
                boolean bl = "zip".equals(string) ? true : "jar".equals(string);
                listBuffer = bl ? result.$plus$eq((Object)new HadoopZipHandle(fc, file.getPath())) : result.$plus$eq((Object)new HadoopFileHandle(fc, file.getPath()));
            }
            boxedUnit = listBuffer;
        }
        return result.result();
    }

    public static final /* synthetic */ boolean $anonfun$interpretPath$1(LocatedFileStatus f) {
        return HadoopDelegate$.MODULE$.HiddenFileFilter().accept(f.getPath());
    }

    public HadoopDelegate(Configuration conf) {
        this.conf = conf;
        LazyLogging.$init$((LazyLogging)this);
        this.recursive = conf.getBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
    }

    public static class HadoopFileHandle
    implements FileSystemDelegate.FileHandle {
        private final FileContext fc;
        private final Path file;
        private String format;
        private volatile boolean bitmap$0;

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate.FileHandle.write$default$2$(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate.FileHandle.delete$default$1$(this);
        }

        private String format$lzycompute() {
            HadoopFileHandle hadoopFileHandle = this;
            synchronized (hadoopFileHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate.FileHandle.format$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.format;
        }

        @Override
        public String format() {
            return !this.bitmap$0 ? this.format$lzycompute() : this.format;
        }

        @Override
        public String path() {
            return this.file.toString();
        }

        @Override
        public boolean exists() {
            return this.fc.util().exists(this.file);
        }

        @Override
        public long length() {
            return this.exists() ? this.fc.getFileStatus(this.file).getLen() : 0L;
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream is = PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName());
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)is), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> is.close());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            FileSystemDelegate$CreateMode$.MODULE$.validate$extension(mode);
            EnumSet<CreateFlag> flags = EnumSet.noneOf(CreateFlag.class);
            Boolean bl = FileSystemDelegate$CreateMode$.MODULE$.append$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.APPEND)) : (FileSystemDelegate$CreateMode$.MODULE$.overwrite$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.OVERWRITE)) : BoxedUnit.UNIT);
            Object object = FileSystemDelegate$CreateMode$.MODULE$.create$extension(mode) ? BoxesRunTime.boxToBoolean((boolean)flags.add(CreateFlag.CREATE)) : BoxedUnit.UNIT;
            Options.CreateOpts.CreateParent ops = createParents ? Options.CreateOpts.createParent() : Options.CreateOpts.donotCreateParent();
            return this.fc.create(this.file, flags, new Options.CreateOpts[]{ops});
        }

        @Override
        public void delete(boolean recursive) {
            if (!this.fc.delete(this.file, recursive)) {
                throw new IOException(new java.lang.StringBuilder(23).append("Could not delete file: ").append(this.path()).toString());
            }
        }

        public HadoopFileHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            FileSystemDelegate.FileHandle.$init$(this);
        }
    }

    public static class HadoopTarHandle
    extends HadoopFileHandle {
        private final FileContext fc;
        private final Path file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream uncompressed = PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName());
            ArchiveInputStream archive = HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$HadoopDelegate$$factory().createArchiveInputStream("tar", uncompressed);
            return new package.ArchiveFileIterator(archive, this.file.toString());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$HadoopDelegate$$factory().createArchiveOutputStream("tar", super.write(mode, createParents));
        }

        public HadoopTarHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            super(fc, file);
        }
    }

    public static class HadoopZipHandle
    extends HadoopFileHandle {
        private final FileContext fc;
        private final Path file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            byte[] bytes2 = (byte[])package$WithClose$.MODULE$.apply(PathUtils$.MODULE$.handleCompression((InputStream)this.fc.open(this.file), this.file.getName()), (Function1 & Serializable & scala.Serializable)is -> IOUtils.toByteArray((InputStream)is), IsCloseable$.MODULE$.closeableIsCloseable());
            return new package.ZipFileIterator(new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(bytes2)), this.file.toString());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return HadoopDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$HadoopDelegate$$factory().createArchiveOutputStream("zip", super.write(mode, createParents));
        }

        public HadoopZipHandle(FileContext fc, Path file) {
            this.fc = fc;
            this.file = file;
            super(fc, file);
        }
    }
}

