/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io.fs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate$CreateMode$;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate$;
import org.locationtech.geomesa.utils.io.fs.package;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0016,\u0001aBQ!\u0014\u0001\u0005\u00029CQ\u0001\u0015\u0001\u0005BECQA\u001d\u0001\u0005BMDQA \u0001\u0005\n}<q!a\u0005,\u0011\u0003\t)B\u0002\u0004+W!\u0005\u0011q\u0003\u0005\u0007\u001b\u001a!\t!!\u0007\t\u0013\u0005maA1A\u0005\n\u0005u\u0001\u0002CA\u001c\r\u0001\u0006I!a\b\u0007\r\u0005eb\u0001AA\u001e\u0011)\t\u0019A\u0003B\u0001B\u0003%\u0011Q\u0001\u0005\u0007\u001b*!\t!!\u0010\t\r%TA\u0011IA#\u0011\u001d\t9E\u0003C!\u0003\u0013Bq!!\u0015\u000b\t\u0003\n\u0019\u0006C\u0004\u0002\\)!\t%!\u0018\t\u000f\u0005u$\u0002\"\u0011\u0002\u0000!9\u0011Q\u0013\u0006\u0005B\u0005]eABAR\r\u0001\t)\u000b\u0003\u0006\u0002\u0004M\u0011\t\u0011)A\u0005\u0003\u000bAa!T\n\u0005\u0002\u0005\u001d\u0006bBA.'\u0011\u0005\u0013Q\f\u0005\b\u0003{\u001aB\u0011IAW\r\u0019\t\u0019L\u0002\u0001\u00026\"Q\u00111\u0001\r\u0003\u0002\u0003\u0006I!!\u0002\t\r5CB\u0011AA\\\u0011\u001d\tY\u0006\u0007C!\u0003;Bq!! \u0019\t\u0003\niL\u0002\u0004\u0002D\u001a\u0001\u0011Q\u0019\u0005\u0007\u001bv!\t!a2\t\r%lB\u0011IA#\u0011\u001d\t9%\bC!\u0003\u0013Bq!!\u0015\u001e\t\u0003\n\u0019\u0006C\u0004\u0002\\u!\t%!\u0018\t\u000f\u0005uT\u0004\"\u0011\u0002L\"9\u0011QS\u000f\u0005B\u0005EwaBAl\r!\u0005\u0011\u0011\u001c\u0004\b\u0003\u00074\u0001\u0012AAn\u0011\u0019ie\u0005\"\u0001\u0002^\"9\u0011q\u001c\u0014\u0005\u0002\u0005\u0005\bbBAsM\u0011\u0005\u0011\u0011\n\u0002\u000e\u0019>\u001c\u0017\r\u001c#fY\u0016<\u0017\r^3\u000b\u00051j\u0013A\u00014t\u0015\tqs&\u0001\u0002j_*\u0011\u0001'M\u0001\u0006kRLGn\u001d\u0006\u0003eM\nqaZ3p[\u0016\u001c\u0018M\u0003\u00025k\u0005aAn\\2bi&|g\u000e^3dQ*\ta'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001s}\u001a\u0005C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$AB!osJ+g\r\u0005\u0002A\u00036\t1&\u0003\u0002CW\t\u0011b)\u001b7f'f\u001cH/Z7EK2,w-\u0019;f!\t!5*D\u0001F\u0015\t1u)\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002I\u0013\u0006AA/\u001f9fg\u00064WMC\u0001K\u0003\r\u0019w.\\\u0005\u0003\u0019\u0016\u00131\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\u0014\t\u0003\u0001\u0002\t\u0011bZ3u\u0011\u0006tG\r\\3\u0015\u0005IC\u0007CA*f\u001d\t!6M\u0004\u0002VE:\u0011a+\u0019\b\u0003/\u0002t!\u0001W0\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/8\u0003\u0019a$o\\8u}%\ta'\u0003\u00025k%\u0011!gM\u0005\u0003aEJ!AL\u0018\n\u00051j\u0013B\u00013,\u0003I1\u0015\u000e\\3TsN$X-\u001c#fY\u0016<\u0017\r^3\n\u0005\u0019<'A\u0003$jY\u0016D\u0015M\u001c3mK*\u0011Am\u000b\u0005\u0006S\n\u0001\rA[\u0001\u0005a\u0006$\b\u000e\u0005\u0002l_:\u0011A.\u001c\t\u00035nJ!A\\\u001e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]n\nQ\"\u001b8uKJ\u0004(/\u001a;QCRDGC\u0001;~!\r)(P\u0015\b\u0003mbt!AW<\n\u0003qJ!!_\u001e\u0002\u000fA\f7m[1hK&\u00111\u0010 \u0002\u0004'\u0016\f(BA=<\u0011\u0015I7\u00011\u0001k\u00031\u0019'/Z1uK\"\u000bg\u000e\u001a7f)\r\u0011\u0016\u0011\u0001\u0005\b\u0003\u0007!\u0001\u0019AA\u0003\u0003\u00111\u0017\u000e\\3\u0011\t\u0005\u001d\u0011qB\u0007\u0003\u0003\u0013Q1ALA\u0006\u0015\t\ti!\u0001\u0003kCZ\f\u0017\u0002BA\t\u0003\u0013\u0011AAR5mK\u0006iAj\\2bY\u0012+G.Z4bi\u0016\u0004\"\u0001\u0011\u0004\u0014\u0005\u0019IDCAA\u000b\u0003\u001d1\u0017m\u0019;pef,\"!a\b\u0011\t\u0005\u0005\u00121G\u0007\u0003\u0003GQA!!\n\u0002(\u0005I\u0011M]2iSZ,'o\u001d\u0006\u0005\u0003S\tY#\u0001\u0005d_6\u0004(/Z:t\u0015\u0011\ti#a\f\u0002\u000f\r|W.\\8og*\u0019\u0011\u0011G\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t)$a\t\u0003)\u0005\u00138\r[5wKN#(/Z1n\r\u0006\u001cGo\u001c:z\u0003!1\u0017m\u0019;pef\u0004#a\u0004'pG\u0006dg)\u001b7f\u0011\u0006tG\r\\3\u0014\u0007)I$\u000b\u0006\u0003\u0002@\u0005\r\u0003cAA!\u00155\ta\u0001C\u0004\u0002\u00041\u0001\r!!\u0002\u0016\u0003)\fa!\u001a=jgR\u001cXCAA&!\rQ\u0014QJ\u0005\u0004\u0003\u001fZ$a\u0002\"p_2,\u0017M\\\u0001\u0007Y\u0016tw\r\u001e5\u0016\u0005\u0005U\u0003c\u0001\u001e\u0002X%\u0019\u0011\u0011L\u001e\u0003\t1{gnZ\u0001\u0005_B,g.\u0006\u0002\u0002`A1\u0011\u0011MA4\u0003Wj!!a\u0019\u000b\u0007\u0005\u0015t&\u0001\u0006d_2dWm\u0019;j_:LA!!\u001b\u0002d\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u000fi\ni'!\u001d\u0002x%\u0019\u0011qN\u001e\u0003\rQ+\b\u000f\\33!\u0011Q\u00141\u000f6\n\u0007\u0005U4H\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000f\tI(\u0003\u0003\u0002|\u0005%!aC%oaV$8\u000b\u001e:fC6\fQa\u001e:ji\u0016$b!!!\u0002\b\u0006E\u0005\u0003BA\u0004\u0003\u0007KA!!\"\u0002\n\taq*\u001e;qkR\u001cFO]3b[\"9\u0011\u0011R\tA\u0002\u0005-\u0015\u0001B7pI\u0016\u00042aUAG\u0013\r\tyi\u001a\u0002\u000b\u0007J,\u0017\r^3N_\u0012,\u0007\"CAJ#A\u0005\t\u0019AA&\u00035\u0019'/Z1uKB\u000b'/\u001a8ug\u00061A-\u001a7fi\u0016$B!!'\u0002 B\u0019!(a'\n\u0007\u0005u5H\u0001\u0003V]&$\b\"CAQ%A\u0005\t\u0019AA&\u0003%\u0011XmY;sg&4XM\u0001\bM_\u000e\fGNW5q\u0011\u0006tG\r\\3\u0014\u0007M\ty\u0004\u0006\u0003\u0002*\u0006-\u0006cAA!'!9\u00111A\u000bA\u0002\u0005\u0015ACBAA\u0003_\u000b\t\fC\u0004\u0002\n^\u0001\r!a#\t\u0013\u0005Mu\u0003%AA\u0002\u0005-#A\u0004'pG\u0006dG+\u0019:IC:$G.Z\n\u00041\u0005}B\u0003BA]\u0003w\u00032!!\u0011\u0019\u0011\u001d\t\u0019A\u0007a\u0001\u0003\u000b!b!!!\u0002@\u0006\u0005\u0007bBAE9\u0001\u0007\u00111\u0012\u0005\n\u0003'c\u0002\u0013!a\u0001\u0003\u0017\u00121b\u0015;e\u0013:D\u0015M\u001c3mKN\u0019Q$\u000f*\u0015\u0005\u0005%\u0007cAA!;Q1\u0011\u0011QAg\u0003\u001fDq!!#$\u0001\u0004\tY\tC\u0005\u0002\u0014\u000e\u0002\n\u00111\u0001\u0002LQ!\u0011\u0011TAj\u0011%\t)\u000e\nI\u0001\u0002\u0004\tY%\u0001\u0005sK\u000e,8/\u001b<f\u0003-\u0019F\u000fZ%o\u0011\u0006tG\r\\3\u0011\u0007\u0005\u0005ce\u0005\u0002'sQ\u0011\u0011\u0011\\\u0001\nCZ\f\u0017\u000e\\1cY\u0016$\"!a9\u0011\ti\n\u0019HU\u0001\fSN\fe/Y5mC\ndW\r")
public class LocalDelegate
implements FileSystemDelegate {
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LocalDelegate localDelegate = this;
        synchronized (localDelegate) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public FileSystemDelegate.FileHandle getHandle(String path) {
        return this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(new File(path));
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Seq seq;
        int firstWildcard = path.indexOf(42);
        if (firstWildcard == -1) {
            File file = new File(path);
            if (file.isDirectory()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Input file is a directory: {}", new Object[]{file.getAbsolutePath()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                seq = (Seq)Nil$.MODULE$;
            } else {
                seq = (Seq)new .colon.colon((Object)this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file), (List)Nil$.MODULE$);
            }
        } else {
            Tuple2 tuple2;
            int lastSep = path.length() - 1 - ((String)new StringOps(Predef$.MODULE$.augmentString(path)).reverse()).indexOf(47, path.length() - firstWildcard - 1);
            Tuple2 tuple22 = tuple2 = lastSep == path.length() ? new Tuple2((Object)new File(".").toPath(), (Object)path) : new Tuple2((Object)new File(path.substring(0, lastSep)).toPath(), (Object)path.substring(lastSep + 1));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path basepath = (Path)tuple2._1();
            String glob = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)basepath, (Object)glob);
            Tuple2 tuple24 = tuple23;
            Path basepath2 = (Path)tuple24._1();
            String glob2 = (String)tuple24._2();
            if (glob2.indexOf(47) == -1 && !glob2.contains("**")) {
                seq = (Seq)package$WithClose$.MODULE$.apply(Files.newDirectoryStream(basepath2, glob2), (Function1 & Serializable & scala.Serializable)stream -> (Seq)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)stream).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)p -> {
                    File file = p.toFile();
                    return file.isDirectory() ? Nil$.MODULE$ : new .colon.colon((Object)this.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file), (List)Nil$.MODULE$);
                }, List$.MODULE$.canBuildFrom()), IsCloseable$.MODULE$.closeableIsCloseable());
            } else {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher(new StringBuilder(5).append("glob:").append(glob2).toString());
                ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this, matcher, result){
                    private final /* synthetic */ LocalDelegate $outer;
                    private final PathMatcher matcher$1;
                    private final ArrayBuffer result$1;

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                        Object object = this.matcher$1.matches(file) && attributes.isRegularFile() && !attributes.isDirectory() ? this.result$1.$plus$eq((Object)this.$outer.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(file.toFile())) : BoxedUnit.UNIT;
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.matcher$1 = matcher$1;
                        this.result$1 = result$1;
                    }
                };
                Files.walkFileTree(basepath2, (FileVisitor<? super Path>)visitor);
                seq = result.toSeq();
            }
        }
        return seq;
    }

    public FileSystemDelegate.FileHandle org$locationtech$geomesa$utils$io$fs$LocalDelegate$$createHandle(File file) {
        boolean bl;
        String string = PathUtils$.MODULE$.getUncompressedExtension(file.getName()).toLowerCase(Locale.US);
        LocalFileHandle localFileHandle = "tar".equals(string) ? new LocalTarHandle(file) : ((bl = "zip".equals(string) ? true : "jar".equals(string)) ? new LocalZipHandle(file) : new LocalFileHandle(file));
        return localFileHandle;
    }

    public LocalDelegate() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class LocalFileHandle
    implements FileSystemDelegate.FileHandle {
        private final File file;
        private String format;
        private volatile boolean bitmap$0;

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate.FileHandle.write$default$2$(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate.FileHandle.delete$default$1$(this);
        }

        private String format$lzycompute() {
            LocalFileHandle localFileHandle = this;
            synchronized (localFileHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate.FileHandle.format$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.format;
        }

        @Override
        public String format() {
            return !this.bitmap$0 ? this.format$lzycompute() : this.format;
        }

        @Override
        public String path() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream is = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)is), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> is.close());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public OutputStream write(int mode, boolean createParents) {
            FileOutputStream fileOutputStream;
            FileSystemDelegate$CreateMode$.MODULE$.validate$extension(mode);
            if (this.file.exists()) {
                if (FileSystemDelegate$CreateMode$.MODULE$.append$extension(mode)) {
                    fileOutputStream = new FileOutputStream(this.file, true);
                    return fileOutputStream;
                } else {
                    if (!FileSystemDelegate$CreateMode$.MODULE$.overwrite$extension(mode)) throw new FileAlreadyExistsException(new StringBuilder(39).append("File already exists for mode 'create': ").append(this.path()).toString());
                    fileOutputStream = new FileOutputStream(this.file, false);
                }
                return fileOutputStream;
            } else {
                if (!FileSystemDelegate$CreateMode$.MODULE$.create$extension(mode)) {
                    throw new FileNotFoundException(new StringBuilder(21).append("File does not exist: ").append(this.path()).toString());
                }
                File parent = this.file.getParentFile();
                if (parent != null && !parent.exists()) {
                    if (!createParents) {
                        throw new FileNotFoundException(new StringBuilder(28).append("Parent file does not exist: ").append(this.path()).toString());
                    }
                    if (!parent.mkdirs()) {
                        throw new IOException(new StringBuilder(53).append("Parent file does not exist and could not be created: ").append(this.path()).toString());
                    }
                }
                fileOutputStream = new FileOutputStream(this.file);
            }
            return fileOutputStream;
        }

        @Override
        public void delete(boolean recursive) {
            if (recursive) {
                PathUtils$.MODULE$.deleteRecursively(this.file.toPath());
            } else if (!this.file.delete()) {
                throw new IOException(new StringBuilder(23).append("Could not delete file: ").append(this.path()).toString());
            }
        }

        public LocalFileHandle(File file) {
            this.file = file;
            FileSystemDelegate.FileHandle.$init$(this);
        }
    }

    public static class LocalTarHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            InputStream uncompressed = PathUtils$.MODULE$.handleCompression(new FileInputStream(this.file), this.file.getName());
            ArchiveInputStream archive = LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveInputStream("tar", uncompressed);
            return new package.ArchiveFileIterator(archive, this.file.getAbsolutePath());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveOutputStream("tar", super.write(mode, createParents));
        }

        public LocalTarHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class LocalZipHandle
    extends LocalFileHandle {
        private final File file;

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return new package.ZipFileIterator(new ZipFile(this.file), this.file.getAbsolutePath());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return LocalDelegate$.MODULE$.org$locationtech$geomesa$utils$io$fs$LocalDelegate$$factory().createArchiveOutputStream("zip", super.write(mode, createParents));
        }

        public LocalZipHandle(File file) {
            this.file = file;
            super(file);
        }
    }

    public static class StdInHandle
    implements FileSystemDelegate.FileHandle {
        private String format;
        private volatile boolean bitmap$0;

        @Override
        public boolean write$default$2() {
            return FileSystemDelegate.FileHandle.write$default$2$(this);
        }

        @Override
        public boolean delete$default$1() {
            return FileSystemDelegate.FileHandle.delete$default$1$(this);
        }

        private String format$lzycompute() {
            StdInHandle stdInHandle = this;
            synchronized (stdInHandle) {
                if (!this.bitmap$0) {
                    this.format = FileSystemDelegate.FileHandle.format$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.format;
        }

        @Override
        public String format() {
            return !this.bitmap$0 ? this.format$lzycompute() : this.format;
        }

        @Override
        public String path() {
            return "<stdin>";
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public long length() {
            return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.in.available()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        }

        @Override
        public CloseableIterator<Tuple2<Option<String>, InputStream>> open() {
            return CloseableIterator$.MODULE$.single(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)System.in), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.single$default$2());
        }

        @Override
        public OutputStream write(int mode, boolean createParents) {
            return System.out;
        }

        @Override
        public void delete(boolean recusive) {
        }

        public StdInHandle() {
            FileSystemDelegate.FileHandle.$init$(this);
        }
    }
}

