/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.iterators;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.iterators.PlaybackIterator$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.temporal.During;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u001e=\u0001\u001dC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"AQ\u0010\u0001B\u0001B\u0003%a\u0010\u0003\u0006\u0002\u0014\u0001\u0011\t\u0011)A\u0005\u0003+A!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\tI\u0003\u0001B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003c\u0001!\u0011!Q\u0001\n\u0005M\u0002BCA#\u0001\t\u0005\t\u0015!\u0003\u0002H!Q\u0011Q\n\u0001\u0003\u0002\u0003\u0006I!a\u0014\t\u0015\u0005U\u0003A!A!\u0002\u0013\t9\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u0013\u0005e\u0004A1A\u0005\n\u0005m\u0004\u0002CAB\u0001\u0001\u0006I!! \t\u0013\u0005\u0015\u0005A1A\u0005\n\u0005\u001d\u0005bBAE\u0001\u0001\u0006IA\u001d\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u001bC\u0001\"a$\u0001A\u0003%\u00111\u0006\u0005\n\u0003#\u0003!\u0019!C\u0005\u0003'C\u0001\"!&\u0001A\u0003%\u0011q\u000b\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033C\u0001\"a*\u0001A\u0003%\u00111\u0014\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003WC\u0001\"!/\u0001A\u0003%\u0011Q\u0016\u0005\n\u0003w\u0003!\u0019!C\u0005\u0003{C\u0001\"!2\u0001A\u0003%\u0011q\u0018\u0005\n\u0003\u000f\u0004\u0001\u0019!C\u0005\u0003{C\u0011\"!3\u0001\u0001\u0004%I!a3\t\u0011\u0005]\u0007\u0001)Q\u0005\u0003\u007fC\u0011\"!7\u0001\u0001\u0004%I!!0\t\u0013\u0005m\u0007\u00011A\u0005\n\u0005u\u0007\u0002CAq\u0001\u0001\u0006K!a0\t\u0013\u0005\r\bA1A\u0005\n\u0005\u0015\b\u0002CAy\u0001\u0001\u0006I!a:\t\u0017\u0005M\b\u00011AA\u0002\u0013%\u0011Q\u001f\u0005\f\u0003o\u0004\u0001\u0019!a\u0001\n\u0013\tI\u0010\u0003\u0006\u0002~\u0002\u0001\r\u0011!Q!\nQC\u0011\"a@\u0001\u0005\u0004%IA!\u0001\t\u0011\t%\u0001\u0001)A\u0005\u0005\u0007AqAa\u0003\u0001\t\u0003\u0012i\u0001C\u0004\u0003\u0010\u0001!\tE!\u0005\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016\u00191!q\u0003\u0001\u0005\u00053Aq!!\u0018+\t\u0003\u0011i\u0003C\u0004\u00034)\"\tE!\u0006\b\u000f\tUB\b#\u0001\u00038\u001911\b\u0010E\u0001\u0005sAq!!\u0018/\t\u0003\u0011Y\u0004C\u0005\u0003>9\u0012\r\u0011\"\u0003\u0003@!A!q\t\u0018!\u0002\u0013\u0011\t\u0005C\u0005\u0003J9\u0012\r\u0011\"\u0003\u0003L!A!\u0011\f\u0018!\u0002\u0013\u0011i\u0005C\u0005\u0003\\9\n\n\u0011\"\u0001\u0003^!I!1\u000f\u0018\u0012\u0002\u0013\u0005!Q\u000f\u0005\n\u0005sr\u0013\u0013!C\u0001\u0005wB\u0011Ba /#\u0003%\tA!!\t\u0013\t\u0015e&%A\u0005\u0002\t\u001d\u0005\"\u0003BF]E\u0005I\u0011\u0001BG\u0011%\u0011\tJLI\u0001\n\u0003\u0011\u0019J\u0001\tQY\u0006L(-Y2l\u0013R,'/\u0019;pe*\u0011QHP\u0001\nSR,'/\u0019;peNT!a\u0010!\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0005\u0013\u0015aB4f_6,7/\u0019\u0006\u0003\u0007\u0012\u000bA\u0002\\8dCRLwN\u001c;fG\"T\u0011!R\u0001\u0004_J<7\u0001A\n\u0005\u0001!se\f\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VM\u001a\t\u0004\u001fJ#V\"\u0001)\u000b\u0005Es\u0014AC2pY2,7\r^5p]&\u00111\u000b\u0015\u0002\u0012\u00072|7/Z1cY\u0016LE/\u001a:bi>\u0014\bCA+]\u001b\u00051&BA,Y\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0011LW\u0001\bM\u0016\fG/\u001e:f\u0015\tYF)A\u0004pa\u0016tw-[:\n\u0005u3&!D*j[BdWMR3biV\u0014X\r\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u0006a1oY1mC2|wmZ5oO*\u00111\rZ\u0001\tif\u0004Xm]1gK*\tQ-A\u0002d_6L!a\u001a1\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\t!7\u000f\u0005\u0002k_6\t1N\u0003\u0002m[\u0006!A-\u0019;b\u0015\tqG)\u0001\u0005hK>$xn\u001c7t\u0013\t\u00018NA\u0005ECR\f7\u000b^8sK\u0006AA/\u001f9f\u001d\u0006lW\r\u0005\u0002tu:\u0011A\u000f\u001f\t\u0003k*k\u0011A\u001e\u0006\u0003o\u001a\u000ba\u0001\u0010:p_Rt\u0014BA=K\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eT\u0015\u0001C5oi\u0016\u0014h/\u00197\u0011\r%{\u00181AA\u0002\u0013\r\t\tA\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!Q\u000f^5m\u0015\t\ti!\u0001\u0003kCZ\f\u0017\u0002BA\t\u0003\u000f\u0011A\u0001R1uK\u0006\u0019A\r^4\u0011\t%\u000b9B]\u0005\u0004\u00033Q%AB(qi&|g.\u0001\u0004gS2$XM\u001d\t\u0006\u0013\u0006]\u0011q\u0004\t\u0005\u0003C\t)#\u0004\u0002\u0002$)\u0019\u00111\u0004.\n\t\u0005\u001d\u00121\u0005\u0002\u0007\r&dG/\u001a:\u0002\u0015Q\u0014\u0018M\\:g_Jl7\u000f\u0005\u0003J\u0003[\u0011\u0018bAA\u0018\u0015\n)\u0011I\u001d:bs\u00061q/\u001b8e_^\u0004R!SA\f\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0005ekJ\fG/[8o\u0015\r\tyDS\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\"\u0003s\u0011\u0001\u0002R;sCRLwN\\\u0001\u0005e\u0006$X\rE\u0002J\u0003\u0013J1!a\u0013K\u0005\u00151En\\1u\u0003\u0011a\u0017N^3\u0011\u0007%\u000b\t&C\u0002\u0002T)\u0013qAQ8pY\u0016\fg.A\u0005sK\u0006$\u0017\t[3bIB\u0019\u0011*!\u0017\n\u0007\u0005m#JA\u0002J]R\fa\u0001P5oSRtDCFA1\u0003K\n9'!\u001b\u0002l\u00055\u0014qNA9\u0003g\n)(a\u001e\u0011\u0007\u0005\r\u0004!D\u0001=\u0011\u0015A7\u00021\u0001j\u0011\u0015\t8\u00021\u0001s\u0011\u0015i8\u00021\u0001\u007f\u0011%\t\u0019b\u0003I\u0001\u0002\u0004\t)\u0002C\u0005\u0002\u001c-\u0001\n\u00111\u0001\u0002\u001e!I\u0011\u0011F\u0006\u0011\u0002\u0003\u0007\u00111\u0006\u0005\n\u0003cY\u0001\u0013!a\u0001\u0003gA\u0011\"!\u0012\f!\u0003\u0005\r!a\u0012\t\u0013\u000553\u0002%AA\u0002\u0005=\u0003\"CA+\u0017A\u0005\t\u0019AA,\u0003\r\u0019h\r^\u000b\u0003\u0003{\u00022!VA@\u0013\r\t\tI\u0016\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\nq\u0001\u001a;h\u001d\u0006lW-F\u0001s\u0003!!Go\u001a(b[\u0016\u0004\u0013!\u0002;eK\u001a\u001cXCAA\u0016\u0003\u0019!H-\u001a4tA\u0005AA\r^4J]\u0012,\u00070\u0006\u0002\u0002X\u0005IA\r^4J]\u0012,\u0007\u0010I\u0001\bIR<\u0007K]8q+\t\tY\n\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+a\t\u0002\u0015\u0015D\bO]3tg&|g.\u0003\u0003\u0002&\u0006}%\u0001\u0004)s_B,'\u000f^=OC6,\u0017\u0001\u00033uOB\u0013x\u000e\u001d\u0011\u0002\tM|'\u000f^\u000b\u0003\u0003[\u0003R!SA\u0017\u0003_\u0003B!!-\u000266\u0011\u00111\u0017\u0006\u0005\u0003S\u000b\u0019#\u0003\u0003\u00028\u0006M&AB*peR\u0014\u00150A\u0003t_J$\b%\u0001\u0007xS:$wn^'jY2L7/\u0006\u0002\u0002@B\u0019\u0011*!1\n\u0007\u0005\r'J\u0001\u0003M_:<\u0017!D<j]\u0012|w/T5mY&\u001c\b%A\u0003ti\u0006\u0014H/A\u0005ti\u0006\u0014Ho\u0018\u0013fcR!\u0011QZAj!\rI\u0015qZ\u0005\u0004\u0003#T%\u0001B+oSRD\u0011\"!6\u001c\u0003\u0003\u0005\r!a0\u0002\u0007a$\u0013'\u0001\u0004ti\u0006\u0014H\u000fI\u0001\u000bKZ,g\u000e^*uCJ$\u0018AD3wK:$8\u000b^1si~#S-\u001d\u000b\u0005\u0003\u001b\fy\u000eC\u0005\u0002Vz\t\t\u00111\u0001\u0002@\u0006YQM^3oiN#\u0018M\u001d;!\u0003!1W-\u0019;ve\u0016\u001cXCAAt!\u0015\tI/!<U\u001b\t\tYO\u0003\u0003\u0002@\u0005\u001d\u0011\u0002BAx\u0003W\u00141\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0002\rM$\u0018mZ3e+\u0005!\u0016AC:uC\u001e,Gm\u0018\u0013fcR!\u0011QZA~\u0011!\t)nIA\u0001\u0002\u0004!\u0016aB:uC\u001e,G\rI\u0001\tKb,7-\u001e;peV\u0011!1\u0001\t\u0005\u0003S\u0014)!\u0003\u0003\u0003\b\u0005-(aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013a\u00025bg:+\u0007\u0010^\u000b\u0003\u0003\u001f\nAA\\3yiR\tA+A\u0003dY>\u001cX\r\u0006\u0002\u0002N\ni\u0011+^3ssJ+hN\\1cY\u0016\u001cRA\u000bB\u000e\u0005O\u0001BA!\b\u0003$5\u0011!q\u0004\u0006\u0005\u0005C\tY!\u0001\u0003mC:<\u0017\u0002\u0002B\u0013\u0005?\u0011aa\u00142kK\u000e$\b\u0003\u0002B\u000f\u0005SIAAa\u000b\u0003 \tA!+\u001e8oC\ndW\r\u0006\u0002\u00030A\u0019!\u0011\u0007\u0016\u000e\u0003\u0001\t1A];o\u0003A\u0001F.Y=cC\u000e\\\u0017\n^3sCR|'\u000fE\u0002\u0002d9\u001a\"A\f%\u0015\u0005\t]\u0012A\u00014g+\t\u0011\t\u0005\u0005\u0003\u0002\"\t\r\u0013\u0002\u0002B#\u0003G\u0011aBR5mi\u0016\u0014h)Y2u_JL('A\u0002gM\u0002\n\u0001\u0002^3s[&t\u0017\r\\\u000b\u0003\u0005\u001b\u0002BAa\u0014\u0003V5\u0011!\u0011\u000b\u0006\u0004/\nM#BA-n\u0013\u0011\u00119F!\u0015\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u00136\u0004H.A\u0005uKJl\u0017N\\1mA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"Aa\u0018+\t\u0005U!\u0011M\u0016\u0003\u0005G\u0002BA!\u001a\u0003p5\u0011!q\r\u0006\u0005\u0005S\u0012Y'A\u0005v]\u000eDWmY6fI*\u0019!Q\u000e&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003r\t\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"Aa\u001e+\t\u0005u!\u0011M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tu$\u0006BA\u0016\u0005C\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001BBU\u0011\t\u0019D!\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011II\u000b\u0003\u0002H\t\u0005\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003\u0010*\"\u0011q\nB1\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"A!&+\t\u0005]#\u0011\r")
public class PlaybackIterator
implements CloseableIterator<SimpleFeature>,
StrictLogging {
    public final DataStore org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds;
    public final String org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName;
    public final Tuple2<Date, Date> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval;
    public final Option<Filter> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter;
    private final float rate;
    private final boolean live;
    private final SimpleFeatureType sft;
    private final String dtgName;
    private final String[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs;
    private final int dtgIndex;
    private final PropertyName org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp;
    private final SortBy[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort;
    private final long org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis;
    private long start;
    private long eventStart;
    private final LinkedBlockingQueue<SimpleFeature> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features;
    private SimpleFeature staged;
    private final ExecutorService executor;
    private final Logger logger;

    public static int $lessinit$greater$default$10() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$9();
    }

    public static float $lessinit$greater$default$8() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Duration> $lessinit$greater$default$7() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$7();
    }

    public static String[] $lessinit$greater$default$6() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Filter> $lessinit$greater$default$5() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return PlaybackIterator$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$map(Function1 f) {
        return Iterator.map$((Iterator)this, (Function1)f);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filter(Function1 p) {
        return Iterator.filter$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$filterNot(Function1 p) {
        return Iterator.filterNot$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$takeWhile(Function1 p) {
        return Iterator.takeWhile$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$utils$collection$CloseableIterator$$super$collect(PartialFunction pf) {
        return Iterator.collect$((Iterator)this, (PartialFunction)pf);
    }

    @Override
    public <B> CloseableIterator<B> map(Function1<SimpleFeature, B> f) {
        return CloseableIterator.map$(this, f);
    }

    @Override
    public CloseableIterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.filter$(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.filterNot$(this, p);
    }

    @Override
    public CloseableIterator<SimpleFeature> take(int n) {
        return CloseableIterator.take$(this, n);
    }

    @Override
    public CloseableIterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
        return CloseableIterator.takeWhile$(this, p);
    }

    @Override
    public <B> CloseableIterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
        return CloseableIterator.collect$(this, pf);
    }

    @Override
    public <B> CloseableIterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return CloseableIterator.$plus$plus$(this, that);
    }

    @Override
    public <B> CloseableIterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
        return CloseableIterator.flatMap$(this, f);
    }

    public Iterator<SimpleFeature> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<SimpleFeature> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<SimpleFeature> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<SimpleFeature> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<SimpleFeature, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<SimpleFeature, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<SimpleFeature, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<SimpleFeature, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<SimpleFeature> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<SimpleFeature> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<SimpleFeature> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<SimpleFeature> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<SimpleFeature> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<SimpleFeature, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<SimpleFeature> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<SimpleFeature> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<SimpleFeature> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<SimpleFeature> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<SimpleFeature> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<SimpleFeature, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private String dtgName() {
        return this.dtgName;
    }

    public String[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs;
    }

    private int dtgIndex() {
        return this.dtgIndex;
    }

    public PropertyName org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp;
    }

    public SortBy[] org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort;
    }

    public long org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long eventStart() {
        return this.eventStart;
    }

    private void eventStart_$eq(long x$1) {
        this.eventStart = x$1;
    }

    public LinkedBlockingQueue<SimpleFeature> org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features() {
        return this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features;
    }

    private SimpleFeature staged() {
        return this.staged;
    }

    private void staged_$eq(SimpleFeature x$1) {
        this.staged = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    public boolean hasNext() {
        boolean bl;
        if (this.staged() != null) {
            bl = true;
        } else {
            this.staged_$eq(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().take());
            if (PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$terminal() != this.staged()) {
                bl = true;
            } else {
                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put(this.staged());
                this.staged_$eq(null);
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeature next() {
        void var1_1;
        block4: {
            long featureRelativeTime;
            long sleep;
            SimpleFeature feature = this.staged();
            this.staged_$eq(null);
            long featureTime = ((Date)feature.getAttribute(this.dtgIndex())).getTime();
            if (this.start() == -1L) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Starting replay clock");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.start_$eq(System.currentTimeMillis());
                this.eventStart_$eq(featureTime);
            }
            if ((sleep = (featureRelativeTime = this.start() + (long)((double)(featureTime - this.eventStart()) / (double)this.rate)) - System.currentTimeMillis()) > 0L) {
                Thread.sleep(sleep);
            }
            if (!this.live) break block4;
            feature.setAttribute(this.dtgIndex(), (Object)new Date(featureRelativeTime));
        }
        return var1_1;
    }

    @Override
    public void close() {
        this.executor().shutdownNow();
    }

    public PlaybackIterator(DataStore ds, String typeName, Tuple2<Date, Date> interval, Option<String> dtg, Option<Filter> filter, String[] transforms, Option<Duration> window, float rate, boolean live, int readAhead) {
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds = ds;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName = typeName;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval = interval;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter = filter;
        this.rate = rate;
        this.live = live;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        CloseableIterator.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        Predef$.MODULE$.require(((Date)interval._2()).after((Date)interval._1()), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("Interval is not ordered correctly: ").append($this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1()).append("/").append($this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).toString());
        this.sft = ds.getSchema(typeName);
        this.dtgName = (String)dtg.orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Schema does not have a default date field");
        });
        String[] stringArray = transforms;
        String[] stringArray2 = stringArray == null ? null : (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).indexOf((Object)this.dtgName()) == -1 ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).$colon$plus((Object)this.dtgName(), ClassTag$.MODULE$.apply(String.class)) : stringArray);
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs = stringArray2;
        String[] stringArray3 = this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs();
        int n = stringArray3 == null ? this.sft().indexOf(this.dtgName()) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray3)).indexOf((Object)this.dtgName());
        this.dtgIndex = n;
        Predef$.MODULE$.require(this.dtgIndex() != -1, (Function0 & Serializable & scala.Serializable)() -> "Invalid date field");
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp = PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().property(this.dtgName());
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort = (SortBy[])((Object[])new SortBy[]{PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().sort(this.dtgName(), SortOrder.ASCENDING)});
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis = BoxesRunTime.unboxToLong((Object)window.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.toMillis())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((Date)$this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).getTime() - ((Date)$this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1()).getTime() + 1L));
        this.start = -1L;
        this.eventStart = -1L;
        this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features = new LinkedBlockingQueue(readAhead);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor().submit(new QueryRunnable());
    }

    private class QueryRunnable
    implements Runnable {
        @Override
        public void run() {
            block14: {
                try {
                    try {
                        Date from = (Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._1();
                        Date to = new Date(from.getTime() + this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis());
                        boolean loop = true;
                        while (loop && !Thread.currentThread().isInterrupted()) {
                            BoxedUnit boxedUnit;
                            BoxedUnit boxedUnit2;
                            if (((Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2()).before(to)) {
                                to = (Date)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$interval._2();
                                loop = false;
                            }
                            if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isDebugEnabled()) {
                                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().debug("Running query window {} to {}", (Object[])new Date[]{from, to});
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            DefaultPeriod period = new DefaultPeriod((Instant)new DefaultInstant((Position)new DefaultPosition(from)), (Instant)new DefaultInstant((Position)new DefaultPosition(to)));
                            During during = PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().during((Expression)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$dtgProp(), (Expression)PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().literal((Object)period));
                            Query query = new Query(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$typeName, (Filter)this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$filter.map((Function1 & Serializable & scala.Serializable)x$2 -> PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ff().and(x$2, (Filter)during)).getOrElse((Function0 & Serializable & scala.Serializable)() -> during), this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$tdefs());
                            query.setSortBy(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$sort());
                            query.getHints().put((Object)Hints.MAX_MEMORY_SORT, (Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
                            LongRef count = LongRef.create((long)0L);
                            SelfClosingIterator$.MODULE$.apply(this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$ds.getFeatureReader(query, Transaction.AUTO_COMMIT)).foreach((Function1 & Serializable & scala.Serializable)f -> {
                                QueryRunnable.$anonfun$run$3(this, count, f);
                                return BoxedUnit.UNIT;
                            });
                            if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isDebugEnabled()) {
                                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().debug("Returned {} features from query window {} to {}", new Object[]{BoxesRunTime.boxToLong((long)count.elem), from, to});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            from = to;
                            to = new Date(from.getTime() + this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$windowMillis());
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            BoxedUnit boxedUnit;
                            Throwable e = (Throwable)option.get();
                            if (this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().isErrorEnabled()) {
                                this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().logger().underlying().error("Error querying playback:", e);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit3 = boxedUnit;
                            break block14;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put((SimpleFeature)PlaybackIterator$.MODULE$.org$locationtech$geomesa$utils$iterators$PlaybackIterator$$terminal());
                }
            }
        }

        public /* synthetic */ PlaybackIterator org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer() {
            return PlaybackIterator.this;
        }

        public static final /* synthetic */ void $anonfun$run$3(QueryRunnable $this, LongRef count$1, SimpleFeature f) {
            $this.org$locationtech$geomesa$utils$iterators$PlaybackIterator$QueryRunnable$$$outer().org$locationtech$geomesa$utils$iterators$PlaybackIterator$$features().put(f);
            ++count$1.elem;
        }

        public QueryRunnable() {
            if (PlaybackIterator.this == null) {
                throw null;
            }
        }
    }
}

