/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.kryo;

import com.esotericsoftware.kryo.io.Input;
import scala.Array$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054Aa\u0003\u0007\u0001/!)1\u0005\u0001C\u0001I!)1\u0005\u0001C\u0001O!)1\u0007\u0001C!i!)\u0001\t\u0001C!\u0003\")!\n\u0001C\u0005i!)1\n\u0001C\u0005\u0019\")!\u000b\u0001C\u0005'\")\u0011\f\u0001C\u00055\")a\f\u0001C\u0005?\")\u0001\r\u0001C\u0005?\n\u0001bj\u001c8NkR\fG/\u001b8h\u0013:\u0004X\u000f\u001e\u0006\u0003\u001b9\tAa\u001b:z_*\u0011q\u0002E\u0001\u0006kRLGn\u001d\u0006\u0003#I\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u0014)\u0005aAn\\2bi&|g\u000e^3dQ*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011$I\u0007\u00025)\u00111\u0004H\u0001\u0003S>T!!D\u000f\u000b\u0005yy\u0012\u0001E3t_R,'/[2t_\u001a$x/\u0019:f\u0015\u0005\u0001\u0013aA2p[&\u0011!E\u0007\u0002\u0006\u0013:\u0004X\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u00031!\"!\n\u0015\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\r\t,hMZ3s!\rYc\u0006M\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t)\u0011I\u001d:bsB\u00111&M\u0005\u0003e1\u0012AAQ=uK\u0006Q!/Z1e'R\u0014\u0018N\\4\u0015\u0003U\u0002\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d-\u001b\u0005I$B\u0001\u001e\u0017\u0003\u0019a$o\\8u}%\u0011A\bL\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=Y\u0005\t\"/Z1e'R\u0014\u0018N\\4Ck&dG-\u001a:\u0015\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEIA\u0007TiJLgn\u001a\"vS2$WM]\u0001\u0010e\u0016\fG-Q:dS&\u001cFO]5oO\u0006!\"/Z1e\u0003N\u001c\u0017.[*ue&twmX:m_^$\"!N'\t\u000b93\u0001\u0019A(\u0002\u000b\r|WO\u001c;\u0011\u0005-\u0002\u0016BA)-\u0005\rIe\u000e^\u0001\u000ee\u0016\fG-\u0016;gq\rC\u0017M]:\u0015\u0005Q;\u0006CA\u0016V\u0013\t1FF\u0001\u0003V]&$\b\"\u0002-\b\u0001\u0004y\u0015!C2iCJ\u001cu.\u001e8u\u0003I\u0011X-\u00193Vi\u001aD4\t[1sg~\u001bHn\\<\u0015\u0007Q[F\fC\u0003Y\u0011\u0001\u0007q\nC\u0003^\u0011\u0001\u0007q*A\u0003j]\u0012,\u00070\u0001\tsK\u0006$g+\u0019:J]RdUM\\4uQR\tq*A\u000bsK\u0006$g+\u0019:J]RdUM\\4uQ~\u001bHn\\<")
public class NonMutatingInput
extends Input {
    public String readString() {
        String string;
        Object object = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
        if ((this.buffer[this.position] & 0x80) == 0) {
            string = this.readAsciiString();
        } else {
            int charCount = this.readVarIntLength();
            if (charCount == 0) {
                string = null;
            } else if (charCount == 1) {
                string = "";
            } else {
                this.readUtf8Chars(--charCount);
                string = new String(this.chars, 0, charCount);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public StringBuilder readStringBuilder() {
        StringBuilder stringBuilder;
        Object object = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
        if ((this.buffer[this.position] & 0x80) == 0) {
            stringBuilder = new StringBuilder(this.readAsciiString());
        } else {
            int charCount = this.readVarIntLength();
            if (charCount == 0) {
                stringBuilder = null;
            } else if (charCount == 1) {
                stringBuilder = new StringBuilder(0);
            } else {
                void var2_2;
                this.readUtf8Chars(--charCount);
                StringBuilder builder = new StringBuilder(charCount);
                builder.append(this.chars, 0, charCount);
                stringBuilder = var2_2;
            }
        }
        return stringBuilder;
    }

    private String readAsciiString() {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        int charCount = 0;
        int p = this.position;
        int n = Math.min(chars.length, this.limit - p);
        while (charCount < n) {
            byte b = buffer[p];
            if ((b & 0x80) == 128) {
                this.position = p + 1;
                chars[charCount] = (char)(b & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount] = (char)b;
            ++charCount;
            ++p;
        }
        this.position = p;
        return this.readAsciiString_slow(charCount);
    }

    private String readAsciiString_slow(int count) {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        int charCount = count;
        int p = this.position;
        while (true) {
            Object object = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
            byte b = buffer[p];
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                this.chars = chars = newChars;
            }
            if ((b & 0x80) == 128) {
                this.position = p + 1;
                chars[charCount] = (char)(b & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount] = (char)b;
            ++charCount;
            ++p;
        }
    }

    private void readUtf8Chars(int charCount) {
        block3: {
            if (this.chars.length < charCount) {
                this.chars = (char[])Array$.MODULE$.ofDim(charCount, ClassTag$.MODULE$.Char());
            }
            byte[] buffer = this.buffer;
            char[] chars = this.chars;
            int count = Math.min(this.require(1), charCount);
            int charIndex = 0;
            int p = this.position;
            byte b = 0;
            while (charIndex < count) {
                b = buffer[p];
                if (b < 0) {
                    count = 0;
                    continue;
                }
                chars[charIndex] = (char)b;
                ++charIndex;
                ++p;
            }
            this.position = p;
            if (charIndex >= charCount) break block3;
            this.readUtf8Chars_slow(charCount, charIndex);
        }
    }

    private void readUtf8Chars_slow(int charCount, int index) {
        char[] chars = this.chars;
        byte[] buffer = this.buffer;
        for (int charIndex = index; charIndex < charCount; ++charIndex) {
            Object object = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
            int b = buffer[this.position] & 0xFF;
            ++this.position;
            int i = b >> 4;
            if (i >= 0 && i < 8) {
                chars[charIndex] = (char)b;
                continue;
            }
            if (i == 12 || i == 13) {
                Object object2 = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
                chars[charIndex] = (char)((b & 0x1F) << 6 | buffer[this.position] & 0x3F);
                ++this.position;
                continue;
            }
            if (i != 14) continue;
            this.require(2);
            chars[charIndex] = (char)((b & 0xF) << 12 | (buffer[this.position] & 0x3F) << 6 | buffer[this.position + 1] & 0x3F);
            this.position += 2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int readVarIntLength() {
        int n;
        if (this.require(1) < 5) {
            n = this.readVarIntLength_slow();
        } else {
            void var2_2;
            byte b = this.buffer[this.position];
            ++this.position;
            int result = b & 0x3F;
            if ((b & 0x40) != 0) {
                b = this.buffer[this.position];
                ++this.position;
                result |= (b & 0x7F) << 6;
                if ((b & 0x80) != 0) {
                    b = this.buffer[this.position];
                    ++this.position;
                    result |= (b & 0x7F) << 13;
                    if ((b & 0x80) != 0) {
                        b = this.buffer[this.position];
                        ++this.position;
                        result |= (b & 0x7F) << 20;
                        if ((b & 0x80) != 0) {
                            b = this.buffer[this.position];
                            ++this.position;
                            result |= (b & 0x7F) << 27;
                        }
                    }
                }
            }
            n = var2_2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int readVarIntLength_slow() {
        void var2_2;
        block3: {
            byte b = this.buffer[this.position];
            ++this.position;
            int result = b & 0x3F;
            if ((b & 0x40) == 0) break block3;
            Object object = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
            b = this.buffer[this.position];
            ++this.position;
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                Object object2 = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
                b = this.buffer[this.position];
                ++this.position;
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    Object object3 = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
                    b = this.buffer[this.position];
                    ++this.position;
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        Object object4 = this.position == this.limit ? BoxesRunTime.boxToInteger((int)this.require(1)) : BoxedUnit.UNIT;
                        b = this.buffer[this.position];
                        ++this.position;
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return (int)var2_2;
    }

    public NonMutatingInput() {
    }

    public NonMutatingInput(byte[] buffer) {
        this();
        this.setBuffer(buffer);
    }
}

