/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import java.io.Serializable;
import java.util.Date;
import org.locationtech.geomesa.curve.Z2SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.stats.BinnedArray$StringBinning$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeqLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rUh!B={\u0001\u0005-\u0001BCA\u000e\u0001\t\u0005\t\u0015!\u0003\u0002\u001e!9\u00111\t\u0001\u0005\u0002\r}\u0005BCBS\u0001\t\u0007I\u0011\u0001>\u0004(\"A11\u0016\u0001!\u0002\u0013\u0019I\u000bC\u0004\u0002z\u0001!\t!!%\t\u000f\u0005\r\u0005\u0001\"\u0001\u0004.\"9\u0011q\t\u0001\u0005\u0002\rE\u0006bBB[\u0001\u0011\u00051q\u0017\u0005\b\u0007\u007f\u0003A\u0011ABa\u0011%\u0019I\rAI\u0001\n\u0003\u0019Y\rC\u0004\u0002*\u0002!\ta!9\t\u000f\u0005]\u0006\u0001\"\u0001\u0004f\"9\u0011Q\u0018\u0001\u0005\u0002\r%\bbBAB\u0001\u0011\u00051Q\u001e\u0005\b\u0003\u0013\u0004A\u0011ABy\u000f\u001d\tYD\u001fE\u0001\u0003{1a!\u001f>\t\u0002\u0005\u0005\u0003bBA\"#\u0011\u0005\u0011Q\t\u0005\b\u0003\u000f\nB\u0011AA%\r\u001d\tY)EA\u0001\u0003\u001bC!\"!\u001f\u0015\u0005\u000b\u0007I\u0011AAI\u0011)\t\u0019\n\u0006B\u0001B\u0003%\u00111\u0010\u0005\u000b\u0003\u0007#\"Q1A\u0005\u0002\u0005U\u0005BCAO)\t\u0005\t\u0015!\u0003\u0002\u0018\"9\u00111\t\u000b\u0005\u0002\u0005}\u0005bBAU)\u0019\u0005\u00111\u0016\u0005\b\u0003o#b\u0011AA]\u0011\u001d\ti\f\u0006D\u0001\u0003\u007fCq!a!\u0015\r\u0003\t)\rC\u0004\u0002JR1\t!a3\b\u000f\u0005U\u0017\u0003#\u0001\u0002X\u001a9\u00111R\t\t\u0002\u0005e\u0007bBA\"A\u0011\u0005\u00111\u001c\u0005\b\u0003\u000f\u0002C\u0011AAo\r\u001d\t)0EA\u0001\u0003oD1\"!\u001f$\u0005\u0003\u0005\u000b\u0011BA>+!Q\u00111Q\u0012\u0003\u0002\u0003\u0006IA!\u0001\t\u000f\u0005\r3\u0005\"\u0001\u0003\u0004!I!1B\u0012C\u0002\u0013%!Q\u0002\u0005\t\u0005\u001f\u0019\u0003\u0015!\u0003\u00022\"I!\u0011C\u0012C\u0002\u0013%!Q\u0002\u0005\t\u0005'\u0019\u0003\u0015!\u0003\u00022\"I!QC\u0012C\u0002\u0013%!q\u0003\u0005\t\u0005?\u0019\u0003\u0015!\u0003\u0003\u001a!9\u0011\u0011V\u0012\u0005B\t\u0005\u0002bBA\\G\u0011\u0005#Q\u0005\u0005\b\u0003{\u001bC\u0011\tB\u0015\u0011\u001d\t\u0019i\tC!\u0005[Aq!!3$\t\u0003\u0012\t\u0004C\u0004\u00036\r2\tBa\u000e\t\u000f\tm2E\"\u0005\u0003>\u00191!\u0011I\t\u0001\u0005\u0007B1\"!\u001f5\u0005\u0003\u0005\u000b\u0011BA>+!Q\u00111\u0011\u001b\u0003\u0002\u0003\u0006IAa\u0016\t\u000f\u0005\rC\u0007\"\u0001\u0003Z!9!Q\u0007\u001b\u0005R\t\u0005\u0004b\u0002B\u001ei\u0011E#Q\r\u0004\u0007\u0005S\n\u0002Aa\u001b\t\u0017\u0005e$H!A!\u0002\u0013\tY(\u0006\u0005\u000b\u0003\u0007S$\u0011!Q\u0001\n\tM\u0004bBA\"u\u0011\u0005!Q\u000f\u0005\b\u0005kQD\u0011\u000bB?\u0011\u001d\u0011YD\u000fC)\u0005\u00033aA!\"\u0012\u0001\t\u001d\u0005bCA=\u0001\n\u0005\t\u0015!\u0003\u0002|UA!\"a!A\u0005\u0003\u0005\u000b\u0011\u0002BL\u0011\u001d\t\u0019\u0005\u0011C\u0001\u00053CqA!\u000eA\t#\u0012\t\u000bC\u0004\u0003<\u0001#\tF!*\u0007\r\t%\u0016\u0003\u0001BV\u0011-\tIH\u0012B\u0001B\u0003%\u00111P\u000b\t\u0015\u0005\reI!A!\u0002\u0013\u0011y\fC\u0004\u0002D\u0019#\tA!1\t\u000f\tUb\t\"\u0015\u0003J\"9!1\b$\u0005R\t5gA\u0002Bi#\u0001\u0011\u0019\u000eC\u0006\u0002z1\u0013\t\u0011)A\u0005\u0003w*\u0002BCAB\u0019\n\u0005\t\u0015!\u0003\u0003^\"9\u00111\t'\u0005\u0002\t}\u0007\"\u0003B\u000b\u0019\n\u0007I\u0011\u0002Bt\u0011!\u0011y\u0002\u0014Q\u0001\n\t%\bbBAU\u0019\u0012\u0005#Q\u001e\u0005\b\u0003ocE\u0011\tBy\u0011\u001d\ti\f\u0014C!\u0005kDq!a!M\t\u0003\u0012I\u0010C\u0004\u0002J2#\tE!@\u0007\r\r\u0005\u0011\u0003AB\u0002\u0011-\tIh\u0016B\u0001B\u0003%\u00111P\u000b\t\u0015\u0005\ruK!A!\u0002\u0013\u0019Y\u0001C\u0004\u0002D]#\ta!\u0004\t\u0013\tUqK1A\u0005\n\t]\u0001\u0002\u0003B\u0010/\u0002\u0006IA!\u0007\t\u000f\u0005%v\u000b\"\u0011\u0004\u0016!9\u0011qW,\u0005B\re\u0001bBA_/\u0012\u00053Q\u0004\u0005\b\u0003\u0007;F\u0011IB\u0011\u0011\u001d\tIm\u0016C!\u0007K1aa!\u000b\u0012\u0001\r-\u0002bCA=E\n\u0005\t\u0015!\u0003\u0002|UA!ba\u0010c\u0005\u0003\u0005\u000b\u0011BB!\u0011\u001d\t\u0019E\u0019C\u0001\u0007\u0007BAba\u0013c!\u0003E9\u0019)C\u0005\u0007\u001bB!ba\u0014c\u0011\u000b\u0007I\u0011BB)\u0011)\u0019\u0019F\u0019EC\u0002\u0013%1\u0011\u000b\u0005\u000b\u0007+\u0012\u0007R1A\u0005\n\u0005E\u0005BCB,E\"\u0015\r\u0011\"\u0003\u0002\u0012\"Q1\u0011\f2\t\u0006\u0004%Iaa\u0017\t\u000f\tU\"\r\"\u0015\u0004b!9!1\b2\u0005R\r\u0015taBB5#!\u000511\u000e\u0004\b\u0007S\t\u0002\u0012AB7\u0011\u001d\t\u0019e\u001cC\u0001\u0007_B\u0011b!\u001dp\u0005\u0004%Iaa\u001d\t\u0011\r\u0005u\u000e)A\u0005\u0007kB\u0011ba!p\u0005\u0004%\ta!\"\t\u0011\r\u001du\u000e)A\u0005\u0007wB\u0011b!#p\u0005\u0004%\ta!\"\t\u0011\r-u\u000e)A\u0005\u0007wBqa!$p\t\u0003\u0019y\tC\u0004\u0004\u0016>$\taa&\u0003\u0017\tKgN\\3e\u0003J\u0014\u0018-\u001f\u0006\u0003wr\fQa\u001d;biNT!! @\u0002\u000bU$\u0018\u000e\\:\u000b\u0007}\f\t!A\u0004hK>lWm]1\u000b\t\u0005\r\u0011QA\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0003\u0003\u000f\t1a\u001c:h\u0007\u0001)B!!\u0004\u0004\u001eN\u0019\u0001!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q!!!\u0006\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005e\u00111\u0003\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\tLgN\\5oOB)\u0011q\u0004\u000b\u0004\u001c:\u0019\u0011\u0011\u0005\t\u000f\t\u0005\r\u0012\u0011\b\b\u0005\u0003K\t9D\u0004\u0003\u0002(\u0005Ub\u0002BA\u0015\u0003gqA!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0005\u0003_\tI!\u0001\u0004=e>|GOP\u0005\u0003\u0003\u000fIA!a\u0001\u0002\u0006%\u0019q0!\u0001\n\u0005ut\u0018BA>}\u0003-\u0011\u0015N\u001c8fI\u0006\u0013(/Y=\u0011\u0007\u0005}\u0012#D\u0001{'\r\t\u0012qB\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005u\u0012!B1qa2LX\u0003BA&\u0003+\"b!!\u0014\u0002x\u0005\u0005E\u0003BA(\u0003O\u0002R!a\u0010\u0001\u0003#\u0002B!a\u0015\u0002V1\u0001AaBA,'\t\u0007\u0011\u0011\f\u0002\u0002)F!\u00111LA1!\u0011\t\t\"!\u0018\n\t\u0005}\u00131\u0003\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t\"a\u0019\n\t\u0005\u0015\u00141\u0003\u0002\u0004\u0003:L\b\"CA5'\u0005\u0005\t9AA6\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003[\n\u0019(!\u0015\u000e\u0005\u0005=$\u0002BA9\u0003'\tqA]3gY\u0016\u001cG/\u0003\u0003\u0002v\u0005=$\u0001C\"mCN\u001cH+Y4\t\u000f\u0005e4\u00031\u0001\u0002|\u00051A.\u001a8hi\"\u0004B!!\u0005\u0002~%!\u0011qPA\n\u0005\rIe\u000e\u001e\u0005\b\u0003\u0007\u001b\u0002\u0019AAC\u0003\u0019\u0011w.\u001e8egBA\u0011\u0011CAD\u0003#\n\t&\u0003\u0003\u0002\n\u0006M!A\u0002+va2,'GA\u0004CS:t\u0017N\\4\u0016\t\u0005=\u00151T\n\u0004)\u0005=QCAA>\u0003\u001daWM\\4uQ\u0002*\"!a&\u0011\u0011\u0005E\u0011qQAM\u00033\u0003B!a\u0015\u0002\u001c\u00129\u0011q\u000b\u000bC\u0002\u0005e\u0013a\u00022pk:$7\u000f\t\u000b\u0007\u0003C\u000b)+a*\u0011\u000b\u0005\rF#!'\u000e\u0003EAq!!\u001f\u001a\u0001\u0004\tY\bC\u0004\u0002\u0004f\u0001\r!a&\u0002\u0017\u0011L'/Z2u\u0013:$W\r\u001f\u000b\u0005\u0003w\ni\u000bC\u0004\u00020j\u0001\r!!-\u0002\u000bY\fG.^3\u0011\t\u0005E\u00111W\u0005\u0005\u0003k\u000b\u0019B\u0001\u0003M_:<\u0017aB5oI\u0016DxJ\u001a\u000b\u0005\u0003w\nY\fC\u0004\u00020n\u0001\r!!'\u0002\u00175,G-[1o-\u0006dW/\u001a\u000b\u0005\u00033\u000b\t\rC\u0004\u0002Dr\u0001\r!a\u001f\u0002\u000b%tG-\u001a=\u0015\t\u0005]\u0015q\u0019\u0005\b\u0003\u0007l\u0002\u0019AA>\u0003\u001dI7OQ3m_^$B!!4\u0002TB!\u0011\u0011CAh\u0013\u0011\t\t.a\u0005\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0016\u0010A\u0002\u0005e\u0015a\u0002\"j]:Lgn\u001a\t\u0004\u0003G\u00033c\u0001\u0011\u0002\u0010Q\u0011\u0011q[\u000b\u0005\u0003?\f9\u000f\u0006\u0004\u0002b\u0006=\u0018\u0011\u001f\u000b\u0005\u0003G\fI\u000fE\u0003\u0002$R\t)\u000f\u0005\u0003\u0002T\u0005\u001dHaBA,E\t\u0007\u0011\u0011\f\u0005\n\u0003W\u0014\u0013\u0011!a\u0002\u0003[\f!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\ti'a\u001d\u0002f\"9\u0011\u0011\u0010\u0012A\u0002\u0005m\u0004bBABE\u0001\u0007\u00111\u001f\t\t\u0003#\t9)!:\u0002f\n\u0011r\u000b[8mK:+XNY3s\u0005&tg.\u001b8h+\u0011\tI0a@\u0014\u0007\r\nY\u0010E\u0003\u0002$R\ti\u0010\u0005\u0003\u0002T\u0005}HaBA,G\t\u0007\u0011\u0011\f\t\t\u0003#\t9)!@\u0002~R1!Q\u0001B\u0004\u0005\u0013\u0001R!a)$\u0003{Dq!!\u001f'\u0001\u0004\tY\bC\u0004\u0002\u0004\u001a\u0002\rA!\u0001\u0002\u00075Lg.\u0006\u0002\u00022\u0006!Q.\u001b8!\u0003\ri\u0017\r_\u0001\u0005[\u0006D\b%A\u0004cS:\u001c\u0016N_3\u0016\u0005\te\u0001\u0003BA\t\u00057IAA!\b\u0002\u0014\t1Ai\\;cY\u0016\f\u0001BY5o'&TX\r\t\u000b\u0005\u0003w\u0012\u0019\u0003C\u0004\u000206\u0002\r!!-\u0015\t\u0005m$q\u0005\u0005\b\u0003_s\u0003\u0019AA\u007f)\u0011\tiPa\u000b\t\u000f\u0005\rw\u00061\u0001\u0002|Q!!\u0011\u0001B\u0018\u0011\u001d\t\u0019\r\ra\u0001\u0003w\"B!!4\u00034!9\u0011qV\u0019A\u0002\u0005u\u0018!D2p]Z,'\u000f\u001e+p\u0019>tw\r\u0006\u0003\u00022\ne\u0002bBAXe\u0001\u0007\u0011Q`\u0001\u0010G>tg/\u001a:u\rJ|W\u000eT8oOR!\u0011Q B \u0011\u001d\tyk\ra\u0001\u0003c\u0013!\"\u00138u\u0005&tg.\u001b8h'\r!$Q\t\t\u0006\u0003G\u001b#q\t\t\u0005\u0005\u0013\u0012\u0019&\u0004\u0002\u0003L)!!Q\nB(\u0003\u0011a\u0017M\\4\u000b\u0005\tE\u0013\u0001\u00026bm\u0006LAA!\u0016\u0003L\t9\u0011J\u001c;fO\u0016\u0014\b\u0003CA\t\u0003\u000f\u00139Ea\u0012\u0015\r\tm#Q\fB0!\r\t\u0019\u000b\u000e\u0005\b\u0003s:\u0004\u0019AA>\u0011\u001d\t\u0019i\u000ea\u0001\u0005/\"B!!-\u0003d!9\u0011q\u0016\u001dA\u0002\t\u001dC\u0003\u0002B$\u0005OBq!a,:\u0001\u0004\t\tLA\u0006M_:<')\u001b8oS:<7c\u0001\u001e\u0003nA)\u00111U\u0012\u0003pA!!\u0011\nB9\u0013\u0011\t)La\u0013\u0011\u0011\u0005E\u0011q\u0011B8\u0005_\"bAa\u001e\u0003z\tm\u0004cAARu!9\u0011\u0011P\u001fA\u0002\u0005m\u0004bBAB{\u0001\u0007!1\u000f\u000b\u0005\u0003c\u0013y\bC\u0004\u00020z\u0002\rAa\u001c\u0015\t\t=$1\u0011\u0005\b\u0003_{\u0004\u0019AAY\u0005-!\u0015\r^3CS:t\u0017N\\4\u0014\u0007\u0001\u0013I\tE\u0003\u0002$\u000e\u0012Y\t\u0005\u0003\u0003\u000e\nMUB\u0001BH\u0015\u0011\u0011\tJa\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005+\u0013yI\u0001\u0003ECR,\u0007\u0003CA\t\u0003\u000f\u0013YIa#\u0015\r\tm%Q\u0014BP!\r\t\u0019\u000b\u0011\u0005\b\u0003s\u001a\u0005\u0019AA>\u0011\u001d\t\u0019i\u0011a\u0001\u0005/#B!!-\u0003$\"9\u0011q\u0016#A\u0002\t-E\u0003\u0002BF\u0005OCq!a,F\u0001\u0004\t\tLA\bHK>lW\r\u001e:z\u0005&tg.\u001b8h'\r1%Q\u0016\t\u0006\u0003G\u001b#q\u0016\t\u0005\u0005c\u0013Y,\u0004\u0002\u00034*!!Q\u0017B\\\u0003\u00119Wm\\7\u000b\t\te\u0016\u0011A\u0001\u0004UR\u001c\u0018\u0002\u0002B_\u0005g\u0013\u0001bR3p[\u0016$(/\u001f\t\t\u0003#\t9Ia,\u00030R1!1\u0019Bc\u0005\u000f\u00042!a)G\u0011\u001d\tI(\u0013a\u0001\u0003wBq!a!J\u0001\u0004\u0011y\f\u0006\u0003\u00022\n-\u0007bBAX\u0015\u0002\u0007!q\u0016\u000b\u0005\u0005_\u0013y\rC\u0004\u00020.\u0003\r!!-\u0003\u0019\u0019cw.\u0019;CS:t\u0017N\\4\u0014\u00071\u0013)\u000eE\u0003\u0002$R\u00119\u000e\u0005\u0003\u0003J\te\u0017\u0002\u0002Bn\u0005\u0017\u0012QA\u00127pCR\u0004\u0002\"!\u0005\u0002\b\n]'q\u001b\u000b\u0007\u0005C\u0014\u0019O!:\u0011\u0007\u0005\rF\nC\u0004\u0002z=\u0003\r!a\u001f\t\u000f\u0005\ru\n1\u0001\u0003^V\u0011!\u0011\u001e\t\u0005\u0003#\u0011Y/\u0003\u0003\u0003\\\u0006MA\u0003BA>\u0005_Dq!a,S\u0001\u0004\t\t\f\u0006\u0003\u0002|\tM\bbBAX'\u0002\u0007!q\u001b\u000b\u0005\u0005/\u00149\u0010C\u0004\u0002DR\u0003\r!a\u001f\u0015\t\tu'1 \u0005\b\u0003\u0007,\u0006\u0019AA>)\u0011\tiMa@\t\u000f\u0005=f\u000b1\u0001\u0003X\niAi\\;cY\u0016\u0014\u0015N\u001c8j]\u001e\u001c2aVB\u0003!\u0015\t\u0019\u000bFB\u0004!\u0011\u0011Ie!\u0003\n\t\tu!1\n\t\t\u0003#\t9ia\u0002\u0004\bQ11qBB\t\u0007'\u00012!a)X\u0011\u001d\tIH\u0017a\u0001\u0003wBq!a![\u0001\u0004\u0019Y\u0001\u0006\u0003\u0002|\r]\u0001bBAX;\u0002\u0007\u0011\u0011\u0017\u000b\u0005\u0003w\u001aY\u0002C\u0004\u00020z\u0003\raa\u0002\u0015\t\r\u001d1q\u0004\u0005\b\u0003\u0007|\u0006\u0019AA>)\u0011\u0019Yaa\t\t\u000f\u0005\r\u0007\r1\u0001\u0002|Q!\u0011QZB\u0014\u0011\u001d\ty+\u0019a\u0001\u0007\u000f\u0011Qb\u0015;sS:<')\u001b8oS:<7c\u00012\u0004.A)\u00111U\u0012\u00040A!1\u0011GB\u001d\u001d\u0011\u0019\u0019d!\u000e\u0011\t\u0005-\u00121C\u0005\u0005\u0007o\t\u0019\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007w\u0019iD\u0001\u0004TiJLgn\u001a\u0006\u0005\u0007o\t\u0019\"A\u0005sC^\u0014u.\u001e8egBA\u0011\u0011CAD\u0007_\u0019y\u0003\u0006\u0004\u0004F\r\u001d3\u0011\n\t\u0004\u0003G\u0013\u0007bBA=K\u0002\u0007\u00111\u0010\u0005\b\u0007\u007f)\u0007\u0019AB!\u0003\rAHEM\u000b\u0003\u0007\u0003\nQa\u001d;beR,\"aa\f\u0002\u0007\u0015tG-\u0001\to_Jl\u0017\r\\5{K\u0012dUM\\4uQ\u0006a\u0001O]3gSbdUM\\4uQ\u00061\u0001O]3gSb,\"a!\u0018\u0011\t\t%3qL\u0005\u0005\u0007w\u0011Y\u0005\u0006\u0003\u00022\u000e\r\u0004bBAXY\u0002\u00071q\u0006\u000b\u0005\u0007_\u00199\u0007C\u0004\u000206\u0004\r!!-\u0002\u001bM#(/\u001b8h\u0005&tg.\u001b8h!\r\t\u0019k\\\n\u0004_\u0006=ACAB6\u0003-\u0011\u0015m]34m\rC\u0017M]:\u0016\u0005\rU\u0004CBA\t\u0007o\u001aY(\u0003\u0003\u0004z\u0005M!!B!se\u0006L\b\u0003BA\t\u0007{JAaa \u0002\u0014\t!1\t[1s\u00031\u0011\u0015m]34m\rC\u0017M]:!\u00031\u0011\u0015m]34m1{w/Z:u+\t\u0019Y(A\u0007CCN,7G\u000e'po\u0016\u001cH\u000fI\u0001\u000e\u0005\u0006\u001cXm\r\u001cIS\u001eDWm\u001d;\u0002\u001d\t\u000b7/Z\u001a7\u0011&<\u0007.Z:uA\u0005Ian\u001c:nC2L'0\u001a\u000b\u0005\u0007_\u0019\t\nC\u0004\u0004\u0014^\u0004\raa\f\u0002\u0003M\fqB\\8s[\u0006d\u0017N_3C_VtGm\u001d\u000b\u0005\u0007\u0003\u001aI\nC\u0004\u0002\u0004b\u0004\ra!\u0011\u0011\t\u0005M3Q\u0014\u0003\b\u0003/\u0002!\u0019AA-)\u0011\u0019\tka)\u0011\u000b\u0005}\u0002aa'\t\u000f\u0005m!\u00011\u0001\u0002\u001e\u000511m\\;oiN,\"a!+\u0011\r\u0005E1qOAY\u0003\u001d\u0019w.\u001e8ug\u0002*\"aa,\u0011\u0011\u0005E\u0011qQBN\u00077#B!!-\u00044\"9\u00111Y\u0004A\u0002\u0005m\u0014!B2mK\u0006\u0014HCAB]!\u0011\t\tba/\n\t\ru\u00161\u0003\u0002\u0005+:LG/A\u0002bI\u0012$ba!/\u0004D\u000e\u0015\u0007bBAX\u0013\u0001\u000711\u0014\u0005\n\u0007\u000fL\u0001\u0013!a\u0001\u0003c\u000bQaY8v]R\fQ\"\u00193eI\u0011,g-Y;mi\u0012\u0012TCABgU\u0011\t\tla4,\u0005\rE\u0007\u0003BBj\u0007;l!a!6\u000b\t\r]7\u0011\\\u0001\nk:\u001c\u0007.Z2lK\u0012TAaa7\u0002\u0014\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r}7Q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003BA>\u0007GDq!a,\f\u0001\u0004\t\t\f\u0006\u0003\u0002|\r\u001d\bbBAX\u0019\u0001\u000711\u0014\u000b\u0005\u00077\u001bY\u000fC\u0004\u0002D6\u0001\r!a\u001f\u0015\t\r=6q\u001e\u0005\b\u0003\u0007t\u0001\u0019AA>)\u0011\tima=\t\u000f\u0005=v\u00021\u0001\u0004\u001c\u0002")
public class BinnedArray<T> {
    private final Binning<T> binning;
    private final long[] counts;

    public long[] counts() {
        return this.counts;
    }

    public int length() {
        return this.binning.length();
    }

    public Tuple2<T, T> bounds() {
        return this.binning.bounds();
    }

    public long apply(int index) {
        return this.counts()[index];
    }

    public void clear() {
        for (int i = 0; i < this.length(); ++i) {
            this.counts()[i] = 0L;
        }
    }

    public void add(T value, long count) {
        block0: {
            int i = this.indexOf(value);
            if (i == -1) break block0;
            this.counts()[i] = this.counts()[i] + count;
        }
    }

    public long add$default$2() {
        return 1L;
    }

    public int directIndex(long value) {
        return this.binning.directIndex(value);
    }

    public int indexOf(T value) {
        return this.binning.indexOf(value);
    }

    public T medianValue(int index) {
        return this.binning.medianValue(index);
    }

    public Tuple2<T, T> bounds(int index) {
        return this.binning.bounds(index);
    }

    public boolean isBelow(T value) {
        return this.binning.isBelow(value);
    }

    public BinnedArray(Binning<T> binning) {
        this.binning = binning;
        this.counts = (long[])Array$.MODULE$.fill(this.length(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long());
    }

    public static abstract class Binning<T> {
        private final int length;
        private final Tuple2<T, T> bounds;

        public int length() {
            return this.length;
        }

        public Tuple2<T, T> bounds() {
            return this.bounds;
        }

        public abstract int directIndex(long var1);

        public abstract int indexOf(T var1);

        public abstract T medianValue(int var1);

        public abstract Tuple2<T, T> bounds(int var1);

        public abstract boolean isBelow(T var1);

        public Binning(int length, Tuple2<T, T> bounds) {
            this.length = length;
            this.bounds = bounds;
        }
    }

    public static class DateBinning
    extends WholeNumberBinning<Date> {
        @Override
        public long convertToLong(Date value) {
            return value.getTime();
        }

        @Override
        public Date convertFromLong(long value) {
            return new Date(value);
        }

        public DateBinning(int length, Tuple2<Date, Date> bounds) {
            super(length, bounds);
        }
    }

    public static class DoubleBinning
    extends Binning<Double> {
        private final Tuple2<Double, Double> bounds;
        private final double binSize;

        private double binSize() {
            return this.binSize;
        }

        @Override
        public int directIndex(long value) {
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Double value) {
            void var2_2;
            int i;
            return Predef$.MODULE$.Double2double(value) < Predef$.MODULE$.Double2double((Double)this.bounds._1()) || Predef$.MODULE$.Double2double(value) > Predef$.MODULE$.Double2double((Double)this.bounds._2()) ? -1 : ((i = (int)package$.MODULE$.floor((Predef$.MODULE$.Double2double(value) - Predef$.MODULE$.Double2double((Double)this.bounds._1())) / this.binSize())) < 0 || i > super.length() ? -1 : (i == super.length() ? super.length() - 1 : var2_2));
        }

        @Override
        public Double medianValue(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double((Double)this.bounds._1()) + this.binSize() / (double)2 + this.binSize() * (double)index);
        }

        @Override
        public Tuple2<Double, Double> bounds(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return new Tuple2((Object)Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double((Double)this.bounds._1()) + this.binSize() * (double)index), (Object)Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double((Double)this.bounds._1()) + this.binSize() * (double)(index + 1)));
        }

        @Override
        public boolean isBelow(Double value) {
            return Predef$.MODULE$.Double2double(value) < Predef$.MODULE$.Double2double((Double)this.bounds._1());
        }

        public DoubleBinning(int length, Tuple2<Double, Double> bounds) {
            this.bounds = bounds;
            super(length, bounds);
            Predef$.MODULE$.require(Predef$.MODULE$.Double2double((Double)bounds._1()) < Predef$.MODULE$.Double2double((Double)bounds._2()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Upper bound must be greater than lower bound: lower='").append($this.bounds._1()).append("' upper='").append($this.bounds._2()).append("'").toString());
            this.binSize = (Predef$.MODULE$.Double2double((Double)bounds._2()) - Predef$.MODULE$.Double2double((Double)bounds._1())) / (double)super.length();
        }
    }

    public static class FloatBinning
    extends Binning<Float> {
        private final Tuple2<Float, Float> bounds;
        private final float binSize;

        private float binSize() {
            return this.binSize;
        }

        @Override
        public int directIndex(long value) {
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Float value) {
            void var2_2;
            int i;
            return Predef$.MODULE$.Float2float(value) < Predef$.MODULE$.Float2float((Float)this.bounds._1()) || Predef$.MODULE$.Float2float(value) > Predef$.MODULE$.Float2float((Float)this.bounds._2()) ? -1 : ((i = (int)package$.MODULE$.floor((double)((Predef$.MODULE$.Float2float(value) - Predef$.MODULE$.Float2float((Float)this.bounds._1())) / this.binSize()))) < 0 || i > super.length() ? -1 : (i == super.length() ? super.length() - 1 : var2_2));
        }

        @Override
        public Float medianValue(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float((Float)this.bounds._1()) + this.binSize() / (float)2 + this.binSize() * (float)index);
        }

        @Override
        public Tuple2<Float, Float> bounds(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return new Tuple2((Object)Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float((Float)this.bounds._1()) + this.binSize() * (float)index), (Object)Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float((Float)this.bounds._1()) + this.binSize() * (float)(index + 1)));
        }

        @Override
        public boolean isBelow(Float value) {
            return Predef$.MODULE$.Float2float(value) < Predef$.MODULE$.Float2float((Float)this.bounds._1());
        }

        public FloatBinning(int length, Tuple2<Float, Float> bounds) {
            this.bounds = bounds;
            super(length, bounds);
            Predef$.MODULE$.require(Predef$.MODULE$.Float2float((Float)bounds._1()) < Predef$.MODULE$.Float2float((Float)bounds._2()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Upper bound must be greater than lower bound: lower='").append($this.bounds._1()).append("' upper='").append($this.bounds._2()).append("'").toString());
            this.binSize = (Predef$.MODULE$.Float2float((Float)bounds._2()) - Predef$.MODULE$.Float2float((Float)bounds._1())) / (float)super.length();
        }
    }

    public static class GeometryBinning
    extends WholeNumberBinning<Geometry> {
        @Override
        public long convertToLong(Geometry value) {
            Point point;
            Geometry geometry = value;
            Point point2 = geometry instanceof Point ? (point = (Point)geometry) : Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geometry));
            Point centroid = point2;
            return Z2SFC$.MODULE$.index(centroid.getX(), centroid.getY(), true);
        }

        @Override
        public Geometry convertFromLong(long value) {
            Tuple2 tuple2 = Z2SFC$.MODULE$.invert(value);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double x = tuple2._1$mcD$sp();
            double y = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
            Tuple2.mcDD.sp sp3 = sp2;
            double x2 = sp3._1$mcD$sp();
            double y2 = sp3._2$mcD$sp();
            return GeometryUtils$.MODULE$.geoFactory().createPoint(new Coordinate(x2, y2));
        }

        public GeometryBinning(int length, Tuple2<Geometry, Geometry> bounds) {
            super(length, bounds);
        }
    }

    public static class IntBinning
    extends WholeNumberBinning<Integer> {
        @Override
        public long convertToLong(Integer value) {
            return Predef$.MODULE$.Integer2int(value);
        }

        @Override
        public Integer convertFromLong(long value) {
            return Predef$.MODULE$.int2Integer((int)value);
        }

        public IntBinning(int length, Tuple2<Integer, Integer> bounds) {
            super(length, bounds);
        }
    }

    public static class LongBinning
    extends WholeNumberBinning<Long> {
        @Override
        public long convertToLong(Long value) {
            return Predef$.MODULE$.Long2long(value);
        }

        @Override
        public Long convertFromLong(long value) {
            return Predef$.MODULE$.long2Long(value);
        }

        public LongBinning(int length, Tuple2<Long, Long> bounds) {
            super(length, bounds);
        }
    }

    public static class StringBinning
    extends WholeNumberBinning<String> {
        private Tuple2<String, String> x$2;
        private String start;
        private String end;
        private int normalizedLength;
        private int prefixLength;
        private String prefix;
        private volatile byte bitmap$0;

        private Tuple2<String, String> x$2$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    Tuple2 tuple2 = this.bounds();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String start = (String)tuple2._1();
                    String end = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)start, (Object)end);
                    this.x$2 = tuple22;
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.x$2;
        }

        private /* synthetic */ Tuple2 x$2() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.x$2$lzycompute() : this.x$2;
        }

        private String start$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.start = (String)this.x$2()._1();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.start;
        }

        private String start() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.start$lzycompute() : this.start;
        }

        private String end$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.end = (String)this.x$2()._2();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.end;
        }

        private String end() {
            return (byte)(this.bitmap$0 & 4) == 0 ? this.end$lzycompute() : this.end;
        }

        private int normalizedLength$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.normalizedLength = this.start().length();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.normalizedLength;
        }

        private int normalizedLength() {
            return (byte)(this.bitmap$0 & 8) == 0 ? this.normalizedLength$lzycompute() : this.normalizedLength;
        }

        private int prefixLength$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.prefixLength = ((GenSeqLike)new StringOps(Predef$.MODULE$.augmentString(this.start())).zip((GenIterable)Predef$.MODULE$.wrapString(this.end()), Predef$.MODULE$.fallbackStringCanBuildFrom())).indexWhere((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StringBinning.$anonfun$prefixLength$1(x0$1)));
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.prefixLength;
        }

        private int prefixLength() {
            return (byte)(this.bitmap$0 & 0x10) == 0 ? this.prefixLength$lzycompute() : this.prefixLength;
        }

        private String prefix$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.prefix = this.start().substring(0, this.prefixLength());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.prefix;
        }

        private String prefix() {
            return (byte)(this.bitmap$0 & 0x20) == 0 ? this.prefix$lzycompute() : this.prefix;
        }

        @Override
        public long convertToLong(String value) {
            long l;
            String normalized = (String)new StringOps(Predef$.MODULE$.augmentString(BinnedArray$StringBinning$.MODULE$.normalize(value))).padTo(this.normalizedLength(), (Object)BoxesRunTime.boxToCharacter((char)'0'), Predef$.MODULE$.StringCanBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(normalized)).$less((Object)this.start())) {
                l = 0L;
            } else if (new StringOps(Predef$.MODULE$.augmentString(normalized)).$greater((Object)this.end())) {
                l = Long.MAX_VALUE;
            } else {
                String sigDigits = ((String)new StringOps(Predef$.MODULE$.augmentString(normalized.substring(this.prefixLength()))).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)BinnedArray$StringBinning$.MODULE$.Base36Lowest()), Predef$.MODULE$.StringCanBuildFrom())).substring(0, 12);
                l = Long.parseLong(sigDigits, 36);
            }
            return l;
        }

        @Override
        public String convertFromLong(long value) {
            return new StringBuilder(0).append(this.prefix()).append(((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(Long.toString(value, 36))).reverse())).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)BinnedArray$StringBinning$.MODULE$.Base36Lowest()), Predef$.MODULE$.StringCanBuildFrom()))).reverse()).replaceFirst("0+$", "")).toString();
        }

        public static final /* synthetic */ boolean $anonfun$prefixLength$1(Tuple2 x0$1) {
            char r;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            char l = tuple2._1$mcC$sp();
            boolean bl = l != (r = tuple2._2$mcC$sp());
            return bl;
        }

        public StringBinning(int length, Tuple2<String, String> rawBounds) {
            super(length, BinnedArray$StringBinning$.MODULE$.normalizeBounds(rawBounds));
        }
    }

    public static abstract class WholeNumberBinning<T>
    extends Binning<T> {
        private final Tuple2<T, T> bounds;
        private final long min;
        private final long max;
        private final double binSize;

        private long min() {
            return this.min;
        }

        private long max() {
            return this.max;
        }

        private double binSize() {
            return this.binSize;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int directIndex(long value) {
            void var3_2;
            int i;
            return value < this.min() || value > this.max() ? -1 : ((i = (int)package$.MODULE$.floor((double)(value - this.min()) / this.binSize())) < 0 || i > super.length() ? -1 : (i == super.length() ? super.length() - 1 : var3_2));
        }

        @Override
        public int indexOf(T value) {
            return this.directIndex(this.convertToLong(value));
        }

        @Override
        public T medianValue(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            long l = this.min() + package$.MODULE$.round(this.binSize() / (double)2 + this.binSize() * (double)index);
            return (T)(l > this.max() ? this.bounds._2() : this.convertFromLong(l));
        }

        @Override
        public Tuple2<T, T> bounds(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            long loLong = this.min() + (long)package$.MODULE$.ceil(this.binSize() * (double)index);
            long hiLong = package$.MODULE$.max(loLong, this.min() + (long)package$.MODULE$.floor(this.binSize() * (double)(index + 1)));
            Object lo = loLong <= this.min() ? this.bounds._1() : this.convertFromLong(loLong);
            Object hi = hiLong >= this.max() ? this.bounds._2() : this.convertFromLong(hiLong);
            return new Tuple2(lo, hi);
        }

        @Override
        public boolean isBelow(T value) {
            return this.convertToLong(value) < this.min();
        }

        public abstract long convertToLong(T var1);

        public abstract T convertFromLong(long var1);

        public WholeNumberBinning(int length, Tuple2<T, T> bounds) {
            this.bounds = bounds;
            super(length, bounds);
            this.min = this.convertToLong(bounds._1());
            this.max = this.convertToLong(bounds._2());
            Predef$.MODULE$.require(this.min() < this.max(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Upper bound must be greater than lower bound: lower='").append($this.bounds._1()).append("'(").append(this.min()).append(") upper='").append($this.bounds._2()).append("'(").append(this.max()).append(")").toString());
            this.binSize = (double)(this.max() - this.min()) / (double)super.length();
        }
    }
}

