/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.commons.text.StringEscapeUtils;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.StatParser$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Stat$ {
    public static Stat$ MODULE$;
    private final JsonSerializer<Map<Object, Object>> ScalaMapSerializer;
    private final JsonSerializer<Seq<Object>> ScalaSeqSerializer;
    private final JsonSerializer<Stat> StatSerializer;
    private final JsonSerializer<Geometry> GeometrySerializer;
    private final JsonSerializer<Date> DateSerializer;
    private final JsonSerializer<Double> DoubleSerializer;
    private final JsonSerializer<Float> FloatSerializer;
    private final Gson org$locationtech$geomesa$utils$stats$Stat$$JSON;

    static {
        new Stat$();
    }

    private JsonSerializer<Map<Object, Object>> ScalaMapSerializer() {
        return this.ScalaMapSerializer;
    }

    private JsonSerializer<Seq<Object>> ScalaSeqSerializer() {
        return this.ScalaSeqSerializer;
    }

    private JsonSerializer<Stat> StatSerializer() {
        return this.StatSerializer;
    }

    private JsonSerializer<Geometry> GeometrySerializer() {
        return this.GeometrySerializer;
    }

    private JsonSerializer<Date> DateSerializer() {
        return this.DateSerializer;
    }

    private JsonSerializer<Double> DoubleSerializer() {
        return this.DoubleSerializer;
    }

    private JsonSerializer<Float> FloatSerializer() {
        return this.FloatSerializer;
    }

    public Gson org$locationtech$geomesa$utils$stats$Stat$$JSON() {
        return this.org$locationtech$geomesa$utils$stats$Stat$$JSON;
    }

    public Stat apply(SimpleFeatureType sft, String s) {
        return StatParser$.MODULE$.parse(sft, s, StatParser$.MODULE$.parse$default$3());
    }

    public String Count() {
        return "Count()";
    }

    public String MinMax(String attribute) {
        return new StringBuilder(8).append("MinMax(").append(this.safeString(attribute)).append(")").toString();
    }

    public String Enumeration(String attribute) {
        return new StringBuilder(13).append("Enumeration(").append(this.safeString(attribute)).append(")").toString();
    }

    public String TopK(String attribute) {
        return new StringBuilder(6).append("TopK(").append(this.safeString(attribute)).append(")").toString();
    }

    public String Frequency(String attribute, int precision) {
        return new StringBuilder(12).append("Frequency(").append(this.safeString(attribute)).append(",").append(precision).append(")").toString();
    }

    public String Frequency(String attribute, String dtg, Enumeration.Value period, int precision) {
        return new StringBuilder(14).append("Frequency(").append(this.safeString(attribute)).append(",").append(this.safeString(dtg)).append(",").append(period).append(",").append(precision).append(")").toString();
    }

    public String Z3Frequency(String geom, String dtg, Enumeration.Value period, int precision) {
        return new StringBuilder(16).append("Z3Frequency(").append(this.safeString(geom)).append(",").append(this.safeString(dtg)).append(",").append(period).append(",").append(precision).append(")").toString();
    }

    public <T> String Histogram(String attribute, int bins, T min, T max, ClassTag<T> ct) {
        Function1<Object, String> stringify = this.stringifier(ct.runtimeClass(), this.stringifier$default$2());
        return new StringBuilder(14).append("Histogram(").append(this.safeString(attribute)).append(",").append(bins).append(",").append(this.safeString((String)stringify.apply(min))).append(",").append(this.safeString((String)stringify.apply(max))).append(")").toString();
    }

    public String Z3Histogram(String geom, String dtg, Enumeration.Value period, int length) {
        return new StringBuilder(16).append("Z3Histogram(").append(this.safeString(geom)).append(",").append(this.safeString(dtg)).append(",").append(period).append(",").append(length).append(")").toString();
    }

    public String IteratorStackCount() {
        return "IteratorStackCount()";
    }

    public String SeqStat(Seq<String> stats) {
        return stats.mkString(";");
    }

    public String GroupBy(String attribute, String groupedStat) {
        return new StringBuilder(10).append("GroupBy(").append(this.safeString(attribute)).append(",").append(groupedStat).append(")").toString();
    }

    public String DescriptiveStats(Seq<String> attributes) {
        return new StringBuilder(18).append("DescriptiveStats(").append(((TraversableOnce)attributes.map((Function1 & Serializable & scala.Serializable)s -> MODULE$.safeString((String)s), Seq$.MODULE$.canBuildFrom())).mkString(",")).append(")").toString();
    }

    public <T extends Stat> Option<T> combine(Seq<T> stats) {
        Option option;
        if (stats.length() < 2) {
            option = stats.headOption();
        } else {
            Stat summed = ((Stat)stats.head()).$plus((Stat)((IterableLike)stats.tail()).head(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
            ((IterableLike)stats.drop(2)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                summed.$plus$eq(x$1, Predef.DummyImplicit$.MODULE$.dummyImplicit());
                return BoxedUnit.UNIT;
            });
            option = new Some((Object)summed);
        }
        return option;
    }

    private String safeString(String s) {
        return new StringBuilder(2).append("\"").append(StringEscapeUtils.escapeJava((String)s)).append("\"").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> Function1<Object, String> stringifier(Class<T> clas, boolean json) {
        Function1 & Serializable & scala.Serializable intersect;
        Function1 & Serializable & scala.Serializable toString;
        Function1 & Serializable & scala.Serializable intersect2 = Geometry.class.isAssignableFrom(clas) ? (Function1 & Serializable & scala.Serializable)v -> WKTUtils$.MODULE$.write((Geometry)v) : (toString = Date.class.isAssignableFrom(clas) ? (Function1 & Serializable & scala.Serializable)v -> package$.MODULE$.GeoToolsDateFormat().format(DateUtils$.MODULE$.toInstant((Date)v)) : (Function1 & Serializable & scala.Serializable)v -> v.toString());
        if (json && !Number.class.isAssignableFrom(clas)) {
            Class<T> clazz = clas;
            Class<Boolean> clazz2 = Boolean.class;
            if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                intersect = (Function1 & Serializable & scala.Serializable)v -> v == null ? "null" : new StringBuilder(2).append("\"").append(toString.apply(v)).append("\"").toString();
                return intersect;
            }
        }
        intersect = (Function1 & Serializable & scala.Serializable)v -> v == null ? "null" : (String)toString.apply(v);
        return intersect;
    }

    public <T> boolean stringifier$default$2() {
        return false;
    }

    public <T> Function1<String, T> destringifier(Class<T> clas) {
        Function1 & Serializable & scala.Serializable intersect;
        Class<T> clazz = clas;
        Class<String> clazz2 = String.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)s -> {
                String string = s;
                String string2 = "null";
                return !(string != null ? !string.equals(string2) : string2 != null) ? null : s;
            };
        } else {
            Class<T> clazz3 = clas;
            Class<Integer> clazz4 = Integer.class;
            if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                    String string = s;
                    String string2 = "null";
                    return !(string != null ? !string.equals(string2) : string2 != null) ? null : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s)).toInt());
                };
            } else {
                Class<T> clazz5 = clas;
                Class<Long> clazz6 = Long.class;
                if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)s -> {
                        String string = s;
                        String string2 = "null";
                        return !(string != null ? !string.equals(string2) : string2 != null) ? null : BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s)).toLong());
                    };
                } else {
                    Class<T> clazz7 = clas;
                    Class<Float> clazz8 = Float.class;
                    if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)s -> {
                            String string = s;
                            String string2 = "null";
                            return !(string != null ? !string.equals(string2) : string2 != null) ? null : BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(s)).toFloat());
                        };
                    } else {
                        Class<T> clazz9 = clas;
                        Class<Double> clazz10 = Double.class;
                        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                String string = s;
                                String string2 = "null";
                                return !(string != null ? !string.equals(string2) : string2 != null) ? null : BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(s)).toDouble());
                            };
                        } else {
                            Class<T> clazz11 = clas;
                            Class<Boolean> clazz12 = Boolean.class;
                            if (!(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    String string = s;
                                    String string2 = "null";
                                    return !(string != null ? !string.equals(string2) : string2 != null) ? null : BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).toBoolean());
                                };
                            } else if (Geometry.class.isAssignableFrom(clas)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    String string = s;
                                    String string2 = "null";
                                    return !(string != null ? !string.equals(string2) : string2 != null) ? null : WKTUtils$.MODULE$.read((String)s);
                                };
                            } else if (Date.class.isAssignableFrom(clas)) {
                                intersect = (Function1 & Serializable & scala.Serializable)s -> {
                                    String string = s;
                                    String string2 = "null";
                                    return !(string != null ? !string.equals(string2) : string2 != null) ? null : Date.from(LocalDateTime.parse(s, package$.MODULE$.GeoToolsDateFormat()).toInstant(ZoneOffset.UTC));
                                };
                            } else {
                                throw new RuntimeException(new StringBuilder(45).append("Unexpected class binding for stat attribute: ").append(clas).toString());
                            }
                        }
                    }
                }
            }
        }
        return intersect;
    }

    private Stat$() {
        MODULE$ = this;
        this.ScalaMapSerializer = new JsonSerializer<Map<Object, Object>>(){

            public JsonElement serialize(Map<Object, Object> s, Type t, JsonSerializationContext jsc) {
                return jsc.serialize(JavaConverters$.MODULE$.mapAsJavaMapConverter(s).asJava());
            }
        };
        this.ScalaSeqSerializer = new JsonSerializer<Seq<Object>>(){

            public JsonElement serialize(Seq<Object> s, Type t, JsonSerializationContext jsc) {
                return jsc.serialize(JavaConverters$.MODULE$.seqAsJavaListConverter(s).asJava());
            }
        };
        this.StatSerializer = new JsonSerializer<Stat>(){

            public JsonElement serialize(Stat s, Type t, JsonSerializationContext jsc) {
                return jsc.serialize(s.toJsonObject());
            }
        };
        this.GeometrySerializer = new JsonSerializer<Geometry>(){

            public JsonElement serialize(Geometry g, Type t, JsonSerializationContext jsc) {
                return new JsonPrimitive(WKTUtils$.MODULE$.write(g));
            }
        };
        this.DateSerializer = new JsonSerializer<Date>(){

            public JsonElement serialize(Date d, Type t, JsonSerializationContext jsc) {
                return new JsonPrimitive(package$.MODULE$.GeoToolsDateFormat().format(DateUtils$.MODULE$.toInstant(d)));
            }
        };
        this.DoubleSerializer = new JsonSerializer<Double>(){

            public JsonElement serialize(Double d, Type t, JsonSerializationContext jsc) {
                Double d2 = d;
                Object object = Double.isNaN(Predef$.MODULE$.Double2double(d2)) ? JsonNull.INSTANCE : (BoxesRunTime.equalsNumObject((Number)d2, (Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)) ? new JsonPrimitive("Infinity") : (BoxesRunTime.equalsNumObject((Number)d2, (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)) ? new JsonPrimitive("+Infinity") : new JsonPrimitive((Number)d)));
                return object;
            }
        };
        this.FloatSerializer = new JsonSerializer<Float>(){

            public JsonElement serialize(Float f, Type t, JsonSerializationContext jsc) {
                Float f2 = f;
                Object object = Float.isNaN(Predef$.MODULE$.Float2float(f2)) ? JsonNull.INSTANCE : (BoxesRunTime.equalsNumObject((Number)f2, (Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)) ? new JsonPrimitive("Infinity") : (BoxesRunTime.equalsNumObject((Number)f2, (Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)) ? new JsonPrimitive("+Infinity") : new JsonPrimitive((Number)f)));
                return object;
            }
        };
        this.org$locationtech$geomesa$utils$stats$Stat$$JSON = new GsonBuilder().serializeNulls().registerTypeAdapter(Double.TYPE, this.DoubleSerializer()).registerTypeAdapter(Double.class, this.DoubleSerializer()).registerTypeAdapter(Float.TYPE, this.FloatSerializer()).registerTypeAdapter(Float.class, this.FloatSerializer()).registerTypeHierarchyAdapter(Stat.class, this.StatSerializer()).registerTypeHierarchyAdapter(Geometry.class, this.GeometrySerializer()).registerTypeHierarchyAdapter(Date.class, this.DateSerializer()).registerTypeHierarchyAdapter(Map.class, this.ScalaMapSerializer()).registerTypeHierarchyAdapter(Seq.class, this.ScalaSeqSerializer()).create();
    }
}

