/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.StatParser;
import org.opengis.feature.simple.SimpleFeatureType;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.ParsingException;
import org.parboiled.scala.ParsingResult;
import org.parboiled.scala.ParsingResult$;
import org.parboiled.scala.package$;
import org.parboiled.scala.parserunners.ReportingParseRunner;
import scala.Function0;
import scala.Serializable;
import scala.collection.Seq;

public final class StatParser$ {
    public static StatParser$ MODULE$;
    private final StatParser Parser;
    private final ThreadLocal<SimpleFeatureType> sfts;

    static {
        new StatParser$();
    }

    private StatParser Parser() {
        return this.Parser;
    }

    private ThreadLocal<SimpleFeatureType> sfts() {
        return this.sfts;
    }

    public Stat parse(SimpleFeatureType sft, String stat, boolean report) throws ParsingException {
        Stat stat2;
        if (stat == null) {
            throw new IllegalArgumentException("Stat must not be null");
        }
        ReportingParseRunner runner = report ? package$.MODULE$.ReportingParseRunner().apply(this.Parser().stat()) : package$.MODULE$.BasicParseRunner().apply(this.Parser().stat());
        this.sfts().set(sft);
        try {
            ParsingResult parsing = runner.run(package$.MODULE$.string2Input(stat));
            stat2 = (Stat)parsing.result().getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
                throw new ParsingException(new StringBuilder(21).append("Invalid stat string: ").append(ErrorUtils.printParseErrors((org.parboiled.support.ParsingResult)ParsingResult$.MODULE$.unwrap(parsing))).toString());
            });
        }
        finally {
            this.sfts().remove();
        }
        return stat2;
    }

    public boolean parse$default$3() {
        return true;
    }

    public Seq<String> propertyNames(SimpleFeatureType sft, String stat, boolean report) throws ParsingException {
        Seq seq;
        if (stat == null) {
            throw new IllegalArgumentException("Stat must not be null");
        }
        ReportingParseRunner runner = report ? package$.MODULE$.ReportingParseRunner().apply(this.Parser().attributes()) : package$.MODULE$.BasicParseRunner().apply(this.Parser().attributes());
        this.sfts().set(sft);
        try {
            ParsingResult parsing = runner.run(package$.MODULE$.string2Input(stat));
            seq = (Seq)parsing.result().getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
                throw new ParsingException(new StringBuilder(21).append("Invalid stat string: ").append(ErrorUtils.printParseErrors((org.parboiled.support.ParsingResult)ParsingResult$.MODULE$.unwrap(parsing))).toString());
            });
        }
        finally {
            this.sfts().remove();
        }
        return seq;
    }

    public boolean propertyNames$default$3() {
        return true;
    }

    public SimpleFeatureType org$locationtech$geomesa$utils$stats$StatParser$$sft() {
        return this.sfts().get();
    }

    private StatParser$() {
        MODULE$ = this;
        this.Parser = new StatParser();
        this.sfts = new ThreadLocal();
    }
}

