/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.Frequency$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Z3Frequency$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001\u0002\u00192\u0001qB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t;\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003a\u0011!a\u0007A!b\u0001\n\u0003y\u0006\u0002C7\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u00119\u0004!Q1A\u0005\u0002=D\u0011\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0015\u0005\u0015\u0001A!b\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0011)A\u0005\u0003\u0013A!\"!\u0005\u0001\u0005\u000b\u0007I\u0011AA\n\u0011)\tY\u0002\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003;\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\rRABA\u001b\u0001\u0001\n)\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011\u0011\b\u0001!\u0002\u0013\tI\u0001C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011Q\b\u0001!\u0002\u0013\tI\u0001C\u0005\u0002@\u0001\u0011\r\u0011\"\u0003\u0002B!A\u0011\u0011\n\u0001!\u0002\u0013\t\u0019\u0005C\u0005\u0002L\u0001\u0011\r\u0011\"\u0003\u0002N!A\u0011q\u000b\u0001!\u0002\u0013\ty\u0005C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\!A\u00111\u000e\u0001!\u0002\u0013\ti\u0006\u0003\u0006\u0002n\u0001\u0011\r\u0011\"\u00012\u0003_B\u0001\"a%\u0001A\u0003%\u0011\u0011\u000f\u0005\t\u0003+\u0003A\u0011A\u0019\u0002\u0018\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011\u001d\tI\u000e\u0001C\u0001\u0003\u0003Bq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002t\u0002!\t%!>\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u000b\u0001\u0011\u0005#q\u0003\u0005\b\u00057\u0001A\u0011\tB\u000f\u0011\u001d\u0011y\u0002\u0001C!\u0005CAqA!\u000b\u0001\t\u0003\u0012Y\u0003C\u0004\u00034\u0001!\tE!\u000e\b\u0013\te\u0012'!A\t\u0002\tmb\u0001\u0003\u00192\u0003\u0003E\tA!\u0010\t\u000f\u0005\u0005B\u0006\"\u0001\u0003@!I!\u0011\t\u0017\u0012\u0002\u0013\u0005!1\t\u0005\n\u00053b\u0013\u0013!C\u0001\u0005\u0007\u00121BW\u001aGe\u0016\fX/\u001a8ds*\u0011!gM\u0001\u0006gR\fGo\u001d\u0006\u0003iU\nQ!\u001e;jYNT!AN\u001c\u0002\u000f\u001d,w.\\3tC*\u0011\u0001(O\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002u\u0005\u0019qN]4\u0004\u0001M!\u0001!P\"H!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fMB\u0011A)R\u0007\u0002c%\u0011a)\r\u0002\u0005'R\fG\u000f\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006a1oY1mC2|wmZ5oO*\u0011A*T\u0001\tif\u0004Xm]1gK*\ta*A\u0002d_6L!\u0001U%\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0004g\u001a$X#A*\u0011\u0005Q[V\"A+\u000b\u0005Y;\u0016AB:j[BdWM\u0003\u0002Y3\u00069a-Z1ukJ,'B\u0001.:\u0003\u001dy\u0007/\u001a8hSNL!\u0001X+\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0003tMR\u0004\u0013\u0001B4f_6,\u0012\u0001\u0019\t\u0003C\"t!A\u00194\u0011\u0005\r|T\"\u00013\u000b\u0005\u0015\\\u0014A\u0002\u001fs_>$h(\u0003\u0002h\u007f\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t9w(A\u0003hK>l\u0007%A\u0002ei\u001e\fA\u0001\u001a;hA\u00051\u0001/\u001a:j_\u0012,\u0012\u0001\u001d\t\u0003czt!A]>\u000f\u0005MLhB\u0001;y\u001d\t)xO\u0004\u0002dm&\t!(\u0003\u00029s%\u0011agN\u0005\u0003uV\nQaY;sm\u0016L!\u0001`?\u0002\u0015QKW.\u001a)fe&|GM\u0003\u0002{k%\u0019q0!\u0001\u0003\u0015QKW.\u001a)fe&|GM\u0003\u0002}{\u00069\u0001/\u001a:j_\u0012\u0004\u0013!\u00039sK\u000eL7/[8o+\t\tI\u0001E\u0002?\u0003\u0017I1!!\u0004@\u0005\rIe\u000e^\u0001\u000baJ,7-[:j_:\u0004\u0013aA3qgV\u0011\u0011Q\u0003\t\u0004}\u0005]\u0011bAA\r\u007f\t1Ai\\;cY\u0016\fA!\u001a9tA\u0005Q1m\u001c8gS\u0012,gnY3\u0002\u0017\r|gNZ5eK:\u001cW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0002C\u0001#\u0001\u0011\u0015\tv\u00021\u0001T\u0011\u0015qv\u00021\u0001a\u0011\u0015aw\u00021\u0001a\u0011\u0015qw\u00021\u0001q\u0011\u001d\t)a\u0004a\u0001\u0003\u0013A\u0011\"!\u0005\u0010!\u0003\u0005\r!!\u0006\t\u0013\u0005uq\u0002%AA\u0002\u0005U!!A*\u0002\u0003\u001d\f!a\u001a\u0011\u0002\u0003\u0011\f!\u0001\u001a\u0011\u0002\t5\f7o[\u000b\u0003\u0003\u0007\u00022APA#\u0013\r\t9e\u0010\u0002\u0005\u0019>tw-A\u0003nCN\\\u0007%A\u0002tM\u000e,\"!a\u0014\u0011\t\u0005E\u00131K\u0007\u0002{&\u0019\u0011QK?\u0003\u000bi\u001b4KR\"\u0002\tM47\rI\u0001\ni&lW\rV8CS:,\"!!\u0018\u0011\t\u0005}\u0013Q\r\b\u0005\u0003#\n\t'C\u0002\u0002du\f!BQ5o]\u0016$G+[7f\u0013\u0011\t9'!\u001b\u0003!QKW.\u001a+p\u0005&tg.\u001a3US6,'bAA2{\u0006QA/[7f)>\u0014\u0015N\u001c\u0011\u0002\u0011M\\W\r^2iKN,\"!!\u001d\u0011\u0011\u0005M\u0014QPAA\u0003\u000fk!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\b[V$\u0018M\u00197f\u0015\r\tYhP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA@\u0003k\u00121!T1q!\rq\u00141Q\u0005\u0004\u0003\u000b{$!B*i_J$\b\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u000555'A\u0006dY\u0016\f'o\u001d9sS:<\u0017\u0002BAI\u0003\u0017\u0013abQ8v]Rl\u0015N\\*lKR\u001c\u0007.A\u0005tW\u0016$8\r[3tA\u0005Ia.Z<TW\u0016$8\r[\u000b\u0003\u0003\u000f\u000bQ\u0001^8LKf$b!!(\u0002$\u0006M\u0006c\u0002 \u0002 \u0006\u0005\u00151I\u0005\u0004\u0003C{$A\u0002+va2,'\u0007\u0003\u0004_=\u0001\u0007\u0011Q\u0015\t\u0005\u0003O\u000by+\u0004\u0002\u0002**\u0019a,a+\u000b\u0007\u00055v'A\u0002kiNLA!!-\u0002*\nAq)Z8nKR\u0014\u0018\u0010\u0003\u0004m=\u0001\u0007\u0011Q\u0017\t\u0005\u0003o\u000b\t-\u0004\u0002\u0002:*!\u00111XA_\u0003\u0011)H/\u001b7\u000b\u0005\u0005}\u0016\u0001\u00026bm\u0006LA!a1\u0002:\n!A)\u0019;f\u0003\u0015\u0019w.\u001e8u)\u0019\t\u0019%!3\u0002L\"1al\ba\u0001\u0003KCa\u0001\\\u0010A\u0002\u0005U\u0016aC2pk:$H)\u001b:fGR$b!a\u0011\u0002R\u0006U\u0007bBAjA\u0001\u0007\u0011\u0011Q\u0001\u0004E&t\u0007bBAlA\u0001\u0007\u00111I\u0001\u0003uN\nAa]5{K\u0006Y1\u000f\u001d7ji\nKH+[7f+\t\ty\u000e\u0005\u0004\u0002b\u0006-\u0018\u0011\u001f\b\u0005\u0003G\f9OD\u0002d\u0003KL\u0011\u0001Q\u0005\u0004\u0003S|\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003[\fyOA\u0002TKFT1!!;@!\u001dq\u0014qTAA\u0003K\tqa\u001c2tKJ4X\r\u0006\u0003\u0002x\u0006u\bc\u0001 \u0002z&\u0019\u00111` \u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u007f\u001c\u0003\u0019\u0001B\u0001\u0003\t\u0019h\rE\u0002U\u0005\u0007I1A!\u0002V\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0006IQO\\8cg\u0016\u0014h/\u001a\u000b\u0005\u0003o\u0014Y\u0001C\u0004\u0002\u0000\u0012\u0002\rA!\u0001\u0002\u000b\u0011\u0002H.^:\u0015\t\u0005\u0015\"\u0011\u0003\u0005\b\u0005')\u0003\u0019AA\u0013\u0003\u0015yG\u000f[3s\u0003!!\u0003\u000f\\;tI\u0015\fH\u0003BA|\u00053AqAa\u0005'\u0001\u0004\t)#A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002x\u00069\u0011n]#naRLXC\u0001B\u0012!\rq$QE\u0005\u0004\u0005Oy$a\u0002\"p_2,\u0017M\\\u0001\ri>T5o\u001c8PE*,7\r^\u000b\u0003\u0005[\u00012A\u0010B\u0018\u0013\r\u0011\td\u0010\u0002\u0004\u0003:L\u0018\u0001D5t\u000bF,\u0018N^1mK:$H\u0003\u0002B\u0012\u0005oAaAa\u0005+\u0001\u0004\u0019\u0015a\u0003.4\rJ,\u0017/^3oGf\u0004\"\u0001\u0012\u0017\u0014\u00051jDC\u0001B\u001e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!Q\t\u0016\u0005\u0003+\u00119e\u000b\u0002\u0003JA!!1\nB+\u001b\t\u0011iE\u0003\u0003\u0003P\tE\u0013!C;oG\",7m[3e\u0015\r\u0011\u0019fP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B,\u0005\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0001")
public class Z3Frequency
implements Stat,
LazyLogging {
    private final SimpleFeatureType sft;
    private final String geom;
    private final String dtg;
    private final Enumeration.Value period;
    private final int precision;
    private final double eps;
    private final double confidence;
    private final int g;
    private final int d;
    private final long mask;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Map<Object, CountMinSketch> sketches;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static double $lessinit$greater$default$7() {
        return Z3Frequency$.MODULE$.$lessinit$greater$default$7();
    }

    public static double $lessinit$greater$default$6() {
        return Z3Frequency$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat.$plus$eq$(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat.$plus$(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat.toJson$(this);
    }

    private Logger logger$lzycompute() {
        Z3Frequency z3Frequency = this;
        synchronized (z3Frequency) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String geom() {
        return this.geom;
    }

    public String dtg() {
        return this.dtg;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int precision() {
        return this.precision;
    }

    public double eps() {
        return this.eps;
    }

    public double confidence() {
        return this.confidence;
    }

    private int g() {
        return this.g;
    }

    private int d() {
        return this.d;
    }

    private long mask() {
        return this.mask;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    public Map<Object, CountMinSketch> sketches() {
        return this.sketches;
    }

    public CountMinSketch newSketch() {
        return CountMinSketch$.MODULE$.apply(this.eps(), this.confidence(), Frequency$.MODULE$.Seed());
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short b = binnedTime.bin();
        long o = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)o));
        Tuple2 tuple22 = tuple2;
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long o2 = tuple22._2$mcJ$sp();
        Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
        long z = this.sfc().index(centroid.getX(), centroid.getY(), o2, this.sfc().index$default$4()) & this.mask();
        return new Tuple2((Object)BoxesRunTime.boxToShort((short)b2), (Object)BoxesRunTime.boxToLong((long)z));
    }

    public long count(Geometry geom, Date dtg) {
        Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long z3 = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)z3));
        Tuple2 tuple23 = tuple22;
        short bin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
        long z32 = tuple23._2$mcJ$sp();
        return this.countDirect(bin2, z32);
    }

    public long countDirect(short bin, long z3) {
        return BoxesRunTime.unboxToLong((Object)this.sketches().get((Object)BoxesRunTime.boxToShort((short)bin)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.estimateCount(z3))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.sketches().values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public Seq<Tuple2<Object, Z3Frequency>> splitByTime() {
        return (Seq)this.sketches().toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
            CountMinSketch sketch = (CountMinSketch)tuple2._2();
            Z3Frequency freq = new Z3Frequency(this.sft(), this.geom(), this.dtg(), this.period(), this.precision(), this.eps(), this.confidence());
            freq.sketches().put((Object)BoxesRunTime.boxToShort((short)w), (Object)sketch);
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)freq);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void observe(SimpleFeature sf) {
        block4: {
            Geometry geom = (Geometry)sf.getAttribute(this.g());
            Date dtg = (Date)sf.getAttribute(this.d());
            if (geom == null || dtg == null) break block4;
            try {
                Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                long z3 = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)z3));
                Tuple2 tuple23 = tuple22;
                short bin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                ((CountMinSketch)this.sketches().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)bin2), (Function0 & Serializable & scala.Serializable)() -> this.newSketch())).add(z32, 1L);
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
    }

    /*
     * WARNING - void declaration
     */
    public Z3Frequency $plus(Z3Frequency other) {
        void var2_2;
        Z3Frequency plus = new Z3Frequency(this.sft(), this.geom(), this.dtg(), this.period(), this.precision(), this.eps(), this.confidence());
        plus.$plus$eq(this);
        plus.$plus$eq(other);
        return var2_2;
    }

    public void $plus$eq(Z3Frequency other) {
        ((IterableLike)other.sketches().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Z3Frequency.$anonfun$$plus$eq$1(x$6)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Z3Frequency.$anonfun$$plus$eq$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void clear() {
        this.sketches().values().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.clear();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isEmpty() {
        return this.sketches().values().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Z3Frequency.$anonfun$isEmpty$1(x$8)));
    }

    @Override
    public Object toJsonObject() {
        Tuple2 tuple2 = (Tuple2)this.sketches().values().headOption().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2.mcDD.sp(s.eps(), s.confidence())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcDD.sp(0.0, 0.0));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double e = tuple2._1$mcD$sp();
        double c = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(e, c);
        Tuple2.mcDD.sp sp3 = sp2;
        double e2 = sp3._1$mcD$sp();
        double c2 = sp3._2$mcD$sp();
        return ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eps"), (Object)BoxesRunTime.boxToDouble((double)e2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confidence"), (Object)BoxesRunTime.boxToDouble((double)c2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToLong((long)this.size()))}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat = other;
        if (!(stat instanceof Z3Frequency)) return false;
        Z3Frequency z3Frequency = (Z3Frequency)stat;
        String string = this.geom();
        String string2 = z3Frequency.geom();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.dtg();
        String string4 = z3Frequency.dtg();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Enumeration.Value value = this.period();
        Enumeration.Value value2 = z3Frequency.period();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (this.precision() != z3Frequency.precision()) return false;
        Map nonEmpty = (Map)this.sketches().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Z3Frequency.$anonfun$isEquivalent$1(x$10)));
        Map sNonEmpty = (Map)z3Frequency.sketches().filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)Z3Frequency.$anonfun$isEquivalent$2(x$11)));
        Iterable iterable = nonEmpty.keys();
        Iterable iterable2 = sNonEmpty.keys();
        if (iterable == null) {
            if (iterable2 != null) {
                return false;
            }
        } else if (!iterable.equals(iterable2)) return false;
        if (!nonEmpty.keys().forall((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)Z3Frequency.$anonfun$isEquivalent$3(this, z3Frequency, BoxesRunTime.unboxToShort((Object)k))))) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$$plus$eq$1(Tuple2 x$6) {
        return ((CountMinSketch)x$6._2()).size() > 0L;
    }

    public static final /* synthetic */ void $anonfun$$plus$eq$2(Z3Frequency $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
        CountMinSketch sketch = (CountMinSketch)tuple2._2();
        ((CountMinSketch)$this.sketches().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)w), (Function0 & Serializable & scala.Serializable)() -> $this.newSketch())).$plus$eq(sketch);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$isEmpty$1(CountMinSketch x$8) {
        return x$8.size() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$isEquivalent$1(Tuple2 x$10) {
        return ((CountMinSketch)x$10._2()).size() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$isEquivalent$2(Tuple2 x$11) {
        return ((CountMinSketch)x$11._2()).size() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$isEquivalent$3(Z3Frequency $this, Z3Frequency x2$1, short k) {
        return ((CountMinSketch)$this.sketches().apply((Object)BoxesRunTime.boxToShort((short)k))).isEquivalent((CountMinSketch)x2$1.sketches().apply((Object)BoxesRunTime.boxToShort((short)k)));
    }

    public Z3Frequency(SimpleFeatureType sft, String geom, String dtg, Enumeration.Value period, int precision, double eps, double confidence) {
        this.sft = sft;
        this.geom = geom;
        this.dtg = dtg;
        this.period = period;
        this.precision = precision;
        this.eps = eps;
        this.confidence = confidence;
        Stat.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.g = sft.indexOf(geom);
        this.d = sft.indexOf(dtg);
        this.mask = Frequency$.MODULE$.getMask(precision);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.sketches = Map$.MODULE$.empty();
    }
}

