/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Z3Histogram$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001\u0002\u001d:\u0001\u0011C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tK\u0002\u0011\t\u0011)A\u00057\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003i\u0011!!\bA!b\u0001\n\u00039\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011Y\u0004!Q1A\u0005\u0002]D\u0011\"a\u0005\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005U\u0001A!b\u0001\n\u0003\t9\u0002\u0003\u0006\u0002 \u0001\u0011\t\u0011)A\u0005\u00033Aq!!\t\u0001\t\u0003\t\u0019#\u0002\u0004\u00022\u0001\u0001\u0013Q\u0005\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003/A\u0001\"!\u000e\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003/A\u0001\"!\u000f\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"a\u0012\u0001A\u0003%\u0011q\b\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u0017B\u0001\"a\u0017\u0001A\u0003%\u0011Q\n\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?B\u0001\"a\u001a\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003WB\u0001\"a\u001d\u0001A\u0003%\u0011Q\u000e\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003WB\u0001\"a\u001e\u0001A\u0003%\u0011Q\u000e\u0005\n\u0003s\u0002\u0001R1A\u0005\n\u001dD!\"a\u001f\u0001\u0005\u0004%\t!OA?\u0011!\tI\u000b\u0001Q\u0001\n\u0005}\u0004\u0002CAV\u0001\u0011\u0005\u0011(!,\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqAa\u0003\u0001\t\u0013\u0011i\u0001C\u0004\u0003 \u0001!IA!\t\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!\u0011\u0007\u0001\u0005B\tM\u0002b\u0002B#\u0001\u0011\u0005#q\t\u0005\b\u0005\u0017\u0002A\u0011\tB'\u0011\u001d\u0011\u0019\u0006\u0001C!\u0005+BqA!\u0017\u0001\t\u0003\u0012Y\u0006C\u0004\u0003d\u0001!\tE!\u001a\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j!9!1\u000e\u0001\u0005B\t5ta\u0002B9s!\u0005!1\u000f\u0004\u0007qeB\tA!\u001e\t\u000f\u0005\u0005\u0002\u0007\"\u0001\u0003x!I!\u0011\u0010\u0019C\u0002\u0013%!1\u0010\u0005\t\u0005\u0007\u0003\u0004\u0015!\u0003\u0003~!I!Q\u0011\u0019C\u0002\u0013\u0005!q\u0011\u0005\t\u0005\u001f\u0003\u0004\u0015!\u0003\u0003\n\"I!\u0011\u0013\u0019C\u0002\u0013\u0005!q\u0011\u0005\t\u0005'\u0003\u0004\u0015!\u0003\u0003\n\nY!l\r%jgR|wM]1n\u0015\tQ4(A\u0003ti\u0006$8O\u0003\u0002={\u0005)Q\u000f^5mg*\u0011ahP\u0001\bO\u0016|W.Z:b\u0015\t\u0001\u0015)\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001C\u0003\ry'oZ\u0002\u0001'\u0011\u0001QiS(\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g!\taU*D\u0001:\u0013\tq\u0015H\u0001\u0003Ti\u0006$\bC\u0001)X\u001b\u0005\t&B\u0001*T\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t!V+\u0001\u0005usB,7/\u00194f\u0015\u00051\u0016aA2p[&\u0011\u0001,\u0015\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002tMR,\u0012a\u0017\t\u00039\u000el\u0011!\u0018\u0006\u0003=~\u000baa]5na2,'B\u00011b\u0003\u001d1W-\u0019;ve\u0016T!AY!\u0002\u000f=\u0004XM\\4jg&\u0011A-\u0018\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001B:gi\u0002\nAaZ3p[V\t\u0001\u000e\u0005\u0002ja:\u0011!N\u001c\t\u0003W\u001ek\u0011\u0001\u001c\u0006\u0003[\u000e\u000ba\u0001\u0010:p_Rt\u0014BA8H\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=<\u0015!B4f_6\u0004\u0013a\u00013uO\u0006!A\r^4!\u0003\u0019\u0001XM]5pIV\t\u0001\u0010E\u0002z\u0003\u001bq1A_A\u0004\u001d\rY\u00181\u0001\b\u0004y\u0006\u0005aBA?\u0000\u001d\tYg0C\u0001C\u0013\t\u0001\u0015)\u0003\u0002?\u007f%\u0019\u0011QA\u001f\u0002\u000b\r,(O^3\n\t\u0005%\u00111B\u0001\u000b)&lW\rU3sS>$'bAA\u0003{%!\u0011qBA\t\u0005)!\u0016.\\3QKJLw\u000e\u001a\u0006\u0005\u0003\u0013\tY!A\u0004qKJLw\u000e\u001a\u0011\u0002\r1,gn\u001a;i+\t\tI\u0002E\u0002G\u00037I1!!\bH\u0005\rIe\u000e^\u0001\bY\u0016tw\r\u001e5!\u0003\u0019a\u0014N\\5u}Qa\u0011QEA\u0014\u0003S\tY#!\f\u00020A\u0011A\n\u0001\u0005\u00063.\u0001\ra\u0017\u0005\u0006M.\u0001\r\u0001\u001b\u0005\u0006i.\u0001\r\u0001\u001b\u0005\u0006m.\u0001\r\u0001\u001f\u0005\b\u0003+Y\u0001\u0019AA\r\u0005\u0005\u0019\u0016!A4\u0002\u0005\u001d\u0004\u0013!\u00013\u0002\u0005\u0011\u0004\u0013aA:gGV\u0011\u0011q\b\t\u0005\u0003\u0003\n\u0019%\u0004\u0002\u0002\f%!\u0011QIA\u0006\u0005\u0015Q6g\u0015$D\u0003\u0011\u0019hm\u0019\u0011\u0002\u0013QLW.\u001a+p\u0005&tWCAA'!\u0011\ty%!\u0016\u000f\t\u0005\u0005\u0013\u0011K\u0005\u0005\u0003'\nY!\u0001\u0006CS:tW\r\u001a+j[\u0016LA!a\u0016\u0002Z\t\u0001B+[7f)>\u0014\u0015N\u001c8fIRKW.\u001a\u0006\u0005\u0003'\nY!\u0001\u0006uS6,Gk\u001c\"j]\u0002\n\u0011BY5o)>$\u0015\r^3\u0016\u0005\u0005\u0005\u0004\u0003BA(\u0003GJA!!\u001a\u0002Z\t\u0001\")\u001b8oK\u0012$\u0016.\\3U_\u0012\u000bG/Z\u0001\u000bE&tGk\u001c#bi\u0016\u0004\u0013\u0001B7j]j+\"!!\u001c\u0011\u0007\u0019\u000by'C\u0002\u0002r\u001d\u0013A\u0001T8oO\u0006)Q.\u001b8[A\u0005!Q.\u0019=[\u0003\u0015i\u0017\r\u001f.!\u0003)Q7o\u001c8G_Jl\u0017\r^\u0001\u0007E&tW*\u00199\u0016\u0005\u0005}\u0004\u0003CAA\u0003\u0017\u000by)!&\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000bq!\\;uC\ndWMC\u0002\u0002\n\u001e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti)a!\u0003\u00075\u000b\u0007\u000fE\u0002G\u0003#K1!a%H\u0005\u0015\u0019\u0006n\u001c:u!\u0015a\u0015qSAN\u0013\r\tI*\u000f\u0002\f\u0005&tg.\u001a3BeJ\f\u0017\u0010\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\t1\fgn\u001a\u0006\u0003\u0003K\u000bAA[1wC&!\u0011\u0011OAP\u0003\u001d\u0011\u0017N\\'ba\u0002\nqA\\3x\u0005&t7/\u0006\u0002\u0002\u0016\u0006AA/[7f\u0005&t7/\u0006\u0002\u00024B1\u0011QWA`\u0003\u001fsA!a.\u0002<:\u00191.!/\n\u0003!K1!!0H\u0003\u001d\u0001\u0018mY6bO\u0016LA!!1\u0002D\n\u00191+Z9\u000b\u0007\u0005uv)A\u0003d_VtG\u000f\u0006\u0004\u0002n\u0005%\u0017Q\u001a\u0005\b\u0003\u0017\u0004\u0003\u0019AAH\u0003\u001d!\u0018.\\3CS:Dq!a4!\u0001\u0004\tI\"A\u0001j\u0003-!\u0017N]3di&sG-\u001a=\u0015\r\u0005e\u0011Q[Al\u0011\u001d\tY-\ta\u0001\u0003\u001fCq!!7\"\u0001\u0004\ti'A\u0003wC2,X-A\u0004j]\u0012,\u0007p\u00144\u0015\t\u0005}\u0017Q\u001d\t\b\r\u0006\u0005\u0018qRA\r\u0013\r\t\u0019o\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005e'\u00051\u0001\u0002hB9a)!9\u0002j\u0006]\b\u0003BAv\u0003gl!!!<\u000b\u0007\u0019\fyOC\u0002\u0002r~\n1A\u001b;t\u0013\u0011\t)0!<\u0003\u0011\u001d+w.\\3uef\u0004B!!?\u0002\u00006\u0011\u00111 \u0006\u0005\u0003{\f\u0019+\u0001\u0003vi&d\u0017\u0002\u0002B\u0001\u0003w\u0014A\u0001R1uK\u0006YQ.\u001a3jC:4\u0016\r\\;f)\u0019\t9Oa\u0002\u0003\n!9\u00111Z\u0012A\u0002\u0005=\u0005bBAhG\u0001\u0007\u0011\u0011D\u0001\u0006i>\\U-\u001f\u000b\t\u0005\u001f\u0011\tBa\u0005\u0003\u0016A9a)!9\u0002\u0010\u00065\u0004B\u00024%\u0001\u0004\tI\u000f\u0003\u0004uI\u0001\u0007\u0011q\u001f\u0005\b\u0005/!\u0003\u0019\u0001B\r\u0003\u001daWM\\5f]R\u00042A\u0012B\u000e\u0013\r\u0011ib\u0012\u0002\b\u0005>|G.Z1o\u0003\u001d1'o\\7LKf$b!a:\u0003$\t\u0015\u0002bBAfK\u0001\u0007\u0011q\u0012\u0005\b\u0005O)\u0003\u0019AA7\u0003\u0005Q\u0018aC:qY&$()\u001f+j[\u0016,\"A!\f\u0011\r\u0005U\u0016q\u0018B\u0018!\u001d1\u0015\u0011]AH\u0003K\tqa\u001c2tKJ4X\r\u0006\u0003\u00036\tm\u0002c\u0001$\u00038%\u0019!\u0011H$\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005{9\u0003\u0019\u0001B \u0003\t\u0019h\rE\u0002]\u0005\u0003J1Aa\u0011^\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0006IQO\\8cg\u0016\u0014h/\u001a\u000b\u0005\u0005k\u0011I\u0005C\u0004\u0003>!\u0002\rAa\u0010\u0002\u000b\u0011\u0002H.^:\u0015\t\u0005\u0015\"q\n\u0005\b\u0005#J\u0003\u0019AA\u0013\u0003\u0015yG\u000f[3s\u0003!!\u0003\u000f\\;tI\u0015\fH\u0003\u0002B\u001b\u0005/BqA!\u0015+\u0001\u0004\t)#\u0001\u0007u_*\u001bxN\\(cU\u0016\u001cG/\u0006\u0002\u0003^A\u0019aIa\u0018\n\u0007\t\u0005tIA\u0002B]f\fq![:F[B$\u00180\u0006\u0002\u0003\u001a\u0005)1\r\\3beR\u0011!QG\u0001\rSN,\u0015/^5wC2,g\u000e\u001e\u000b\u0005\u00053\u0011y\u0007\u0003\u0004\u0003R9\u0002\raS\u0001\f5NB\u0015n\u001d;pOJ\fW\u000e\u0005\u0002MaM\u0011\u0001'\u0012\u000b\u0003\u0005g\n!a\u001a4\u0016\u0005\tu\u0004\u0003BAv\u0005\u007fJAA!!\u0002n\nyq)Z8nKR\u0014\u0018PR1di>\u0014\u00180A\u0002hM\u0002\nq!\\5o\u000f\u0016|W.\u0006\u0002\u0003\nB!\u00111\u001eBF\u0013\u0011\u0011i)!<\u0003\u000bA{\u0017N\u001c;\u0002\u00115LgnR3p[\u0002\nq!\\1y\u000f\u0016|W.\u0001\u0005nCb<Um\\7!\u0001")
public class Z3Histogram
implements Stat,
LazyLogging {
    private String jsonFormat;
    private final SimpleFeatureType sft;
    private final String geom;
    private final String dtg;
    private final Enumeration.Value period;
    private final int length;
    private final int g;
    private final int d;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Function1<BinnedTime, ZonedDateTime> binToDate;
    private final long minZ;
    private final long maxZ;
    private final Map<Object, BinnedArray<Long>> binMap;
    private Logger logger;
    private volatile byte bitmap$0;

    public static Point maxGeom() {
        return Z3Histogram$.MODULE$.maxGeom();
    }

    public static Point minGeom() {
        return Z3Histogram$.MODULE$.minGeom();
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat.$plus$eq$(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat.$plus$(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat.toJson$(this);
    }

    private Logger logger$lzycompute() {
        Z3Histogram z3Histogram = this;
        synchronized (z3Histogram) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String geom() {
        return this.geom;
    }

    public String dtg() {
        return this.dtg;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int length() {
        return this.length;
    }

    private int g() {
        return this.g;
    }

    private int d() {
        return this.d;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    private Function1<BinnedTime, ZonedDateTime> binToDate() {
        return this.binToDate;
    }

    private long minZ() {
        return this.minZ;
    }

    private long maxZ() {
        return this.maxZ;
    }

    private String jsonFormat$lzycompute() {
        Z3Histogram z3Histogram = this;
        synchronized (z3Histogram) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String string;
                Enumeration.Value value = this.period();
                Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    string = new StringBuilder(5).append(this.period()).append("-%05d").toString();
                } else {
                    Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        string = new StringBuilder(5).append(this.period()).append("-%04d").toString();
                    } else {
                        Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            string = new StringBuilder(5).append(this.period()).append("-%03d").toString();
                        } else {
                            Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                string = new StringBuilder(5).append(this.period()).append("-%02d").toString();
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
                this.jsonFormat = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.jsonFormat;
    }

    private String jsonFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.jsonFormat$lzycompute() : this.jsonFormat;
    }

    public Map<Object, BinnedArray<Long>> binMap() {
        return this.binMap;
    }

    public BinnedArray<Long> newBins() {
        return new BinnedArray<Long>(new BinnedArray.LongBinning(this.length(), (Tuple2<Long, Long>)new Tuple2((Object)Predef$.MODULE$.long2Long(this.minZ()), (Object)Predef$.MODULE$.long2Long(this.maxZ()))));
    }

    public Seq<Object> timeBins() {
        return (Seq)this.binMap().keys().toSeq().sorted((Ordering)Ordering.Short$.MODULE$);
    }

    public long count(short timeBin, int i) {
        return BoxesRunTime.unboxToLong((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)Z3Histogram.$anonfun$count$1(i, x$1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public int directIndex(short timeBin, long value) {
        return BoxesRunTime.unboxToInt((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.indexOf(Predef$.MODULE$.long2Long(value)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
    }

    public Tuple2<Object, Object> indexOf(Tuple2<Geometry, Date> value) {
        Tuple2<Object, Object> tuple2 = this.toKey((Geometry)value._1(), (Date)value._2(), false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
        long z = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z));
        Tuple2 tuple23 = tuple22;
        short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
        long z2 = tuple23._2$mcJ$sp();
        return new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin2), (Object)BoxesRunTime.boxToInteger((int)this.directIndex(timeBin2, z2)));
    }

    public Tuple2<Geometry, Date> medianValue(short timeBin, int i) {
        return this.fromKey(timeBin, Predef$.MODULE$.Long2long((Long)((BinnedArray)this.binMap().apply((Object)BoxesRunTime.boxToShort((short)timeBin))).medianValue(i)));
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg, boolean lenient) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime == null) {
            throw new MatchError((Object)binnedTime);
        }
        short bin = binnedTime.bin();
        long offset = binnedTime.offset();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)offset));
        Tuple2 tuple22 = tuple2;
        short bin2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long offset2 = tuple22._2$mcJ$sp();
        Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
        long z = this.sfc().index(centroid.getX(), centroid.getY(), offset2, lenient);
        return new Tuple2((Object)BoxesRunTime.boxToShort((short)bin2), (Object)BoxesRunTime.boxToLong((long)z));
    }

    private Tuple2<Geometry, Date> fromKey(short timeBin, long z) {
        Tuple3 tuple3 = this.sfc().invert(z);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        long t = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToLong((long)t));
        Tuple3 tuple33 = tuple32;
        double x2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
        double y2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
        long t2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
        Date dtg = Date.from(((ChronoZonedDateTime)this.binToDate().apply((Object)new BinnedTime(timeBin, t2))).toInstant());
        Point geom = Z3Histogram$.MODULE$.org$locationtech$geomesa$utils$stats$Z3Histogram$$gf().createPoint(new Coordinate(x2, y2));
        return new Tuple2((Object)geom, (Object)dtg);
    }

    public Seq<Tuple2<Object, Z3Histogram>> splitByTime() {
        return (Seq)this.binMap().toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
            BinnedArray bins = (BinnedArray)tuple2._2();
            Z3Histogram hist = new Z3Histogram(this.sft(), this.geom(), this.dtg(), this.period(), this.length());
            hist.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)hist);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void observe(SimpleFeature sf) {
        block4: {
            Geometry geom = (Geometry)sf.getAttribute(this.g());
            Date dtg = (Date)sf.getAttribute(this.d());
            if (geom == null || dtg == null) break block4;
            try {
                Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg, false);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                long z3 = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                Tuple2 tuple23 = tuple22;
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                ((BinnedArray)this.binMap().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)timeBin2), (Function0 & Serializable & scala.Serializable)() -> this.newBins())).add(Predef$.MODULE$.long2Long(z32), 1L);
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        block4: {
            Geometry geom = (Geometry)sf.getAttribute(this.g());
            Date dtg = (Date)sf.getAttribute(this.d());
            if (geom == null || dtg == null) break block4;
            try {
                Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg, true);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                long z3 = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                Tuple2 tuple23 = tuple22;
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin2)).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                    x$8.add(Predef$.MODULE$.long2Long(z32), -1L);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error un-observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Z3Histogram $plus(Z3Histogram other) {
        void var2_2;
        Z3Histogram plus = new Z3Histogram(this.sft(), this.geom(), this.dtg(), this.period(), this.length());
        plus.$plus$eq(this);
        plus.$plus$eq(other);
        return var2_2;
    }

    public void $plus$eq(Z3Histogram other) {
        if (this.length() != other.length()) {
            throw new NotImplementedError("Can only add z3 histograms with the same length");
        }
        other.binMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option option;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
            BinnedArray bins = (BinnedArray)tuple2._2();
            Option option2 = this.binMap().get((Object)BoxesRunTime.boxToShort((short)w));
            if (None$.MODULE$.equals(option2)) {
                option = this.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                return option;
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some = (Some)option2;
                BinnedArray b = (BinnedArray)some.value();
                for (int i = 0; i < b.length(); ++i) {
                    int n = i;
                    b.counts()[n] = b.counts()[n] + bins.counts()[i];
                }
                option = BoxedUnit.UNIT;
            }
            return option;
        });
    }

    @Override
    public Object toJsonObject() {
        return ((TraversableLike)((TraversableLike)this.binMap().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToShort((short)Z3Histogram.$anonfun$toJsonObject$1(x$9)), (Ordering)Ordering.Short$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            short p = BoxesRunTime.unboxToShort((Object)tuple2._1());
            BinnedArray bins = (BinnedArray)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)String.format(this.jsonFormat(), BoxesRunTime.boxToShort((short)p)), (Object)bins);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String label = (String)tuple2._1();
            BinnedArray bins = (BinnedArray)tuple2._2();
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)bins.counts())})))}));
            return map;
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isEmpty() {
        return this.binMap().values().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Z3Histogram.$anonfun$isEmpty$1(x$10)));
    }

    @Override
    public void clear() {
        this.binMap().values().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.clear();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat = other;
        if (!(stat instanceof Z3Histogram)) return false;
        Z3Histogram z3Histogram = (Z3Histogram)stat;
        if (this.g() != z3Histogram.g()) return false;
        if (this.d() != z3Histogram.d()) return false;
        Enumeration.Value value = this.period();
        Enumeration.Value value2 = z3Histogram.period();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (this.length() != z3Histogram.length()) return false;
        Set set = this.binMap().keySet();
        Set set2 = z3Histogram.binMap().keySet();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (!this.binMap().forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Z3Histogram.$anonfun$isEquivalent$1(z3Histogram, x0$1)))) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$count$1(int i$1, BinnedArray x$1) {
        return x$1.counts()[i$1];
    }

    public static final /* synthetic */ short $anonfun$toJsonObject$1(Tuple2 x$9) {
        return BoxesRunTime.unboxToShort((Object)x$9._1());
    }

    public static final /* synthetic */ boolean $anonfun$isEmpty$1(BinnedArray x$10) {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$10.counts())).forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 == 0L);
    }

    public static final /* synthetic */ boolean $anonfun$isEquivalent$1(Z3Histogram x2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
        BinnedArray bins = (BinnedArray)tuple2._2();
        boolean bl = Arrays.equals(bins.counts(), ((BinnedArray)x2$1.binMap().apply((Object)BoxesRunTime.boxToShort((short)w))).counts());
        return bl;
    }

    public Z3Histogram(SimpleFeatureType sft, String geom, String dtg, Enumeration.Value period, int length) {
        this.sft = sft;
        this.geom = geom;
        this.dtg = dtg;
        this.period = period;
        this.length = length;
        Stat.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.g = sft.indexOf(geom);
        this.d = sft.indexOf(dtg);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.binToDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.minZ = this.sfc().index(Z3Histogram$.MODULE$.minGeom().getX(), Z3Histogram$.MODULE$.minGeom().getY(), (long)this.sfc().time().min(), this.sfc().index$default$4());
        this.maxZ = this.sfc().index(Z3Histogram$.MODULE$.maxGeom().getX(), Z3Histogram$.MODULE$.maxGeom().getY(), (long)this.sfc().time().max(), this.sfc().index$default$4());
        this.binMap = Map$.MODULE$.empty();
    }
}

