/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.text;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package$WithClose$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;

public final class StringSerialization$
implements LazyLogging {
    public static StringSerialization$ MODULE$;
    private final DateTimeFormatter dateFormat;
    private final Pattern AlphaNumericPattern;
    private final IndexedSeq<Object> AlphaNumeric;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StringSerialization$();
    }

    private Logger logger$lzycompute() {
        StringSerialization$ stringSerialization$ = this;
        synchronized (stringSerialization$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private DateTimeFormatter dateFormat() {
        return this.dateFormat;
    }

    private Pattern AlphaNumericPattern() {
        return this.AlphaNumericPattern;
    }

    private IndexedSeq<Object> AlphaNumeric() {
        return this.AlphaNumeric;
    }

    public String encodeSeq(Seq<String> values) {
        String string;
        if (values.isEmpty()) {
            string = "";
        } else {
            java.lang.StringBuilder sb = new java.lang.StringBuilder();
            CSVPrinter printer = new CSVPrinter((Appendable)sb, CSVFormat.DEFAULT);
            values.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                printer.print(x$1);
                return BoxedUnit.UNIT;
            });
            string = sb.toString();
        }
        return string;
    }

    public Seq<String> decodeSeq(String values) {
        return values.isEmpty() ? (Seq)Nil$.MODULE$ : (Seq)package$WithClose$.MODULE$.apply(CSVParser.parse((String)values, (CSVFormat)CSVFormat.DEFAULT), (Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((CSVRecord)x$1.iterator().next()).iterator()).asScala()).toList(), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public String encodeMap(Map<String, String> values) {
        return this.encodeSeq((Seq<String>)((Seq)values.toSeq().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Seq seq = (Seq)new .colon.colon((Object)k, (List)new .colon.colon((Object)v, (List)Nil$.MODULE$));
            return seq;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public scala.collection.immutable.Map<String, String> decodeMap(String values) {
        return this.decodeSeq(values).grouped(2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq = x0$1;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            String k = (String)((SeqLike)some.get()).apply(0);
            String v = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            return tuple2;
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public String encodeSeqMap(scala.collection.immutable.Map<String, Seq<Object>> map) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        CSVPrinter printer = new CSVPrinter((Appendable)sb, CSVFormat.DEFAULT);
        map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StringSerialization$.$anonfun$encodeSeqMap$1(printer, x0$1);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    public scala.collection.immutable.Map<String, Object[]> decodeSeqMap(SimpleFeatureType sft, String encoded) {
        Buffer bindings = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.getLocalName()), (Object)d.getType().getBinding()), Buffer$.MODULE$.canBuildFrom());
        return this.decodeSeqMap(encoded, bindings.toMap(Predef$.MODULE$.$conforms()));
    }

    public scala.collection.immutable.Map<String, Object[]> decodeSeqMap(String encoded, scala.collection.immutable.Map<String, Class<?>> bindings) {
        return (scala.collection.immutable.Map)package$WithClose$.MODULE$.apply(CSVParser.parse((String)encoded, (CSVFormat)CSVFormat.DEFAULT), (Function1 & Serializable & scala.Serializable)parser -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(parser.iterator()).asScala()).map(arg_0 -> StringSerialization$.$anonfun$decodeSeqMap$3(bindings, arg_0)).toMap(Predef$.MODULE$.$conforms()), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public String alphaNumericSafeString(String input) {
        String string;
        if (this.AlphaNumericPattern().matcher(input).matches()) {
            string = input;
        } else {
            StringBuilder sb = new StringBuilder();
            new StringOps(Predef$.MODULE$.augmentString(input)).foreach((Function1 & Serializable & scala.Serializable)c -> StringSerialization$.$anonfun$alphaNumericSafeString$1(sb, BoxesRunTime.unboxToChar((Object)c)));
            string = sb.toString();
        }
        return string;
    }

    public String decodeAlphaNumericSafeString(String input) {
        String string;
        if (this.AlphaNumericPattern().matcher(input).matches()) {
            string = input;
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                StringBuilder stringBuilder = c != '_' ? sb.append(c) : sb.append(new String(Hex.decodeHex((char[])new char[]{input.charAt((i += 2) - 1), input.charAt(i)}), StandardCharsets.UTF_8));
            }
            string = sb.toString();
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$encodeSeqMap$1(CSVPrinter printer$2, Tuple2 x0$1) {
        Some some;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Seq v = (Seq)tuple2._2();
        Option option = v.headOption();
        Seq seq = option instanceof Some && (some = (Some)option).value() instanceof Date ? (Seq)v.map((Function1 & Serializable & scala.Serializable)d -> ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant((Date)d), ZoneOffset.UTC).format(MODULE$.dateFormat()), Seq$.MODULE$.canBuildFrom()) : v;
        Seq strings = seq;
        printer$2.print((Object)k);
        strings.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            printer$2.print(x$1);
            return BoxedUnit.UNIT;
        });
        printer$2.println();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Integer $anonfun$decodeSeqMap$4(String x$1) {
        return Integer.valueOf(x$1);
    }

    public static final /* synthetic */ Long $anonfun$decodeSeqMap$5(String x$1) {
        return Long.valueOf(x$1);
    }

    public static final /* synthetic */ Float $anonfun$decodeSeqMap$6(String x$1) {
        return Float.valueOf(x$1);
    }

    public static final /* synthetic */ Double $anonfun$decodeSeqMap$7(String x$1) {
        return Double.valueOf(x$1);
    }

    public static final /* synthetic */ Date $anonfun$decodeSeqMap$8(String v) {
        return Date.from(ZonedDateTime.parse(v, MODULE$.dateFormat()).toInstant());
    }

    public static final /* synthetic */ Boolean $anonfun$decodeSeqMap$9(String x$1) {
        return Boolean.valueOf(x$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$decodeSeqMap$3(scala.collection.immutable.Map bindings$1, CSVRecord record) {
        block5: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    iter = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(record.iterator()).asScala();
                                    key = (String)iter.next();
                                    var6_4 = false;
                                    var7_5 = null;
                                    var8_6 = bindings$1.get((Object)key);
                                    if (!(var8_6 instanceof Some)) break block4;
                                    var6_4 = true;
                                    var7_5 = (Some)var8_6;
                                    v0 = c = (Class)var7_5.value();
                                    var10_8 = String.class;
                                    if (v0 != null ? v0.equals(var10_8) == false : var10_8 != null) break block4;
                                    var2_9 = (Object[])iter.toArray(ClassTag$.MODULE$.AnyRef());
                                    break block5;
                                }
                                if (!var6_4) break block6;
                                v1 = c = (Class)var7_5.value();
                                var12_11 = Integer.class;
                                if (v1 != null ? v1.equals(var12_11) == false : var12_11 != null) break block6;
                                var2_9 = (Object[])iter.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$4(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Integer;)()).toArray(ClassTag$.MODULE$.AnyRef());
                                break block5;
                            }
                            if (!var6_4) break block7;
                            v2 = c = (Class)var7_5.value();
                            var14_13 = Long.class;
                            if (v2 != null ? v2.equals(var14_13) == false : var14_13 != null) break block7;
                            var2_9 = (Object[])iter.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$5(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Long;)()).toArray(ClassTag$.MODULE$.AnyRef());
                            break block5;
                        }
                        if (!var6_4) break block8;
                        v3 = c = (Class)var7_5.value();
                        var16_15 = Float.class;
                        if (v3 != null ? v3.equals(var16_15) == false : var16_15 != null) break block8;
                        var2_9 = (Object[])iter.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$6(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Float;)()).toArray(ClassTag$.MODULE$.AnyRef());
                        break block5;
                    }
                    if (!var6_4) break block9;
                    v4 = c = (Class)var7_5.value();
                    var18_17 = Double.class;
                    if (v4 != null ? v4.equals(var18_17) == false : var18_17 != null) break block9;
                    var2_9 = (Object[])iter.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$7(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Double;)()).toArray(ClassTag$.MODULE$.AnyRef());
                    break block5;
                }
                if (!var6_4 || !Date.class.isAssignableFrom(c = (Class)var7_5.value())) break block10;
                var2_9 = (Object[])iter.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$8(java.lang.String ), (Ljava/lang/String;)Ljava/util/Date;)()).toArray(ClassTag$.MODULE$.AnyRef());
                break block5;
            }
            if (!var6_4) ** GOTO lbl-1000
            v5 = c = (Class)var7_5.value();
            var21_20 = Boolean.class;
            if (!(v5 != null ? v5.equals(var21_20) == false : var21_20 != null)) {
                var2_9 = (Object[])iter.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$decodeSeqMap$9(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)()).toArray(ClassTag$.MODULE$.AnyRef());
            } else lbl-1000:
            // 2 sources

            {
                if (StringSerialization$.MODULE$.logger().underlying().isWarnEnabled()) {
                    StringSerialization$.MODULE$.logger().underlying().warn("No conversion defined for encoded attribute '{}' of type {}", new Object[]{key, var8_6.orNull(Predef$.MODULE$.$conforms())});
                    v6 = BoxedUnit.UNIT;
                } else {
                    v6 = BoxedUnit.UNIT;
                }
                var2_9 = (Object[])iter.toArray(ClassTag$.MODULE$.AnyRef());
            }
        }
        values = var2_9;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)values);
    }

    public static final /* synthetic */ StringBuilder $anonfun$alphaNumericSafeString$1(StringBuilder sb$1, char c) {
        StringBuilder stringBuilder;
        if (MODULE$.AlphaNumeric().contains((Object)BoxesRunTime.boxToCharacter((char)c))) {
            stringBuilder = sb$1.append(c);
        } else {
            char[] hex = Hex.encodeHex((byte[])Character.toString(c).getBytes(StandardCharsets.UTF_8));
            String encoded = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(hex)).grouped(2).map((Function1 & Serializable & scala.Serializable)arr -> new java.lang.StringBuilder(1).append("_").append(arr[0]).append(arr[1]).toString()).mkString().toLowerCase(Locale.US);
            stringBuilder = sb$1.append(encoded);
        }
        return stringBuilder;
    }

    private StringSerialization$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.dateFormat = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);
        this.AlphaNumericPattern = Pattern.compile("^[a-zA-Z0-9]+$");
        this.AlphaNumeric = (IndexedSeq)((TraversableLike)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')), IndexedSeq$.MODULE$.canBuildFrom());
    }
}

