/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.curve.XZSFC$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.geomesa.zorder.sfcurve.package$IndexRange$;
import org.locationtech.geomesa.zorder.sfcurve.package$IndexRange$IndexRangeIsOrdered$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rUf\u0001\u00028p\u0001aD\u0011b \u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005\u001d\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0016\u0001\u0011\t\u0011)A\u0005\u0003\u0013Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011\u0011\u0006\u0001!\u0002\u0013\ty\u0001C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011Q\u0006\u0001!\u0002\u0013\ty\u0001C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011\u0011\u0007\u0001!\u0002\u0013\ty\u0001C\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011Q\u0007\u0001!\u0002\u0013\ty\u0001C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011\u0011\b\u0001!\u0002\u0013\ty\u0001C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011Q\b\u0001!\u0002\u0013\ty\u0001C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005}\u0002\u0001\"\u0001\u0002T!I\u0011q\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000f\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t9\t\u0001C\u0001\u0003\u001fDq!a\"\u0001\t\u0003\t\u0019\u000fC\u0004\u0002\b\u0002!\t!!<\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002z\"I!1\u0001\u0001\u0012\u0002\u0013\u0005!Q\u0001\u0005\b\u0003\u000f\u0003A\u0011\u0002B\u0005\u0011\u001d\u0019I\t\u0001C\u0005\u0007\u0017Cqaa&\u0001\t\u0013\u0019I\nC\u0004\u0004(\u0002!Ia!+\b\u000f\tmq\u000e#\u0001\u0003\u001e\u00191an\u001cE\u0001\u0005?Aq!a\u0006 \t\u0003\u0011\t\u0003C\u0005\u0003$}\u0011\r\u0011\"\u0003\u0003&!A!q`\u0010!\u0002\u0013\u00119\u0003C\u0005\u0004\u0002}\u0011\r\u0011\"\u0003\u0004\u0004!A1QA\u0010!\u0002\u0013\u0011I\u0003C\u0005\u0004\b}\u0011\r\u0011\"\u0003\u0004\n!A11D\u0010!\u0002\u0013\u0019Y\u0001C\u0004\u0004\u001e}!\taa\b\u0007\r\t\rt\u0004\u0012B3\u0011)\t9\u0006\u000bBK\u0002\u0013\u0005\u0011q\u0005\u0005\u000b\u0005{A#\u0011#Q\u0001\n\u0005=\u0001BCA.Q\tU\r\u0011\"\u0001\u0002(!Q!q\b\u0015\u0003\u0012\u0003\u0006I!a\u0004\t\u0015\u0005}\u0003F!f\u0001\n\u0003\t9\u0003\u0003\u0006\u0003B!\u0012\t\u0012)A\u0005\u0003\u001fA!\"a\u0019)\u0005+\u0007I\u0011AA\u0014\u0011)\u0011\u0019\u0005\u000bB\tB\u0003%\u0011q\u0002\u0005\b\u0003/AC\u0011\u0001B4\u0011%\u0011\t\bKA\u0001\n\u0003\u0011\u0019\bC\u0005\u0003~!\n\n\u0011\"\u0001\u0003\u0000!I!1\u0011\u0015\u0012\u0002\u0013\u0005!q\u0010\u0005\n\u0005\u000bC\u0013\u0013!C\u0001\u0005\u007fB\u0011Ba\")#\u0003%\tAa \t\u0013\t%\u0005&!A\u0005B\t-\u0005\"\u0003BOQ\u0005\u0005I\u0011\u0001BP\u0011%\u0011\t\u000bKA\u0001\n\u0003\u0011\u0019\u000bC\u0005\u00030\"\n\t\u0011\"\u0011\u00032\"I!q\u0018\u0015\u0002\u0002\u0013\u0005!\u0011\u0019\u0005\n\u0005\u000bD\u0013\u0011!C!\u0005\u000fD\u0011Ba3)\u0003\u0003%\tE!4\t\u0013\t=\u0007&!A\u0005B\tE\u0007\"\u0003BjQ\u0005\u0005I\u0011\tBk\u000f%\u0019\u0019cHA\u0001\u0012\u0013\u0019)CB\u0005\u0003d}\t\t\u0011#\u0003\u0004(!9\u0011qC!\u0005\u0002\r}\u0002\"\u0003Bh\u0003\u0006\u0005IQ\tBi\u0011%\u0019i\"QA\u0001\n\u0003\u001b\t\u0005C\u0005\u0004L\u0005\u000b\t\u0011\"!\u0004N!I1QK!\u0002\u0002\u0013%1q\u000b\u0004\u0007\u0005[yBIa\f\t\u0015\u0005]sI!f\u0001\n\u0003\t9\u0003\u0003\u0006\u0003>\u001d\u0013\t\u0012)A\u0005\u0003\u001fA!\"a\u0017H\u0005+\u0007I\u0011AA\u0014\u0011)\u0011yd\u0012B\tB\u0003%\u0011q\u0002\u0005\u000b\u0003?:%Q3A\u0005\u0002\u0005\u001d\u0002B\u0003B!\u000f\nE\t\u0015!\u0003\u0002\u0010!Q\u00111M$\u0003\u0016\u0004%\t!a\n\t\u0015\t\rsI!E!\u0002\u0013\ty\u0001\u0003\u0006\u0003F\u001d\u0013)\u001a!C\u0001\u0003OA!Ba\u0012H\u0005#\u0005\u000b\u0011BA\b\u0011\u001d\t9b\u0012C\u0001\u0005\u0013B!B!\u0016H\u0011\u000b\u0007I\u0011AA\u0014\u0011)\u00119f\u0012EC\u0002\u0013\u0005\u0011q\u0005\u0005\b\u00053:E\u0011\u0001B.\u0011\u001d\u0011In\u0012C\u0001\u00057DqAa8H\t\u0003\u0011)\u0003C\u0005\u0003r\u001d\u000b\t\u0011\"\u0001\u0003b\"I!QP$\u0012\u0002\u0013\u0005!q\u0010\u0005\n\u0005\u0007;\u0015\u0013!C\u0001\u0005\u007fB\u0011B!\"H#\u0003%\tAa \t\u0013\t\u001du)%A\u0005\u0002\t}\u0004\"\u0003Bw\u000fF\u0005I\u0011\u0001B@\u0011%\u0011IiRA\u0001\n\u0003\u0012Y\tC\u0005\u0003\u001e\u001e\u000b\t\u0011\"\u0001\u0003 \"I!\u0011U$\u0002\u0002\u0013\u0005!q\u001e\u0005\n\u0005_;\u0015\u0011!C!\u0005cC\u0011Ba0H\u0003\u0003%\tAa=\t\u0013\t\u0015w)!A\u0005B\t]\b\"\u0003Bf\u000f\u0006\u0005I\u0011\tBg\u0011%\u0011ymRA\u0001\n\u0003\u0012\t\u000eC\u0005\u0003T\u001e\u000b\t\u0011\"\u0011\u0003|\u001eI1qL\u0010\u0002\u0002#%1\u0011\r\u0004\n\u0005[y\u0012\u0011!E\u0005\u0007GBq!a\u0006i\t\u0003\u0019Y\u0007C\u0005\u0003P\"\f\t\u0011\"\u0012\u0003R\"I1Q\u00045\u0002\u0002\u0013\u00055Q\u000e\u0005\n\u0007\u0017B\u0017\u0011!CA\u0007sB\u0011b!\u0016i\u0003\u0003%Iaa\u0016\u0003\raS&g\u0015$D\u0015\t\u0001\u0018/A\u0003dkJ4XM\u0003\u0002sg\u00069q-Z8nKN\f'B\u0001;v\u00031awnY1uS>tG/Z2i\u0015\u00051\u0018aA8sO\u000e\u00011C\u0001\u0001z!\tQX0D\u0001|\u0015\u0005a\u0018!B:dC2\f\u0017B\u0001@|\u0005\u0019\te.\u001f*fM\u0006\tq\rE\u0002{\u0003\u0007I1!!\u0002|\u0005\u0015\u0019\u0006n\u001c:u\u0003\u001dA(i\\;oIN\u0004rA_A\u0006\u0003\u001f\ty!C\u0002\u0002\u000em\u0014a\u0001V;qY\u0016\u0014\u0004c\u0001>\u0002\u0012%\u0019\u00111C>\u0003\r\u0011{WO\u00197f\u0003\u001dI(i\\;oIN\fa\u0001P5oSRtD\u0003CA\u000e\u0003?\t\t#a\t\u0011\u0007\u0005u\u0001!D\u0001p\u0011\u0019yH\u00011\u0001\u0002\u0002!9\u0011q\u0001\u0003A\u0002\u0005%\u0001bBA\u000b\t\u0001\u0007\u0011\u0011B\u0001\u0004q2{WCAA\b\u0003\u0011AHj\u001c\u0011\u0002\u0007aD\u0015.\u0001\u0003y\u0011&\u0004\u0013aA=M_\u0006!\u0011\u0010T8!\u0003\rI\b*[\u0001\u0005s\"K\u0007%A\u0003y'&TX-\u0001\u0004y'&TX\rI\u0001\u0006sNK'0Z\u0001\u0007sNK'0\u001a\u0011\u0002\u000b%tG-\u001a=\u0015\t\u0005\r\u0013\u0011\n\t\u0004u\u0006\u0015\u0013bAA$w\n!Aj\u001c8h\u0011\u001d\tY%\u0005a\u0001\u0003\u001b\naAY8v]\u0012\u001c\bc\u0003>\u0002P\u0005=\u0011qBA\b\u0003\u001fI1!!\u0015|\u0005\u0019!V\u000f\u001d7fiQa\u00111IA+\u00033\ni&!\u0019\u0002f!9\u0011q\u000b\nA\u0002\u0005=\u0011\u0001\u0002=nS:Dq!a\u0017\u0013\u0001\u0004\ty!\u0001\u0003z[&t\u0007bBA0%\u0001\u0007\u0011qB\u0001\u0005q6\f\u0007\u0010C\u0004\u0002dI\u0001\r!a\u0004\u0002\tel\u0017\r\u001f\u0005\n\u0003O\u0012\u0002\u0013!a\u0001\u0003S\nq\u0001\\3oS\u0016tG\u000fE\u0002{\u0003WJ1!!\u001c|\u0005\u001d\u0011un\u001c7fC:\fq\"\u001b8eKb$C-\u001a4bk2$H%N\u000b\u0003\u0003gRC!!\u001b\u0002v-\u0012\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0002n\f!\"\u00198o_R\fG/[8o\u0013\u0011\t))a\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0004sC:<Wm\u001d\u000b\u0005\u0003\u0017\u000bY\r\u0005\u0004\u0002\u000e\u0006u\u00151\u0015\b\u0005\u0003\u001f\u000bIJ\u0004\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)j^\u0001\u0007yI|w\u000e\u001e \n\u0003qL1!a'|\u0003\u001d\u0001\u0018mY6bO\u0016LA!a(\u0002\"\n\u00191+Z9\u000b\u0007\u0005m5\u0010\u0005\u0003\u0002&\u0006\u0015g\u0002BAT\u0003\u0003tA!!+\u0002<:!\u00111VA\\\u001d\u0011\ti+!.\u000f\t\u0005=\u00161\u0017\b\u0005\u0003#\u000b\t,C\u0001w\u0013\t!X/\u0003\u0002sg&\u0019\u0011\u0011X9\u0002\ri|'\u000fZ3s\u0013\u0011\ti,a0\u0002\u000fM47-\u001e:wK*\u0019\u0011\u0011X9\n\t\u0005m\u00151\u0019\u0006\u0005\u0003{\u000by,\u0003\u0003\u0002H\u0006%'AC%oI\u0016D(+\u00198hK*!\u00111TAb\u0011\u001d\ti\r\u0006a\u0001\u0003\u001b\nQ!];fef$b!a#\u0002R\u0006M\u0007bBAg+\u0001\u0007\u0011Q\n\u0005\b\u0003+,\u0002\u0019AAl\u0003%i\u0017\r\u001f*b]\u001e,7\u000fE\u0003{\u00033\fi.C\u0002\u0002\\n\u0014aa\u00149uS>t\u0007c\u0001>\u0002`&\u0019\u0011\u0011]>\u0003\u0007%sG\u000f\u0006\u0006\u0002\f\u0006\u0015\u0018q]Au\u0003WDq!a\u0016\u0017\u0001\u0004\ty\u0001C\u0004\u0002\\Y\u0001\r!a\u0004\t\u000f\u0005}c\u00031\u0001\u0002\u0010!9\u00111\r\fA\u0002\u0005=A\u0003DAF\u0003_\f\t0a=\u0002v\u0006]\bbBA,/\u0001\u0007\u0011q\u0002\u0005\b\u00037:\u0002\u0019AA\b\u0011\u001d\tyf\u0006a\u0001\u0003\u001fAq!a\u0019\u0018\u0001\u0004\ty\u0001C\u0004\u0002V^\u0001\r!a6\u0015\r\u0005-\u00151 B\u0001\u0011\u001d\ti\u0010\u0007a\u0001\u0003\u007f\fq!];fe&,7\u000f\u0005\u0004\u0002\u000e\u0006u\u0015Q\n\u0005\n\u0003+D\u0002\u0013!a\u0001\u0003/\f\u0001C]1oO\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u001d!\u0006BAl\u0003k\"b!a#\u0003\f\r\u0015\u0005bBAg5\u0001\u0007!Q\u0002\t\u0006u\n=!1C\u0005\u0004\u0005#Y(!B!se\u0006L\bc\u0001B\u000bQ9\u0019!q\u0003\u0010\u000f\t\u0005-&\u0011D\u0005\u0003aF\fa\u0001\u0017.3'\u001a\u001b\u0005cAA\u000f?M\u0011q$\u001f\u000b\u0003\u0005;\t\u0001\u0003T3wK2|e.Z#mK6,g\u000e^:\u0016\u0005\t\u001d\u0002CBAG\u0003;\u0013I\u0003E\u0002\u0003,\u001dk\u0011a\b\u0002\t1\u0016cW-\\3oiN1q)\u001fB\u0019\u0005o\u00012A\u001fB\u001a\u0013\r\u0011)d\u001f\u0002\b!J|G-^2u!\u0011\tiI!\u000f\n\t\tm\u0012\u0011\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006q6Lg\u000eI\u0001\u0006s6Lg\u000eI\u0001\u0006q6\f\u0007\u0010I\u0001\u0006s6\f\u0007\u0010I\u0001\u0007Y\u0016tw\r\u001e5\u0002\u000f1,gn\u001a;iAQa!\u0011\u0006B&\u0005\u001b\u0012yE!\u0015\u0003T!9\u0011q\u000b*A\u0002\u0005=\u0001bBA.%\u0002\u0007\u0011q\u0002\u0005\b\u0003?\u0012\u0006\u0019AA\b\u0011\u001d\t\u0019G\u0015a\u0001\u0003\u001fAqA!\u0012S\u0001\u0004\ty!\u0001\u0003yKb$\u0018\u0001B=fqR\f1\"[:D_:$\u0018-\u001b8fIR!\u0011\u0011\u000eB/\u0011\u001d\u0011y&\u0016a\u0001\u0005C\naa^5oI><\bc\u0001B\u0016Q\tY\u0011+^3ss^Kg\u000eZ8x'\u0019A\u0013P!\r\u00038QQ!\u0011\rB5\u0005W\u0012iGa\u001c\t\u000f\u0005]\u0013\u00071\u0001\u0002\u0010!9\u00111L\u0019A\u0002\u0005=\u0001bBA0c\u0001\u0007\u0011q\u0002\u0005\b\u0003G\n\u0004\u0019AA\b\u0003\u0011\u0019w\u000e]=\u0015\u0015\t\u0005$Q\u000fB<\u0005s\u0012Y\bC\u0005\u0002XI\u0002\n\u00111\u0001\u0002\u0010!I\u00111\f\u001a\u0011\u0002\u0003\u0007\u0011q\u0002\u0005\n\u0003?\u0012\u0004\u0013!a\u0001\u0003\u001fA\u0011\"a\u00193!\u0003\u0005\r!a\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0011\u0016\u0005\u0003\u001f\t)(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u000eB!!q\u0012BM\u001b\t\u0011\tJ\u0003\u0003\u0003\u0014\nU\u0015\u0001\u00027b]\u001eT!Aa&\u0002\t)\fg/Y\u0005\u0005\u00057\u0013\tJ\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003&\n-\u0006c\u0001>\u0003(&\u0019!\u0011V>\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003.f\n\t\u00111\u0001\u0002^\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa-\u0011\r\tU&1\u0018BS\u001b\t\u00119LC\u0002\u0003:n\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iLa.\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003S\u0012\u0019\rC\u0005\u0003.n\n\t\u00111\u0001\u0003&\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011iI!3\t\u0013\t5F(!AA\u0002\u0005u\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002j\t]\u0007\"\u0003BW\u007f\u0005\u0005\t\u0019\u0001BS\u0003!yg/\u001a:mCB\u001cH\u0003BA5\u0005;DqAa\u0018W\u0001\u0004\u0011\t'\u0001\u0005dQ&dGM]3o)1\u0011ICa9\u0003f\n\u001d(\u0011\u001eBv\u0011%\t9\u0006\u0017I\u0001\u0002\u0004\ty\u0001C\u0005\u0002\\a\u0003\n\u00111\u0001\u0002\u0010!I\u0011q\f-\u0011\u0002\u0003\u0007\u0011q\u0002\u0005\n\u0003GB\u0006\u0013!a\u0001\u0003\u001fA\u0011B!\u0012Y!\u0003\u0005\r!a\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kQ!!Q\u0015By\u0011%\u0011i\u000bYA\u0001\u0002\u0004\ti\u000e\u0006\u0003\u0002j\tU\b\"\u0003BWE\u0006\u0005\t\u0019\u0001BS)\u0011\u0011iI!?\t\u0013\t56-!AA\u0002\u0005uG\u0003BA5\u0005{D\u0011B!,g\u0003\u0003\u0005\rA!*\u0002#1+g/\u001a7P]\u0016,E.Z7f]R\u001c\b%A\bMKZ,G\u000eV3s[&t\u0017\r^8s+\t\u0011I#\u0001\tMKZ,G\u000eV3s[&t\u0017\r^8sA\u0005)1-Y2iKV\u001111\u0002\t\t\u0007\u001b\u00199\"!\u0001\u0002\u001c5\u00111q\u0002\u0006\u0005\u0007#\u0019\u0019\"\u0001\u0006d_:\u001cWO\u001d:f]RTAa!\u0006\u0003\u0016\u0006!Q\u000f^5m\u0013\u0011\u0019Iba\u0004\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007/\u0001\u0004dC\u000eDW\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u00037\u0019\t\u0003\u0003\u0004\u0000O\u0001\u0007\u0011\u0011A\u0001\f#V,'/_,j]\u0012|w\u000fE\u0002\u0003,\u0005\u001bR!QB\u0015\u0007k\u0001bba\u000b\u00042\u0005=\u0011qBA\b\u0003\u001f\u0011\t'\u0004\u0002\u0004.)\u00191qF>\u0002\u000fI,h\u000e^5nK&!11GB\u0017\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0007o\u0019i$\u0004\u0002\u0004:)!11\bBK\u0003\tIw.\u0003\u0003\u0003<\reBCAB\u0013))\u0011\tga\u0011\u0004F\r\u001d3\u0011\n\u0005\b\u0003/\"\u0005\u0019AA\b\u0011\u001d\tY\u0006\u0012a\u0001\u0003\u001fAq!a\u0018E\u0001\u0004\ty\u0001C\u0004\u0002d\u0011\u0003\r!a\u0004\u0002\u000fUt\u0017\r\u001d9msR!1qJB)!\u0015Q\u0018\u0011\\A'\u0011%\u0019\u0019&RA\u0001\u0002\u0004\u0011\t'A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\u0017\u0011\t\t=51L\u0005\u0005\u0007;\u0012\tJ\u0001\u0004PE*,7\r^\u0001\t1\u0016cW-\\3oiB\u0019!1\u00065\u0014\u000b!\u001c)g!\u000e\u0011!\r-2qMA\b\u0003\u001f\ty!a\u0004\u0002\u0010\t%\u0012\u0002BB5\u0007[\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86)\t\u0019\t\u0007\u0006\u0007\u0003*\r=4\u0011OB:\u0007k\u001a9\bC\u0004\u0002X-\u0004\r!a\u0004\t\u000f\u0005m3\u000e1\u0001\u0002\u0010!9\u0011qL6A\u0002\u0005=\u0001bBA2W\u0002\u0007\u0011q\u0002\u0005\b\u0005\u000bZ\u0007\u0019AA\b)\u0011\u0019Yha!\u0011\u000bi\fIn! \u0011\u001bi\u001cy(a\u0004\u0002\u0010\u0005=\u0011qBA\b\u0013\r\u0019\ti\u001f\u0002\u0007)V\u0004H.Z\u001b\t\u0013\rMC.!AA\u0002\t%\u0002bBBD5\u0001\u0007\u0011Q\\\u0001\ne\u0006tw-Z*u_B\fAb]3rk\u0016t7-Z\"pI\u0016$\u0002\"a\u0011\u0004\u000e\u000eE5Q\u0013\u0005\b\u0007\u001f[\u0002\u0019AA\b\u0003\u0005A\bbBBJ7\u0001\u0007\u0011qB\u0001\u0002s\"9!QI\u000eA\u0002\u0005u\u0017\u0001E:fcV,gnY3J]R,'O^1m))\u0019Yj!(\u0004 \u000e\u000561\u0015\t\bu\u0006-\u00111IA\"\u0011\u001d\u0019y\t\ba\u0001\u0003\u001fAqaa%\u001d\u0001\u0004\ty\u0001C\u0004\u0003Fq\u0001\r!!\u0001\t\u000f\r\u0015F\u00041\u0001\u0002j\u00059\u0001/\u0019:uS\u0006d\u0017!\u00038pe6\fG.\u001b>f)1\tiea+\u0004.\u000e=6\u0011WBZ\u0011\u001d\t9&\ba\u0001\u0003\u001fAq!a\u0017\u001e\u0001\u0004\ty\u0001C\u0004\u0002`u\u0001\r!a\u0004\t\u000f\u0005\rT\u00041\u0001\u0002\u0010!9\u0011qM\u000fA\u0002\u0005%\u0004")
public class XZ2SFC {
    private final short g;
    private final double xLo;
    private final double xHi;
    private final double yLo;
    private final double yHi;
    private final double xSize;
    private final double ySize;

    public static XZ2SFC apply(short g) {
        return XZ2SFC$.MODULE$.apply(g);
    }

    private double xLo() {
        return this.xLo;
    }

    private double xHi() {
        return this.xHi;
    }

    private double yLo() {
        return this.yLo;
    }

    private double yHi() {
        return this.yHi;
    }

    private double xSize() {
        return this.xSize;
    }

    private double ySize() {
        return this.ySize;
    }

    public long index(Tuple4<Object, Object, Object, Object> bounds) {
        return this.index(BoxesRunTime.unboxToDouble((Object)bounds._1()), BoxesRunTime.unboxToDouble((Object)bounds._2()), BoxesRunTime.unboxToDouble((Object)bounds._3()), BoxesRunTime.unboxToDouble((Object)bounds._4()), this.index$default$5());
    }

    public long index(double xmin, double ymin, double xmax, double ymax, boolean lenient) {
        double w2;
        Tuple4<Object, Object, Object, Object> tuple4 = this.normalize(xmin, ymin, xmax, ymax, lenient);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        double nxmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double nymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double nxmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double nymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
        double nxmin2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
        double nymin2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
        double nxmax2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
        double nymax2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
        double maxDim = package$.MODULE$.max(nxmax2 - nxmin2, nymax2 - nymin2);
        int l1 = (int)package$.MODULE$.floor(package$.MODULE$.log(maxDim) / XZSFC$.MODULE$.LogPointFive());
        int length = l1 >= this.g ? this.g : (XZ2SFC.predicate$1(nxmin2, nxmax2, w2 = package$.MODULE$.pow(0.5, (double)(l1 + 1))) && XZ2SFC.predicate$1(nymin2, nymax2, w2) ? l1 + 1 : l1);
        return this.sequenceCode(nxmin2, nymin2, length);
    }

    public boolean index$default$5() {
        return false;
    }

    public Seq<package.IndexRange> ranges(Tuple4<Object, Object, Object, Object> query) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)new .colon.colon(query, (List)Nil$.MODULE$), this.ranges$default$2());
    }

    public Seq<package.IndexRange> ranges(Tuple4<Object, Object, Object, Object> query, Option<Object> maxRanges) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)new .colon.colon(query, (List)Nil$.MODULE$), maxRanges);
    }

    public Seq<package.IndexRange> ranges(double xmin, double ymin, double xmax, double ymax) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax)), (List)Nil$.MODULE$), this.ranges$default$2());
    }

    public Seq<package.IndexRange> ranges(double xmin, double ymin, double xmax, double ymax, Option<Object> maxRanges) {
        return this.ranges((Seq<Tuple4<Object, Object, Object, Object>>)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax)), (List)Nil$.MODULE$), maxRanges);
    }

    public Seq<package.IndexRange> ranges(Seq<Tuple4<Object, Object, Object, Object>> queries, Option<Object> maxRanges) {
        Seq windows = (Seq)queries.map((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double ymax;
                double xmax;
                double ymin;
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                Tuple4<Object, Object, Object, Object> tuple42 = this.normalize(xmin, ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2()), xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3()), ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4()), false);
                if (tuple42 == null) {
                    throw new MatchError(tuple42);
                }
                double nxmin = BoxesRunTime.unboxToDouble((Object)tuple42._1());
                double nymin = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                double nxmax = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                double nymax = BoxesRunTime.unboxToDouble((Object)tuple42._4());
                Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
                double nxmin2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
                double nymin2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                double nxmax2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                double nymax2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
                return new QueryWindow(nxmin2, nymin2, nxmax2, nymax2);
            }
            throw new MatchError((Object)tuple4);
        });
        return this.ranges((QueryWindow[])windows.toArray(ClassTag$.MODULE$.apply(QueryWindow.class)), BoxesRunTime.unboxToInt((Object)maxRanges.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)));
    }

    private Seq<package.IndexRange> ranges(QueryWindow[] query, int rangeStop) {
        ArrayList<package.IndexRange> ranges = new ArrayList<package.IndexRange>(100);
        ArrayDeque<XElement> remaining = new ArrayDeque<XElement>(100);
        XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelOneElements().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)remaining.add(x$1)));
        remaining.add(XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator());
        short level = 1;
        while (level < this.g && !remaining.isEmpty() && ranges.size() < rangeStop) {
            Object object;
            XElement next = (XElement)remaining.poll();
            if (next == XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator()) {
                if (!remaining.isEmpty()) {
                    level = (short)(level + 1);
                    object = BoxesRunTime.boxToBoolean((boolean)remaining.add(XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator()));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            this.checkValue$1(next, level, ranges, remaining, query);
            object = BoxedUnit.UNIT;
        }
        while (!remaining.isEmpty()) {
            Object object;
            XElement quad = (XElement)remaining.poll();
            if (quad == XZ2SFC$.MODULE$.org$locationtech$geomesa$curve$XZ2SFC$$LevelTerminator()) {
                level = (short)(level + 1);
                object = BoxedUnit.UNIT;
                continue;
            }
            Tuple2<Object, Object> tuple2 = this.sequenceInterval(quad.xmin(), quad.ymin(), level, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long min = tuple2._1$mcJ$sp();
            long max = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(min, max);
            long min2 = sp2._1$mcJ$sp();
            long max2 = sp2._2$mcJ$sp();
            object = BoxesRunTime.boxToBoolean((boolean)ranges.add(package$IndexRange$.MODULE$.apply(min2, max2, false)));
        }
        ranges.sort((Comparator<package.IndexRange>)((Object)package$IndexRange$IndexRangeIsOrdered$.MODULE$));
        package.IndexRange current = (package.IndexRange)ranges.get(0);
        ArrayBuffer result = ArrayBuffer$.MODULE$.empty();
        for (int i = 1; i < ranges.size(); ++i) {
            package.IndexRange range = (package.IndexRange)ranges.get(i);
            if (range.lower() <= current.upper() + 1L) {
                current = package$IndexRange$.MODULE$.apply(current.lower(), package$.MODULE$.max(current.upper(), range.upper()), current.contained() && range.contained());
                continue;
            }
            result.append((Object)current);
            current = range;
        }
        result.append((Object)current);
        return result.toSeq();
    }

    public Option<Object> ranges$default$2() {
        return None$.MODULE$;
    }

    private long sequenceCode(double x, double y, int length) {
        double xmin = 0.0;
        double ymin = 0.0;
        double xmax = 1.0;
        double ymax = 1.0;
        long cs = 0L;
        for (int i = 0; i < length; ++i) {
            double yCenter;
            double xCenter = (xmin + xmax) / 2.0;
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(x < xCenter, y < (yCenter = (ymin + ymax) / 2.0));
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl2 = sp2._2$mcZ$sp();
                if (bl && bl2) {
                    ++cs;
                    xmax = xCenter;
                    ymax = yCenter;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl3 = sp2._2$mcZ$sp();
                if (!bl && bl3) {
                    cs += 1L + 1L * ((long)package$.MODULE$.pow(4.0, (double)(this.g - i)) - 1L) / 3L;
                    xmin = xCenter;
                    ymax = yCenter;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl4 = sp2._2$mcZ$sp();
                if (bl && !bl4) {
                    cs += 1L + 2L * ((long)package$.MODULE$.pow(4.0, (double)(this.g - i)) - 1L) / 3L;
                    xmax = xCenter;
                    ymin = yCenter;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl5 = sp2._2$mcZ$sp();
                if (!bl && !bl5) {
                    cs += 1L + 3L * ((long)package$.MODULE$.pow(4.0, (double)(this.g - i)) - 1L) / 3L;
                    xmin = xCenter;
                    ymin = yCenter;
                    continue;
                }
            }
            throw new MatchError((Object)sp2);
        }
        return cs;
    }

    private Tuple2<Object, Object> sequenceInterval(double x, double y, short length, boolean partial) {
        long min = this.sequenceCode(x, y, length);
        long max = partial ? min : min + ((long)package$.MODULE$.pow(4.0, (double)(this.g - length + 1)) - 1L) / 3L;
        return new Tuple2.mcJJ.sp(min, max);
    }

    private Tuple4<Object, Object, Object, Object> normalize(double xmin, double ymin, double xmax, double ymax, boolean lenient) {
        Tuple4 tuple4;
        Predef$.MODULE$.require(xmin <= xmax && ymin <= ymax, (Function0 & Serializable)() -> new StringBuilder(31).append("Bounds must be ordered: [").append(xmin).append(" ").append(xmax).append("] [").append(ymin).append(" ").append(ymax).append("]").toString());
        try {
            Predef$.MODULE$.require(xmin >= this.xLo() && xmax <= this.xHi() && ymin >= this.yLo() && ymax <= this.yHi(), (Function0 & Serializable)() -> new StringBuilder(39).append("Values out of bounds ([").append(this.xLo()).append(" ").append(this.xHi()).append("] [").append(this.yLo()).append(" ").append(this.yHi()).append("]): [").append(xmin).append(" ").append(xmax).append("] [").append(ymin).append(" ").append(ymax).append("]").toString());
            double nxmin = (xmin - this.xLo()) / this.xSize();
            double nymin = (ymin - this.yLo()) / this.ySize();
            double nxmax = (xmax - this.xLo()) / this.xSize();
            double nymax = (ymax - this.yLo()) / this.ySize();
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && lenient) {
                double bxmax;
                double bymin;
                double bxmin;
                double d = xmin < this.xLo() ? this.xLo() : (bxmin = xmin > this.xHi() ? this.xHi() : xmin);
                double d2 = ymin < this.yLo() ? this.yLo() : (bymin = ymin > this.yHi() ? this.yHi() : ymin);
                double d3 = xmax < this.xLo() ? this.xLo() : (bxmax = xmax > this.xHi() ? this.xHi() : xmax);
                double bymax = ymax < this.yLo() ? this.yLo() : (ymax > this.yHi() ? this.yHi() : ymax);
                double nxmin = (bxmin - this.xLo()) / this.xSize();
                double nymin = (bymin - this.yLo()) / this.ySize();
                double nxmax = (bxmax - this.xLo()) / this.xSize();
                double nymax = (bymax - this.yLo()) / this.ySize();
                tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)nxmin), (Object)BoxesRunTime.boxToDouble((double)nymin), (Object)BoxesRunTime.boxToDouble((double)nxmax), (Object)BoxesRunTime.boxToDouble((double)nymax));
            }
            throw throwable;
        }
        return tuple4;
    }

    private static final boolean predicate$1(double min, double max, double w2$1) {
        return max <= package$.MODULE$.floor(min / w2$1) * w2$1 + (double)2 * w2$1;
    }

    private static final boolean isContained$1(XElement quad, QueryWindow[] query$1) {
        for (int i = 0; i < query$1.length; ++i) {
            if (!quad.isContained(query$1[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isOverlapped$1(XElement quad, QueryWindow[] query$1) {
        for (int i = 0; i < query$1.length; ++i) {
            if (!quad.overlaps(query$1[i])) continue;
            return true;
        }
        return false;
    }

    private final void checkValue$1(XElement quad, short level, ArrayList ranges$1, ArrayDeque remaining$1, QueryWindow[] query$1) {
        if (XZ2SFC.isContained$1(quad, query$1)) {
            Tuple2<Object, Object> tuple2 = this.sequenceInterval(quad.xmin(), quad.ymin(), level, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long min = tuple2._1$mcJ$sp();
            long max = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(min, max);
            long min2 = sp2._1$mcJ$sp();
            long max2 = sp2._2$mcJ$sp();
            ranges$1.add(package$IndexRange$.MODULE$.apply(min2, max2, true));
            return;
        }
        if (XZ2SFC.isOverlapped$1(quad, query$1)) {
            Tuple2<Object, Object> tuple2 = this.sequenceInterval(quad.xmin(), quad.ymin(), level, true);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long min = tuple2._1$mcJ$sp();
            long max = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(min, max);
            long min3 = sp3._1$mcJ$sp();
            long max3 = sp3._2$mcJ$sp();
            ranges$1.add(package$IndexRange$.MODULE$.apply(min3, max3, false));
            quad.children().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)remaining$1.add(x$1)));
            return;
        }
    }

    public XZ2SFC(short g, Tuple2<Object, Object> xBounds, Tuple2<Object, Object> yBounds) {
        this.g = g;
        this.xLo = xBounds._1$mcD$sp();
        this.xHi = xBounds._2$mcD$sp();
        this.yLo = yBounds._1$mcD$sp();
        this.yHi = yBounds._2$mcD$sp();
        this.xSize = this.xHi() - this.xLo();
        this.ySize = this.yHi() - this.yLo();
    }

    private static class QueryWindow
    implements Product,
    Serializable {
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        public QueryWindow copy(double xmin, double ymin, double xmax, double ymax) {
            return new QueryWindow(xmin, ymin, xmax, ymax);
        }

        public double copy$default$1() {
            return this.xmin();
        }

        public double copy$default$2() {
            return this.ymin();
        }

        public double copy$default$3() {
            return this.xmax();
        }

        public double copy$default$4() {
            return this.ymax();
        }

        public String productPrefix() {
            return "QueryWindow";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.xmin());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.ymin());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this.xmax());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this.ymax());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof QueryWindow;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "xmin";
                }
                case 1: {
                    return "ymin";
                }
                case 2: {
                    return "xmax";
                }
                case 3: {
                    return "ymax";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymax()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof QueryWindow)) return false;
            boolean bl = true;
            if (!bl) return false;
            QueryWindow queryWindow = (QueryWindow)x$1;
            if (this.xmin() != queryWindow.xmin()) return false;
            if (this.ymin() != queryWindow.ymin()) return false;
            if (this.xmax() != queryWindow.xmax()) return false;
            if (this.ymax() != queryWindow.ymax()) return false;
            if (!queryWindow.canEqual(this)) return false;
            return true;
        }

        public QueryWindow(double xmin, double ymin, double xmax, double ymax) {
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
            Product.$init$((Product)this);
        }
    }

    private static class XElement
    implements Product,
    Serializable {
        private double xext;
        private double yext;
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;
        private final double length;
        private volatile byte bitmap$0;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        public double length() {
            return this.length;
        }

        private double xext$lzycompute() {
            XElement xElement = this;
            synchronized (xElement) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.xext = this.xmax() + this.length();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.xext;
        }

        public double xext() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.xext$lzycompute();
            }
            return this.xext;
        }

        private double yext$lzycompute() {
            XElement xElement = this;
            synchronized (xElement) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.yext = this.ymax() + this.length();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.yext;
        }

        public double yext() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.yext$lzycompute();
            }
            return this.yext;
        }

        public boolean isContained(QueryWindow window) {
            return window.xmin() <= this.xmin() && window.ymin() <= this.ymin() && window.xmax() >= this.xext() && window.ymax() >= this.yext();
        }

        public boolean overlaps(QueryWindow window) {
            return window.xmax() >= this.xmin() && window.ymax() >= this.ymin() && window.xmin() <= this.xext() && window.ymin() <= this.yext();
        }

        public Seq<XElement> children() {
            double xCenter = (this.xmin() + this.xmax()) / 2.0;
            double yCenter = (this.ymin() + this.ymax()) / 2.0;
            double len = this.length() / 2.0;
            double x$1 = xCenter;
            double x$2 = yCenter;
            double x$3 = len;
            double x$4 = this.copy$default$1();
            double x$5 = this.copy$default$2();
            XElement c0 = this.copy(x$4, x$5, x$1, x$2, x$3);
            double x$6 = xCenter;
            double x$7 = yCenter;
            double x$8 = len;
            double x$9 = this.copy$default$2();
            double x$10 = this.copy$default$3();
            XElement c1 = this.copy(x$6, x$9, x$10, x$7, x$8);
            double x$11 = xCenter;
            double x$12 = yCenter;
            double x$13 = len;
            double x$14 = this.copy$default$1();
            double x$15 = this.copy$default$4();
            XElement c2 = this.copy(x$14, x$12, x$11, x$15, x$13);
            double x$16 = xCenter;
            double x$17 = yCenter;
            double x$18 = len;
            double x$19 = this.copy$default$3();
            double x$20 = this.copy$default$4();
            XElement c3 = this.copy(x$16, x$17, x$19, x$20, x$18);
            return new .colon.colon((Object)c0, (List)new .colon.colon((Object)c1, (List)new .colon.colon((Object)c2, (List)new .colon.colon((Object)c3, (List)Nil$.MODULE$))));
        }

        public XElement copy(double xmin, double ymin, double xmax, double ymax, double length) {
            return new XElement(xmin, ymin, xmax, ymax, length);
        }

        public double copy$default$1() {
            return this.xmin();
        }

        public double copy$default$2() {
            return this.ymin();
        }

        public double copy$default$3() {
            return this.xmax();
        }

        public double copy$default$4() {
            return this.ymax();
        }

        public double copy$default$5() {
            return this.length();
        }

        public String productPrefix() {
            return "XElement";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.xmin());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.ymin());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this.xmax());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this.ymax());
                }
                case 4: {
                    return BoxesRunTime.boxToDouble((double)this.length());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof XElement;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "xmin";
                }
                case 1: {
                    return "ymin";
                }
                case 2: {
                    return "xmax";
                }
                case 3: {
                    return "ymax";
                }
                case 4: {
                    return "length";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymin()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.xmax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.ymax()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.length()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof XElement)) return false;
            boolean bl = true;
            if (!bl) return false;
            XElement xElement = (XElement)x$1;
            if (this.xmin() != xElement.xmin()) return false;
            if (this.ymin() != xElement.ymin()) return false;
            if (this.xmax() != xElement.xmax()) return false;
            if (this.ymax() != xElement.ymax()) return false;
            if (this.length() != xElement.length()) return false;
            if (!xElement.canEqual(this)) return false;
            return true;
        }

        public XElement(double xmin, double ymin, double xmax, double ymax, double length) {
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
            this.length = length;
            Product.$init$((Product)this);
        }
    }
}

