/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.zk;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.data.Stat;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.KeyValueStoreMetadata;
import org.locationtech.geomesa.index.metadata.TableBasedMetadata;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.zk.CuratorHelper$;
import org.locationtech.geomesa.utils.zk.ZookeeperMetadata$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\r\u001b\u0001\u0015B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005\u000f\"A1\u000b\u0001BC\u0002\u0013\u0005a\t\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003H\u0011!)\u0006A!b\u0001\n\u00031\u0006\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u000b%\u0004A\u0011\u00016\t\u000fA\u0004!\u0019!C\u0005c\"1A\u0010\u0001Q\u0001\nIDQ! \u0001\u0005RyDq!!\u0002\u0001\t#\n9\u0001C\u0004\u0002\u0010\u0001!\t&!\u0005\t\u000f\u0005]\u0001\u0001\"\u0015\u0002\u001a!9\u0011\u0011\t\u0001\u0005R\u0005\r\u0003bBA%\u0001\u0011E\u00131\n\u0005\b\u0003/\u0002A\u0011KA-\u0011\u001d\tY\u0007\u0001C!\u0003\u000fAq!!\u001c\u0001\t\u0013\ty\u0007C\u0005\u0002x\u0001\t\n\u0011\"\u0003\u0002z\u001d9\u0011q\u0012\u000e\t\u0002\u0005EeAB\r\u001b\u0011\u0003\t\u0019\n\u0003\u0004j+\u0011\u0005\u00111\u0014\u0005\n\u0003;+\"\u0019!C\u0005\u0003?C\u0001\"!*\u0016A\u0003%\u0011\u0011\u0015\u0002\u00125>|7.Z3qKJlU\r^1eCR\f'BA\u000e\u001d\u0003\tQ8N\u0003\u0002\u001e=\u0005)Q\u000f^5mg*\u0011q\u0004I\u0001\bO\u0016|W.Z:b\u0015\t\t#%\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001$\u0003\ry'oZ\u0002\u0001+\t1\u0013hE\u0002\u0001O=\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\t1\fgn\u001a\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0004PE*,7\r\u001e\t\u0004aU:T\"A\u0019\u000b\u0005I\u001a\u0014\u0001C7fi\u0006$\u0017\r^1\u000b\u0005Qr\u0012!B5oI\u0016D\u0018B\u0001\u001c2\u0005UYU-\u001f,bYV,7\u000b^8sK6+G/\u00193bi\u0006\u0004\"\u0001O\u001d\r\u0001\u0011)!\b\u0001b\u0001w\t\tA+\u0005\u0002=\u0005B\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t9aj\u001c;iS:<\u0007CA\u001fD\u0013\t!eHA\u0002B]f\f\u0011B\\1nKN\u0004\u0018mY3\u0016\u0003\u001d\u0003\"\u0001S(\u000f\u0005%k\u0005C\u0001&?\u001b\u0005Y%B\u0001'%\u0003\u0019a$o\\8u}%\u0011aJP\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002O}\u0005Qa.Y7fgB\f7-\u001a\u0011\u0002\u0015i|wn[3fa\u0016\u00148/A\u0006{_>\\W-\u001a9feN\u0004\u0013AC:fe&\fG.\u001b>feV\tq\u000bE\u0002YK^r!!W2\u000f\u0005i\u0013gBA.b\u001d\ta\u0006M\u0004\u0002^?:\u0011!JX\u0005\u0002G%\u0011\u0011EI\u0005\u0003?\u0001J!\u0001\u000e\u0010\n\u0005I\u001a\u0014B\u000132\u0003\u001d\u0001\u0018mY6bO\u0016L!AZ4\u0003%5+G/\u00193bi\u0006\u001cVM]5bY&TXM\u001d\u0006\u0003IF\n1b]3sS\u0006d\u0017N_3sA\u00051A(\u001b8jiz\"Ba[7o_B\u0019A\u000eA\u001c\u000e\u0003iAQ!R\u0004A\u0002\u001dCQaU\u0004A\u0002\u001dCQ!V\u0004A\u0002]\u000baa\u00197jK:$X#\u0001:\u0011\u0005MTX\"\u0001;\u000b\u0005U4\u0018!\u00034sC6,wo\u001c:l\u0015\t9\b0A\u0004dkJ\fGo\u001c:\u000b\u0005e\u0014\u0013AB1qC\u000eDW-\u0003\u0002|i\n\u00012)\u001e:bi>\u0014hI]1nK^|'o[\u0001\bG2LWM\u001c;!\u0003I\u0019\u0007.Z2l\u0013\u001a$\u0016M\u00197f\u000bbL7\u000f^:\u0016\u0003}\u00042!PA\u0001\u0013\r\t\u0019A\u0010\u0002\b\u0005>|G.Z1o\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0005\u0005%\u0001cA\u001f\u0002\f%\u0019\u0011Q\u0002 \u0003\tUs\u0017\u000e^\u0001\u0012GJ,\u0017\r^3F[B$\u0018PQ1dWV\u0004HcA6\u0002\u0014!1\u0011Q\u0003\u0007A\u0002\u001d\u000b\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0005%\u00111\u0004\u0005\b\u0003;i\u0001\u0019AA\u0010\u0003\u0011\u0011xn^:\u0011\r\u0005\u0005\u0012\u0011FA\u0018\u001d\u0011\t\u0019#a\n\u000f\u0007)\u000b)#C\u0001@\u0013\t!g(\u0003\u0003\u0002,\u00055\"aA*fc*\u0011AM\u0010\t\b{\u0005E\u0012QGA\u001b\u0013\r\t\u0019D\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000bu\n9$a\u000f\n\u0007\u0005ebHA\u0003BeJ\f\u0017\u0010E\u0002>\u0003{I1!a\u0010?\u0005\u0011\u0011\u0015\u0010^3\u0002\r\u0011,G.\u001a;f)\u0011\tI!!\u0012\t\u000f\u0005ua\u00021\u0001\u0002HA1\u0011\u0011EA\u0015\u0003k\t\u0011b]2b]Z\u000bG.^3\u0015\t\u00055\u00131\u000b\t\u0006{\u0005=\u0013QG\u0005\u0004\u0003#r$AB(qi&|g\u000eC\u0004\u0002V=\u0001\r!!\u000e\u0002\u0007I|w/\u0001\u0005tG\u0006t'k\\<t)\u0011\tY&a\u001a\u0011\r\u0005u\u00131MA\u0018\u001b\t\tyFC\u0002\u0002bq\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)'a\u0018\u0003#\rcwn]3bE2,\u0017\n^3sCR|'\u000fC\u0004\u0002jA\u0001\r!!\u0014\u0002\rA\u0014XMZ5y\u0003\u0015\u0019Gn\\:f\u0003\u0019!x\u000eU1uQR)q)!\u001d\u0002t!9\u0011Q\u000b\nA\u0002\u0005U\u0002\u0002CA;%A\u0005\t\u0019A@\u0002\u0013]LG\u000f[*mCND\u0017\u0001\u0005;p!\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tYHK\u0002\u0000\u0003{Z#!a \u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013s\u0014AC1o]>$\u0018\r^5p]&!\u0011QRAB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u00125>|7.Z3qKJlU\r^1eCR\f\u0007C\u00017\u0016'\r)\u0012Q\u0013\t\u0004{\u0005]\u0015bAAM}\t1\u0011I\\=SK\u001a$\"!!%\u0002\tI{w\u000e^\u000b\u0003\u0003C\u00032\u0001KAR\u0013\t\u0001\u0016&A\u0003S_>$\b\u0005")
public class ZookeeperMetadata<T>
implements KeyValueStoreMetadata<T> {
    private final String namespace;
    private final String zookeepers;
    private final package.MetadataSerializer<T> serializer;
    private final CuratorFramework client;
    private char typeNameSeparator;
    private AtomicBoolean org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    private long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    private LoadingCache<Tuple2<String, String>, Option<T>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    private LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    private DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public byte[] encodeRow(String typeName, String key) {
        return KeyValueStoreMetadata.encodeRow$((KeyValueStoreMetadata)this, (String)typeName, (String)key);
    }

    public void write(String typeName, Seq<Tuple2<String, byte[]>> rows) {
        KeyValueStoreMetadata.write$((KeyValueStoreMetadata)this, (String)typeName, rows);
    }

    public void delete(String typeName, Seq<String> keys) {
        KeyValueStoreMetadata.delete$((KeyValueStoreMetadata)this, (String)typeName, keys);
    }

    public Option<byte[]> scanValue(String typeName, String key) {
        return KeyValueStoreMetadata.scanValue$((KeyValueStoreMetadata)this, (String)typeName, (String)key);
    }

    public CloseableIterator<Tuple2<String, byte[]>> scanValues(String typeName, String prefix) {
        return KeyValueStoreMetadata.scanValues$((KeyValueStoreMetadata)this, (String)typeName, (String)prefix);
    }

    public CloseableIterator<Tuple2<String, String>> scanKeys() {
        return KeyValueStoreMetadata.scanKeys$((KeyValueStoreMetadata)this);
    }

    public String scanValues$default$2() {
        return TableBasedMetadata.scanValues$default$2$((TableBasedMetadata)this);
    }

    public String[] getFeatureTypes() {
        return TableBasedMetadata.getFeatureTypes$((TableBasedMetadata)this);
    }

    public Option<T> read(String typeName, String key, boolean cache) {
        return TableBasedMetadata.read$((TableBasedMetadata)this, (String)typeName, (String)key, (boolean)cache);
    }

    public Seq<Tuple2<String, T>> scan(String typeName, String prefix, boolean cache) {
        return TableBasedMetadata.scan$((TableBasedMetadata)this, (String)typeName, (String)prefix, (boolean)cache);
    }

    public void insert(String typeName, String key, T value) {
        TableBasedMetadata.insert$((TableBasedMetadata)this, (String)typeName, (String)key, value);
    }

    public void insert(String typeName, Map<String, T> kvPairs) {
        TableBasedMetadata.insert$((TableBasedMetadata)this, (String)typeName, kvPairs);
    }

    public void invalidateCache(String typeName, String key) {
        TableBasedMetadata.invalidateCache$((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, String key) {
        TableBasedMetadata.remove$((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, Seq<String> keys) {
        TableBasedMetadata.remove$((TableBasedMetadata)this, (String)typeName, keys);
    }

    public void delete(String typeName) {
        TableBasedMetadata.delete$((TableBasedMetadata)this, (String)typeName);
    }

    public void backup(String typeName) {
        TableBasedMetadata.backup$((TableBasedMetadata)this, (String)typeName);
    }

    public void ensureTableExists() {
        TableBasedMetadata.ensureTableExists$((TableBasedMetadata)this);
    }

    public void resetCache() {
        TableBasedMetadata.resetCache$((TableBasedMetadata)this);
    }

    public boolean read$default$3() {
        return GeoMesaMetadata.read$default$3$((GeoMesaMetadata)this);
    }

    public T readRequired(String typeName, String key) {
        return (T)GeoMesaMetadata.readRequired$((GeoMesaMetadata)this, (String)typeName, (String)key);
    }

    public boolean scan$default$3() {
        return GeoMesaMetadata.scan$default$3$((GeoMesaMetadata)this);
    }

    public char typeNameSeparator() {
        return this.typeNameSeparator;
    }

    public void org$locationtech$geomesa$index$metadata$KeyValueStoreMetadata$_setter_$typeNameSeparator_$eq(char x$1) {
        this.typeNameSeparator = x$1;
    }

    public AtomicBoolean org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    }

    public long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    }

    public LoadingCache<Tuple2<String, String>, Option<T>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    }

    public LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    }

    private DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute() {
        ZookeeperMetadata zookeeperMetadata = this;
        synchronized (zookeeperMetadata) {
            if (!this.bitmap$0) {
                this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter = TableBasedMetadata.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$((TableBasedMetadata)this);
                this.bitmap$0 = true;
            }
        }
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    }

    public DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter() {
        if (!this.bitmap$0) {
            return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute();
        }
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists_$eq(AtomicBoolean x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry_$eq(long x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache_$eq(LoadingCache<Tuple2<String, String>, Option<T>> x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache_$eq(LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache = x$1;
    }

    private Logger logger$lzycompute() {
        ZookeeperMetadata zookeeperMetadata = this;
        synchronized (zookeeperMetadata) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String namespace() {
        return this.namespace;
    }

    public String zookeepers() {
        return this.zookeepers;
    }

    public package.MetadataSerializer<T> serializer() {
        return this.serializer;
    }

    private CuratorFramework client() {
        return this.client;
    }

    public boolean checkIfTableExists() {
        return true;
    }

    public void createTable() {
    }

    public ZookeeperMetadata<T> createEmptyBackup(String timestamp) {
        return new ZookeeperMetadata<T>(new StringBuilder(5).append(this.namespace()).append("_").append(timestamp).append("_bak").toString(), this.zookeepers(), this.serializer());
    }

    public void write(Seq<Tuple2<byte[], byte[]>> rows) {
        rows.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                byte[] row = (byte[])tuple2._1();
                byte[] value = (byte[])tuple2._2();
                String path = this.toPath(row, this.toPath$default$2());
                Object object = this.client().checkExists().forPath(path) == null ? this.client().create().creatingParentsIfNeeded().forPath(path) : BoxedUnit.UNIT;
                return (Stat)this.client().setData().forPath(path, value);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void delete(Seq<byte[]> rows) {
        rows.foreach((Function1 & Serializable)row -> {
            String path = this.toPath((byte[])row, this.toPath$default$2());
            if (this.client().checkExists().forPath(path) != null) {
                return this.client().delete().deletingChildrenIfNeeded().forPath(path);
            }
            return BoxedUnit.UNIT;
        });
    }

    public Option<byte[]> scanValue(byte[] row) {
        String path = this.toPath(row, this.toPath$default$2());
        if (this.client().checkExists().forPath(path) == null) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply(this.client().getData().forPath(path));
    }

    public CloseableIterator<Tuple2<byte[], byte[]>> scanRows(Option<byte[]> prefix) {
        CloseableIterator closeableIterator;
        Option path = prefix.map((Function1 & Serializable)x$1 -> this.toPath((byte[])x$1, false));
        if (this.client().checkExists().forPath(ZookeeperMetadata$.MODULE$.org$locationtech$geomesa$utils$zk$ZookeeperMetadata$$Root()) == null) {
            return CloseableIterator$.MODULE$.empty();
        }
        CloseableIterator all = CloseableIterator$.MODULE$.apply(((List)this.client().getChildren().forPath(ZookeeperMetadata$.MODULE$.org$locationtech$geomesa$utils$zk$ZookeeperMetadata$$Root())).iterator());
        Option option = path;
        if (None$.MODULE$.equals(option)) {
            closeableIterator = all;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            closeableIterator = all.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(p)));
        } else {
            throw new MatchError((Object)option);
        }
        CloseableIterator filtered = closeableIterator;
        return filtered.map((Function1 & Serializable)f -> {
            byte[] bytes = f.getBytes(StandardCharsets.UTF_8);
            return new Tuple2((Object)bytes, this.client().getData().forPath(this.toPath(bytes, this.toPath$default$2())));
        });
    }

    public void close() {
        this.client().close();
    }

    private String toPath(byte[] row, boolean withSlash) {
        String string = new String(row, StandardCharsets.UTF_8);
        if (withSlash) {
            return new StringBuilder(1).append("/").append(string).toString();
        }
        return string;
    }

    private boolean toPath$default$2() {
        return true;
    }

    public ZookeeperMetadata(String namespace, String zookeepers, package.MetadataSerializer<T> serializer) {
        this.namespace = namespace;
        this.zookeepers = zookeepers;
        this.serializer = serializer;
        GeoMesaMetadata.$init$((GeoMesaMetadata)this);
        LazyLogging.$init$((LazyLogging)this);
        TableBasedMetadata.$init$((TableBasedMetadata)this);
        KeyValueStoreMetadata.$init$((KeyValueStoreMetadata)this);
        this.client = CuratorHelper$.MODULE$.client(zookeepers).namespace(namespace).build();
        this.client().start();
        Statics.releaseFence();
    }
}

