/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.adapter.auth;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.locationtech.geowave.adapter.auth.AuthorizationSPI;
import org.locationtech.geowave.adapter.auth.AuthorizationSet;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class JsonFileAuthorizationProvider
implements AuthorizationSPI {
    private AuthorizationSet authorizationSet;

    public JsonFileAuthorizationProvider(URL location) {
        if (location == null) {
            this.authorizationSet = new AuthorizationSet();
        } else {
            String path = location.getPath();
            if (!location.getProtocol().equals("file") || !new File(path).canRead() && !new File("." + path).canRead()) {
                throw new IllegalArgumentException("Cannot find file " + location.toString());
            }
            try {
                if (!new File(path).canRead()) {
                    path = "." + path;
                }
                this.parse(new File(path));
            }
            catch (JsonParseException e) {
                throw new IllegalArgumentException("Cannot parse file " + location.toString(), e);
            }
            catch (JsonMappingException e) {
                throw new IllegalArgumentException("Cannot parse file " + location.toString(), e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot parse file " + location.toString(), e);
            }
        }
    }

    private void parse(File file) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        this.authorizationSet = (AuthorizationSet)mapper.readValue(file, AuthorizationSet.class);
    }

    @Override
    public String[] getAuthorizations() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return new String[0];
        }
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String userName = principal.toString();
        if (principal instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)principal;
            userName = userDetails.getUsername();
        }
        List<String> auths = this.authorizationSet.findAuthorizationsFor(userName);
        String[] result = new String[auths.size()];
        auths.toArray(result);
        return result;
    }
}

