/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.geowave.cli.geoserver.GeoServerRestClient;
import org.locationtech.geowave.cli.geoserver.GeoServerSSLConfigurationOptions;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.cli.converters.GeoWaveBaseConverter;
import org.locationtech.geowave.core.cli.converters.OptionalPasswordConverter;
import org.locationtech.geowave.core.cli.operations.config.ConfigSection;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.prefix.JCommanderPrefixTranslator;
import org.locationtech.geowave.core.cli.prefix.JCommanderTranslationMap;
import org.locationtech.geowave.core.cli.prefix.TranslationEntry;

@GeowaveOperation(name="geoserver", parentOperation=ConfigSection.class)
@Parameters(commandDescription="Create a local configuration for GeoServer")
public class ConfigGeoServerCommand
extends ServiceEnabledCommand<String> {
    @Parameter(names={"-u", "--username"}, description="GeoServer User")
    private String username;
    @Parameter(names={"-p", "--password"}, description="GeoServer Password - Can be specified as 'pass:<password>', 'file:<local file containing the password>', 'propfile:<local properties file containing the password>:<property file key>', 'env:<variable containing the pass>', or stdin", converter=OptionalPasswordConverter.class)
    private String pass;
    @Parameter(names={"-ws", "--workspace"}, description="GeoServer Default Workspace")
    private String workspace;
    @Parameter(description="<GeoServer URL>")
    private List<String> parameters = new ArrayList<String>();
    private String url = null;
    @ParametersDelegate
    private GeoServerSSLConfigurationOptions sslConfigOptions = new GeoServerSSLConfigurationOptions();

    public Boolean successStatusIs200() {
        return true;
    }

    public boolean prepare(OperationParams params) {
        boolean passwordSpecified;
        boolean retval = true;
        retval |= super.prepare(params);
        String username = this.getName();
        String password = this.getPass();
        boolean usernameSpecified = username != null && !"".equals(username.trim());
        boolean bl = passwordSpecified = password != null && !"".equals(password.trim());
        if (usernameSpecified || passwordSpecified) {
            if (usernameSpecified && !passwordSpecified) {
                this.setPass(GeoWaveBaseConverter.promptAndReadPassword((String)("Please enter a password for username [" + username + "]: ")));
                if (this.getPass() == null || "".equals(this.getPass().trim())) {
                    throw new ParameterException("Password cannot be null or empty if username is specified");
                }
            } else if (passwordSpecified && !usernameSpecified) {
                this.setName(GeoWaveBaseConverter.promptAndReadValue((String)"Please enter a username associated with specified password: "));
                if (this.getName() == null || "".equals(this.getName().trim())) {
                    throw new ParameterException("Username cannot be null or empty if password is specified");
                }
            }
        }
        return retval;
    }

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String getName() {
        return this.username;
    }

    public void setName(String name) {
        this.username = name;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public GeoServerSSLConfigurationOptions getGeoServerSSLConfigurationOptions() {
        return this.sslConfigOptions;
    }

    public void setGeoServerSSLConfigurationOptions(GeoServerSSLConfigurationOptions sslConfigOptions) {
        this.sslConfigOptions = sslConfigOptions;
    }

    public String usage() {
        StringBuilder builder = new StringBuilder();
        ArrayList nameArray = new ArrayList();
        JCommanderPrefixTranslator translator = new JCommanderPrefixTranslator();
        translator.addObject((Object)this);
        JCommanderTranslationMap map = translator.translate();
        map.createFacadeObjects();
        map.transformToFacade();
        JCommander jc = new JCommander();
        Map translations = map.getEntries();
        block0: for (Object obj : map.getObjects()) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                TranslationEntry tEntry = (TranslationEntry)translations.get(field.getName());
                if (tEntry == null || !(tEntry.getObject() instanceof ConfigGeoServerCommand)) continue;
                jc.addObject(obj);
                continue block0;
            }
        }
        String programName = StringUtils.join(nameArray, (String)" ");
        jc.setProgramName(programName);
        jc.usage(builder);
        String operations = builder.toString().trim();
        builder = new StringBuilder();
        builder.append(operations);
        builder.append("\n\n");
        builder.append("  ");
        jc = new JCommander();
        block2: for (Object obj : map.getObjects()) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                TranslationEntry tEntry = (TranslationEntry)translations.get(field.getName());
                if (tEntry == null || tEntry.getObject() instanceof ConfigGeoServerCommand) continue;
                Parameters parameters = tEntry.getObject().getClass().getAnnotation(Parameters.class);
                if (parameters != null) {
                    builder.append(parameters.commandDescription());
                } else {
                    builder.append("Additional Parameters");
                }
                jc.addObject(obj);
                continue block2;
            }
        }
        jc.setProgramName(programName);
        jc.usage(builder);
        builder.append("\n\n");
        return builder.toString().trim();
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <GeoServer URL>");
        }
        this.url = this.parameters.get(0);
        Properties existingProps = this.getGeoWaveConfigProperties(params);
        if (this.url != null) {
            existingProps.setProperty("geoserver.url", this.url);
        }
        if (this.getName() != null) {
            existingProps.setProperty("geoserver.user", this.getName());
        }
        if (this.getPass() != null) {
            existingProps.setProperty("geoserver.pass", this.getPass());
        }
        if (this.getWorkspace() != null) {
            existingProps.setProperty("geoserver.workspace", this.getWorkspace());
        }
        this.sslConfigOptions.saveProperties(existingProps);
        ConfigOptions.writeProperties((File)this.getGeoWaveConfigFile(params), (Properties)existingProps, ((Object)((Object)this)).getClass(), (String)"geoserver");
        GeoServerRestClient.invalidateInstance();
        StringBuilder builder = new StringBuilder();
        for (Object key : existingProps.keySet()) {
            if (!key.toString().startsWith("geoserver")) continue;
            builder.append(key.toString() + "=" + existingProps.getProperty(key.toString()) + "\n");
        }
        return builder.toString();
    }
}

