/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="addcv", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="Add a GeoServer coverage")
public class GeoServerAddCoverageCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace = null;
    @Parameter(names={"-cs", "--cvgstore"}, required=true, description="coverage store name")
    private String cvgstore = null;
    @Parameter(description="<coverage name>")
    private List<String> parameters = new ArrayList<String>();
    private String cvgName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <coverage name>");
        }
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        this.cvgName = this.parameters.get(0);
        Response addLayerResponse = this.geoserverClient.addCoverage(this.workspace, this.cvgstore, this.cvgName);
        if (addLayerResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            return "Add coverage '" + this.cvgName + "' to '" + this.workspace + "/" + this.cvgstore + "' on GeoServer: OK";
        }
        String errorMessage = "Error adding GeoServer coverage " + this.cvgName + ": " + (String)addLayerResponse.readEntity(String.class) + "\nGeoServer Response Code = " + addLayerResponse.getStatus();
        return (String)this.handleError(addLayerResponse, errorMessage);
    }
}

