/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="addstyle", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="Add a GeoServer style")
public class GeoServerAddStyleCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-sld", "--stylesld"}, required=true, description="style sld file")
    private String stylesld = null;
    @Parameter(description="<GeoWave style name>")
    private List<String> parameters = new ArrayList<String>();
    private String gwStyle = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <style name>");
        }
        this.gwStyle = this.parameters.get(0);
        if (this.gwStyle == null) {
            throw new ParameterException("Requires argument: <style xml file>");
        }
        File styleXmlFile = new File(this.stylesld);
        try (FileInputStream inStream = new FileInputStream(styleXmlFile);){
            Response addStyleResponse = this.geoserverClient.addStyle(this.gwStyle, inStream);
            if (addStyleResponse.getStatus() == Response.Status.OK.getStatusCode() || addStyleResponse.getStatus() == Response.Status.CREATED.getStatusCode()) {
                String string = "Add style for '" + this.gwStyle + "' on GeoServer: OK";
                return string;
            }
            String errorMessage = "Error adding style for '" + this.gwStyle + "' on GeoServer: " + (String)addStyleResponse.readEntity(String.class) + "\nGeoServer Response Code = " + addStyleResponse.getStatus();
            String string = (String)this.handleError(addStyleResponse, errorMessage);
            return string;
        }
    }
}

