/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="addws", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="Add GeoServer workspace")
public class GeoServerAddWorkspaceCommand
extends GeoServerCommand<String> {
    @Parameter(description="<workspace name>")
    private List<String> parameters = new ArrayList<String>();
    private String wsName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <workspace name>");
        }
        this.wsName = this.parameters.get(0);
        Response addWorkspaceResponse = this.geoserverClient.addWorkspace(this.wsName);
        if (addWorkspaceResponse.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return "Add workspace '" + this.wsName + "' to GeoServer: OK";
        }
        String errorMessage = "Error adding workspace '" + this.wsName + "' to GeoServer: " + (String)addWorkspaceResponse.readEntity(String.class) + "\nGeoServer Response Code = " + addWorkspaceResponse.getStatus();
        return (String)this.handleError(addWorkspaceResponse, errorMessage);
    }
}

