/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="getfl", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="Get GeoServer feature layer info")
public class GeoServerGetFeatureLayerCommand
extends GeoServerCommand<String> {
    @Parameter(description="<layer name>")
    private List<String> parameters = new ArrayList<String>();
    private String layerName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <layer name>");
        }
        this.layerName = this.parameters.get(0);
        Response getLayerResponse = this.geoserverClient.getFeatureLayer(this.layerName, false);
        if (getLayerResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)getLayerResponse.getEntity());
            return "\nGeoServer layer info for '" + this.layerName + "': " + jsonResponse.toString(2);
        }
        String errorMessage = "Error getting GeoServer layer info for '" + this.layerName + "': " + (String)getLayerResponse.readEntity(String.class) + "\nGeoServer Response Code = " + getLayerResponse.getStatus();
        return (String)this.handleError(getLayerResponse, errorMessage);
    }
}

