/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="listds", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="List GeoServer datastores")
public class GeoServerListDatastoresCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        Response listStoresResponse;
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        if ((listStoresResponse = this.geoserverClient.getDatastores(this.workspace)).getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)listStoresResponse.getEntity());
            JSONArray datastores = jsonResponse.getJSONArray("dataStores");
            return "\nGeoServer stores list for '" + this.workspace + "': " + datastores.toString(2);
        }
        String errorMessage = "Error getting GeoServer stores list for '" + this.workspace + "': " + (String)listStoresResponse.readEntity(String.class) + "\nGeoServer Response Code = " + listStoresResponse.getStatus();
        return (String)this.handleError(listStoresResponse, errorMessage);
    }
}

