/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="liststyles", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="List GeoServer styles")
public class GeoServerListStylesCommand
extends GeoServerCommand<String> {
    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        Response listStylesResponse = this.geoserverClient.getStyles();
        if (listStylesResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)listStylesResponse.getEntity());
            JSONArray styles = jsonResponse.getJSONArray("styles");
            return "\nGeoServer styles list: " + styles.toString(2);
        }
        String errorMessage = "Error getting GeoServer styles list: " + (String)listStylesResponse.readEntity(String.class) + "\nGeoServer Response Code = " + listStylesResponse.getStatus();
        return (String)this.handleError(listStylesResponse, errorMessage);
    }
}

