/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="listws", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="List GeoServer workspaces")
public class GeoServerListWorkspacesCommand
extends GeoServerCommand<List<String>> {
    public void execute(OperationParams params) throws Exception {
        Iterator iterator = this.computeResults(params).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JCommander.getConsole().println(string);
        }
    }

    public List<String> computeResults(OperationParams params) throws Exception {
        Response getWorkspacesResponse = this.geoserverClient.getWorkspaces();
        ArrayList<String> results = new ArrayList<String>();
        if (getWorkspacesResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            results.add("\nList of GeoServer workspaces:");
            JSONObject jsonResponse = JSONObject.fromObject((Object)getWorkspacesResponse.getEntity());
            JSONArray workspaces = jsonResponse.getJSONArray("workspaces");
            for (int i = 0; i < workspaces.size(); ++i) {
                String wsName = workspaces.getJSONObject(i).getString("name");
                results.add("  > " + wsName);
            }
            results.add("---\n");
            return results;
        }
        String errorMessage = "Error getting GeoServer workspace list: " + (String)getWorkspacesResponse.readEntity(String.class) + "\nGeoServer Response Code = " + getWorkspacesResponse.getStatus();
        return (List)this.handleError(getWorkspacesResponse, errorMessage);
    }
}

