/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerRemoveCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="rmcs", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="Remove GeoServer Coverage Store")
public class GeoServerRemoveCoverageStoreCommand
extends GeoServerRemoveCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="Workspace Name")
    private String workspace;
    @Parameter(description="<coverage store name>")
    private List<String> parameters = new ArrayList<String>();
    private String cvgstoreName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <coverage store name>");
        }
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        this.cvgstoreName = this.parameters.get(0);
        Response deleteCvgStoreResponse = this.geoserverClient.deleteCoverageStore(this.workspace, this.cvgstoreName);
        if (deleteCvgStoreResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            return "Delete store '" + this.cvgstoreName + "' from workspace '" + this.workspace + "' on GeoServer: OK";
        }
        String errorMessage = "Error deleting store '" + this.cvgstoreName + "' from workspace '" + this.workspace + "' on GeoServer: " + (String)deleteCvgStoreResponse.readEntity(String.class) + "\nGeoServer Response Code = " + deleteCvgStoreResponse.getStatus();
        return (String)this.handleError(deleteCvgStoreResponse, errorMessage);
    }
}

