/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerRemoveCommand;
import org.locationtech.geowave.cli.geoserver.GeoServerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name="rmstyle", parentOperation=GeoServerSection.class)
@Parameters(commandDescription="Remove GeoServer Style")
public class GeoServerRemoveStyleCommand
extends GeoServerRemoveCommand<String> {
    @Parameter(description="<style name>")
    private List<String> parameters = new ArrayList<String>();
    private String styleName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <style name>");
        }
        this.styleName = this.parameters.get(0);
        Response deleteStyleResponse = this.geoserverClient.deleteStyle(this.styleName);
        if (deleteStyleResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            return "Delete style '" + this.styleName + "' on GeoServer: OK";
        }
        String errorMessage = "Error deleting style '" + this.styleName + "' on GeoServer: " + (String)deleteStyleResponse.readEntity(String.class) + "\nGeoServer Response Code = " + deleteStyleResponse.getStatus();
        return (String)this.handleError(deleteStyleResponse, errorMessage);
    }
}

