/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.coverage;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.coverage.CoverageSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"list"}, parentOperation=CoverageSection.class)
@Parameters(commandDescription="List GeoServer Coverages")
public class GeoServerListCoveragesCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace;
    @Parameter(description="<coverage store name>")
    private List<String> parameters = new ArrayList<String>();
    private String csName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <coverage store name>");
        }
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        this.csName = this.parameters.get(0);
        Response getCvgStoreResponse = this.geoserverClient.getCoverages(this.workspace, this.csName);
        if (getCvgStoreResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)getCvgStoreResponse.getEntity());
            JSONArray cvgArray = jsonResponse.getJSONArray("coverages");
            return "\nGeoServer coverage list for '" + this.csName + "': " + cvgArray.toString(2);
        }
        String errorMessage = "Error getting GeoServer coverage list for '" + this.csName + "': " + (String)getCvgStoreResponse.readEntity(String.class) + "\nGeoServer Response Code = " + getCvgStoreResponse.getStatus();
        return (String)this.handleError(getCvgStoreResponse, errorMessage);
    }
}

