/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.datastore;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.datastore.DatastoreSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"get"}, parentOperation=DatastoreSection.class)
@Parameters(commandDescription="Get GeoServer DataStore info")
public class GeoServerGetDatastoreCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace = null;
    @Parameter(description="<datastore name>")
    private List<String> parameters = new ArrayList<String>();
    private String datastore = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        Response getStoreResponse;
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <datastore name>");
        }
        this.datastore = this.parameters.get(0);
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        if ((getStoreResponse = this.geoserverClient.getDatastore(this.workspace, this.datastore, false)).getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)getStoreResponse.getEntity());
            JSONObject datastore = jsonResponse.getJSONObject("dataStore");
            return "\nGeoServer store info for '" + datastore + "': " + datastore.toString(2);
        }
        String errorMessage = "Error getting GeoServer store info for '" + this.datastore + "': " + (String)getStoreResponse.readEntity(String.class) + "\nGeoServer Response Code = " + getStoreResponse.getStatus();
        return (String)this.handleError(getStoreResponse, errorMessage);
    }
}

