/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.datastore;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerRemoveCommand;
import org.locationtech.geowave.cli.geoserver.datastore.DatastoreSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"rm"}, parentOperation=DatastoreSection.class)
@Parameters(commandDescription="Remove GeoServer DataStore")
public class GeoServerRemoveDatastoreCommand
extends GeoServerRemoveCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="Workspace Name")
    private String workspace;
    @Parameter(description="<datastore name>")
    private final List<String> parameters = new ArrayList<String>();
    private String datastoreName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <datastore name>");
        }
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        this.datastoreName = this.parameters.get(0);
        Response deleteStoreResponse = this.geoserverClient.deleteDatastore(this.workspace, this.datastoreName);
        if (deleteStoreResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            return "Delete store '" + this.datastoreName + "' from workspace '" + this.workspace + "' on GeoServer: OK";
        }
        String errorMessage = "Error deleting store '" + this.datastoreName + "' from workspace '" + this.workspace + "' on GeoServer: " + (String)deleteStoreResponse.readEntity(String.class) + "\nGeoServer Response Code = " + deleteStoreResponse.getStatus();
        return (String)this.handleError(deleteStoreResponse, errorMessage);
    }
}

