/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.layer;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.layer.LayerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"add"}, parentOperation=LayerSection.class)
@Parameters(commandDescription="Add a GeoServer layer from the given GeoWave store")
public class GeoServerAddLayerCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace = null;
    @Parameter(names={"-a", "--add"}, converter=AddOptionConverter.class, description="For multiple layers, add (all | raster | vector)")
    private AddOption addOption = null;
    @Parameter(names={"-id", "--adapterId"}, description="select just <adapter id> from the store")
    private String adapterId = null;
    @Parameter(names={"-sld", "--setStyle"}, description="default style sld")
    private String style = null;
    @Parameter(description="<GeoWave store name>")
    private List<String> parameters = new ArrayList<String>();
    private String gwStore = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        Response addLayerResponse;
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <store name>");
        }
        this.gwStore = this.parameters.get(0);
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        if (this.addOption != null) {
            this.adapterId = this.addOption.name();
        }
        if ((addLayerResponse = this.geoserverClient.addLayer(this.workspace, this.gwStore, this.adapterId, this.style)).getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)addLayerResponse.getEntity());
            return "Add GeoServer layer for '" + this.gwStore + ": OK : " + jsonResponse.toString(2);
        }
        String errorMessage = "Error adding GeoServer layer for store '" + this.gwStore + "': " + addLayerResponse.getEntity() + "\nGeoServer Response Code = " + addLayerResponse.getStatus();
        return (String)this.handleError(addLayerResponse, errorMessage);
    }

    public static class AddOptionConverter
    implements IStringConverter<AddOption> {
        public AddOption convert(String value) {
            AddOption convertedValue = AddOption.valueOf(value.toUpperCase());
            if (convertedValue != AddOption.ALL && convertedValue != AddOption.RASTER && convertedValue != AddOption.VECTOR) {
                throw new ParameterException("Value " + value + "can not be converted to an add option. Available values are: " + StringUtils.join((Object[])AddOption.values(), (String)", ").toLowerCase(Locale.ENGLISH));
            }
            return convertedValue;
        }
    }

    public static enum AddOption {
        ALL,
        RASTER,
        VECTOR;

    }
}

