/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.style;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.style.StyleSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"get"}, parentOperation=StyleSection.class)
@Parameters(commandDescription="Get GeoServer Style info")
public class GeoServerGetStyleCommand
extends GeoServerCommand<String> {
    @Parameter(description="<style name>")
    private List<String> parameters = new ArrayList<String>();
    private String style = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <style name>");
        }
        this.style = this.parameters.get(0);
        Response getStyleResponse = this.geoserverClient.getStyle(this.style, false);
        if (getStyleResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            String styleInfo = IOUtils.toString((InputStream)((InputStream)getStyleResponse.getEntity()));
            return "\nGeoServer style info for '" + this.style + "': " + styleInfo;
        }
        String errorMessage = "Error getting GeoServer style info for '" + this.style + "': " + (String)getStyleResponse.readEntity(String.class) + "\nGeoServer Response Code = " + getStyleResponse.getStatus();
        return (String)this.handleError(getStyleResponse, errorMessage);
    }
}

