/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.workspace;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerRemoveCommand;
import org.locationtech.geowave.cli.geoserver.workspace.WorkspaceSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"rm"}, parentOperation=WorkspaceSection.class)
@Parameters(commandDescription="Remove GeoServer workspace")
public class GeoServerRemoveWorkspaceCommand
extends GeoServerRemoveCommand<String> {
    @Parameter(description="<workspace name>")
    private List<String> parameters = new ArrayList<String>();
    private String wsName = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <workspace name>");
        }
        this.wsName = this.parameters.get(0);
        Response deleteWorkspaceResponse = this.geoserverClient.deleteWorkspace(this.wsName);
        if (deleteWorkspaceResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            return "Delete workspace '" + this.wsName + "' from GeoServer: OK";
        }
        String errorMessage = "Error deleting workspace '" + this.wsName + "' from GeoServer: " + (String)deleteWorkspaceResponse.readEntity(String.class) + "\nGeoServer Response Code = " + deleteWorkspaceResponse.getStatus();
        return (String)this.handleError(deleteWorkspaceResponse, errorMessage);
    }
}

